/*
 * Decompiled with CFR 0.152.
 */
package examples.waterworld;

import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.platform.StdGame;

public class WaterWorld
extends StdGame {
    public String action_msg = null;
    public Player player;
    public int level_nr;
    public int gamedifficulty;
    public int goodies_left;
    public LevelDefs lev;
    public final LevelDefs[] levels = new LevelDefs[]{new LevelDefs(1, 4, 2, 2, 1, 2, 5, 0, 30, 50, 90), new LevelDefs(11, 5, 1, 5, 3, 9999, 1, 2, 25, 99999, 99999), new LevelDefs(19, 5, 1, 5, 3, 9999, 9, 1, 40, 99999, 70), new LevelDefs(37, 17, 5, 4, 2, 4, 6, 0, 35, 45, 50), new LevelDefs(1, 5, 1, 6, 1, 1, 3, 0, 99999, 30, 100), new LevelDefs(43, 3, 1, 5, 3, 3, 5, 4, 30, 50, 40)};

    public static void main(String[] args) {
        new WaterWorld(WaterWorld.parseSizeArgs(args, 0));
    }

    public WaterWorld() {
        this.initEngineApplet();
    }

    public WaterWorld(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(20, 15, 32, 32, null, null, null);
    }

    public void defineLevel() {
        int x;
        int y;
        this.lev = this.levels[this.level_nr];
        this.removeObjects(null, 0);
        this.fillBG(" ");
        int alter = 1;
        for (y = 2; y < 15; y += 2) {
            this.setTiles(0, y, new String[]{"                    "});
            for (x = y * this.lev.multiplier % this.lev.modulo / this.lev.divider; x < 20; x += this.lev.increment) {
                for (int w = 0; w < this.lev.width; ++w) {
                    if (alter % this.lev.solid_freq == 0) {
                        this.setTile(x + w, y, "#");
                    } else {
                        this.setTile(x + w, y, "-");
                    }
                    if (y <= 2) continue;
                    this.setTile(x + w, y - 1, "*");
                }
                ++alter;
            }
        }
        for (y = this.pfTilesY() - this.lev.waterlevel; y < this.pfTilesY(); ++y) {
            for (x = 0; x < this.pfTilesX(); ++x) {
                String tile = this.getTileStr(x, y);
                if (tile.equals(" ")) {
                    this.setTile(x, y, "w");
                } else if (tile.equals("*")) {
                    this.setTile(x, y, "*w");
                }
                if (!tile.equals("-") && !tile.equals("*") && !tile.equals("#") || x >= 2 && x <= this.pfTilesX() - 3) continue;
                this.setTile(x, y, "w");
            }
        }
        if ((this.lev.special_flags & 1) != 0) {
            this.setTiles(this.pfTilesX() / 2 - 1, 0, new String[]{"##", "##", "##", "##", "##", "##", "##", "##", "##", "##"});
        }
        if ((this.lev.special_flags & 2) != 0) {
            this.setTiles(2 * this.pfTilesX() / 3 + 2, 6, new String[]{"#", "#", "#", "#", "#"});
            this.setTiles(this.pfTilesX() / 3 - 2, 6, new String[]{"#", "#", "#", "#", "#"});
        }
        if ((this.lev.special_flags & 4) != 0) {
            this.setTilesMulti(this.pfTilesX() - 6, 7, new String[]{"# w  w  *w w w", "# w  w  #  # w", "# *w *w w  w w", "# #  #  w  w w", "# w  w  *w w w", "# w  w  #  # w", "# *w *w *w w w", "# #  #  #  # w"});
            this.setTilesMulti(0, 7, new String[]{"w w *w w  w  #", "w # #  w  w  #", "w w w  *w *w #", "w w w  #  #  #", "w w *w w  w  #", "w # #  w  w  #", "w w *w *w *w #", "w # #  #  #  #"});
            for (y = 0; y <= this.lev.waterlevel; ++y) {
                if (y == this.lev.waterlevel) {
                    this.setTiles(5, this.pfTilesY() - y, new String[]{"####ww####"});
                    continue;
                }
                if (y % 2 == 0) {
                    this.setTilesMulti(5, this.pfTilesY() - y, new String[]{"*w *w w w *w *w w w *w *w"});
                    continue;
                }
                this.setTiles(5, this.pfTilesY() - y, new String[]{"##ww##ww##"});
            }
        }
        this.goodies_left = this.countTiles(4);
    }

    public void initGame() {
        this.defineMedia("water_world.tbl");
        this.setFrameRate(40.0, 4.0);
        this.startgame_ticks = 60;
        this.lifelost_ticks = 100;
        this.leveldone_ticks = 100;
        this.startgame_ingame = true;
        this.setGameState("Title");
    }

    public void startTitle() {
        this.level_nr = 0;
        this.gamedifficulty = 0;
        this.defineLevel();
        this.playAudio("music", "titlemusic", true);
    }

    public void initNewGame(int level_selected) {
        this.level_nr = 1;
        this.gamedifficulty = 0;
        this.lives = 3;
        this.stopAudio("music");
    }

    public void incrementLevel() {
        ++this.level_nr;
        if (this.level_nr >= this.levels.length) {
            this.level_nr = 1;
            if (this.gamedifficulty < 5) {
                ++this.gamedifficulty;
            }
        }
        this.lev = this.levels[this.level_nr];
    }

    public void doFrame() {
        int y;
        int dir;
        int x;
        super.doFrame();
        this.moveObjects();
        this.checkCollision(2, 1);
        this.checkCollision(4, 2);
        this.checkBGCollision(3, 5);
        this.checkBGCollision(4, 1);
        this.checkBGCollision(11, 6);
        if ((int)this.timer % (this.lev.ball_freq - 3 * this.gamedifficulty) == 0) {
            new Ball(this.random(-this.tileHeight(), this.pfWidth() - 32), -this.tileHeight(), -1 + 2 * (int)(Math.random() + 0.5));
        }
        if ((int)this.timer % (this.lev.bird_freq - 3 * this.gamedifficulty) == 0) {
            int cid;
            do {
                if (this.player == null || this.player.x > (double)(this.pfWidth() / 2)) {
                    x = -this.tileWidth();
                    dir = 1;
                } else {
                    x = this.pfWidth();
                    dir = -1;
                }
                y = this.random(32, (this.pfTilesY() - this.lev.waterlevel) * this.tileHeight(), 64);
            } while (((cid = this.getTileCidAtCoord(x + this.tileWidth() * dir, y)) & 0xB) != 0);
            new Bird(x, y, dir);
        }
        if ((int)this.timer % (this.lev.fish_freq - 2 * this.gamedifficulty) == 0) {
            int timeout = 8;
            while (timeout-- > 0) {
                if (this.random(0.0, 2.0) >= 1.0) {
                    x = -this.tileWidth();
                    dir = 1;
                } else {
                    x = this.pfWidth();
                    dir = -1;
                }
                y = this.random(32, this.pfHeight(), 32);
                int cid = this.getTileCidAtCoord(x + this.tileWidth() * dir, y);
                if ((cid & 3) != 0 || (cid & 8) == 0) continue;
                new Fish(x, y, dir);
                break;
            }
        }
        if (this.countObjects("bubble", 0) > 0) {
            this.playAudio("bubbling", "bubbling", true);
        } else {
            this.stopAudio("bubbling");
        }
    }

    public void startStartGame() {
        this.removeObjects(null, 0);
        this.player = new Player(this.pfWidth() / 4, 160.0);
    }

    public void paintFrame() {
        this.drawImageString("SCORE " + this.score, 0.0, 0.0, -1, "fonts_map", 32, 0);
        for (int i = 1; i < this.lives; ++i) {
            this.drawImage(this.pfWidth() - 32 * i, 0.0, "player_l1");
        }
    }

    public void paintFrameStartGame() {
        this.drawImageString("START", this.pfWidth() / 2, this.pfHeight() / 3, 0, "fontl_map", 32, 0);
    }

    public void paintFrameStartLevel() {
        this.drawImageString("LEVEL " + (this.stage + 1), this.pfWidth() / 2, 2 * this.pfHeight() / 3, 0, "fontl_map", 32, 0);
    }

    public void paintFrameTitle() {
        this.drawImageString("WATER WORLD", 144.0, this.pfHeight() / 3, -1, "fontl_map", 32, 0);
        this.drawImageString("PRESS " + this.getKeyDesc(this.key_startgame).toUpperCase() + " TO START", 0.0, 2 * this.pfHeight() / 3, -1, "fontl_map", 32, 0);
    }

    public void paintFrameLevelDone() {
        this.drawImageString("LEVEL CLEAR !", 112.0, this.pfHeight() / 3, -1, "fontl_map", 32, 0);
    }

    public void paintFrameLifeLost() {
        this.drawImageString("OUCH!", this.pfWidth() / 2, this.pfHeight() / 3, 0, "fontl_map", 32, 0);
    }

    public void paintFrameGameOver() {
        this.drawImageString("GAME OVER", this.pfWidth() / 2, this.pfHeight() / 3, 0, "fontl_map", 32, 0);
    }

    public class Fish
    extends JGObject {
        double speed;
        int dir;
        double ydir;
        boolean was_falling;
        int crabtimer;
        int crabmax;

        public Fish(double x, double y, int dir) {
            super("fish", true, x, y, 2, "fish_r", 0, 0, 32, 32);
            this.speed = 1.7 + 0.3 * (double)WaterWorld.this.gamedifficulty;
            this.ydir = 0.0;
            this.was_falling = false;
            this.crabtimer = 24;
            this.crabmax = 32 - 2 * WaterWorld.this.gamedifficulty;
            if (dir < 0) {
                this.setImage("fish_l");
            }
            this.dir = dir;
        }

        public void move() {
            if (this.isXAligned(this.speed)) {
                JGPoint ct = this.getCenterTile();
                int front1cid = WaterWorld.this.getTileCid(ct, this.dir, 0);
                int front2cid = WaterWorld.this.getTileCid(ct, this.dir * 2, 0);
                int upcid = WaterWorld.this.getTileCid(ct, this.dir * 2, -1) & WaterWorld.this.getTileCid(ct, this.dir, -1) & WaterWorld.this.getTileCid(ct, 0, -1);
                int downcid = WaterWorld.this.getTileCid(ct, this.dir * 2, 1) & WaterWorld.this.getTileCid(ct, this.dir, 1) & WaterWorld.this.getTileCid(ct, 0, 1);
                if (Fish.and(front1cid, 8) && !Fish.and(front2cid, 8)) {
                    if (Fish.and(upcid, 8)) {
                        this.ydir = -1.0;
                    } else if (Fish.and(downcid, 8)) {
                        this.ydir = 1.0;
                    }
                }
            }
            this.y += this.ydir * this.speed * 2.0;
            if (this.isYAligned(this.speed)) {
                this.ydir = 0.0;
                this.snapToGrid(0.0, this.speed);
            }
            this.x += this.speed * (double)this.dir;
            if (!this.isOnPF(32, 32)) {
                this.remove();
            }
            if (this.crabtimer-- <= 0 && this.x >= 0.0 && this.x < (double)(WaterWorld.this.pfWidth() - 32)) {
                if (WaterWorld.this.countObjects("crab", 0) < 20) {
                    new Crab(this.x + 8.0, this.y + 7.0, this.random(-1, 1, 2));
                }
                this.crabtimer = this.crabmax;
            }
        }

        public void hit(JGObject obj) {
            this.remove();
            obj.remove();
            WaterWorld.this.score += 25;
            new Explo(this.x, this.y);
        }

        public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
            if ((tilecid & 3) != 0) {
                this.snapToGrid(this.speed, this.speed);
                this.dir = -this.dir;
                this.setImage("fish_r");
                if (this.dir < 0) {
                    this.setImage("fish_l");
                }
            }
        }
    }

    public class Bird
    extends JGObject {
        double speed;
        double dir;
        boolean was_falling;

        public Bird(double x, double y, int dir) {
            super("bird", true, x, y, 2, null, 0, 0, 32, 32);
            this.speed = 3.0 + 0.4 * (double)WaterWorld.this.gamedifficulty;
            this.was_falling = false;
            this.setAnim("vogel_l");
            if (dir >= 0) {
                this.setAnim("vogel_r");
            }
            this.dir = dir;
        }

        public void move() {
            this.x += this.speed * this.dir;
            if (!this.isOnPF(32, 32)) {
                this.remove();
            }
        }

        public void hit(JGObject obj) {
            this.remove();
            obj.remove();
            WaterWorld.this.score += 10;
            new Explo(this.x, this.y);
        }

        public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
            if ((tilecid & 3) != 0) {
                this.snapToGrid(this.speed, this.speed);
                this.dir = -this.dir;
                this.setAnim("vogel_l");
                if (this.dir >= 0.0) {
                    this.setAnim("vogel_r");
                }
            }
            if ((tilecid & 8) != 0) {
                this.remove();
                new Explo(this.x, this.y);
            }
        }
    }

    public class Crab
    extends JGObject {
        double speed;
        double dir;
        char orient;
        boolean was_falling;

        public Crab(double x, double y, int dir) {
            super("crab", true, x, y, 2, "crab_u");
            this.speed = 1.5 + 0.2 * (double)WaterWorld.this.gamedifficulty;
            this.dir = 1.0;
            this.orient = (char)117;
            this.was_falling = true;
            this.dir = dir;
        }

        public void move() {
            JGRectangle ts = this.getTiles();
            if (this.orient == 'u') {
                if (this.isBottomAligned(this.speed * 0.5)) {
                    int cid = WaterWorld.this.getTileCid(ts.x, ts.y + 1) | WaterWorld.this.getTileCid(ts.x + ts.width - 1, ts.y + 1);
                    if ((cid & 3) == 0) {
                        if (!this.was_falling) {
                            if (this.dir > 0.0) {
                                this.orient = (char)114;
                                this.snapBBoxToGrid(this.speed, this.speed, false, true);
                                this.y += 2.0 * this.speed;
                            } else {
                                this.orient = (char)108;
                                this.snapBBoxToGrid(this.speed, this.speed, true, true);
                                this.y += 2.0 * this.speed;
                            }
                        } else {
                            this.y += this.speed;
                        }
                        this.was_falling = true;
                    } else {
                        this.x += this.dir * this.speed;
                        this.was_falling = false;
                    }
                } else {
                    this.y += this.speed;
                    this.was_falling = true;
                }
            } else if (this.orient == 'r') {
                int cid = WaterWorld.this.getTileCid(ts.x - 1, ts.y) | WaterWorld.this.getTileCid(ts.x - 1, ts.y + ts.height - 1);
                if ((cid & 3) == 0) {
                    if (!this.was_falling) {
                        if (this.dir > 0.0) {
                            this.orient = (char)100;
                            this.snapBBoxToGrid(this.speed, this.speed, false, false);
                            this.x -= this.speed * 2.0;
                        } else {
                            this.orient = (char)117;
                            this.snapBBoxToGrid(this.speed, this.speed, false, true);
                            this.x -= this.speed * 2.0;
                        }
                    } else {
                        this.orient = (char)117;
                        this.y += this.speed;
                    }
                    this.was_falling = true;
                } else {
                    this.y += this.dir * this.speed;
                    if (this.y >= (double)(WaterWorld.this.pfHeight() - 16) || this.y <= 0.0) {
                        this.dir = -this.dir;
                    }
                    this.was_falling = false;
                }
            } else if (this.orient == 'l') {
                int cid = WaterWorld.this.getTileCid(ts.x + 1, ts.y) | WaterWorld.this.getTileCid(ts.x + 1, ts.y + ts.height - 1);
                if ((cid & 3) == 0) {
                    if (!this.was_falling) {
                        if (this.dir > 0.0) {
                            this.orient = (char)117;
                            this.snapBBoxToGrid(this.speed, this.speed, true, true);
                            this.x += this.speed * 2.0;
                        } else {
                            this.orient = (char)100;
                            this.snapBBoxToGrid(this.speed, this.speed, true, false);
                            this.x += this.speed * 2.0;
                        }
                    } else {
                        this.orient = (char)117;
                        this.y += this.speed;
                    }
                    this.was_falling = true;
                } else {
                    this.y -= this.dir * this.speed;
                    if (this.y >= (double)(WaterWorld.this.pfHeight() - 16) || this.y <= 0.0) {
                        this.dir = -this.dir;
                    }
                    this.was_falling = false;
                }
            } else if (this.orient == 'd') {
                int cid = WaterWorld.this.getTileCid(ts.x, ts.y - 1) | WaterWorld.this.getTileCid(ts.x + ts.width - 1, ts.y - 1);
                if ((cid & 3) == 0) {
                    if (!this.was_falling) {
                        if (this.dir > 0.0) {
                            this.orient = (char)108;
                            this.snapBBoxToGrid(this.speed, this.speed, true, false);
                            this.y -= this.speed * 2.0;
                        } else {
                            this.orient = (char)114;
                            this.snapBBoxToGrid(this.speed, this.speed, false, false);
                            this.y -= this.speed * 2.0;
                        }
                    } else {
                        this.orient = (char)117;
                        this.y += this.speed;
                    }
                    this.was_falling = true;
                } else {
                    this.x -= this.dir * this.speed;
                    this.was_falling = false;
                }
            }
            this.setAnim("crab_" + this.orient);
            if (!this.isOnPF((int)(-this.speed), (int)(-this.speed))) {
                this.remove();
            }
        }

        public void hit(JGObject obj) {
            this.remove();
            obj.remove();
            WaterWorld.this.score += 5;
            new Explo(this.x, this.y);
        }

        public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
            if ((tilecid & 3) != 0) {
                this.snapBBoxToGrid(0.0, this.speed, false, true);
                this.dir = -this.dir;
            }
        }
    }

    public class Ball
    extends JGObject {
        double speed;
        double dir;
        boolean was_falling;
        boolean floating;
        int float_timeout;

        public Ball(double x, double y, int dir) {
            super("ball", true, x, y, 2, null, 0, 0, 32, 32);
            this.speed = 1.7 + 0.3 * (double)WaterWorld.this.gamedifficulty;
            this.dir = 1.0;
            this.was_falling = false;
            this.floating = false;
            this.float_timeout = 100;
            this.dir = dir;
        }

        public void move() {
            JGRectangle ts = this.getTiles();
            JGRectangle cts = this.getCenterTiles();
            if (!this.floating) {
                this.snapToGrid(this.speed / 2.0, 0.0);
                if (this.isYAligned(this.speed)) {
                    int cid = 0;
                    for (int tdx = 0; tdx < ts.width; ++tdx) {
                        cid |= WaterWorld.this.getTileCid(ts.x + tdx, cts.y + 1);
                    }
                    if ((cid & 3) == 0) {
                        this.y += this.speed;
                        this.was_falling = true;
                    } else {
                        this.snapToGrid(0.0, this.speed);
                        this.x += this.dir * this.speed;
                        this.was_falling = false;
                    }
                } else {
                    this.y += this.speed;
                }
            } else {
                this.x += this.dir * 1.0;
                if (this.float_timeout-- <= 0) {
                    new Explo(this.x, this.y);
                    this.remove();
                }
            }
            if (this.dir >= 0.0) {
                this.setAnim("ball_r");
            } else {
                this.setAnim("ball_l");
            }
            if (!this.isOnPF(32, 32)) {
                this.remove();
            }
        }

        public void hit(JGObject obj) {
            this.remove();
            obj.remove();
            WaterWorld.this.score += 10;
            new Explo(this.x, this.y);
        }

        public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
            if ((tilecid & 2) != 0) {
                if (!this.floating) {
                    this.snapToGrid(this.speed, this.speed);
                } else {
                    this.snapToGrid(0.0, this.speed);
                }
                this.dir = -this.dir;
            }
            if ((tilecid & 1) != 0 && this.floating) {
                this.snapToGrid(0.0, this.speed);
                this.dir = -this.dir;
            }
            if ((tilecid & 8) != 0) {
                this.floating = true;
                this.setAnim("ball_water");
                int tlcid = WaterWorld.this.getTileCid(tx, ty);
                int trcid = WaterWorld.this.getTileCid(tx + txsize - 1, ty);
                this.y = ((tlcid | trcid) & 8) != 0 ? (this.y -= 1.0) : (this.y > 0.0 && (double)((int)this.y % WaterWorld.this.tileHeight()) > (double)WaterWorld.this.tileHeight() * 0.7 ? (this.y -= 1.0) : (this.y += 2.0));
            }
        }
    }

    public class Player
    extends JGObject {
        double speed = 6.0;
        int jumptime = 0;
        int falltime = 0;
        int bullettime = 0;
        int dir = 1;
        boolean jumping_up = false;
        boolean jumping_down = false;
        boolean swimming = false;

        public Player(double x, double y) {
            super("player", false, x, y, 1, "player_l1", 0, 0, 32, 32);
        }

        public void move() {
            if (!this.swimming && (this.checkBGCollision(this.getTileBBox()) & 8) != 0) {
                this.swimming = true;
                WaterWorld.this.playAudio("splash", "splash", false);
                this.jumptime = 0;
                this.setAnim("player_swd");
                this.falltime = (int)((double)WaterWorld.this.tileHeight() / this.speed);
            }
            if (!this.swimming) {
                this.moveNorm();
            } else {
                this.moveSwim();
            }
            if (this.x >= (double)(WaterWorld.this.pfWidth() - 32)) {
                this.x = WaterWorld.this.pfWidth() - 32;
            }
            if (this.y >= (double)(WaterWorld.this.pfHeight() - 32)) {
                this.y = WaterWorld.this.pfHeight() - 32;
            }
            if (this.x < 0.0) {
                this.x = 0.0;
            }
            if (this.y < 0.0) {
                this.y = 0.0;
            }
        }

        void moveSwim() {
            int cid = this.checkBGCollision(this.getTileBBox());
            this.stopAnim();
            if (this.falltime > 0) {
                this.y += this.speed;
                --this.falltime;
                return;
            }
            if (this.bullettime > 0) {
                --this.bullettime;
            } else if (WaterWorld.this.getKey(WaterWorld.this.key_fireleft)) {
                new Bubble((int)this.x, (int)this.y, -1, 0);
                this.bullettime = 5;
            } else if (WaterWorld.this.getKey(WaterWorld.this.key_fireright)) {
                new Bubble((int)this.x, (int)this.y, 1, 0);
                this.bullettime = 5;
            } else if (WaterWorld.this.getKey(WaterWorld.this.key_firedown)) {
                new Bubble((int)this.x, (int)this.y, 0, 1);
                this.bullettime = 5;
            } else if (WaterWorld.this.getKey(WaterWorld.this.key_fireup)) {
                new Bubble((int)this.x, (int)this.y, 0, -1);
                this.bullettime = 5;
            }
            if (WaterWorld.this.getKey(WaterWorld.this.key_left)) {
                this.setAnim("player_swl");
                this.startAnim();
                this.x -= this.speed;
                this.snapToGrid(0.0, 16.0);
                this.dir = -1;
            } else if (WaterWorld.this.getKey(WaterWorld.this.key_right)) {
                this.setAnim("player_swr");
                this.startAnim();
                this.x += this.speed;
                this.snapToGrid(0.0, 16.0);
                this.dir = 1;
            } else if (WaterWorld.this.getKey(WaterWorld.this.key_up)) {
                this.setAnim("player_swu");
                this.startAnim();
                this.y -= this.speed;
                this.snapToGrid(16.0, 0.0);
                this.dir = 0;
                if ((cid & 8) == 0) {
                    this.jumptime = 22;
                    this.swimming = false;
                    return;
                }
            } else if (WaterWorld.this.getKey(WaterWorld.this.key_down)) {
                this.setAnim("player_swd");
                this.startAnim();
                this.y += this.speed;
                this.snapToGrid(16.0, 0.0);
                this.dir = 0;
            }
            if ((cid & 8) == 0) {
                this.swimming = false;
            }
        }

        public void moveNorm() {
            this.snapToGrid(this.speed / 2.0, 0.0);
            JGRectangle ts = this.getTiles();
            JGRectangle cts = this.getCenterTiles();
            int cid = 0;
            for (int tdx = 0; tdx < ts.width; ++tdx) {
                cid |= WaterWorld.this.getTileCid(ts.x + tdx, cts.y + 1);
            }
            if (this.bullettime > 0) {
                --this.bullettime;
            } else if (WaterWorld.this.getKey(WaterWorld.this.key_fireleft)) {
                new Bullet((int)this.x, (int)this.y, -1);
                this.bullettime = 12;
            } else if (WaterWorld.this.getKey(WaterWorld.this.key_fireright)) {
                new Bullet((int)this.x, (int)this.y, 1);
                this.bullettime = 12;
            }
            this.stopAnim();
            if (this.jumptime <= 0) {
                this.jumping_up = false;
                this.jumping_down = false;
                if (this.isYAligned(this.speed)) {
                    if ((cid & 3) == 0) {
                        this.y += this.speed;
                        this.snapToGrid(this.speed / 2.0, 0.0);
                    } else {
                        this.snapToGrid(0.0, this.speed);
                        if (WaterWorld.this.getKey(WaterWorld.this.key_left)) {
                            this.setAnim("player_l");
                            this.startAnim();
                            this.dir = -1;
                            this.x -= this.speed;
                        }
                        if (WaterWorld.this.getKey(WaterWorld.this.key_right)) {
                            this.setAnim("player_r");
                            this.startAnim();
                            this.dir = 1;
                            this.x += this.speed;
                        }
                        if (WaterWorld.this.getKey(WaterWorld.this.key_up)) {
                            this.jumptime = 22;
                        }
                    }
                } else {
                    this.y += this.speed;
                }
            } else {
                if (this.jumptime > 11) {
                    this.y -= this.speed;
                    this.jumping_up = true;
                    this.jumping_down = false;
                } else {
                    this.y += this.speed;
                    this.jumping_up = false;
                    this.jumping_down = true;
                    if (this.isYAligned(this.speed)) {
                        cid = 0;
                        for (int tx = 0; tx < ts.width; ++tx) {
                            cid |= WaterWorld.this.getTileCid(ts.x + tx, cts.y + 1);
                        }
                        if ((cid & 3) != 0) {
                            this.jumptime = 0;
                        }
                    }
                }
                if (WaterWorld.this.getKey(WaterWorld.this.key_left)) {
                    this.setAnim("player_l");
                    this.startAnim();
                    this.x -= this.speed;
                    this.dir = -1;
                }
                if (WaterWorld.this.getKey(WaterWorld.this.key_right)) {
                    this.setAnim("player_r");
                    this.startAnim();
                    this.x += this.speed;
                    this.dir = 1;
                }
                --this.jumptime;
            }
        }

        public void hit(JGObject obj) {
            this.remove();
            new Explo(this.x, this.y);
            WaterWorld.this.lifeLost();
        }

        public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
            if ((tilecid & 2) != 0) {
                if (this.jumping_up) {
                    if (this.isYAligned(this.speed * 2.0)) {
                        boolean bump_head = false;
                        JGRectangle cts = this.getCenterTiles();
                        for (int tdx = 0; tdx < txsize; ++tdx) {
                            boolean botwall;
                            boolean topwall = (WaterWorld.this.getTileCid(tx + tdx, cts.y - 1) & 2) != 0;
                            boolean bl = botwall = (WaterWorld.this.getTileCid(tx + tdx, cts.y) & 2) != 0;
                            if (!topwall || botwall) continue;
                            bump_head = true;
                            break;
                        }
                        if (bump_head) {
                            this.jumptime = 0;
                            this.snapToGrid(this.speed, this.speed);
                        } else {
                            this.snapToGrid(this.speed, 0.0);
                        }
                    } else {
                        this.snapToGrid(this.speed, 0.0);
                    }
                } else if (!this.swimming) {
                    this.snapToGrid(this.speed, 0.0);
                } else {
                    this.snapToGrid(this.speed, this.speed);
                }
            }
            if ((tilecid & 1) != 0 && this.swimming) {
                this.snapToGrid(this.speed, this.speed);
            }
            if ((tilecid & 4) != 0) {
                WaterWorld.this.playAudio("pickup");
                for (int x = 0; x < txsize; ++x) {
                    for (int y = 0; y < tysize; ++y) {
                        if ((WaterWorld.this.getTileCid(tx + x, ty + y) & 4) == 0) continue;
                        --WaterWorld.this.goodies_left;
                        WaterWorld.this.score += 25;
                        if ((WaterWorld.this.getTileCid(tx + x, ty + y) & 8) != 0) {
                            WaterWorld.this.setTile(tx + x, ty + y, "w");
                            continue;
                        }
                        WaterWorld.this.setTile(tx + x, ty + y, " ");
                    }
                }
            }
            if (WaterWorld.this.goodies_left <= 0) {
                this.remove();
                WaterWorld.this.levelDone();
            }
        }
    }

    public class Bullet
    extends JGObject {
        public Bullet(int x, int y, int dir) {
            super("bullet", true, (double)(x + 8), (double)(y + 8), 4, "bullet", dir, 1, 8.0, -2.0, -2);
            WaterWorld.this.playAudio("shoot");
        }

        public void move() {
            this.yspeed += 0.5;
        }

        public void hit() {
            this.remove();
        }

        public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
            if ((tilecid & 2) != 0) {
                int tlcid = WaterWorld.this.getTileCid(tx, ty);
                int blcid = WaterWorld.this.getTileCid(tx, ty + tysize - 1);
                int trcid = WaterWorld.this.getTileCid(tx + txsize - 1, ty);
                int brcid = WaterWorld.this.getTileCid(tx + txsize - 1, ty + tysize - 1);
                if (this.xdir == 0) {
                    this.remove();
                }
                if (this.xdir == 1 && ((tlcid | blcid) & 2) == 0 || this.xdir == -1 && ((trcid | brcid) & 2) == 0) {
                    this.xdir = -this.xdir;
                }
                if (this.yspeed > 0.0 && (blcid & 2 & (brcid & 2)) != 0 || this.yspeed < 0.0 && (tlcid & 2 & (trcid & 2)) != 0) {
                    this.yspeed = this.yspeed < 0.0 ? -this.yspeed : -(this.yspeed / 2.0);
                }
            }
            if ((tilecid & 8) != 0) {
                this.yspeed = -(this.yspeed / 2.0);
                if (this.yspeed > -2.0 || this.xdir == 0) {
                    this.remove();
                }
            }
        }
    }

    public class Bubble
    extends JGObject {
        public Bubble(int x, int y, int xdir, int ydir) {
            super("bubble", true, (double)(x + 8), (double)(y + 8), 4, "bubble", 0.0, 0.0, -2);
            this.setDirSpeed(xdir, 1, 14.0, ydir > 0 ? 8.0 : (double)(ydir < 0 ? -5 : 1));
        }

        public void move() {
            this.xspeed = this.xspeed > 0.8 ? (this.xspeed -= 0.8) : 0.0;
            if (this.yspeed > -3.0) {
                this.yspeed -= 0.3;
            }
            JGRectangle cts = this.getCenterTiles();
            if ((WaterWorld.this.getTileCid(cts.x, cts.y) & 8) == 0) {
                if (this.yspeed > 1.0) {
                    this.yspeed = -this.yspeed;
                } else {
                    this.remove();
                }
            }
        }

        public void hit() {
            this.remove();
        }
    }

    public class Explo
    extends JGObject {
        public Explo(double x, double y) {
            super("explo", true, x, y, 0, "explo", 0.0, 0.0, 16);
        }
    }

    public class LevelDefs {
        public int multiplier = 37;
        public int modulo = 17;
        public int divider = 5;
        public int increment = 4;
        public int width = 2;
        public int solid_freq = 4;
        public int waterlevel;
        public int special_flags;
        public int ball_freq = 20;
        public int bird_freq = 30;
        public int fish_freq = 50;

        public LevelDefs(int multiplier, int modulo, int divider, int increment, int width, int solid_freq, int waterlevel, int special_flags, int ball_freq, int bird_freq, int fish_freq) {
            this.multiplier = multiplier;
            this.modulo = modulo;
            this.divider = divider;
            this.increment = increment;
            this.width = width;
            this.solid_freq = solid_freq;
            this.waterlevel = waterlevel;
            this.special_flags = special_flags;
            this.ball_freq = ball_freq;
            this.bird_freq = bird_freq;
            this.fish_freq = fish_freq;
        }
    }
}

