/*
 * Decompiled with CFR 0.152.
 */
package jgame.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGImage;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.JGTimer;
import jgame.impl.Animation;
import jgame.impl.ImageMap;
import jgame.impl.JGEngineInterface;
import jgame.impl.JGameError;
import jgame.impl.SortedArray;

public class EngineLogic {
    public JGImage imageutil;
    Random random;
    public boolean is_resizeable = true;
    boolean make_bitmask;
    boolean prescale;
    public boolean view_initialised = false;
    public JGColor fg_color = JGColor.white;
    public JGColor bg_color = JGColor.black;
    public JGFont msg_font = null;
    public int outline_thickness = 0;
    public JGColor outline_colour = JGColor.black;
    public double fps = 35.0;
    public double maxframeskip = 4.0;
    public double gamespeed = 1.00000000001;
    public Vector gamestate = new Vector(10, 20);
    public Vector gamestate_nextframe = new Vector(10, 20);
    public Vector gamestate_new = new Vector(10, 20);
    boolean in_parallel_upd = false;
    private Vector timers = new Vector(20, 40);
    public boolean is_inited = false;
    public boolean is_exited = false;
    public String exit_message = "JGEngine exited successfully";
    Hashtable animations = new Hashtable();
    public Hashtable images_orig = new Hashtable();
    public Hashtable image_orig_size = new Hashtable();
    public Hashtable images = new Hashtable();
    public Hashtable images_exists = new Hashtable();
    public Hashtable images_transp = new Hashtable();
    public Hashtable images_loaded = new Hashtable();
    public Hashtable images_tile = new Hashtable();
    public Hashtable images_bbox = new Hashtable();
    public Hashtable images_tilecid = new Hashtable();
    public Hashtable imagemaps = new Hashtable();
    public int alpha_thresh = 128;
    public JGColor render_bg_color = null;
    public SortedArray objects = new SortedArray(80);
    SortedArray obj_to_remove = new SortedArray(40);
    Vector obj_spec_to_remove = new Vector(20, 40);
    SortedArray obj_to_add = new SortedArray(40);
    public int nrtilesx;
    public int nrtilesy;
    public int tilex;
    public int tiley;
    public int viewnrtilesx;
    public int viewnrtilesy;
    public double min_aspect = 0.75;
    public double max_aspect = 1.3333333333333333;
    public int crop_top = 0;
    public int crop_left = 0;
    public int crop_bottom = 0;
    public int crop_right = 0;
    public boolean smooth_magnify = true;
    public int width;
    public int height;
    public int pfwidth_half;
    public int pfheight_half;
    public int pfwidth;
    public int pfheight;
    public int canvas_xofs = 0;
    public int canvas_yofs = 0;
    public int scaledtilex;
    public int scaledtiley;
    public int pendingxofs = 0;
    public int pendingyofs = 0;
    public int xofs = 0;
    public int yofs = 0;
    public int tilexofs = -1;
    public int tileyofs = -1;
    public int xofs_scaled = 0;
    public int yofs_scaled = 0;
    public int xofs_mid;
    public int yofs_mid;
    public double x_scale_fac = 1.0;
    public double y_scale_fac = 1.0;
    public double min_scale_fac = 1.0;
    public int winwidth = 0;
    public int winheight = 0;
    public int[][] tilemap = null;
    public int[][] tilecidmap = null;
    public boolean pf_wrapx = false;
    public boolean pf_wrapy = false;
    public int pf_wrapshiftx = 0;
    public int pf_wrapshifty = 0;
    public Vector bg_images = new Vector(8, 20);
    String out_of_bounds_tile = "";
    int out_of_bounds_cid = 0;
    int preserve_cids = 0;
    public int offscreen_margin_x = 16;
    public int offscreen_margin_y = 16;
    public boolean[][] bg_defined = null;
    JGRectangle tmprect1 = new JGRectangle();
    JGRectangle tmprect2 = new JGRectangle();
    JGObject[] srcobj = new JGObject[50];
    JGObject[] dstobj = new JGObject[50];
    public Hashtable audioclips = new Hashtable();

    public EngineLogic(JGImage imageutil, boolean make_bitmask, boolean prescale) {
        this.imageutil = imageutil;
        this.make_bitmask = make_bitmask;
        this.prescale = prescale;
        this.random = new Random();
        this.bg_images.addElement(null);
    }

    public int viewWidth() {
        return this.viewnrtilesx * this.tilex;
    }

    public int viewHeight() {
        return this.viewnrtilesy * this.tiley;
    }

    public int tileWidth() {
        return this.tilex;
    }

    public int tileHeight() {
        return this.tiley;
    }

    public static Vector tokenizeString(String str, char splitchar) {
        int nextidx;
        Vector<String> tok = new Vector<String>(20, 50);
        int curidx = 0;
        while ((nextidx = str.indexOf(splitchar, curidx)) >= 0) {
            if (nextidx > curidx) {
                tok.addElement(str.substring(curidx, nextidx));
            }
            curidx = nextidx + 1;
        }
        if (curidx < str.length()) {
            tok.addElement(str.substring(curidx));
        }
        return tok;
    }

    public static String readline(InputStreamReader in) {
        StringBuffer line = null;
        try {
            while (true) {
                int ch;
                if ((ch = in.read()) == -1) {
                    if (line == null) {
                        return null;
                    }
                    return line.toString();
                }
                if (ch == 10 || ch == 13) {
                    if (line == null) continue;
                    return line.toString();
                }
                if (line == null) {
                    line = new StringBuffer();
                }
                line.append((char)ch);
            }
        }
        catch (IOException e) {
            if (line == null) {
                return null;
            }
            return line.toString();
        }
    }

    public String getAbsolutePath(Object pkg_obj, String filename) {
        if (filename.indexOf("/") == 0 || filename.indexOf("://") >= 0 && filename.indexOf("://") <= 5) {
            return filename;
        }
        String pkgname = pkg_obj.getClass().getName();
        String pkgname_path = "";
        Vector tokens = EngineLogic.tokenizeString(pkgname, '.');
        Enumeration e = tokens.elements();
        while (e.hasMoreElements()) {
            String tok = (String)e.nextElement();
            if (!e.hasMoreElements()) continue;
            pkgname_path = pkgname_path + tok + "/";
        }
        return "/" + pkgname_path + filename;
    }

    public boolean existsImage(String imgname) {
        return this.images_exists.containsKey(imgname);
    }

    public Object getTileImage(Integer tileid) {
        String imgid = (String)this.images_tile.get(tileid);
        if (imgid == null) {
            return null;
        }
        if (!this.is_resizeable) {
            return (JGImage)this.images.get(imgid);
        }
        return this.getImage(imgid);
    }

    public JGPoint getImageSize(String imgname) {
        return (JGPoint)this.image_orig_size.get(imgname);
    }

    public JGImage getImageQuick(String imgname) {
        return (JGImage)this.images.get(imgname);
    }

    public JGImage getImage(String imgname) {
        if (!this.existsImage(imgname)) {
            throw new JGameError("Image '" + imgname + "' not defined.", true);
        }
        JGImage img = (JGImage)this.images.get(imgname);
        if (img == null) {
            img = (JGImage)this.images_orig.get(imgname);
            if (img == null) {
                return null;
            }
            JGColor render_bg_col = this.render_bg_color;
            if (render_bg_col == null) {
                render_bg_col = this.bg_color;
            }
            img = img.toDisplayCompatible(this.alpha_thresh, render_bg_col, true, this.make_bitmask);
            JGPoint size = img.getSize();
            if (this.width > 0 && this.height > 0) {
                if (this.prescale) {
                    JGPoint scaledpos = this.scalePos(size.x, size.y, false);
                    img = img.scale(scaledpos.x, scaledpos.y);
                }
                this.images.put(imgname, img);
            } else {
                throw new JGameError("Image width, height <= 0 !", true);
            }
        }
        return img;
    }

    public JGImage getImageOrig(String imgname) {
        return (JGImage)this.images_orig.get(imgname);
    }

    public JGImage getSubImage(String mapname, int imgnr) {
        ImageMap imgmap = (ImageMap)this.imagemaps.get(mapname);
        if (imgmap == null) {
            throw new JGameError("Image map '" + mapname + "' not found.", true);
        }
        JGPoint subcoord = imgmap.getImageCoord(imgnr);
        if (subcoord != null) {
            return imgmap.img.crop(subcoord.x, subcoord.y, imgmap.tilex, imgmap.tiley);
        }
        return null;
    }

    public void defineMedia(JGEngineInterface eng, String filename) {
        int lnr = 1;
        int nr_lines = 0;
        filename = this.getAbsolutePath(eng, filename);
        try {
            String line;
            InputStreamReader in;
            InputStream instr = this.getClass().getResourceAsStream(filename);
            if (instr == null) {
                eng.exitEngine("Cannot open `" + filename + "'.");
            }
            if ((in = new InputStreamReader(instr)) == null) {
                eng.exitEngine("Cannot open `" + filename + "'.");
            }
            while (EngineLogic.readline(in) != null) {
                ++nr_lines;
            }
            if (nr_lines == 0) {
                eng.exitEngine("Cannot open `" + filename + "'.");
            }
            in = new InputStreamReader(this.getClass().getResourceAsStream(filename));
            String[] fields = new String[14];
            while ((line = EngineLogic.readline(in)) != null) {
                eng.setProgressBar((double)lnr / (double)nr_lines);
                int i = 0;
                Vector tokens = EngineLogic.tokenizeString(line, '\t');
                Enumeration e = tokens.elements();
                while (e.hasMoreElements()) {
                    fields[i++] = (String)e.nextElement();
                }
                if (i == 8) {
                    this.defineImageMap(eng, fields[0], fields[1], Integer.parseInt(fields[2]), Integer.parseInt(fields[3]), Integer.parseInt(fields[4]), Integer.parseInt(fields[5]), Integer.parseInt(fields[6]), Integer.parseInt(fields[7]));
                } else if (i == 9) {
                    this.defineImage(eng, fields[0], fields[1], Integer.parseInt(fields[2]), fields[3], fields[4], Integer.parseInt(fields[5]), Integer.parseInt(fields[6]), Integer.parseInt(fields[7]), Integer.parseInt(fields[8]));
                } else if (i == 5) {
                    this.defineImage(eng, fields[0], fields[1], Integer.parseInt(fields[2]), fields[3], fields[4], -1, -1, -1, -1);
                } else if (i == 10) {
                    this.defineImage(fields[0], fields[1], Integer.parseInt(fields[2]), this.getSubImage(fields[3], Integer.parseInt(fields[4])), fields[5], Integer.parseInt(fields[6]), Integer.parseInt(fields[7]), Integer.parseInt(fields[8]), Integer.parseInt(fields[9]));
                } else if (i == 6) {
                    this.defineImage(fields[0], fields[1], Integer.parseInt(fields[2]), this.getSubImage(fields[3], Integer.parseInt(fields[4])), fields[5], -1, -1, -1, -1);
                } else if (i == 3) {
                    this.defineAnimation(fields[0], EngineLogic.splitList(fields[1]), Double.parseDouble(fields[2]));
                } else if (i == 4) {
                    this.defineAnimation(fields[0], EngineLogic.splitList(fields[1]), Double.parseDouble(fields[2]), fields[3].equals("true"));
                } else if (i == 2) {
                    this.defineAudioClip(eng, fields[0], fields[1]);
                }
                ++lnr;
            }
        }
        catch (JGameError e) {
            eng.exitEngine("Error in " + filename + " line " + lnr + ": " + e);
        }
        catch (Exception e) {
            eng.exitEngine("Error in " + filename + " line " + lnr + ":\n" + eng.dbgExceptionToString(e));
        }
    }

    public static String[] splitList(String liststr) {
        Vector list = EngineLogic.tokenizeString(liststr, ';');
        String[] list_arr = new String[list.size()];
        int i = 0;
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            list_arr[i] = (String)e.nextElement();
            ++i;
        }
        return list_arr;
    }

    public void undefineImage(String name) {
        this.imageutil.purgeImage((String)this.images_loaded.get(name));
        this.images_orig.remove(name);
        this.image_orig_size.remove(name);
        this.images.remove(name);
        this.images_exists.remove(name);
        this.images_transp.remove(name);
        this.images_loaded.remove(name);
        this.images_bbox.remove(name);
        for (int i = this.bg_images.size() - 1; i >= 0; --i) {
            BGImage bg_image = (BGImage)this.bg_images.elementAt(i);
            if (bg_image == null || !bg_image.imgname.equals(name)) continue;
            this.bg_images.setElementAt(null, i);
        }
    }

    public void defineImage(Object pkg_obj, String name, String tilename, int collisionid, String imgfile, String img_op, int top, int left, int width, int height) {
        if (this.images_loaded.containsKey(name) && !this.images_loaded.get(name).equals(imgfile)) {
            this.undefineImage(name);
        }
        JGImage img = null;
        if (!imgfile.equals("null")) {
            imgfile = this.getAbsolutePath(pkg_obj, imgfile);
            img = this.imageutil.loadImage(imgfile);
            this.images_loaded.put(name, imgfile);
        }
        this.defineImage(name, tilename, collisionid, img, img_op, top, left, width, height);
    }

    public void defineImage(String name, String tilename, int collisionid, JGImage img, String img_op, int top, int left, int width, int height) {
        if (img != null) {
            boolean rot270;
            boolean flipx = (img_op = img_op.toLowerCase()).indexOf("x") >= 0;
            boolean flipy = img_op.indexOf("y") >= 0;
            boolean rot90 = img_op.indexOf("r") >= 0;
            boolean rot180 = img_op.indexOf("u") >= 0;
            boolean bl = rot270 = img_op.indexOf("l") >= 0;
            if (flipx || flipy) {
                img = img.flip(flipx, flipy);
            }
            if (rot90) {
                img = img.rotate(90);
            } else if (rot180) {
                img = img.rotate(180);
            } else if (rot270) {
                img = img.rotate(270);
            }
            this.images_orig.put(name, img);
            this.image_orig_size.put(name, img.getSize());
        }
        this.images_exists.put(name, "yes");
        Integer tileid = new Integer(this.tileStrToID(tilename));
        if (img == null || !img.isOpaque(this.alpha_thresh)) {
            this.images_transp.put(tileid, "yes");
        }
        this.images_tile.put(tileid, name);
        this.images_tilecid.put(tileid, new Integer(collisionid));
        if (width >= 0) {
            this.images_bbox.put(name, new JGRectangle(top, left, width, height));
        } else {
            JGPoint size = img == null ? new JGPoint(0, 0) : img.getSize();
            this.images_bbox.put(name, new JGRectangle(0, 0, size.x, size.y));
        }
        this.getImage(name);
        if (!this.is_resizeable) {
            this.images_orig.remove(name);
        }
    }

    public void defineImageRotated(Object pkg_obj, String name, String tilename, int collisionid, String srcname, double angle) {
        String imgfile;
        if (this.images_loaded.containsKey(name)) {
            this.undefineImage(name);
        }
        if ((imgfile = (String)this.images_loaded.get(srcname)).equals("null")) {
            throw new JGameError("Source image '" + srcname + "' does not have a filename.", true);
        }
        imgfile = this.getAbsolutePath(pkg_obj, imgfile);
        JGImage img = this.imageutil.loadImage(imgfile);
        this.defineImage(name, tilename, collisionid, img.rotateAny(angle), "-", 0, 0, -1, -1);
    }

    public void defineImageMap(Object pkg_obj, String mapname, String imgfile, int xofs, int yofs, int tilex, int tiley, int skipx, int skipy) {
        imgfile = this.getAbsolutePath(pkg_obj, imgfile);
        this.imagemaps.put(mapname, new ImageMap(this.imageutil, imgfile, xofs, yofs, tilex, tiley, skipx, skipy));
    }

    public JGRectangle getImageBBox(String imgname) {
        return (JGRectangle)this.images_bbox.get(imgname);
    }

    public void defineImage(Object pkg_obj, String imgname, String tilename, int collisionid, String imgfile, String img_op) {
        this.defineImage(pkg_obj, imgname, tilename, collisionid, imgfile, img_op, -1, -1, -1, -1);
    }

    public void defineImage(String imgname, String tilename, int collisionid, String imgmap, int mapidx, String img_op, int top, int left, int width, int height) {
        this.defineImage(imgname, tilename, collisionid, this.getSubImage(imgmap, mapidx), img_op, top, left, width, height);
    }

    public void defineImage(String imgname, String tilename, int collisionid, String imgmap, int mapidx, String img_op) {
        this.defineImage(imgname, tilename, collisionid, this.getSubImage(imgmap, mapidx), img_op, 0, 0, -1, -1);
    }

    void setPendingViewOffset(int xofs, int yofs) {
        BGImage bgimg;
        if (!this.pf_wrapx) {
            if (xofs < 0) {
                xofs = 0;
            }
            if (xofs > this.tilex * (this.nrtilesx - this.viewnrtilesx)) {
                xofs = this.tilex * (this.nrtilesx - this.viewnrtilesx);
            }
        }
        if (!this.pf_wrapy) {
            if (yofs < 0) {
                yofs = 0;
            }
            if (yofs > this.tiley * (this.nrtilesy - this.viewnrtilesy)) {
                yofs = this.tiley * (this.nrtilesy - this.viewnrtilesy);
            }
        }
        this.pendingxofs = xofs;
        this.pendingyofs = yofs;
        if (this.bg_images.size() >= 1 && (bgimg = (BGImage)this.bg_images.elementAt(0)) != null) {
            bgimg.xofs = xofs;
            bgimg.yofs = yofs;
        }
    }

    public void updateViewOffset() {
        if (this.pendingxofs != this.xofs || this.pendingyofs != this.yofs) {
            this.setViewOffset(this.pendingxofs, this.pendingyofs);
        }
    }

    void setViewOffset(int xofs, int yofs) {
        int mintileyofs;
        if (this.bg_defined == null) {
            return;
        }
        this.xofs = xofs;
        this.yofs = yofs;
        int oldtilexofs = this.tilexofs;
        int oldtileyofs = this.tileyofs;
        this.tilexofs = this.divFloor(xofs, this.tilex) - 1;
        this.tileyofs = this.divFloor(yofs, this.tiley) - 1;
        this.xofs_scaled = this.scaleXPos(xofs, false);
        this.yofs_scaled = this.scaleYPos(yofs, false);
        this.calcPFWrapCenter();
        int maxtilexofs = Math.max(this.tilexofs, oldtilexofs);
        int maxtileyofs = Math.max(this.tileyofs, oldtileyofs);
        int mintilexofs = Math.min(this.tilexofs, oldtilexofs);
        for (int yi = mintileyofs = Math.min(this.tileyofs, oldtileyofs); yi < maxtileyofs; ++yi) {
            for (int xi = 0; xi < this.viewnrtilesx + 3; ++xi) {
                this.bg_defined[xi][this.moduloFloor((int)yi, (int)(this.viewnrtilesy + 3))] = false;
            }
        }
        for (int xi = mintilexofs; xi < maxtilexofs; ++xi) {
            for (int yi = 0; yi < this.viewnrtilesy + 3; ++yi) {
                this.bg_defined[this.moduloFloor((int)xi, (int)(this.viewnrtilesx + 3))][yi] = false;
            }
        }
    }

    void calcPFWrapCenter() {
        this.xofs_mid = this.xofs + this.viewnrtilesx * this.tilex / 2 + this.pf_wrapshiftx;
        this.yofs_mid = this.yofs + this.viewnrtilesy * this.tiley / 2 + this.pf_wrapshifty;
    }

    public void markAddObject(JGObject obj) {
        this.obj_to_add.put(obj.getName(), obj);
    }

    void addObject(JGObject obj, boolean skip_actual_add) {
        int idx = this.objects.get(obj.getName());
        if (idx >= 0) {
            JGObject old_obj = (JGObject)this.objects.values[idx];
            old_obj.removeDone();
            old_obj.remove();
        }
        if (!skip_actual_add) {
            this.objects.put(obj.getName(), obj);
        }
    }

    void markRemoveObject(String index) {
        int idx = this.objects.get(index);
        if (idx < 0) {
            return;
        }
        this.obj_to_remove.put(index, (JGObject)this.objects.values[idx]);
    }

    void markRemoveObject(JGObject obj) {
        this.obj_to_remove.put(obj.getName(), obj);
    }

    void doRemoveObject(JGObject obj) {
        obj.removeDone();
        this.objects.remove(obj.getName());
    }

    void markRemoveObjects(String prefix, int cidmask, boolean suspended_obj) {
        this.obj_spec_to_remove.addElement(prefix);
        this.obj_spec_to_remove.addElement(new Integer(cidmask));
        this.obj_spec_to_remove.addElement(new Boolean(suspended_obj));
    }

    void doRemoveObjects(String prefix, int cidmask, boolean suspended_obj, boolean do_remove_list) {
        JGObject o;
        int i;
        int firstidx = this.getFirstObjectIndex(prefix);
        int lastidx = this.getLastObjectIndex(prefix);
        for (i = firstidx; i < lastidx; ++i) {
            o = (JGObject)this.objects.values[i];
            if (cidmask != 0 && (o.colid & cidmask) == 0 || !suspended_obj && o.is_suspended) continue;
            this.obj_to_remove.put(this.objects.keys[i], o);
        }
        if (do_remove_list) {
            this.doRemoveList();
        }
        for (i = this.obj_to_add.size - 1; i >= 0; --i) {
            o = (JGObject)this.obj_to_add.values[i];
            if (prefix != null && !this.obj_to_add.keys[i].startsWith(prefix) || cidmask != 0 && (o.colid & cidmask) == 0 || !suspended_obj && o.is_suspended) continue;
            this.obj_to_add.remove(this.obj_to_add.keys[i]);
            o.removeDone();
        }
    }

    public void flushRemoveList() {
        if (this.obj_spec_to_remove.size() != 0) {
            Enumeration e = this.obj_spec_to_remove.elements();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                int cid = (Integer)e.nextElement();
                boolean suspended_obj = (Boolean)e.nextElement();
                this.doRemoveObjects(prefix, cid, suspended_obj, false);
            }
            this.obj_spec_to_remove.removeAllElements();
        }
        this.doRemoveList();
    }

    void doRemoveList() {
        for (int i = 0; i < this.obj_to_remove.size; ++i) {
            ((JGObject)this.obj_to_remove.values[i]).removeDone();
        }
        this.objects.remove(this.obj_to_remove);
        this.obj_to_remove.clear();
    }

    public void flushAddList() {
        for (int i = 0; i < this.obj_to_add.size; ++i) {
            this.addObject((JGObject)this.obj_to_add.values[i], true);
        }
        this.objects.put(this.obj_to_add);
        this.obj_to_add.clear();
    }

    public boolean existsObject(String index) {
        return this.objects.get(index) >= 0;
    }

    public JGObject getObject(String index) {
        int idx = this.objects.get(index);
        if (idx < 0) {
            return null;
        }
        return (JGObject)this.objects.values[idx];
    }

    public void moveObjects(JGEngineInterface eng, String prefix, int cidmask) {
        if (this.in_parallel_upd) {
            throw new JGameError("Recursive call", true);
        }
        this.in_parallel_upd = true;
        int firstidx = this.getFirstObjectIndex(prefix);
        int lastidx = this.getLastObjectIndex(prefix);
        for (int i = firstidx; i < lastidx; ++i) {
            JGObject o = (JGObject)this.objects.values[i];
            if (cidmask != 0 && (o.colid & cidmask) == 0) continue;
            if (o.is_suspended) {
                if (o.resume_in_view && o.isInView(this.offscreen_margin_x, this.offscreen_margin_y)) {
                    o.resume();
                }
            } else if (!(o.expiry != -4.0 && o.expiry != -5.0 || o.isInView(this.offscreen_margin_x, this.offscreen_margin_y))) {
                o.suspend();
            }
            if (this.pf_wrapx) {
                o.x = this.moduloXPos(o.x);
            }
            if (this.pf_wrapy) {
                o.y = this.moduloYPos(o.y);
            }
            if (!o.is_suspended) {
                if (this.pf_wrapx) {
                    o.x = this.moduloXPos(o.x);
                }
                if (this.pf_wrapy) {
                    o.y = this.moduloYPos(o.y);
                }
                try {
                    o.move();
                }
                catch (JGameError ex) {
                    eng.exitEngine(eng.dbgExceptionToString(ex));
                }
                catch (Exception ex) {
                    eng.dbgShowException(o.getName(), ex);
                }
                o.updateAnimation(this.gamespeed);
                o.x += (double)o.xdir * o.xspeed * this.gamespeed;
                o.y += (double)o.ydir * o.yspeed * this.gamespeed;
                if (this.pf_wrapx) {
                    o.x = this.moduloXPos(o.x);
                }
                if (this.pf_wrapy) {
                    o.y = this.moduloYPos(o.y);
                }
            }
            if (o.is_suspended) continue;
            int expiry = (int)o.expiry;
            if (expiry >= 0) {
                o.expiry -= this.gamespeed;
                if (!(o.expiry < 0.0)) continue;
                o.remove();
                continue;
            }
            if (!(expiry != -2 && expiry != -5 || o.isOnPF(this.offscreen_margin_x, this.offscreen_margin_y))) {
                o.remove();
            }
            if (expiry != -3 || o.isInView(this.offscreen_margin_x, this.offscreen_margin_y)) continue;
            o.remove();
        }
        this.flushRemoveList();
        this.in_parallel_upd = false;
    }

    public void moveObjects(JGEngineInterface eng) {
        this.moveObjects(eng, null, 0);
    }

    public void checkCollision(JGEngineInterface eng, int srccid, int dstcid) {
        if (this.in_parallel_upd) {
            throw new JGameError("Recursive call", true);
        }
        this.in_parallel_upd = true;
        if (this.objects.size > this.srcobj.length) {
            this.srcobj = new JGObject[this.objects.size + 50];
            this.dstobj = new JGObject[this.objects.size + 50];
        }
        int srcsize = 0;
        int dstsize = 0;
        JGRectangle sr = this.tmprect1;
        JGRectangle dr = this.tmprect2;
        for (int i = 0; i < this.objects.size; ++i) {
            JGObject o = (JGObject)this.objects.values[i];
            if (o.is_suspended || !o.getBBox(sr)) continue;
            if ((o.colid & srccid) != 0) {
                this.srcobj[srcsize++] = o;
            }
            if ((o.colid & dstcid) == 0) continue;
            this.dstobj[dstsize++] = o;
        }
        for (int si = 0; si < srcsize; ++si) {
            JGObject srco = this.srcobj[si];
            if (!srco.getBBox(sr)) continue;
            for (int di = 0; di < dstsize; ++di) {
                JGObject dsto = this.dstobj[di];
                if (dsto == srco || !dsto.getBBox(dr) || !sr.intersects(dr)) continue;
                try {
                    dsto.hit(srco);
                    continue;
                }
                catch (JGameError ex) {
                    eng.exitEngine(eng.dbgExceptionToString(ex));
                    continue;
                }
                catch (Exception ex) {
                    eng.dbgShowException(dsto.getName(), ex);
                }
            }
        }
        this.flushRemoveList();
        this.in_parallel_upd = false;
    }

    public int checkCollision(int cidmask, JGObject obj) {
        JGRectangle bbox = obj.getBBox();
        if (bbox == null) {
            return 0;
        }
        int retcid = 0;
        JGRectangle obj_bbox = this.tmprect1;
        for (int i = 0; i < this.objects.size; ++i) {
            JGObject o = (JGObject)this.objects.values[i];
            if (o == obj || o.is_suspended || cidmask != 0 && (o.colid & cidmask) == 0 || !o.getBBox(obj_bbox) || !bbox.intersects(obj_bbox)) continue;
            retcid |= o.colid;
        }
        return retcid;
    }

    public int checkBGCollision(JGRectangle r) {
        return this.getTileCid(this.getTiles(r));
    }

    public void checkBGCollision(JGEngineInterface eng, int tilecid, int objcid) {
        if (this.in_parallel_upd) {
            throw new JGameError("Recursive call", true);
        }
        this.in_parallel_upd = true;
        if (this.objects.size > this.srcobj.length) {
            this.srcobj = new JGObject[this.objects.size + 50];
        }
        int srcsize = 0;
        JGRectangle r = this.tmprect1;
        for (int i = 0; i < this.objects.size; ++i) {
            JGObject o = (JGObject)this.objects.values[i];
            if (o.is_suspended || !o.getTileBBox(r) || (o.colid & objcid) == 0) continue;
            this.srcobj[srcsize++] = o;
        }
        JGRectangle tiler = this.tmprect2;
        for (int i = 0; i < srcsize; ++i) {
            JGObject o = this.srcobj[i];
            o.getTileBBox(r);
            this.getTiles(tiler, r);
            int cid = this.getTileCid(tiler);
            if ((cid & tilecid) == 0) continue;
            try {
                o.hit_bg(cid);
                o.hit_bg(cid, tiler.x, tiler.y, tiler.width, tiler.height);
                for (int y = 0; y < tiler.height; ++y) {
                    for (int x = 0; x < tiler.width; ++x) {
                        int thiscid = this.getTileCid(tiler.x + x, tiler.y + y);
                        if ((thiscid & tilecid) == 0) continue;
                        o.hit_bg(thiscid, tiler.x + x, tiler.y + y);
                    }
                }
                continue;
            }
            catch (JGameError ex) {
                eng.exitEngine(eng.dbgExceptionToString(ex));
                continue;
            }
            catch (Exception ex) {
                eng.dbgShowException(o.getName(), ex);
            }
        }
        this.flushRemoveList();
        this.in_parallel_upd = false;
    }

    public Vector getObjects(String prefix, int cidmask, boolean suspended_obj, JGRectangle bbox) {
        Vector<JGObject> objects_v = new Vector<JGObject>(50, 100);
        boolean nr_obj = false;
        JGRectangle obj_bbox = this.tmprect1;
        int firstidx = this.getFirstObjectIndex(prefix);
        int lastidx = this.getLastObjectIndex(prefix);
        for (int i = firstidx; i < lastidx; ++i) {
            JGObject obj = (JGObject)this.objects.values[i];
            if (cidmask != 0 && (obj.colid & cidmask) == 0 || !suspended_obj && obj.is_suspended) continue;
            if (bbox != null) {
                if (!obj.getBBox(obj_bbox) || !bbox.intersects(obj_bbox)) continue;
                objects_v.addElement(obj);
                continue;
            }
            objects_v.addElement(obj);
        }
        return objects_v;
    }

    public void removeObject(JGObject obj) {
        if (this.in_parallel_upd) {
            this.markRemoveObject(obj);
        } else {
            this.doRemoveObject(obj);
        }
    }

    public void removeObjects(String prefix, int cidmask) {
        this.removeObjects(prefix, cidmask, true);
    }

    public void removeObjects(String prefix, int cidmask, boolean suspended_obj) {
        if (this.in_parallel_upd) {
            this.markRemoveObjects(prefix, cidmask, suspended_obj);
        } else {
            this.doRemoveObjects(prefix, cidmask, suspended_obj, true);
        }
    }

    public int countObjects(String prefix, int cidmask) {
        return this.countObjects(prefix, cidmask, true);
    }

    public int countObjects(String prefix, int cidmask, boolean suspended_obj) {
        int nr_obj = 0;
        int firstidx = this.getFirstObjectIndex(prefix);
        int lastidx = this.getLastObjectIndex(prefix);
        for (int i = firstidx; i < lastidx; ++i) {
            JGObject obj = (JGObject)this.objects.values[i];
            if (cidmask != 0 && (obj.colid & cidmask) == 0 || !suspended_obj && obj.is_suspended) continue;
            ++nr_obj;
        }
        return nr_obj;
    }

    int getFirstObjectIndex(String prefix) {
        if (prefix == null) {
            return 0;
        }
        int firstidx = this.objects.get(prefix);
        if (firstidx < 0) {
            firstidx = -1 - firstidx;
        }
        return firstidx;
    }

    int getLastObjectIndex(String prefix) {
        if (prefix == null) {
            return this.objects.size;
        }
        return -1 - this.objects.get(prefix + '\uffff');
    }

    public void frameFinished() {
        for (int i = 0; i < this.objects.size; ++i) {
            ((JGObject)this.objects.values[i]).frameFinished();
        }
    }

    public void repaintBG(JGEngineInterface eng) {
        if (this.bg_defined == null) {
            return;
        }
        int nrtilesdrawn = 0;
        int maxpredrawtiles = (this.viewnrtilesx + this.viewnrtilesy) / 5;
        for (int x = 0; x < this.viewnrtilesx + 3; ++x) {
            int xi = x + this.tilexofs;
            if (!this.pf_wrapx && (xi < 0 || xi >= this.nrtilesx)) continue;
            int xi_mod = this.moduloFloor(xi, this.viewnrtilesx + 3);
            int xi_modpf = xi;
            if (this.pf_wrapx) {
                xi_modpf = this.moduloFloor(xi, this.nrtilesx);
            }
            int ylower = this.tileyofs;
            int yupper = this.tileyofs + this.viewnrtilesy + 3;
            if (!this.pf_wrapy) {
                if (yupper < 0) continue;
                if (ylower < 0) {
                    ylower = 0;
                }
                if (ylower > this.nrtilesy) continue;
                if (yupper > this.nrtilesy) {
                    yupper = this.nrtilesy;
                }
            }
            int divfactor = this.viewnrtilesy + 3;
            for (int yi = ylower; yi < yupper; ++yi) {
                int yi_mod;
                int n = yi_mod = yi >= 0 ? yi % divfactor : divfactor - 1 - (-1 - yi) % divfactor;
                if (this.bg_defined[xi_mod][yi_mod]) continue;
                int yi_modpf = yi;
                if (this.pf_wrapy) {
                    yi_modpf = this.moduloFloor(yi, this.nrtilesy);
                }
                int y = yi - this.tileyofs;
                if ((x == 0 || y == 0 || x == this.viewnrtilesx + 2 || y == this.viewnrtilesy + 2) && nrtilesdrawn > maxpredrawtiles) continue;
                eng.drawTile(xi, yi, this.tilemap[xi_modpf][yi_modpf]);
                ++nrtilesdrawn;
                this.bg_defined[xi_mod][yi_mod] = true;
            }
        }
    }

    public void setBGImage(String bgimg, int depth, boolean wrapx, boolean wrapy) {
        while (this.bg_images.size() < depth + 1) {
            this.bg_images.addElement(null);
        }
        if (bgimg != null) {
            if (!this.images.containsKey(bgimg) && !this.images_orig.containsKey(bgimg)) {
                throw new JGameError("unknown BG image " + bgimg);
            }
            BGImage newimg = new BGImage(bgimg, wrapx, wrapy);
            this.bg_images.setElementAt(newimg, depth);
            if (depth == 0) {
                newimg.xofs = this.xofs;
                newimg.yofs = this.yofs;
            }
        } else {
            this.bg_images.setElementAt(null, depth);
        }
        this.invalidateBGTiles();
    }

    public void initBGTiles(int nrtilesx, int nrtilesy, String filltile) {
        this.nrtilesx = nrtilesx;
        this.nrtilesy = nrtilesy;
        this.pfwidth = nrtilesx * this.tilex;
        this.pfheight = nrtilesy * this.tiley;
        this.pfwidth_half = this.pfwidth / 2;
        this.pfheight_half = this.pfheight / 2;
        this.tilemap = new int[nrtilesx][nrtilesy];
        this.tilecidmap = new int[nrtilesx][nrtilesy];
        this.bg_defined = new boolean[this.viewnrtilesx + 3][this.viewnrtilesy + 3];
        this.fillBG(filltile);
        this.setViewOffset(0, 0);
    }

    public void invalidateBGTiles() {
        if (this.bg_defined == null) {
            return;
        }
        for (int x = 0; x < this.viewnrtilesx + 3; ++x) {
            for (int y = 0; y < this.viewnrtilesy + 3; ++y) {
                this.bg_defined[x][y] = false;
            }
        }
    }

    public void setTileSettings(String out_of_bounds_tile, int out_of_bounds_cid, int preserve_cids) {
        this.out_of_bounds_tile = out_of_bounds_tile;
        this.out_of_bounds_cid = out_of_bounds_cid;
        this.preserve_cids = preserve_cids;
    }

    public void fillBG(String filltile) {
        for (int y = 0; y < this.nrtilesy; ++y) {
            for (int x = 0; x < this.nrtilesx; ++x) {
                this.setTile(x, y, filltile);
            }
        }
    }

    public void setTileCid(int x, int y, int and_mask, int or_mask) {
        if (this.pf_wrapx) {
            x = this.moduloFloor(x, this.nrtilesx);
        } else if (x < 0 || x >= this.nrtilesx) {
            return;
        }
        if (this.pf_wrapy) {
            y = this.moduloFloor(y, this.nrtilesy);
        } else if (y < 0 || y >= this.nrtilesy) {
            return;
        }
        int[] nArray = this.tilecidmap[x];
        int n = y;
        nArray[n] = nArray[n] & and_mask;
        int[] nArray2 = this.tilecidmap[x];
        int n2 = y;
        nArray2[n2] = nArray2[n2] | or_mask;
    }

    public void setTile(int x, int y, String tilestr) {
        int y_mod_bg;
        int tileid;
        int x_mod = x;
        int y_mod = y;
        if (this.pf_wrapx) {
            x_mod = this.moduloFloor(x, this.nrtilesx);
        } else if (x < 0 || x >= this.nrtilesx) {
            return;
        }
        if (this.pf_wrapy) {
            y_mod = this.moduloFloor(y, this.nrtilesy);
        } else if (y < 0 || y >= this.nrtilesy) {
            return;
        }
        this.tilemap[x_mod][y_mod] = tileid = this.tileStrToID(tilestr);
        int[] nArray = this.tilecidmap[x_mod];
        int n = y_mod;
        nArray[n] = nArray[n] & this.preserve_cids;
        int[] nArray2 = this.tilecidmap[x_mod];
        int n2 = y_mod;
        nArray2[n2] = nArray2[n2] | this.tileintToCid(tileid);
        if (!(this.pf_wrapx || x_mod >= this.tilexofs && x_mod < this.tilexofs + this.viewnrtilesx + 3)) {
            return;
        }
        if (!(this.pf_wrapy || y_mod >= this.tileyofs && y_mod < this.tileyofs + this.viewnrtilesy + 3)) {
            return;
        }
        int x_mod_bg = x >= 0 ? x % (this.viewnrtilesx + 3) : this.viewnrtilesx + 2 - (-1 - x) % (this.viewnrtilesx + 3);
        int n3 = y_mod_bg = y >= 0 ? y % (this.viewnrtilesy + 3) : this.viewnrtilesy + 2 - (-1 - y) % (this.viewnrtilesy + 3);
        if (x_mod_bg >= this.nrtilesx) {
            x_mod_bg -= this.nrtilesx;
        }
        if (y_mod_bg >= this.nrtilesy) {
            y_mod_bg -= this.nrtilesy;
        }
        this.bg_defined[x_mod_bg][y_mod_bg] = false;
        boolean do_doubley = false;
        if (this.pf_wrapx && this.viewnrtilesx + 3 - this.nrtilesx > x_mod_bg) {
            this.bg_defined[x_mod_bg + this.nrtilesx][y_mod_bg] = false;
            if (this.pf_wrapy && this.viewnrtilesy + 3 - this.nrtilesy > y_mod_bg) {
                this.bg_defined[x_mod_bg + this.nrtilesx][y_mod_bg + this.nrtilesy] = false;
                do_doubley = true;
            }
        }
        if (do_doubley) {
            this.bg_defined[x_mod_bg][y_mod_bg + this.nrtilesy] = false;
        }
    }

    public int countTiles(int tilecidmask) {
        int count = 0;
        for (int x = 0; x < this.nrtilesx; ++x) {
            for (int y = 0; y < this.nrtilesy; ++y) {
                if ((this.tilecidmap[x][y] & tilecidmask) == 0) continue;
                ++count;
            }
        }
        return count;
    }

    public int getTileCid(int xidx, int yidx) {
        if (this.pf_wrapx) {
            xidx = this.moduloFloor(xidx, this.nrtilesx);
        } else if (xidx < 0 || xidx >= this.nrtilesx) {
            return this.out_of_bounds_cid;
        }
        if (this.pf_wrapy) {
            yidx = this.moduloFloor(yidx, this.nrtilesy);
        } else if (yidx < 0 || yidx >= this.nrtilesy) {
            return this.out_of_bounds_cid;
        }
        return this.tilecidmap[xidx][yidx];
    }

    public String getTileStr(int xidx, int yidx) {
        if (this.pf_wrapx) {
            xidx = this.moduloFloor(xidx, this.nrtilesx);
        } else if (xidx < 0 || xidx >= this.nrtilesx) {
            return this.out_of_bounds_tile;
        }
        if (this.pf_wrapy) {
            yidx = this.moduloFloor(yidx, this.nrtilesy);
        } else if (yidx < 0 || yidx >= this.nrtilesy) {
            return this.out_of_bounds_tile;
        }
        return this.tileIDToStr(this.tilemap[xidx][yidx]);
    }

    public int getTileCid(JGRectangle tiler) {
        int cid = 0;
        for (int x = tiler.x; x < tiler.x + tiler.width; ++x) {
            for (int y = tiler.y; y < tiler.y + tiler.height; ++y) {
                cid |= this.getTileCid(x, y);
            }
        }
        return cid;
    }

    private int tilestrToCid(String tilestr) {
        if (tilestr == null || tilestr.length() == 0) {
            return 0;
        }
        Integer tileid = (Integer)this.images_tilecid.get(new Integer(this.tileStrToID(tilestr)));
        if (tileid == null) {
            System.out.println("Warning: unknown tile '" + tilestr + "'.");
            return 0;
        }
        return tileid;
    }

    private int tileintToCid(int tileint) {
        if (tileint == 0) {
            return 0;
        }
        Integer tileid = (Integer)this.images_tilecid.get(new Integer(tileint));
        if (tileid == null) {
            System.out.println("Warning: unknown tile '" + tileint + "'.");
            return 0;
        }
        return tileid;
    }

    public int tileStrToID(String tilestr) {
        if (tilestr == null) {
            return 0;
        }
        switch (tilestr.length()) {
            case 0: {
                return 0;
            }
            case 1: {
                return tilestr.charAt(0);
            }
            case 2: {
                return tilestr.charAt(0) + tilestr.charAt(1) * 256;
            }
            case 3: {
                return tilestr.charAt(0) + tilestr.charAt(1) * 256 + tilestr.charAt(2) * 256 * 256;
            }
            case 4: {
                return tilestr.charAt(0) + tilestr.charAt(1) * 256 + tilestr.charAt(2) * 256 * 256 + tilestr.charAt(3) * 256 * 256 * 256;
            }
        }
        System.out.println("Warning: string '" + tilestr + " has wrong size.");
        return 0;
    }

    public String tileIDToStr(int tileid) {
        if (tileid == 0) {
            return "";
        }
        StringBuffer tilestr = new StringBuffer("" + (char)(tileid & 0xFF));
        if (tileid >= 256) {
            tilestr.append((char)(tileid / 256 & 0xFF));
        }
        if (tileid >= 65536) {
            tilestr.append((char)(tileid / 65536 & 0xFF));
        }
        if (tileid >= 0x1000000) {
            tilestr.append((char)(tileid / 0x1000000 & 0xFF));
        }
        return tilestr.toString();
    }

    public boolean getTiles(JGRectangle dest, JGRectangle r) {
        if (r == null) {
            return false;
        }
        dest.copyFrom(r);
        this.convertToTiles(dest, r);
        return true;
    }

    void convertToTiles(JGRectangle dest, JGRectangle r) {
        if (dest.x >= 0) {
            dest.x /= this.tilex;
            dest.width = 1 - dest.x + (r.x + r.width - 1) / this.tilex;
        } else {
            dest.x = (dest.x - this.tilex + 1) / this.tilex;
            dest.width = 1 - dest.x + (r.x + r.width - 1 - this.tilex + 1) / this.tilex;
        }
        if (dest.y >= 0) {
            dest.y /= this.tiley;
            dest.height = 1 - dest.y + (r.y + r.height - 1) / this.tiley;
        } else {
            dest.y = (dest.y - this.tiley + 1) / this.tiley;
            dest.height = 1 - dest.y + (r.y + r.height - 1 - this.tilex + 1) / this.tiley;
        }
    }

    public JGRectangle getTiles(JGRectangle r) {
        if (r == null) {
            return null;
        }
        JGRectangle tiler = new JGRectangle(r);
        this.convertToTiles(tiler, r);
        return tiler;
    }

    public void setTileCid(int x, int y, int value) {
        this.setTileCid(x, y, 0, value);
    }

    public void orTileCid(int x, int y, int or_mask) {
        this.setTileCid(x, y, -1, or_mask);
    }

    public void andTileCid(int x, int y, int and_mask) {
        this.setTileCid(x, y, and_mask, 0);
    }

    public void setTile(JGPoint tileidx, String tilename) {
        this.setTile(tileidx.x, tileidx.y, tilename);
    }

    public void setTiles(int xofs, int yofs, String[] tilemap) {
        for (int y = 0; y < tilemap.length; ++y) {
            for (int x = 0; x < tilemap[y].length(); ++x) {
                this.setTile(x + xofs, y + yofs, new String(tilemap[y].substring(x, x + 1)));
            }
        }
    }

    public void setTilesMulti(int xofs, int yofs, String[] tilemap) {
        for (int y = 0; y < tilemap.length; ++y) {
            Vector tokens = EngineLogic.tokenizeString(tilemap[y], ' ');
            int x = 0;
            Enumeration e = tokens.elements();
            while (e.hasMoreElements()) {
                this.setTile(x + xofs, y + yofs, (String)e.nextElement());
                ++x;
            }
        }
    }

    public int getTileCidAtCoord(double x, double y) {
        int xidx = (int)x / this.tilex;
        int yidx = (int)y / this.tiley;
        return this.getTileCid(xidx, yidx);
    }

    public int getTileCid(JGPoint center, int xofs, int yofs) {
        return this.getTileCid(center.x + xofs, center.y + yofs);
    }

    public String getTileStrAtCoord(double x, double y) {
        int xidx = (int)x / this.tilex;
        int yidx = (int)y / this.tiley;
        return this.getTileStr(xidx, yidx);
    }

    public String getTileStr(JGPoint center, int xofs, int yofs) {
        return this.getTileStr(center.x + xofs, center.y + yofs);
    }

    public void drawImageString(JGEngineInterface eng, String string, double x, double y, int align, String imgmap, int char_offset, int spacing, boolean pf_relative) {
        ImageMap map = (ImageMap)this.imagemaps.get(imgmap);
        if (map == null) {
            throw new JGameError("Font image map '" + imgmap + "' not found.", true);
        }
        if (align == 0) {
            x -= (double)((map.tilex + spacing) * string.length() / 2);
        } else if (align == 1) {
            x -= (double)((map.tilex + spacing) * string.length());
        }
        StringBuffer lettername_buf = new StringBuffer(imgmap + "# ");
        int lastchar = lettername_buf.length() - 1;
        String lettername = null;
        for (int i = 0; i < string.length(); ++i) {
            int imgnr = -char_offset + string.charAt(i);
            lettername_buf.setCharAt(lastchar, string.charAt(i));
            lettername = lettername_buf.toString();
            if (!this.existsImage(lettername)) {
                this.defineImage(lettername, "FONT", 0, this.getSubImage(imgmap, imgnr), "-", 0, 0, 0, 0);
            }
            JGImage letter = this.getImage(lettername);
            eng.drawImage(x, y, lettername, pf_relative);
            x += (double)(map.tilex + spacing);
        }
    }

    public double moduloXPos(double x) {
        while (x - (double)this.xofs_mid > (double)this.pfwidth_half) {
            x -= (double)(this.pfwidth_half * 2);
        }
        while (x - (double)this.xofs_mid < (double)(-this.pfwidth_half)) {
            x += (double)(this.pfwidth_half * 2);
        }
        return x;
    }

    public double moduloYPos(double y) {
        while (y - (double)this.yofs_mid > (double)this.pfheight_half) {
            y -= (double)(this.pfheight_half * 2);
        }
        while (y - (double)this.yofs_mid < (double)(-this.pfheight_half)) {
            y += (double)(this.pfheight_half * 2);
        }
        return y;
    }

    public int divFloor(int pos, int div) {
        return (int)Math.floor((double)pos / (double)div);
    }

    public double moduloFloor(double pos, int div) {
        return pos - (double)div * Math.floor(pos / (double)div);
    }

    public int moduloFloor(int pos, int modulo) {
        if (pos >= 0) {
            return pos % modulo;
        }
        return modulo - 1 - (-1 - pos) % modulo;
    }

    public int scaleXPos(double x, boolean pf_relative) {
        if (!pf_relative) {
            return (int)Math.floor(this.x_scale_fac * x);
        }
        if (this.pf_wrapx) {
            x = this.moduloXPos(x);
        }
        return (int)Math.floor(this.x_scale_fac * x) - this.xofs_scaled;
    }

    public int scaleYPos(double y, boolean pf_relative) {
        if (!pf_relative) {
            return (int)Math.floor(this.y_scale_fac * y);
        }
        if (this.pf_wrapy) {
            y = this.moduloYPos(y);
        }
        return (int)Math.floor(this.y_scale_fac * y) - this.yofs_scaled;
    }

    public JGPoint scalePos(double x, double y, boolean pf_relative) {
        return new JGPoint(this.scaleXPos(x, pf_relative), this.scaleYPos(y, pf_relative));
    }

    public JGRectangle scalePos(double x, double y, double width, double height, boolean pf_relative) {
        JGPoint topleft = this.scalePos(x, y, pf_relative);
        JGPoint botright = this.scalePos(x + width, y + height, pf_relative);
        if (botright.x < topleft.x) {
            botright.x = topleft.x + this.scaleXPos(width, pf_relative);
        }
        if (botright.y < topleft.y) {
            botright.y = topleft.y + this.scaleYPos(height, pf_relative);
        }
        return new JGRectangle(topleft.x, topleft.y, botright.x - topleft.x - 1, botright.y - topleft.y - 1);
    }

    public JGRectangle scalePos(JGRectangle r, boolean pf_relative) {
        if (r == null) {
            return null;
        }
        return this.scalePos(r.x, r.y, r.width, r.height, pf_relative);
    }

    public void initPF() {
        int allowed_width = this.winwidth + this.crop_left + this.crop_right;
        int allowed_height = this.winheight + this.crop_top + this.crop_bottom;
        if (!this.prescale) {
            allowed_width = this.winwidth;
            allowed_height = this.winheight;
        }
        this.scaledtilex = allowed_width / this.viewnrtilesx;
        this.scaledtiley = allowed_height / this.viewnrtilesy;
        double aspectratio = (double)this.scaledtilex / (double)this.scaledtiley / ((double)this.tilex / (double)this.tiley);
        if (aspectratio < this.min_aspect) {
            this.scaledtiley = (int)((double)this.scaledtilex / this.min_aspect);
        } else if (aspectratio > this.max_aspect) {
            this.scaledtilex = (int)(this.max_aspect * (double)this.scaledtiley);
        }
        this.width = this.scaledtilex * this.viewnrtilesx;
        this.height = this.scaledtiley * this.viewnrtilesy;
        if (!this.prescale) {
            this.scaledtilex = this.tilex;
            this.scaledtiley = this.tiley;
        }
        this.x_scale_fac = (double)this.width / (double)(this.tilex * this.viewnrtilesx);
        this.y_scale_fac = (double)this.height / (double)(this.tiley * this.viewnrtilesy);
        this.min_scale_fac = Math.min(this.x_scale_fac, this.y_scale_fac);
        int x_excess = this.width - this.winwidth;
        int y_excess = this.height - this.winheight;
        double xbalance = 0.0;
        double ybalance = 0.0;
        if (this.crop_left + this.crop_right > 0 && x_excess > 0) {
            xbalance = (this.crop_right - this.crop_left) / (this.crop_left + this.crop_right);
        }
        if (this.crop_top + this.crop_bottom > 0 && y_excess > 0) {
            ybalance = (this.crop_bottom - this.crop_top) / (this.crop_top + this.crop_bottom);
        }
        this.canvas_xofs = (int)((double)(-x_excess) * (0.5 - 0.5 * xbalance));
        this.canvas_yofs = (int)((double)(-y_excess) * (0.5 - 0.5 * ybalance));
        if (!this.is_inited) {
            this.initBGTiles(this.nrtilesx, this.nrtilesy, "");
        } else if (this.is_resizeable) {
            this.images = new Hashtable();
        }
    }

    public void setViewOffset(int xofs, int yofs, boolean centered) {
        if (centered) {
            xofs -= this.viewWidth() / 2;
            yofs -= this.viewHeight() / 2;
        }
        this.setPendingViewOffset(xofs, yofs);
        JGObject.updateEngineSettings();
    }

    public void setBGImgOffset(int depth, double xofs, double yofs, boolean centered) {
        if (centered) {
            xofs -= (double)(this.viewWidth() / 2);
            yofs -= (double)(this.viewHeight() / 2);
        }
        if (this.bg_images.size() < depth) {
            throw new JGameError("Parallax depth " + depth + " not defined.");
        }
        BGImage bgimg = (BGImage)this.bg_images.elementAt(depth);
        bgimg.xofs = xofs;
        bgimg.yofs = yofs;
    }

    public void setPFSize(int nrtilesx, int nrtilesy) {
        this.initBGTiles(nrtilesx, nrtilesy, "");
        JGObject.updateEngineSettings();
    }

    public void setPFWrap(boolean wrapx, boolean wrapy, int shiftx, int shifty) {
        this.pf_wrapx = wrapx;
        this.pf_wrapy = wrapy;
        this.pf_wrapshiftx = shiftx;
        this.pf_wrapshifty = shifty;
        this.setViewOffset(this.pendingxofs, this.pendingyofs, false);
        this.calcPFWrapCenter();
        JGObject.updateEngineSettings();
    }

    public void setFrameRate(double fps, double maxframeskip) {
        this.fps = fps;
        this.maxframeskip = maxframeskip;
    }

    public void setRenderSettings(int alpha_thresh, JGColor render_bg_col) {
        this.alpha_thresh = alpha_thresh;
        this.render_bg_color = render_bg_col;
    }

    public void setOffscreenMargin(int xmargin, int ymargin) {
        this.offscreen_margin_x = xmargin;
        this.offscreen_margin_y = ymargin;
    }

    public void setGameSpeed(double speed) {
        this.gamespeed = speed + 1.0E-11;
        JGObject.updateEngineSettings();
    }

    public void removeAllTimers() {
        this.timers.removeAllElements();
    }

    public void registerTimer(JGTimer timer) {
        this.timers.addElement(timer);
    }

    public void tickTimers() {
        for (int i = this.timers.size() - 1; i >= 0; --i) {
            JGTimer timer = (JGTimer)this.timers.elementAt(i);
            if (!timer.tick(this.gamespeed)) continue;
            this.timers.removeElement(timer);
        }
    }

    public void setGameState(String state) {
        boolean already_in_state = this.inGameStateNextFrame(state);
        this.gamestate_nextframe.removeAllElements();
        this.gamestate_nextframe.addElement(state);
        this.gamestate_new.removeAllElements();
        if (!already_in_state) {
            this.gamestate_new.addElement(state);
        }
    }

    public void addGameState(String state) {
        if (!this.inGameStateNextFrame(state)) {
            this.gamestate_nextframe.addElement(state);
            this.gamestate_new.addElement(state);
        }
    }

    public void removeGameState(String state) {
        this.gamestate_nextframe.removeElement(state);
        this.gamestate_new.removeElement(state);
    }

    public void clearGameState() {
        this.gamestate_nextframe.removeAllElements();
    }

    public boolean inGameState(String state) {
        for (int i = this.gamestate.size() - 1; i >= 0; --i) {
            if (!((String)this.gamestate.elementAt(i)).equals(state)) continue;
            return true;
        }
        return false;
    }

    public boolean inGameStateNextFrame(String state) {
        for (int i = this.gamestate_nextframe.size() - 1; i >= 0; --i) {
            if (!((String)this.gamestate_nextframe.elementAt(i)).equals(state)) continue;
            return true;
        }
        return false;
    }

    public void defineAnimation(String id, String[] frames, double speed) {
        this.animations.put(id, new Animation(frames, speed));
    }

    public void defineAnimation(String id, String[] frames, double speed, boolean pingpong) {
        this.animations.put(id, new Animation(frames, speed, pingpong));
    }

    public Animation getAnimation(String id) {
        return (Animation)this.animations.get(id);
    }

    public boolean and(int value, int mask) {
        return (value & mask) != 0;
    }

    public double random(double min, double max) {
        return min + this.random.nextDouble() * (max - min);
    }

    public double random(double min, double max, double interval) {
        int steps = (int)Math.floor(1.0E-5 + (max - min) / interval);
        return min + (double)((int)(this.random.nextDouble() * ((double)steps + 0.99))) * interval;
    }

    public int random(int min, int max, int interval) {
        int steps = (max - min) / interval;
        return min + (int)(this.random.nextDouble() * ((double)steps + 0.99)) * interval;
    }

    public JGPoint getTileIndex(double x, double y) {
        return new JGPoint((int)Math.floor(x / (double)this.tilex), (int)Math.floor(y / (double)this.tiley));
    }

    public JGPoint getTileCoord(int tilex, int tiley) {
        return new JGPoint(tilex * this.tileWidth(), tiley * this.tileHeight());
    }

    public JGPoint getTileCoord(JGPoint tileidx) {
        return new JGPoint(tileidx.x * this.tileWidth(), tileidx.y * this.tileHeight());
    }

    public double snapToGridX(double x, double gridsnapx) {
        if (gridsnapx <= 0.0) {
            return x;
        }
        int xaligned = this.tilex * (int)Math.floor((x + (double)this.tilex / 2.0) / (double)this.tilex);
        double gridofsx = Math.abs(x - (double)xaligned);
        if (gridofsx <= gridsnapx + 2.0E-4) {
            return xaligned;
        }
        return x;
    }

    public double snapToGridY(double y, double gridsnapy) {
        if (gridsnapy <= 0.0) {
            return y;
        }
        int yaligned = this.tiley * (int)Math.floor((y + (double)this.tiley / 2.0) / (double)this.tiley);
        double gridofsy = Math.abs(y - (double)yaligned);
        if (gridofsy <= gridsnapy + 2.0E-4) {
            return yaligned;
        }
        return y;
    }

    public void snapToGrid(JGPoint p, int gridsnapx, int gridsnapy) {
        if (gridsnapx == 0 && gridsnapy == 0) {
            return;
        }
        int xaligned = this.tilex * (int)Math.floor(((double)p.x + (double)this.tilex / 2.0) / (double)this.tilex);
        int yaligned = this.tiley * (int)Math.floor(((double)p.y + (double)this.tiley / 2.0) / (double)this.tiley);
        int gridofsx = Math.abs(p.x - xaligned);
        int gridofsy = Math.abs(p.y - yaligned);
        if (gridofsx <= gridsnapx) {
            p.x = xaligned;
        }
        if (gridofsy <= gridsnapy) {
            p.y = yaligned;
        }
    }

    public boolean isXAligned(double x, double margin) {
        int xaligned;
        if (margin < 0.0) {
            margin = 0.0;
        }
        return Math.abs(x - (double)(xaligned = this.tilex * (((int)x + this.tilex / 2) / this.tilex))) <= margin + 5.0E-5;
    }

    public boolean isYAligned(double y, double margin) {
        int yaligned;
        if (margin < 0.0) {
            margin = 0.0;
        }
        return Math.abs(y - (double)(yaligned = this.tiley * (((int)y + this.tiley / 2) / this.tiley))) <= margin + 5.0E-5;
    }

    public double getXAlignOfs(double x) {
        int xaligned = this.tilex * (((int)x + this.tilex / 2) / this.tilex);
        return x - (double)xaligned;
    }

    public double getYAlignOfs(double y) {
        int yaligned = this.tiley * (((int)y + this.tiley / 2) / this.tiley);
        return y - (double)yaligned;
    }

    public double getXDist(double x1, double x2) {
        if (this.pf_wrapx) {
            double x1mod = this.moduloFloor(x1, this.pfwidth);
            double x2mod = this.moduloFloor(x2, this.pfwidth);
            return Math.min(Math.abs(x1mod - x2mod), Math.abs(x1mod + (double)this.pfwidth - x2mod));
        }
        return Math.abs(x1 - x2);
    }

    public double getYDist(double y1, double y2) {
        if (this.pf_wrapy) {
            int pfheight = this.pfheight_half * 2;
            double y1mod = this.moduloFloor(y1, pfheight);
            double y2mod = this.moduloFloor(y2, pfheight);
            return Math.min(Math.abs(y1mod - y2mod), Math.abs(y1mod + (double)pfheight - y2mod));
        }
        return Math.abs(y1 - y2);
    }

    public void defineAudioClip(Object pkg_obj, String clipid, String filename) {
        filename = this.getAbsolutePath(pkg_obj, filename);
        this.audioclips.put(clipid, filename);
    }

    public class BGImage {
        public String imgname;
        public boolean wrapx;
        public boolean wrapy;
        public JGPoint tiles;
        public double xofs = 0.0;
        public double yofs = 0.0;

        public BGImage(String imgname, boolean wrapx, boolean wrapy) {
            this.imgname = imgname;
            this.wrapx = wrapx;
            this.wrapy = wrapy;
            this.tiles = new JGPoint((JGPoint)EngineLogic.this.image_orig_size.get(imgname));
            this.tiles.x /= EngineLogic.this.tilex;
            this.tiles.y /= EngineLogic.this.tiley;
        }
    }
}

