/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JOptionPane;
import jgame.Highscore;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGPoint;
import jgame.JGTimer;
import jgame.platform.AppConfig;
import jgame.platform.JGEngine;

public abstract class StdGame
extends JGEngine {
    public boolean audioenabled = true;
    public boolean audio_dialog_at_startup = true;
    public boolean accel_set_zero_menu = false;
    public int key_startgame = 32;
    public int key_gamesettings = 10;
    public int key_continuegame = 32;
    public int key_quitgame = 27;
    public int key_quitprogram = 27;
    public int key_pausegame = 80;
    public int key_left = 37;
    public int key_right = 39;
    public int key_up = 38;
    public int key_down = 40;
    public int key_fire = 90;
    public int key_fireleft = 65;
    public int key_fireright = 68;
    public int key_fireup = 87;
    public int key_firedown = 83;
    public int key_action = 88;
    public double gametime = 0.0;
    public double seqtimer = 0.0;
    public double timer = 0.0;
    public int score = 0;
    public int level = 0;
    public int stage = 0;
    public int lives = 0;
    public int initial_lives = 4;
    public int startgame_ticks = 80;
    public int leveldone_ticks = 80;
    public int lifelost_ticks = 80;
    public int gameover_ticks = 120;
    public boolean startgame_ingame = false;
    public boolean leveldone_ingame = false;
    public boolean lifelost_ingame = false;
    public boolean gameover_ingame = false;
    public int status_l_margin = 12;
    public int status_r_margin = 12;
    public JGFont status_font = new JGFont("Courier", 1, 12.0);
    public JGColor status_color = JGColor.white;
    public String lives_img = null;
    public JGFont title_font = new JGFont("Courier", 0, 18.0);
    public JGColor title_color = JGColor.white;
    public JGColor title_bg_color = JGColor.blue;
    boolean just_inited = true;
    public AppConfig appconfig = null;
    public Highscore[] highscores = null;
    public int highscore_maxnamelen = 15;
    public String playername = "";
    public int highscore_waittime = 500;
    public int highscore_showtime = 600;
    public JGFont highscore_font = new JGFont("Courier", 1, 16.0);
    public JGColor highscore_color = JGColor.white;
    public JGFont highscore_title_font = new JGFont("Courier", 1, 16.0);
    public JGColor highscore_title_color = JGColor.white;
    public String highscore_title = "Highest Scores";
    public String highscore_entry = "You have a high score!";

    public void setStatusDisplay(JGFont status_font, JGColor status_color, String lives_img) {
        this.status_font = status_font;
        this.status_color = status_color;
        this.lives_img = lives_img;
    }

    public void setSequences(boolean startgame_ingame, int startgame_ticks, boolean leveldone_ingame, int leveldone_ticks, boolean lifelost_ingame, int lifelost_ticks, boolean gameover_ingame, int gameover_ticks) {
        this.startgame_ingame = startgame_ingame;
        this.leveldone_ingame = leveldone_ingame;
        this.lifelost_ingame = lifelost_ingame;
        this.gameover_ingame = gameover_ingame;
        this.startgame_ticks = startgame_ticks;
        this.leveldone_ticks = leveldone_ticks;
        this.lifelost_ticks = lifelost_ticks;
        this.gameover_ticks = gameover_ticks;
    }

    public double[] getAccelZeroVector() {
        return new double[]{0.0, 0.0, 1.0};
    }

    public double[] getAccelZeroCorrected() {
        return this.getAccelVec();
    }

    public void setHighscores(int nr_highscores, Highscore default_hisc, int maxnamelen) {
        this.highscores = new Highscore[nr_highscores];
        for (int i = 0; i < nr_highscores; ++i) {
            this.highscores[i] = default_hisc;
        }
        this.highscore_maxnamelen = maxnamelen;
    }

    public void setHighscoreDisplay(int waittime, int showtime, JGFont font, JGColor color, String title, String entry, JGFont titlefont, JGColor titlecolor) {
        this.highscore_waittime = waittime;
        this.highscore_showtime = showtime;
        this.highscore_font = font;
        this.highscore_color = color;
        this.highscore_title = title;
        this.highscore_entry = entry;
        this.highscore_title_font = titlefont;
        this.highscore_title_color = titlecolor;
    }

    public static JGPoint parseSizeArgs(String[] args, int arg_ofs) {
        JGPoint size = new JGPoint(0, 0);
        if (args.length == arg_ofs + 2) {
            try {
                size.x = Integer.parseInt(args[arg_ofs]);
                size.y = Integer.parseInt(args[arg_ofs + 1]);
            }
            catch (Exception e) {
                System.out.println("\nError parsing width/height arguments.They should be integers.\n");
                System.exit(0);
            }
        } else if (args.length != arg_ofs) {
            System.out.println("\nYou can supply either no arguments, or [width] [height].\n");
            System.exit(0);
        }
        return size;
    }

    public void initNewGame(int level_selected) {
        this.stage = this.level = level_selected;
        this.score = 0;
        this.lives = this.initial_lives;
    }

    public void initNewLife() {
    }

    public void defineLevel() {
    }

    public void decrementLives() {
        --this.lives;
    }

    public void incrementLevel() {
        ++this.level;
        ++this.stage;
    }

    public void startGame() {
        this.startGame(0);
    }

    public void startGame(int level_selected) {
        this.gametime = 0.0;
        this.initNewGame(level_selected);
        this.defineLevel();
        this.initNewLife();
        this.clearKey(this.key_continuegame);
        this.seqtimer = 0.0;
        if (this.startgame_ticks > 0) {
            this.setGameState("StartLevel");
            this.addGameState("StartGame");
            if (this.startgame_ingame) {
                this.addGameState("InGame");
            }
            new JGTimer(this.startgame_ticks, true, "StartLevel"){

                public void alarm() {
                    StdGame.this.setGameState("InGame");
                }
            };
        } else {
            this.setGameState("InGame");
        }
    }

    public final void lifeLost() {
        if (!this.inGameState("InGame") || this.inGameState("LevelDone") || this.inGameState("LifeLost") || this.inGameState("GameOver")) {
            return;
        }
        this.clearKey(this.key_continuegame);
        this.removeGameState("StartLevel");
        this.removeGameState("StartGame");
        this.seqtimer = 0.0;
        if (this.lifelost_ticks > 0) {
            if (this.lifelost_ingame) {
                this.addGameState("LifeLost");
            } else {
                this.setGameState("LifeLost");
            }
            new JGTimer(this.lifelost_ticks, true, "LifeLost"){

                public void alarm() {
                    StdGame.this.endLifeLost();
                }
            };
        } else {
            this.endLifeLost();
        }
    }

    private void endLifeLost() {
        this.clearKey(this.key_continuegame);
        this.decrementLives();
        if (this.lives <= 0) {
            this.gameOver();
        } else {
            this.initNewLife();
            this.seqtimer = 0.0;
            if (this.startgame_ticks > 0) {
                this.setGameState("StartGame");
                if (this.startgame_ingame) {
                    this.addGameState("InGame");
                }
                new JGTimer(this.startgame_ticks, true, "StartGame"){

                    public void alarm() {
                        StdGame.this.setGameState("InGame");
                    }
                };
            } else {
                this.clearGameState();
                this.setGameState("InGame");
            }
        }
    }

    public final void levelDone() {
        if (!this.inGameState("InGame") || this.inGameState("LevelDone") || this.inGameState("LifeLost") || this.inGameState("GameOver")) {
            return;
        }
        this.clearKey(this.key_continuegame);
        this.removeGameState("StartLevel");
        this.removeGameState("StartGame");
        this.seqtimer = 0.0;
        if (this.leveldone_ticks > 0) {
            if (this.leveldone_ingame) {
                this.addGameState("LevelDone");
            } else {
                this.setGameState("LevelDone");
            }
            new JGTimer(this.leveldone_ticks, true, "LevelDone"){

                public void alarm() {
                    StdGame.this.levelDoneToStartLevel();
                }
            };
        } else {
            this.levelDoneToStartLevel();
        }
    }

    private void levelDoneToStartLevel() {
        this.clearKey(this.key_continuegame);
        this.gametime = 0.0;
        this.incrementLevel();
        this.defineLevel();
        this.seqtimer = 0.0;
        if (this.startgame_ticks > 0) {
            this.setGameState("StartLevel");
            this.addGameState("StartGame");
            if (this.startgame_ingame) {
                this.addGameState("InGame");
            }
            new JGTimer(this.startgame_ticks, true, "StartLevel"){

                public void alarm() {
                    StdGame.this.setGameState("InGame");
                }
            };
        } else {
            this.clearGameState();
            this.setGameState("InGame");
        }
    }

    public final void gameOver() {
        if (this.inGameState("GameOver") || !this.inGameState("InGame") && !this.inGameState("LifeLost")) {
            return;
        }
        this.clearKey(this.key_continuegame);
        this.removeGameState("StartLevel");
        this.removeGameState("StartGame");
        this.removeGameState("LifeLost");
        this.seqtimer = 0.0;
        if (this.gameover_ticks > 0) {
            if (this.gameover_ingame) {
                this.addGameState("GameOver");
            } else {
                this.setGameState("GameOver");
            }
            new JGTimer(this.gameover_ticks, true, "GameOver"){

                public void alarm() {
                    StdGame.this.gotoTitle();
                }
            };
        } else {
            this.gotoTitle();
        }
    }

    private void gotoTitle() {
        this.seqtimer = 0.0;
        this.clearKey(this.key_startgame);
        if (this.highscores != null && Highscore.findPos(this.highscores, this.score) >= 0) {
            this.setGameState("EnterHighscore");
        } else {
            this.setGameState("Title");
        }
    }

    public void initAppConfig() {
        this.appconfig = new AppConfig(this.getClass().getName().substring(this.getClass().getName().indexOf(46) + 1) + " settings", this, this.getConfigPath(this.getClass().getName() + ".cfg"));
        this.appconfig.defineField("audioenabled", "Enable Sound", "boolean");
        this.appconfig.defineFields("key_", "", "", "", "key");
        this.appconfig.loadFromFile();
        this.appconfig.saveToObject();
    }

    public void doFrame() {
        if (this.audioenabled) {
            this.enableAudio();
        } else {
            this.disableAudio();
        }
        if (this.inGameState("Paused")) {
            this.clearKey(this.key_pausegame);
            this.removeGameState("Paused");
            this.stop();
        }
        if (this.getKey(this.key_pausegame) && !this.inGameState("EnterHighscore")) {
            this.addGameState("Paused");
            this.clearKey(this.key_pausegame);
            this.wakeUpOnKey(this.key_pausegame);
        }
        this.timer += this.getGameSpeed();
        this.seqtimer += this.getGameSpeed();
        if (this.just_inited) {
            this.setGameState("Title");
            this.just_inited = false;
            Thread t = new Thread(new Runnable(){

                public void run() {
                    StdGame.this.initAppConfig();
                    if (StdGame.this.appconfig != null) {
                        StdGame.this.appconfig.setListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                StdGame.this.start();
                                StdGame.this.requestGameFocus();
                            }
                        });
                    }
                }
            });
            t.start();
            try {
                Highscore[] loadedhisc = Highscore.load(new FileInputStream(this.getConfigPath(this.getClass().getName() + ".hsc")));
                if (loadedhisc.length > 0) {
                    this.highscores = loadedhisc;
                }
            }
            catch (Exception exception) {}
        } else if (this.inGameState("InGame")) {
            this.gametime += this.getGameSpeed();
            if (this.getKey(this.key_quitgame)) {
                this.gameOver();
            }
        } else if (this.inGameState("Title") || this.inGameState("Highscores")) {
            if (this.getKey(this.key_quitprogram) && !this.isApplet()) {
                this.clearKey(this.key_quitprogram);
                new Thread(new QuitgameThread()).start();
                this.stop();
            }
            if (this.getKey(this.key_gamesettings) && this.appconfig != null) {
                this.appconfig.openGui();
                this.clearKey(this.key_gamesettings);
                this.stop();
            }
            if (this.getKey(this.key_startgame)) {
                this.startGame();
            }
            if (this.highscores != null) {
                if (this.getKey(this.key_continuegame)) {
                    this.clearKey(this.key_continuegame);
                    this.seqtimer = 0.0;
                    if (this.inGameState("Title")) {
                        this.setGameState("Highscores");
                    } else {
                        this.setGameState("Title");
                    }
                }
                if (this.inGameState("Title") && this.seqtimer >= (double)this.highscore_waittime) {
                    this.seqtimer = 0.0;
                    this.setGameState("Highscores");
                } else if (this.inGameState("Highscores") && this.seqtimer >= (double)this.highscore_showtime) {
                    this.seqtimer = 0.0;
                    this.setGameState("Title");
                }
            }
        } else if (this.inGameState("StartGame")) {
            if (this.getKey(this.key_continuegame)) {
                this.setGameState("InGame");
            }
        } else if (this.inGameState("LevelDone")) {
            if (this.getKey(this.key_continuegame)) {
                this.levelDoneToStartLevel();
            }
        } else if (this.inGameState("LifeLost")) {
            if (this.getKey(this.key_continuegame)) {
                this.endLifeLost();
            }
        } else if (this.inGameState("GameOver") && this.getKey(this.key_continuegame)) {
            this.gotoTitle();
        }
    }

    public void doFrameEnterHighscore() {
        char key = this.getLastKeyChar();
        this.clearLastKey();
        if (key == '\b' && this.playername.length() > 0) {
            this.playername = this.playername.substring(0, this.playername.length() - 1);
        }
        if (key == '\n') {
            this.highscores = Highscore.insert(this.highscores, new Highscore(this.score, this.playername));
            this.clearLastKey();
            this.clearKey(10);
            this.saveHighscores();
            this.seqtimer = 0.0;
            this.setGameState("Highscores");
        }
        if (key >= ' ' && key < '\u007f' && this.playername.length() < this.highscore_maxnamelen) {
            this.playername = this.playername + key;
        }
    }

    public boolean saveHighscores() {
        try {
            Highscore.save(this.highscores, new FileOutputStream(this.getConfigPath(this.getClass().getName() + ".hsc")));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void startTitle() {
    }

    public void startHighscores() {
    }

    public void startInGame() {
    }

    public void startStartLevel() {
    }

    public void startStartGame() {
    }

    public void startLevelDone() {
    }

    public void startLifeLost() {
    }

    public void startGameOver() {
    }

    public void startEnterHighscore() {
        this.clearLastKey();
        this.playername = "";
    }

    public void paintFrame() {
        this.setFont(this.status_font);
        this.setColor(this.status_color);
        this.drawString("Score " + this.score, this.status_l_margin, 0.0, -1);
        if (this.lives_img == null) {
            this.drawString("Lives " + this.lives, this.viewWidth() - this.status_r_margin, 0.0, 1);
        } else {
            this.drawCount(this.lives - 1, this.lives_img, this.viewWidth() - this.status_r_margin, 0, -this.getImageSize((String)this.lives_img).x - 2);
        }
    }

    public void paintFrameTitle() {
        this.drawString(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1), this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", this.viewWidth() / 2, (double)(6 * this.viewHeight() / 10), 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_gamesettings) + " for settings", this.viewWidth() / 2, (double)(7 * this.viewHeight() / 10), 0, this.title_font, this.title_color);
    }

    public void paintFramePaused() {
        this.setColor(this.title_bg_color);
        this.drawRect(this.viewWidth() / 20, 15 * this.viewHeight() / 36, 18 * this.viewWidth() / 20, 5 * this.viewHeight() / 36 + (int)this.getFontHeight(this.title_font), true, false, false);
        this.drawString("Paused", this.viewWidth() / 2, (double)(16 * this.viewHeight() / 36), 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_pausegame) + " to continue", this.viewWidth() / 2, (double)(19 * this.viewHeight() / 36), 0, this.title_font, this.title_color);
    }

    public void paintFrameStartLevel() {
        this.drawString("Level " + (this.stage + 1), this.viewWidth() / 2, (double)(3 * this.viewHeight() / 5), 0, this.title_font, this.title_color);
    }

    public void paintFrameStartGame() {
        this.drawString("Start !", this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
    }

    public void paintFrameLevelDone() {
        this.drawString("Level Done !", this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
    }

    public void paintFrameLifeLost() {
        this.drawString("Life Lost !", this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
    }

    public void paintFrameGameOver() {
        this.drawString("Game Over !", this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.title_font, this.title_color);
    }

    public void paintFrameEnterHighscore() {
        this.drawString(this.highscore_entry, this.viewWidth() / 2, (double)(this.viewHeight() / 3), 0, this.highscore_title_font, this.highscore_title_color);
        this.drawString("" + this.score, this.viewWidth() / 2, (double)(this.viewHeight() / 2), 0, this.highscore_font, this.highscore_color);
        this.drawString(this.playername + "|", this.viewWidth() / 2, (double)(2 * this.viewHeight() / 3), 0, this.highscore_font, this.highscore_color);
    }

    public void paintFrameHighscores() {
        this.drawString(this.highscore_title, this.viewWidth() / 2, (double)(this.viewHeight() / 7), 0, this.highscore_title_font, this.highscore_title_color);
        double yinc = 0.7 * (double)this.viewHeight() / (double)this.highscores.length;
        double ypos = 0.6 * (double)this.viewHeight() - yinc * ((double)this.highscores.length / 2.0);
        for (int i = 0; i < this.highscores.length; ++i) {
            this.drawString("" + this.highscores[i].score, 0.35 * (double)this.viewWidth(), ypos + (double)i * yinc, 1, this.highscore_font, this.highscore_color);
            this.drawString(this.highscores[i].name, 0.6 * (double)this.viewWidth(), ypos + (double)i * yinc, 0, this.highscore_font, this.highscore_color);
        }
    }

    public boolean checkTime(int min_time, int max_time, int increment) {
        return this.gametime > (double)min_time && this.gametime < (double)max_time && (this.gametime - 1.0) % (double)increment < this.getGameSpeed();
    }

    public boolean checkTime(int increment) {
        return (this.gametime - 1.0) % (double)increment < this.getGameSpeed();
    }

    public void drawCount(int count, String image, int x, int y, int increment_x) {
        if (increment_x < 0) {
            x += increment_x;
        }
        for (int i = 0; i < count; ++i) {
            this.drawImage(x + i * increment_x, (double)y, image, false);
        }
    }

    public void drawWavyString(String s, int x, int y, int align, int increment_x, double tmr, double amplitude, double pos_phaseshift, double timer_phaseshift, JGFont font, JGColor col) {
        this.setFont(font);
        this.setColor(col);
        if (align == 0) {
            x -= increment_x * s.length() / 2;
        } else if (align == 1) {
            x -= increment_x * s.length();
        }
        for (int i = 0; i < s.length(); ++i) {
            this.drawString(s.substring(i, i + 1), x + i * increment_x, y + (int)(amplitude * -Math.cos(Math.PI * (pos_phaseshift * (double)i + tmr * timer_phaseshift))), 0);
        }
    }

    public JGFont getZoomingFont(JGFont basejgfont, double tmr, double min_size_fac, double speed) {
        return new JGFont(basejgfont.name, basejgfont.style, basejgfont.size * (min_size_fac + 0.5 - 0.5 * Math.cos(Math.PI * speed * tmr)));
    }

    public JGColor cycleColor(JGColor[] cycle, double tmr, double speed) {
        return cycle[(int)(tmr * speed) % cycle.length];
    }

    public int posWalkForwards(int begin_pos, int end_pos, double tmr, int end_time, int standstill_pos, int standstill_time, int standstill_count) {
        if (tmr < (double)standstill_time) {
            double step = (double)(standstill_pos - begin_pos) / (double)standstill_time;
            return begin_pos + (int)(tmr * step);
        }
        if (tmr >= (double)standstill_time && tmr < (double)(standstill_time + standstill_count)) {
            return standstill_pos;
        }
        if (tmr >= (double)(standstill_time + standstill_count) && tmr < (double)end_time) {
            int beg2_time = standstill_time + standstill_count;
            double step = (double)(end_pos - standstill_pos) / (double)(end_time - beg2_time);
            return standstill_pos + (int)((tmr - (double)beg2_time) * step);
        }
        return end_pos;
    }

    class QuitgameThread
    implements Runnable {
        public void run() {
            int opt = JOptionPane.showConfirmDialog(null, "Really quit?", "Quit Game", 2);
            if (opt == 0) {
                System.exit(0);
            }
            StdGame.this.start();
        }
    }
}

