/*
 * Decompiled with CFR 0.152.
 */
package examples.ogrotron;

import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class Ogrotron
extends StdGame {
    Player player = null;
    boolean first_time = true;
    boolean has_fired = false;
    int show_man_accel = 0;
    int show_man_touch = 0;
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);
    JGColor[] cyclecol = new JGColor[]{JGColor.yellow, JGColor.green, JGColor.cyan, JGColor.blue, JGColor.magenta, JGColor.red};

    public static void main(String[] args) {
        new Ogrotron(Ogrotron.parseSizeArgs(args, 0));
    }

    public Ogrotron() {
        this.initEngineApplet();
    }

    public Ogrotron(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(15, 20, 16, 16, null, null, null);
    }

    public void initGame() {
        this.setProgressMessage("");
        this.defineMedia("ogrotron.tbl");
        this.setSmoothing(false);
        this.setVideoSyncedUpdate(true);
        if (this.isMidlet()) {
            this.setFrameRate(25.0, 1.0);
            this.setGameSpeed(2.0);
        } else {
            this.setFrameRate(50.0, 1.0);
            this.title_font = new JGFont("Arial", 0, 11.0);
            this.highscore_title_font = new JGFont("Arial", 0, 11.0);
            this.highscore_font = new JGFont("Arial", 0, 11.0);
        }
        this.setScalingPreferences(0.9, 1.12, 5, 5, 5, 5);
        this.leveldone_ingame = true;
        this.startgame_ingame = true;
        this.lifelost_ingame = true;
        this.accel_set_zero_menu = true;
        this.setPFSize(17, 22);
        this.status_font = new JGFont("Arial", 0, 16.0);
        this.title_font = new JGFont("Arial", 0, 16.0);
    }

    public void startTitle() {
        this.show_man_accel = 0;
        this.show_man_touch = 0;
        this.fillBG("");
        this.setBGImage("introscreen");
        this.setViewOffset(0, 0, false);
    }

    public void paintFrameTitle() {
    }

    public void doFrameTitle() {
        if (this.getMouseButton(1)) {
            this.clearMouseButton(1);
            if (this.getMouseY() > 3 * this.viewHeight() / 4) {
                this.invokeUrl("http://tmtg.net/", "_blank");
            } else {
                this.startGame();
            }
        }
    }

    public void defineLevel() {
        int i;
        this.removeObjects(null, 0);
        this.fillBG("");
        this.setBGImage("bg" + this.stage % 3);
        this.player = new Player(this.pfWidth() / 2 - 8, this.pfHeight() / 2 - 8);
        for (i = 0; i < 8 + this.level * 2; ++i) {
            double y;
            double x;
            do {
                x = this.random(0.0, this.pfWidth() - 16);
                y = this.random(0.0, this.pfHeight() - 16);
            } while (!(x < (double)(this.pfWidth() / 2 - 24) || x > (double)(this.pfWidth() / 2 + 24) || y < (double)(this.pfHeight() / 2 - 24)) && !(y > (double)(this.pfHeight() / 2 + 24)));
            new Ogre(x, y, this.random(0.45, 0.8));
        }
        for (i = 0; i < 8 + 2 * this.level; ++i) {
            this.setTile(this.random(0, this.pfTilesX(), 1), this.random(0, this.pfTilesY(), 1), "" + this.stage % 5);
        }
    }

    public void initNewLife() {
        this.player = new Player(this.pfWidth() / 2 - 8, this.pfHeight() / 2 - 8);
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
        this.first_time = false;
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(4, 1);
        this.checkBGCollision(1, 5);
        this.checkCollision(2, 4);
        if (this.countObjects(null, 4) == 0) {
            this.levelDone();
        }
    }

    public void paintFrameInGame() {
        if (this.getMouseButton(1) && (this.isAndroid() || this.isMidlet())) {
            this.drawImage(this.getMouseX(), (double)this.getMouseY(), "crosshairs" + (int)this.seqtimer / 3 % 3);
        }
        double[] accel = this.getAccelZeroCorrected();
        if (this.level == 0 && this.first_time && this.gametime < 200.0 && this.show_man_accel == 0 && Math.abs(accel[2]) < Math.max(Math.abs(accel[0]), Math.abs(accel[1]))) {
            this.show_man_accel = 200;
        }
        if (this.level == 0 && this.first_time && this.gametime > 250.0 && this.gametime < 260.0 && this.show_man_touch == 0 && !this.has_fired) {
            this.show_man_touch = 200;
        }
        if (this.level == 0) {
            if (this.show_man_accel > 0) {
                --this.show_man_accel;
                double alpha = this.show_man_accel > 50 ? 1.0 : (double)this.show_man_accel / 50.0;
                double scale = 0.7 - 0.07 * ((double)this.show_man_accel / 4.0 / 50.0);
                this.drawImage(-40.0, 25.0, "manual_accel", null, alpha, 0.0, scale, false);
            } else if (this.show_man_touch > 0) {
                --this.show_man_touch;
                double alpha = this.show_man_touch > 50 ? 1.0 : (double)this.show_man_touch / 50.0;
                double scale = 0.7 - 0.07 * ((double)this.show_man_touch / 4.0 / 50.0);
                this.drawImage(-40.0, 25.0, "manual_touch", null, alpha, 0.0, scale, false);
            }
        }
    }

    public void incrementLevel() {
        if (this.level < 8) {
            ++this.level;
        }
        ++this.stage;
    }

    void explode(double x, double y) {
        this.playAudio("explo");
        if (this.isOpenGL() || this.isAndroid()) {
            double baseang = this.random(0.0, 3.14);
            double phase = this.random(0.0, 6.28);
            new Explo(x, y, baseang, 2.1, phase);
            new Explo(x, y, baseang + 2.5132741228718345, 2.0, phase);
            new Explo(x, y, baseang + 5.026548245743669, 1.9, phase);
            new Explo(x, y, baseang + 1.2566370614359172, 1.8, phase);
            new Explo(x, y, baseang + 3.7699111843077517, 1.7, phase);
        } else {
            new JGObject("explo", true, x, y, 0, "explo_u", 0.0, -4.0, -2);
            new JGObject("explo", true, x, y, 0, "explo_d", 0.0, 4.0, -2);
        }
    }

    public class Player
    extends JGObject {
        double bullettimer = 0.0;
        double invultimer = 100.0;
        double bulxspeed = 0.0;
        double bulyspeed = 0.0;

        public Player(double x, double y) {
            super("player", false, x, y, 1, "player", 1.0, 1.0, -1);
            this.setBBox(4, 4, 8, 8);
        }

        public void move() {
            Ogrotron.this.setViewOffset((int)(this.x / (double)pfwidth * 32.0), (int)(this.y / (double)pfheight * 32.0), false);
            if (Ogrotron.this.getMouseButton(1)) {
                double angle = Ogrotron.this.atan2((double)(Ogrotron.this.viewXOfs() + Ogrotron.this.getMouseX()) - this.x, (double)(Ogrotron.this.viewYOfs() + Ogrotron.this.getMouseY()) - this.y);
                this.xspeed = 3.0 * Math.sin(angle);
                this.yspeed = 3.0 * Math.cos(angle);
                this.xdir = 1;
                this.ydir = 1;
                this.bulxspeed = -this.xspeed * (double)this.xdir;
                this.bulyspeed = -this.yspeed * (double)this.ydir;
                if (this.xspeed < 0.0) {
                    this.setGraphic("player_l");
                } else {
                    this.setGraphic("player_r");
                }
            } else {
                this.xspeed = 3.0;
                this.yspeed = 3.0;
                this.setDir(0, 0);
                if (Ogrotron.this.getKey(Ogrotron.this.key_up) && this.y > this.yspeed) {
                    this.ydir = -1;
                }
                if (Ogrotron.this.getKey(Ogrotron.this.key_down) && this.y < (double)(Ogrotron.this.pfHeight() - 16)) {
                    this.ydir = 1;
                }
                if (Ogrotron.this.getKey(Ogrotron.this.key_left) && this.x > this.xspeed) {
                    this.xdir = -1;
                    this.setGraphic("player_l");
                }
                if (Ogrotron.this.getKey(Ogrotron.this.key_right) && this.x < (double)(Ogrotron.this.pfWidth() - 16)) {
                    this.xdir = 1;
                    this.setGraphic("player_r");
                }
                if (this.xdir != 0 || this.ydir != 0) {
                    this.bulxspeed = this.xspeed * (double)this.xdir;
                    this.bulyspeed = this.yspeed * (double)this.ydir;
                }
            }
            if (this.bullettimer <= 0.0) {
                if (this.bulxspeed != 0.0 || this.bulyspeed != 0.0) {
                    this.bullettimer = 8.0;
                    new JGObject("bullet", true, this.x, this.y, 2, "bullet", -2.0 * this.bulxspeed, -2.0 * this.bulyspeed, -2);
                    Ogrotron.this.has_fired = true;
                }
            } else {
                this.bullettimer -= gamespeed;
            }
            if (this.invultimer >= 0.0) {
                this.invultimer -= gamespeed;
            }
            double[] accel = Ogrotron.this.getAccelZeroCorrected();
            if (Ogrotron.this.hasAccelerometer() && (accel[0] != 0.0 || accel[1] != 0.0)) {
                double angle = Ogrotron.this.atan2(accel[0], accel[1]);
                this.xspeed = 2.0 * accel[0];
                this.yspeed = 2.0 * accel[1];
                this.xdir = 1;
                this.ydir = 1;
            }
            if (this.x < 8.0) {
                this.x = 8.0;
                if (this.xspeed < 0.0) {
                    this.xspeed = 0.0;
                }
            }
            if (this.x > (double)(pfwidth - 24)) {
                this.x = pfwidth - 24;
                if (this.xspeed > 0.0) {
                    this.xspeed = 0.0;
                }
            }
            if (this.y < 8.0) {
                this.y = 8.0;
                if (this.yspeed < 0.0) {
                    this.yspeed = 0.0;
                }
            }
            if (this.y > (double)(pfheight - 24)) {
                this.y = pfheight - 24;
                if (this.yspeed > 0.0) {
                    this.yspeed = 0.0;
                }
            }
        }

        public void paint() {
            if (this.invultimer >= 0.0 && (int)this.invultimer % 4 < 2) {
                Ogrotron.this.setColor(JGColor.white);
                Ogrotron.this.drawOval(this.x + 9.0, this.y + 9.0, 19.0, 19.0, true, true);
            }
        }

        public void hit_bg(int tilecid, int tilex, int tiley) {
            Ogrotron.this.setTile(tilex, tiley, "");
            Ogrotron.this.score += 25;
            Ogrotron.this.playAudio("bonus");
            if (Ogrotron.this.isAndroid() || Ogrotron.this.isOpenGL()) {
                new Pts(tilex * tilewidth, tiley * tileheight);
            } else {
                new JGObject("pts", true, (double)(tilex * tilewidth), (double)(tiley * tileheight), 0, "pts", 0.0, -0.25, 80);
            }
        }

        public void hit(JGObject obj) {
            if (this.invultimer < 0.0) {
                this.remove();
                obj.remove();
                Ogrotron.this.explode(obj.x, obj.y);
                Ogrotron.this.lifeLost();
                Ogrotron.this.playAudio("death");
                Ogrotron.this.explode(this.x, this.y);
            }
        }
    }

    public class Pts
    extends JGObject {
        int cyc = 0;

        public Pts(double x, double y) {
            super("pts", true, x - 8.0, y - 8.0, 0, null, 70);
            this.setBBox(0, 0, 32, 32);
        }

        public void paint() {
            double alpha = this.expiry / 70.0;
            this.cyc = (this.cyc + 1) % (2 * Ogrotron.this.cyclecol.length);
            int anim = this.cyc / 2;
            Ogrotron.this.setBlendMode(1, 0);
            Ogrotron.this.drawImage(this.x, this.y, "pts_large", Ogrotron.this.cyclecol[anim], alpha, 0.0, 2.0 - 1.5 * this.expiry / 70.0, true);
            Ogrotron.this.setBlendMode(1, -1);
        }
    }

    public class Explo
    extends JGObject {
        double ang;
        double cenx;
        double ceny;
        double speed;
        double phase;

        public Explo(double x, double y, double ang, double speed, double phase) {
            super("explo", true, x, y, 0, null, 70);
            this.setBBox(0, 0, 16, 16);
            this.cenx = x;
            this.ceny = y;
            this.speed = speed;
            this.phase = phase;
            this.ang = ang;
        }

        public void move() {
            this.x = this.cenx + (70.0 - this.expiry) * this.speed * Math.sin(this.ang);
            this.y = this.ceny + (70.0 - this.expiry) * this.speed * Math.cos(this.ang);
            this.ang += 0.01 * Math.sin(0.001 * this.expiry + this.phase);
        }

        public void paint() {
            double alpha = this.expiry / 70.0;
            int anim = 1 + ((int)this.expiry / 2 & 1);
            Ogrotron.this.setBlendMode(1, 0);
            Ogrotron.this.drawImage(this.x, this.y, "explo_d" + anim, null, alpha, this.ang, 2.0 - 1.2 * this.expiry / 70.0, true);
            Ogrotron.this.setBlendMode(1, -1);
        }
    }

    class Spawned
    extends JGObject {
        double sleeptmr = this.random(150.0, 200.0);
        double speed = this.random(1.0, 2.0);
        double circleang = this.random(0.1, 0.5);
        double newdirtimer = 0.0;

        Spawned(double x, double y) {
            super("spawn", true, x, y, 4, "egg");
        }

        public void move() {
            if (this.sleeptmr > 0.0) {
                this.sleeptmr -= gamespeed;
                return;
            }
            this.setGraphic("spawn");
            if (this.newdirtimer <= 0.0) {
                this.newdirtimer = this.random(15.0, 35.0);
                if (Ogrotron.this.player != null) {
                    double ang = Ogrotron.this.atan2(Ogrotron.this.player.x - this.x, Ogrotron.this.player.y - this.y) + this.circleang;
                    this.setSpeed(this.speed * Math.sin(ang), this.speed * Math.cos(ang));
                } else {
                    this.setSpeed(0.0, 0.0);
                }
            } else {
                this.newdirtimer -= gamespeed;
            }
        }

        public void hit(JGObject obj) {
            Ogrotron.this.score += 5;
            this.remove();
            obj.remove();
            Ogrotron.this.explode(this.x, this.y);
        }
    }

    class Ogre
    extends JGObject {
        double speed;
        double newdirtimer = 0.0;

        Ogre(double x, double y, double speed) {
            super("ogre", true, x, y, 4, "ogre" + Ogrotron.this.stage % 3);
            this.speed = speed;
        }

        public void move() {
            if (this.newdirtimer <= 0.0) {
                this.newdirtimer = this.random(15.0, 35.0);
                double ang = this.random(0.0, Math.PI * 2);
                if (this.random(0.0, 1.0) > 0.5 && Ogrotron.this.player != null) {
                    ang = Ogrotron.this.atan2(Ogrotron.this.player.x - this.x, Ogrotron.this.player.y - this.y);
                }
                this.setSpeedAbs(this.speed * Math.sin(ang), this.speed * Math.cos(ang));
                if (this.x < 0.0 && this.xdir <= 0) {
                    this.xdir = 1;
                }
                if (this.x > (double)pfwidth && this.xdir >= 0) {
                    this.xdir = -1;
                }
                if (this.y < 0.0 && this.ydir <= 0) {
                    this.ydir = 1;
                }
                if (this.y > (double)pfheight && this.ydir >= 0) {
                    this.ydir = -1;
                }
            } else {
                this.newdirtimer -= gamespeed;
            }
        }

        public void hit(JGObject obj) {
            Ogrotron.this.score += 10;
            this.remove();
            obj.remove();
            Ogrotron.this.explode(this.x, this.y);
        }

        public void hit_bg(int tilecid, int tilex, int tiley) {
            Ogrotron.this.setTile(tilex, tiley, "");
            new Spawned(tilex * tilewidth, tiley * tileheight);
        }
    }
}

