/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGImage;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.JGTimer;
import jgame.impl.Animation;
import jgame.impl.EngineLogic;
import jgame.impl.JGEngineInterface;
import jgame.impl.JGameError;
import jgame.impl.SortedArray;
import jgame.platform.JREEngine;
import jgame.platform.JREImage;

public abstract class JGEngine
extends Applet
implements JGEngineInterface {
    JREImage imageutil = new JREImage();
    EngineLogic el = new EngineLogic(this.imageutil, true, true);
    JREEngine jre = new JREEngine(this.el, this);
    private Thread thread = null;
    JGCanvas canvas = null;
    boolean running = true;
    boolean i_am_applet = false;
    public static final int KeyBackspace = 8;
    public static final int KeyTab = 9;
    Graphics buf_gfx = null;
    Image background = null;
    Image buffer = null;
    Graphics bgg = null;
    int debugflags = 8;
    static final int BBOX_DEBUG = 1;
    static final int GAMESTATE_DEBUG = 2;
    static final int FULLSTACKTRACE_DEBUG = 4;
    static final int MSGSINPF_DEBUG = 8;
    private static int dbgframelog_expiry = 80;
    private JGFont debugmessage_font = new JGFont("Arial", 0, 12.0);
    JGColor debug_auxcolor1 = JGColor.green;
    JGColor debug_auxcolor2 = JGColor.magenta;
    private Hashtable dbgframelogs = new Hashtable();
    private Hashtable dbgnewframelogs = new Hashtable();
    private Hashtable dbgframelogs_new = new Hashtable();
    private Hashtable dbgframelogs_obj = new Hashtable();
    private Hashtable dbgframelogs_dead = new Hashtable();
    private BufferedImage null_image = new BufferedImage(1, 1, 2);

    public JGImage getImage(String imgname) {
        return this.el.getImage(imgname);
    }

    public JGPoint getImageSize(String imgname) {
        return this.el.getImageSize(imgname);
    }

    public void defineImage(String name, String tilename, int collisionid, String imgfile, String img_op, int top, int left, int width, int height) {
        this.el.defineImage(this, name, tilename, collisionid, imgfile, img_op, top, left, width, height);
    }

    public void defineImage(String imgname, String tilename, int collisionid, String imgfile, String img_op) {
        this.el.defineImage(this, imgname, tilename, collisionid, imgfile, img_op);
    }

    public void defineImage(String imgname, String tilename, int collisionid, String imgmap, int mapidx, String img_op, int top, int left, int width, int height) {
        this.el.defineImage(imgname, tilename, collisionid, imgmap, mapidx, img_op, top, left, width, height);
    }

    public void defineImage(String imgname, String tilename, int collisionid, String imgmap, int mapidx, String img_op) {
        this.el.defineImage(imgname, tilename, collisionid, imgmap, mapidx, img_op);
    }

    public void defineImageRotated(String name, String tilename, int collisionid, String srcname, double angle) {
        this.el.defineImageRotated(this, name, tilename, collisionid, srcname, angle);
    }

    public void defineImageMap(String mapname, String imgfile, int xofs, int yofs, int tilex, int tiley, int skipx, int skipy) {
        this.el.defineImageMap(this, mapname, imgfile, xofs, yofs, tilex, tiley, skipx, skipy);
    }

    public JGRectangle getImageBBox(String imgname) {
        return this.el.getImageBBox(imgname);
    }

    public void defineMedia(String filename) {
        this.el.defineMedia(this, filename);
    }

    public void markAddObject(JGObject obj) {
        this.el.markAddObject(obj);
    }

    public boolean existsObject(String index) {
        return this.el.existsObject(index);
    }

    public JGObject getObject(String index) {
        return this.el.getObject(index);
    }

    public void moveObjects(String prefix, int cidmask) {
        this.el.moveObjects(this, prefix, cidmask);
    }

    public void moveObjects() {
        this.el.moveObjects(this);
    }

    public void checkCollision(int srccid, int dstcid) {
        this.el.checkCollision(this, srccid, dstcid);
    }

    public int checkCollision(int cidmask, JGObject obj) {
        return this.el.checkCollision(cidmask, obj);
    }

    public int checkBGCollision(JGRectangle r) {
        return this.el.checkBGCollision(r);
    }

    public void checkBGCollision(int tilecid, int objcid) {
        this.el.checkBGCollision(this, tilecid, objcid);
    }

    public Vector getObjects(String prefix, int cidmask, boolean suspended_obj, JGRectangle bbox) {
        return this.el.getObjects(prefix, cidmask, suspended_obj, bbox);
    }

    public void removeObject(JGObject obj) {
        this.el.removeObject(obj);
    }

    public void removeObjects(String prefix, int cidmask) {
        this.el.removeObjects(prefix, cidmask);
    }

    public void removeObjects(String prefix, int cidmask, boolean suspended_obj) {
        this.el.removeObjects(prefix, cidmask, suspended_obj);
    }

    public int countObjects(String prefix, int cidmask) {
        return this.el.countObjects(prefix, cidmask);
    }

    public int countObjects(String prefix, int cidmask, boolean suspended_obj) {
        return this.el.countObjects(prefix, cidmask, suspended_obj);
    }

    void drawObject(Graphics g, JGObject o) {
        if (!o.is_suspended) {
            this.drawImage(g, (int)o.x, (int)o.y, o.getImageName(), true);
            try {
                o.paint();
            }
            catch (JGameError ex) {
                this.exitEngine(this.dbgExceptionToString(ex));
            }
            catch (Exception e) {
                this.dbgShowException(o.getName(), e);
            }
        }
        if ((this.debugflags & 1) != 0) {
            this.setColor(g, this.el.fg_color);
            JGRectangle bbox = o.getBBox();
            if (bbox != null) {
                bbox = this.el.scalePos(bbox, true);
                g.drawRect(bbox.x, bbox.y, bbox.width, bbox.height);
            }
            if ((bbox = o.getTileBBox()) != null) {
                bbox = this.el.scalePos(bbox, true);
                g.drawRect(bbox.x, bbox.y, bbox.width, bbox.height);
                this.setColor(g, this.debug_auxcolor1);
                bbox = o.getTileBBox();
                bbox = this.getTiles(bbox);
                bbox.x *= this.el.tilex;
                bbox.y *= this.el.tiley;
                bbox.width *= this.el.tilex;
                bbox.height *= this.el.tiley;
                bbox = this.el.scalePos(bbox, true);
                g.drawRect(bbox.x, bbox.y, bbox.width, bbox.height);
                this.setColor(g, this.debug_auxcolor2);
                bbox = o.getCenterTiles();
                bbox.x *= this.el.tilex;
                bbox.y *= this.el.tiley;
                bbox.width *= this.el.tilex;
                bbox.height *= this.el.tiley;
                bbox = this.el.scalePos(bbox, true);
                g.drawRect(bbox.x + 2, bbox.y + 2, bbox.width - 4, bbox.height - 4);
            }
        }
    }

    public void setBGImage(String bgimg) {
        this.el.setBGImage(bgimg, 0, true, true);
    }

    public void setBGImage(int depth, String bgimg, boolean wrapx, boolean wrapy) {
        this.el.setBGImage(bgimg, depth, wrapx, wrapy);
    }

    public void setTileSettings(String out_of_bounds_tile, int out_of_bounds_cid, int preserve_cids) {
        this.el.setTileSettings(out_of_bounds_tile, out_of_bounds_cid, preserve_cids);
    }

    public void fillBG(String filltile) {
        this.el.fillBG(filltile);
    }

    public void setTileCid(int x, int y, int and_mask, int or_mask) {
        this.el.setTileCid(x, y, and_mask, or_mask);
    }

    public void setTile(int x, int y, String tilestr) {
        this.el.setTile(x, y, tilestr);
    }

    void setColor(Graphics g, JGColor col) {
        col.impl = new Color(col.r, col.g, col.b);
        g.setColor((Color)col.impl);
    }

    public void drawTile(int xi, int yi, int tileid) {
        Integer tileid_obj;
        JREImage img;
        if (this.background == null) {
            return;
        }
        int x = this.el.moduloFloor(xi + 1, this.el.viewnrtilesx + 3) * this.el.scaledtilex;
        int y = this.el.moduloFloor(yi + 1, this.el.viewnrtilesy + 3) * this.el.scaledtiley;
        if (this.bgg == null) {
            this.bgg = this.background.getGraphics();
        }
        if ((img = (JREImage)this.el.getTileImage(tileid_obj = new Integer(tileid))) == null || this.el.images_transp.containsKey(tileid_obj)) {
            EngineLogic.BGImage bg_image = (EngineLogic.BGImage)this.el.bg_images.get(0);
            if (bg_image == null) {
                this.setColor(this.bgg, this.el.bg_color);
                this.bgg.fillRect(x, y, this.el.scaledtilex, this.el.scaledtiley);
            } else {
                int xtile = this.el.moduloFloor(xi, bg_image.tiles.x);
                int ytile = this.el.moduloFloor(yi, bg_image.tiles.y);
                this.bgg.drawImage(((JREImage)this.el.getImage((String)bg_image.imgname)).img, x, y, x + this.el.scaledtilex, y + this.el.scaledtiley, xtile * this.el.scaledtilex, ytile * this.el.scaledtiley, (xtile + 1) * this.el.scaledtilex, (ytile + 1) * this.el.scaledtiley, (Color)this.el.bg_color.impl, null);
            }
        }
        if (img != null) {
            this.bgg.drawImage(img.img, x, y, this);
        }
    }

    public int countTiles(int tilecidmask) {
        return this.el.countTiles(tilecidmask);
    }

    public int getTileCid(int xidx, int yidx) {
        return this.el.getTileCid(xidx, yidx);
    }

    public String getTileStr(int xidx, int yidx) {
        return this.el.getTileStr(xidx, yidx);
    }

    public int getTileCid(JGRectangle tiler) {
        return this.el.getTileCid(tiler);
    }

    public JGRectangle getTiles(JGRectangle r) {
        return this.el.getTiles(r);
    }

    public boolean getTiles(JGRectangle dest, JGRectangle r) {
        return this.el.getTiles(dest, r);
    }

    public void setTileCid(int x, int y, int value) {
        this.el.setTileCid(x, y, value);
    }

    public void orTileCid(int x, int y, int or_mask) {
        this.el.orTileCid(x, y, or_mask);
    }

    public void andTileCid(int x, int y, int and_mask) {
        this.el.andTileCid(x, y, and_mask);
    }

    public void setTile(JGPoint tileidx, String tilename) {
        this.el.setTile(tileidx, tilename);
    }

    public void setTiles(int xofs, int yofs, String[] tilemap) {
        this.el.setTiles(xofs, yofs, tilemap);
    }

    public void setTilesMulti(int xofs, int yofs, String[] tilemap) {
        this.el.setTilesMulti(xofs, yofs, tilemap);
    }

    public int getTileCidAtCoord(double x, double y) {
        return this.el.getTileCidAtCoord(x, y);
    }

    public int getTileCid(JGPoint center, int xofs, int yofs) {
        return this.el.getTileCid(center, xofs, yofs);
    }

    public String getTileStrAtCoord(double x, double y) {
        return this.el.getTileStrAtCoord(x, y);
    }

    public String getTileStr(JGPoint center, int xofs, int yofs) {
        return this.el.getTileStr(center, xofs, yofs);
    }

    public int tileStrToID(String tilestr) {
        return this.el.tileStrToID(tilestr);
    }

    public String tileIDToStr(int tileid) {
        return this.el.tileIDToStr(tileid);
    }

    void copyBGToBuf(Graphics bufg, int sx1, int sy1, int sx2, int sy2, int dx1, int dy1) {
        if (sx2 <= sx1 || sy2 <= sy1) {
            return;
        }
        int barrelx = this.el.scaleXPos(this.el.moduloFloor(this.el.xofs, this.el.tilex), false);
        int barrely = this.el.scaleYPos(this.el.moduloFloor(this.el.yofs, this.el.tiley), false);
        int barreldx = sx1 == 0 ? barrelx : 0;
        int barreldy = sy1 == 0 ? barrely : 0;
        barrelx = sx1 == 0 ? 0 : barrelx;
        barrely = sy1 == 0 ? 0 : barrely;
        int dx2 = dx1 + sx2 - sx1;
        int dy2 = dy1 + sy2 - sy1;
        bufg.drawImage(this.background, dx1 * this.el.scaledtilex - barreldx, dy1 * this.el.scaledtiley - barreldy, dx2 * this.el.scaledtilex - barreldx, dy2 * this.el.scaledtiley - barreldy, barrelx + sx1 * this.el.scaledtilex, barrely + sy1 * this.el.scaledtiley, barrelx + sx2 * this.el.scaledtilex, barrely + sy2 * this.el.scaledtiley, this);
    }

    public double moduloXPos(double x) {
        return this.el.moduloXPos(x);
    }

    public double moduloYPos(double y) {
        return this.el.moduloYPos(y);
    }

    public void setProgressBar(double pos) {
        this.canvas.setProgressBar(pos);
    }

    public void setProgressMessage(String msg) {
        this.canvas.setProgressMessage(msg);
    }

    public void setAuthorMessage(String msg) {
        this.canvas.setAuthorMessage(msg);
    }

    private void refreshDbgFrameLogs() {
        this.dbgframelogs_new = new Hashtable();
        Enumeration e = this.dbgnewframelogs.keys();
        while (e.hasMoreElements()) {
            String source = (String)e.nextElement();
            Object log = this.dbgnewframelogs.get(source);
            this.dbgframelogs.put(source, log);
            this.dbgframelogs_new.put(source, "yes");
        }
        this.dbgnewframelogs = new Hashtable();
    }

    void paintDbgFrameLogs(Graphics g) {
        Font dbgfont = new Font(this.debugmessage_font.name, this.debugmessage_font.style, (int)this.debugmessage_font.size);
        g.setFont(dbgfont);
        Enumeration e = this.dbgframelogs.keys();
        while (e.hasMoreElements()) {
            Enumeration f;
            String source = (String)e.nextElement();
            Vector log = (Vector)this.dbgframelogs.get(source);
            if (this.dbgframelogs_new.containsKey(source)) {
                this.setColor(g, this.el.fg_color);
            } else {
                this.setColor(g, this.debug_auxcolor1);
            }
            JGObject obj = this.el.getObject(source);
            if (obj == null) {
                obj = (JGObject)this.dbgframelogs_obj.get(source);
                this.setColor(g, this.debug_auxcolor2);
                if (obj != null) {
                    int deadtime = 0;
                    if (this.dbgframelogs_dead.containsKey(source)) {
                        deadtime = (Integer)this.dbgframelogs_dead.get(source);
                    }
                    if (deadtime < dbgframelog_expiry) {
                        this.dbgframelogs_dead.put(source, new Integer(deadtime + 1));
                    } else {
                        this.dbgframelogs_obj.remove(source);
                        this.dbgframelogs_dead.remove(source);
                    }
                }
            }
            int lineheight = this.debugmessage_font.getSize() + 1;
            if (obj != null) {
                JGPoint scaled = this.el.scalePos(obj.x - (double)this.el.xofs, obj.y - (double)this.el.yofs + (double)(lineheight / 3), false);
                scaled.y -= lineheight * log.size();
                f = log.elements();
                while (f.hasMoreElements()) {
                    g.drawString((String)f.nextElement(), scaled.x, scaled.y);
                    scaled.y += lineheight;
                }
                continue;
            }
            if (!source.equals("MAIN")) {
                this.dbgframelogs.remove(source);
                continue;
            }
            if (this.dbgframelogs_new.containsKey(source)) {
                this.setColor(g, this.el.fg_color);
            } else {
                this.setColor(this.debug_auxcolor1);
            }
            int ypos = this.el.scaleYPos(this.el.viewHeight(), false);
            ypos -= lineheight * log.size();
            f = log.elements();
            while (f.hasMoreElements()) {
                g.drawString((String)f.nextElement(), 0, ypos);
                ypos += lineheight;
            }
        }
    }

    public void dbgShowBoundingBox(boolean enabled) {
        this.debugflags = enabled ? (this.debugflags |= 1) : (this.debugflags &= 0xFFFFFFFE);
    }

    public void dbgShowGameState(boolean enabled) {
        this.debugflags = enabled ? (this.debugflags |= 2) : (this.debugflags &= 0xFFFFFFFD);
    }

    public void dbgShowFullStackTrace(boolean enabled) {
        this.debugflags = enabled ? (this.debugflags |= 4) : (this.debugflags &= 0xFFFFFFFB);
    }

    public void dbgShowMessagesInPf(boolean enabled) {
        this.debugflags = enabled ? (this.debugflags |= 8) : (this.debugflags &= 0xFFFFFFF7);
    }

    public void dbgSetMessageExpiry(int ticks) {
        dbgframelog_expiry = ticks;
    }

    public void dbgSetMessageFont(JGFont font) {
        this.debugmessage_font = font;
    }

    public void dbgSetDebugColor1(JGColor col) {
        this.debug_auxcolor1 = col;
    }

    public void dbgSetDebugColor2(JGColor col) {
        this.debug_auxcolor2 = col;
    }

    public void dbgPrint(String msg) {
        this.dbgPrint("MAIN", msg);
    }

    public void dbgPrint(String source, String msg) {
        if ((this.debugflags & 8) != 0) {
            Vector<String> log = (Vector<String>)this.dbgnewframelogs.get(source);
            if (log == null) {
                log = new Vector<String>(5, 15);
            }
            if (log.size() < 19) {
                log.add(msg);
            } else if (log.size() == 19) {
                log.add("<messages truncated>");
            }
            this.dbgnewframelogs.put(source, log);
            JGObject obj = this.el.getObject(source);
            if (obj != null) {
                this.dbgframelogs_obj.put(source, obj);
                this.dbgframelogs_dead.remove(source);
            }
        } else {
            System.out.println(source + ": " + msg);
        }
    }

    public void dbgShowException(String source, Throwable e) {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(st));
        if ((this.debugflags & 4) != 0) {
            this.dbgPrint(source, st.toString());
        } else {
            StringTokenizer toker = new StringTokenizer(st.toString(), "\n");
            if (toker.hasMoreTokens()) {
                this.dbgPrint(source, toker.nextToken());
            }
            if (toker.hasMoreTokens()) {
                this.dbgPrint(source, toker.nextToken());
            }
            if (toker.hasMoreTokens()) {
                this.dbgPrint(source, toker.nextToken());
            }
        }
    }

    public String dbgExceptionToString(Throwable e) {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(st));
        if ((this.debugflags & 4) != 0) {
            return st.toString();
        }
        StringTokenizer toker = new StringTokenizer(st.toString(), "\n");
        String ret = toker.nextToken() + "\n";
        ret = ret + toker.nextToken() + "\n";
        if (toker.hasMoreTokens()) {
            ret = ret + toker.nextToken();
        }
        return ret;
    }

    public void exitEngine(String msg) {
        if (msg != null) {
            System.err.println(msg);
            this.el.exit_message = msg;
        }
        System.err.println("Exiting JGEngine.");
        if (!this.i_am_applet) {
            System.exit(0);
        }
        this.destroy();
        this.canvas.repaint();
    }

    public JGEngine() {
        this.imageutil.setComponent(this);
    }

    public void initEngineComponent(int width, int height) {
        this.i_am_applet = false;
        this.jre.create_frame = false;
        this.el.winwidth = width;
        this.el.winheight = height;
        this.init();
    }

    public void initEngineApplet() {
        this.i_am_applet = true;
    }

    public void initEngine(int width, int height) {
        this.i_am_applet = false;
        if (width == 0) {
            Dimension scrsize = Toolkit.getDefaultToolkit().getScreenSize();
            this.el.winwidth = scrsize.width;
            this.el.winheight = scrsize.height;
            this.jre.win_decoration = false;
        } else {
            this.el.winwidth = width;
            this.el.winheight = height;
            this.jre.win_decoration = true;
        }
        this.init();
    }

    public void setCanvasSettings(int nrtilesx, int nrtilesy, int tilex, int tiley, JGColor fgcolor, JGColor bgcolor, JGFont msgfont) {
        this.el.nrtilesx = nrtilesx;
        this.el.nrtilesy = nrtilesy;
        this.el.viewnrtilesx = nrtilesx;
        this.el.viewnrtilesy = nrtilesy;
        this.el.tilex = tilex;
        this.el.tiley = tiley;
        this.setColorsFont(fgcolor, bgcolor, msgfont);
        this.el.view_initialised = true;
    }

    public void setScalingPreferences(double min_aspect_ratio, double max_aspect_ratio, int crop_top, int crop_left, int crop_bottom, int crop_right) {
        this.el.min_aspect = min_aspect_ratio;
        this.el.max_aspect = max_aspect_ratio;
        this.el.crop_top = crop_top;
        this.el.crop_left = crop_left;
        this.el.crop_bottom = crop_bottom;
        this.el.crop_right = crop_right;
    }

    public void setSmoothing(boolean smooth_magnify) {
        this.el.smooth_magnify = smooth_magnify;
    }

    public void requestGameFocus() {
        this.canvas.requestFocus();
    }

    public boolean isApplet() {
        return this.i_am_applet;
    }

    public boolean isMidlet() {
        return false;
    }

    public boolean isOpenGL() {
        return false;
    }

    public boolean isAndroid() {
        return false;
    }

    public int viewWidth() {
        return this.el.viewnrtilesx * this.el.tilex;
    }

    public int viewHeight() {
        return this.el.viewnrtilesy * this.el.tiley;
    }

    public int viewTilesX() {
        return this.el.viewnrtilesx;
    }

    public int viewTilesY() {
        return this.el.viewnrtilesy;
    }

    public int viewXOfs() {
        return this.el.pendingxofs;
    }

    public int viewYOfs() {
        return this.el.pendingyofs;
    }

    public int pfWidth() {
        return this.el.nrtilesx * this.el.tilex;
    }

    public int pfHeight() {
        return this.el.nrtilesy * this.el.tiley;
    }

    public int pfTilesX() {
        return this.el.nrtilesx;
    }

    public int pfTilesY() {
        return this.el.nrtilesy;
    }

    public boolean pfWrapX() {
        return this.el.pf_wrapx;
    }

    public boolean pfWrapY() {
        return this.el.pf_wrapy;
    }

    public int tileWidth() {
        return this.el.tilex;
    }

    public int tileHeight() {
        return this.el.tiley;
    }

    public int displayWidth() {
        return this.el.winwidth;
    }

    public int displayHeight() {
        return this.el.winheight;
    }

    public double getFrameRate() {
        return this.el.fps;
    }

    public double getGameSpeed() {
        return this.el.gamespeed;
    }

    public double getFrameSkip() {
        return this.el.maxframeskip;
    }

    public boolean getVideoSyncedUpdate() {
        return false;
    }

    public int getOffscreenMarginX() {
        return this.el.offscreen_margin_x;
    }

    public int getOffscreenMarginY() {
        return this.el.offscreen_margin_y;
    }

    public double getXScaleFactor() {
        return this.el.x_scale_fac;
    }

    public double getYScaleFactor() {
        return this.el.y_scale_fac;
    }

    public double getMinScaleFactor() {
        return this.el.min_scale_fac;
    }

    public void init() {
        this.jre.storeInit();
        if (this.el.winwidth == 0) {
            this.el.winwidth = this.getWidth();
            this.el.winheight = this.getHeight();
        }
        this.initCanvas();
        if (!this.el.view_initialised) {
            this.exitEngine("Canvas settings not initialised, use setCanvasSettings().");
        }
        this.el.initPF();
        if (!this.i_am_applet && this.jre.create_frame) {
            this.jre.createWindow(this, this.jre.win_decoration);
        }
        this.canvas = new JGCanvas(this.el.winwidth - (this.el.canvas_xofs > 0 ? this.el.canvas_xofs * 2 : 0), this.el.winheight - (this.el.canvas_yofs > 0 ? this.el.canvas_yofs * 2 : 0));
        this.jre.canvas = this.canvas;
        this.jre.clearKeymap();
        this.canvas.addMouseListener(this.jre);
        this.canvas.addMouseMotionListener(this.jre);
        this.canvas.addFocusListener(this.jre);
        this.canvas.setBackground(this.getAWTColor(this.el.bg_color));
        this.setBackground(this.getAWTColor(this.el.bg_color));
        if (this.jre.my_win != null) {
            this.jre.my_win.setBackground(this.getAWTColor(this.el.bg_color));
        }
        this.el.msg_font = new JGFont("Helvetica", 0, (int)(16.0 / (640.0 / (double)(this.el.tilex * this.el.nrtilesx))));
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add(this.canvas);
        if (!JGObject.setEngine(this)) {
            this.canvas.setInitPainter(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList d1, Object value, int d2, boolean initialise, boolean d4) {
                    Graphics g = (Graphics)value;
                    JGEngine.this.setFont(g, JGEngine.this.el.msg_font);
                    JGEngine.this.setColor(g, JGEngine.this.el.fg_color);
                    JGEngine.this.drawString(g, "JGame is already running in this VM", (double)(JGEngine.this.el.viewWidth() / 2), (double)(JGEngine.this.el.viewHeight() / 3), 0, false);
                    return null;
                }
            });
            return;
        }
        this.el.is_inited = true;
        this.canvas.setInitPainter(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList d1, Object value, int d2, boolean initialise, boolean d4) {
                JGImage splash;
                Graphics g = (Graphics)value;
                JGEngine.this.setFont(g, JGEngine.this.el.msg_font);
                JGEngine.this.setColor(g, JGEngine.this.el.fg_color);
                JGImage jGImage = splash = JGEngine.this.el.existsImage("splash_image") ? JGEngine.this.el.getImage("splash_image") : null;
                if (splash != null) {
                    JGPoint splash_size = JGEngine.this.getImageSize("splash_image");
                    JGEngine.this.drawImage(g, JGEngine.this.viewWidth() / 2 - splash_size.x / 2, Math.max(0, JGEngine.this.viewHeight() / 4 - splash_size.y / 2), "splash_image", false);
                }
                JGEngine.this.drawString(g, JGEngine.this.canvas.progress_message, (double)(JGEngine.this.viewWidth() / 2), (double)(JGEngine.this.viewHeight() / 2), 0, false);
                JGEngine.this.setColor(g, JGEngine.this.el.bg_color);
                JGEngine.this.drawRect(g, (double)((int)((double)JGEngine.this.viewWidth() * (0.1 + 0.8 * JGEngine.this.canvas.progress_bar))), (double)((int)((double)JGEngine.this.viewHeight() * 0.75)), (double)((int)((double)JGEngine.this.viewWidth() * 0.8 * (1.0 - JGEngine.this.canvas.progress_bar))), (int)((double)JGEngine.this.viewHeight() * 0.05), true, false, false);
                JGEngine.this.setColor(g, JGEngine.this.el.fg_color);
                JGEngine.this.drawRect(g, (double)((int)((double)JGEngine.this.viewWidth() * 0.1)), (double)((int)((double)JGEngine.this.viewHeight() * 0.75)), (double)((int)((double)JGEngine.this.viewWidth() * 0.8 * JGEngine.this.canvas.progress_bar)), (int)((double)JGEngine.this.viewHeight() * 0.05), true, false, false);
                JGEngine.this.drawRect(g, (double)((int)((double)JGEngine.this.viewWidth() * 0.1)), (double)((int)((double)JGEngine.this.viewHeight() * 0.75)), (double)((int)((double)JGEngine.this.viewWidth() * 0.8)), (int)((double)JGEngine.this.viewHeight() * 0.008), true, false, false);
                JGEngine.this.drawRect(g, (double)((int)((double)JGEngine.this.viewWidth() * 0.1)), (double)((int)((double)JGEngine.this.viewHeight() * 0.796)), (double)((int)((double)JGEngine.this.viewWidth() * 0.8)), (int)((double)JGEngine.this.viewHeight() * 0.008), true, false, false);
                JGEngine.this.drawString(g, JGEngine.this.canvas.author_message, (double)(JGEngine.this.viewWidth() - 16), (double)JGEngine.this.viewHeight() - JGEngine.this.getFontHeight(g, JGEngine.this.el.msg_font) - 10.0, 1, false);
                return null;
            }
        });
        if (this.jre.my_win != null) {
            this.jre.my_win.setVisible(true);
            this.jre.my_win.validate();
            this.jre.setWindowSize(this.jre.win_decoration);
        }
        this.canvas.addKeyListener(this.jre);
        this.canvas.requestFocus();
        this.thread = new Thread(new JGEngineThread());
        this.thread.start();
    }

    public abstract void initCanvas();

    public abstract void initGame();

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public void startApp() {
        if (!this.el.is_inited) {
            this.init();
        } else {
            this.start();
        }
    }

    public void pauseApp() {
        this.stop();
    }

    public void destroyApp(boolean unconditional) {
        this.destroy();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void wakeUpOnKey(int key) {
        this.jre.wakeUpOnKey(key);
    }

    public void destroy() {
        this.el.is_exited = true;
        if (this.thread != null) {
            if (!this.i_am_applet) {
                this.thread.interrupt();
            }
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.el.is_inited) {
            JGObject.setEngine(null);
        }
        this.disableAudio();
        System.out.println("JGame engine disposed.");
    }

    public void setViewOffset(int xofs, int yofs, boolean centered) {
        this.el.setViewOffset(xofs, yofs, centered);
    }

    public void setBGImgOffset(int depth, double xofs, double yofs, boolean centered) {
    }

    public void setViewZoomRotate(double zoom, double rotate) {
    }

    public void setPFSize(int nrtilesx, int nrtilesy) {
        this.el.setPFSize(nrtilesx, nrtilesy);
    }

    public void setPFWrap(boolean wrapx, boolean wrapy, int shiftx, int shifty) {
        this.el.setPFWrap(wrapx, wrapy, shiftx, shifty);
    }

    public void setFrameRate(double fps, double maxframeskip) {
        this.el.setFrameRate(fps, maxframeskip);
    }

    public void setVideoSyncedUpdate(boolean value) {
    }

    public void setGameSpeed(double gamespeed) {
        this.el.setGameSpeed(gamespeed);
    }

    public void setRenderSettings(int alpha_thresh, JGColor render_bg_col) {
        this.el.setRenderSettings(alpha_thresh, render_bg_col);
    }

    public void setOffscreenMargin(int xmargin, int ymargin) {
        this.el.setOffscreenMargin(xmargin, ymargin);
    }

    public void setBGColor(JGColor bgcolor) {
        Color bgcol = new Color(bgcolor.r, bgcolor.g, bgcolor.b);
        if (this.canvas != null) {
            this.canvas.setBackground(bgcol);
        }
        if (this.jre.my_win != null) {
            this.jre.my_win.setBackground(bgcol);
        }
        this.el.bg_color = bgcolor;
    }

    public void setFGColor(JGColor fgcolor) {
        this.el.fg_color = fgcolor;
    }

    public void setMsgFont(JGFont msgfont) {
        this.el.msg_font = msgfont;
    }

    public void setColorsFont(JGColor fgcolor, JGColor bgcolor, JGFont msgfont) {
        if (msgfont != null) {
            this.el.msg_font = msgfont;
        }
        if (fgcolor != null) {
            this.el.fg_color = fgcolor;
        }
        if (bgcolor != null) {
            this.setBGColor(bgcolor);
        }
    }

    public void setTextOutline(int thickness, JGColor colour) {
        this.el.outline_colour = colour;
        this.el.outline_thickness = thickness;
    }

    public void setMouseCursor(int cursor) {
        if (cursor == 0) {
            this.canvas.setCursor(new Cursor(0));
        } else if (cursor == 1) {
            this.canvas.setCursor(new Cursor(1));
        } else if (cursor == 2) {
            this.canvas.setCursor(new Cursor(12));
        } else if (cursor == 3) {
            this.canvas.setCursor(new Cursor(3));
        } else if (cursor == -1) {
            this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.null_image, new Point(0, 0), "hidden"));
        }
    }

    public void setMouseCursor(Object cursor) {
        if (cursor == null) {
            this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.null_image, new Point(0, 0), "hidden"));
        } else {
            this.canvas.setCursor((Cursor)cursor);
        }
    }

    public void removeAllTimers() {
        this.el.removeAllTimers();
    }

    public void registerTimer(JGTimer timer) {
        this.el.registerTimer(timer);
    }

    public void setGameState(String state) {
        this.el.setGameState(state);
    }

    public void addGameState(String state) {
        this.el.addGameState(state);
    }

    public void removeGameState(String state) {
        this.el.removeGameState(state);
    }

    public void clearGameState() {
        this.el.clearGameState();
    }

    public boolean inGameState(String state) {
        return this.el.inGameState(state);
    }

    public boolean inGameStateNextFrame(String state) {
        return this.el.inGameStateNextFrame(state);
    }

    private void doFrameAll() {
        this.jre.audioNewFrame();
        this.el.flushRemoveList();
        this.el.flushAddList();
        this.el.tickTimers();
        this.el.flushRemoveList();
        this.el.flushAddList();
        this.el.gamestate = this.el.gamestate_nextframe;
        this.el.gamestate_nextframe = new Vector(10, 20);
        this.el.gamestate_nextframe.addAll(this.el.gamestate);
        this.invokeGameStateMethods("start", this.el.gamestate_new);
        this.el.gamestate_new.clear();
        this.el.flushRemoveList();
        this.el.flushAddList();
        try {
            this.doFrame();
        }
        catch (JGameError ex) {
            this.exitEngine(this.dbgExceptionToString(ex));
        }
        catch (Exception ex) {
            this.dbgShowException("MAIN", ex);
        }
        this.invokeGameStateMethods("doFrame", this.el.gamestate);
        this.el.frameFinished();
    }

    private void invokeGameStateMethods(String prefix, Vector states) {
        Enumeration e = states.elements();
        while (e.hasMoreElements()) {
            String state = (String)e.nextElement();
            this.jre.tryMethod(this, prefix + state, new Object[0]);
        }
    }

    public void doFrame() {
    }

    void paintFrame(Graphics g) {
        this.buf_gfx = g;
        this.setColor(g, this.el.fg_color);
        this.setFont(this.el.msg_font);
        try {
            this.paintFrame();
        }
        catch (JGameError ex) {
            this.exitEngine(this.dbgExceptionToString(ex));
        }
        catch (Exception ex) {
            this.dbgShowException("MAIN", ex);
        }
        this.invokeGameStateMethods("paintFrame", this.el.gamestate);
        if ((this.debugflags & 2) != 0) {
            String state = "{";
            Enumeration e = this.el.gamestate.elements();
            while (e.hasMoreElements()) {
                state = state + (String)e.nextElement();
                if (!e.hasMoreElements()) continue;
                state = state + ",";
            }
            state = state + "}";
            this.setFont(this.el.msg_font);
            this.setColor(g, this.el.fg_color);
            this.drawString(state, this.el.viewWidth(), this.el.viewHeight() - (int)this.getFontHeight(g, this.el.msg_font), 1);
        }
        if ((this.debugflags & 8) != 0) {
            this.paintDbgFrameLogs(this.buf_gfx);
        }
        this.buf_gfx = null;
    }

    public void paintFrame() {
    }

    public Graphics getBufferGraphics() {
        return this.buf_gfx;
    }

    public void setColor(JGColor col) {
        if (this.buf_gfx != null) {
            this.setColor(this.buf_gfx, col);
        }
    }

    public Color getAWTColor(JGColor col) {
        return new Color(col.r, col.g, col.b);
    }

    public void setFont(JGFont font) {
        this.setFont(this.buf_gfx, font);
    }

    public void setFont(Graphics g, JGFont jgfont) {
        if (this.canvas != null && g != null) {
            Font font = new Font(jgfont.name, jgfont.style, (int)jgfont.size);
            font = font.deriveFont((float)(jgfont.size * this.el.min_scale_fac));
            g.setFont(font);
        }
    }

    public void setStroke(double thickness) {
        Graphics2D g = (Graphics2D)this.buf_gfx;
        g.setStroke(new BasicStroke((float)(thickness * this.el.min_scale_fac)));
    }

    public void setBlendMode(int src_func, int dst_func) {
    }

    public double getFontHeight(JGFont jgfont) {
        if (this.buf_gfx != null) {
            return this.getFontHeight(this.buf_gfx, jgfont);
        }
        return 0.0;
    }

    double getFontHeight(Graphics g, JGFont jgfont) {
        Font font = jgfont == null ? g.getFont() : new Font(jgfont.name, jgfont.style, (int)jgfont.size);
        FontRenderContext fontrc = ((Graphics2D)g).getFontRenderContext();
        Rectangle2D fontbounds = font.getMaxCharBounds(fontrc);
        return fontbounds.getHeight();
    }

    void drawImage(Graphics g, double x, double y, String imgname, boolean pf_relative) {
        if (imgname == null) {
            return;
        }
        x = this.el.scaleXPos(x, pf_relative);
        y = this.el.scaleYPos(y, pf_relative);
        JREImage img = (JREImage)this.el.getImage(imgname);
        if (img != null) {
            g.drawImage(img.img, (int)x, (int)y, this);
        }
    }

    public void drawLine(double x1, double y1, double x2, double y2, double thickness, JGColor color) {
        if (color != null) {
            this.setColor(color);
        }
        this.setStroke(thickness);
        this.drawLine(x1, y1, x2, y2, true);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.drawLine(x1, y1, x2, y2, true);
    }

    public void drawLine(double x1, double y1, double x2, double y2, boolean pf_relative) {
        if (this.buf_gfx == null) {
            return;
        }
        this.buf_gfx.drawLine(this.el.scaleXPos(x1, pf_relative), this.el.scaleYPos(y1, pf_relative), this.el.scaleXPos(x2, pf_relative), this.el.scaleYPos(y2, pf_relative));
    }

    public void drawPolygon(double[] x, double[] y, JGColor[] col, int len, boolean filled, boolean pf_relative) {
        if (this.buf_gfx == null) {
            return;
        }
        int[] xpos = new int[3];
        int[] ypos = new int[3];
        xpos[0] = this.el.scaleXPos(x[0], pf_relative);
        ypos[0] = this.el.scaleYPos(y[0], pf_relative);
        xpos[1] = this.el.scaleXPos(x[1], pf_relative);
        ypos[1] = this.el.scaleYPos(y[1], pf_relative);
        xpos[2] = this.el.scaleXPos(x[len - 1], pf_relative);
        ypos[2] = this.el.scaleYPos(y[len - 1], pf_relative);
        if (!filled) {
            if (col != null) {
                this.setColor(this.buf_gfx, col[1]);
            }
            this.buf_gfx.drawLine(xpos[0], ypos[0], xpos[1], ypos[1]);
            if (col != null) {
                this.setColor(this.buf_gfx, col[0]);
            }
            this.buf_gfx.drawLine(xpos[2], ypos[2], xpos[0], ypos[0]);
        }
        for (int i = 2; i < len; ++i) {
            xpos[2] = this.el.scaleXPos(x[i], pf_relative);
            ypos[2] = this.el.scaleYPos(y[i], pf_relative);
            if (col != null) {
                this.setColor(this.buf_gfx, col[i]);
            }
            if (filled) {
                this.buf_gfx.fillPolygon(xpos, ypos, 3);
            } else {
                this.buf_gfx.drawLine(xpos[1], ypos[1], xpos[2], ypos[2]);
            }
            xpos[1] = xpos[2];
            ypos[1] = ypos[2];
        }
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered, double thickness, JGColor color) {
        if (color != null) {
            this.setColor(color);
        }
        this.setStroke(thickness);
        this.drawRect(x, y, width, height, filled, centered, true);
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered) {
        this.drawRect(x, y, width, height, filled, centered, true);
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered, boolean pf_relative) {
        if (this.buf_gfx == null) {
            return;
        }
        this.drawRect(this.buf_gfx, x, y, width, height, filled, centered, pf_relative);
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered, boolean pf_relative, JGColor[] shadecol) {
        this.drawRect(this.buf_gfx, x, y, width, height, filled, centered, pf_relative);
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered, boolean pf_relative, JGColor[] shadecol, String tileimage) {
        this.drawRect(this.buf_gfx, x, y, width, height, filled, centered, pf_relative);
    }

    void drawRect(Graphics g, double x, double y, double width, double height, boolean filled, boolean centered, boolean pf_relative) {
        if (centered) {
            x -= width / 2.0;
            y -= height / 2.0;
        }
        JGRectangle r = this.el.scalePos(x, y, width, height, pf_relative);
        if (filled) {
            g.fillRect(r.x, r.y, r.width, r.height);
        } else {
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    public void drawOval(double x, double y, double width, double height, boolean filled, boolean centered, double thickness, JGColor color) {
        if (color != null) {
            this.setColor(color);
        }
        this.setStroke(thickness);
        this.drawOval(x, y, width, height, filled, centered, true);
    }

    public void drawOval(double x, double y, double width, double height, boolean filled, boolean centered) {
        this.drawOval(x, y, width, height, filled, centered, true);
    }

    public void drawOval(double x, double y, double width, double height, boolean filled, boolean centered, boolean pf_relative) {
        if (this.buf_gfx == null) {
            return;
        }
        x = this.el.scaleXPos(x, pf_relative);
        y = this.el.scaleYPos(y, pf_relative);
        width = this.el.scaleXPos(width, false);
        height = this.el.scaleYPos(height, false);
        if (centered) {
            x -= width / 2.0;
            y -= height / 2.0;
        }
        if (filled) {
            this.buf_gfx.fillOval((int)x, (int)y, (int)width, (int)height);
        } else {
            this.buf_gfx.drawOval((int)x, (int)y, (int)width, (int)height);
        }
    }

    public void drawImage(double x, double y, String imgname) {
        if (this.buf_gfx == null) {
            return;
        }
        this.drawImage(this.buf_gfx, x, y, imgname, true);
    }

    public void drawImage(double x, double y, String imgname, boolean pf_relative) {
        if (this.buf_gfx == null) {
            return;
        }
        this.drawImage(this.buf_gfx, x, y, imgname, pf_relative);
    }

    public void drawImage(double x, double y, String imgname, JGColor blend_col, double alpha, double rot, double scale, boolean pf_relative) {
        if (this.buf_gfx == null) {
            return;
        }
        this.drawImage(this.buf_gfx, x, y, imgname, pf_relative);
    }

    public void drawImage(String imgname, double x, double y) {
        this.drawImage(x, y, imgname);
    }

    public void drawImage(String imgname, double x, double y, boolean pf_relative) {
        this.drawImage(x, y, imgname, pf_relative);
    }

    public void drawImage(String imgname, double x, double y, boolean pf_relative, JGColor blend_col, double alpha, double rot, double scale) {
        this.drawImage(x, y, imgname, blend_col, alpha, rot, scale, pf_relative);
    }

    public void drawString(String str, double x, double y, int align, JGFont font, JGColor color) {
        if (font != null) {
            this.setFont(font);
        }
        if (color != null) {
            this.setColor(color);
        }
        this.drawString(this.buf_gfx, str, x, y, align, false);
    }

    public void drawString(String str, double x, double y, int align) {
        this.drawString(this.buf_gfx, str, x, y, align, false);
    }

    public void drawString(String str, double x, double y, int align, boolean pf_relative) {
        this.drawString(this.buf_gfx, str, x, y, align, pf_relative);
    }

    void drawString(Graphics g, String str, double x, double y, int align, boolean pf_relative) {
        int ypos;
        int xpos;
        if (g == null) {
            return;
        }
        if (str.equals("")) {
            return;
        }
        x = this.el.scaleXPos(x, pf_relative);
        y = this.el.scaleYPos(y, pf_relative);
        Font font = g.getFont();
        FontRenderContext fontrc = ((Graphics2D)g).getFontRenderContext();
        TextLayout layout = new TextLayout(str, font, fontrc);
        Rectangle2D strbounds = layout.getBounds();
        if (align == -1) {
            xpos = (int)(x - strbounds.getMinX());
            ypos = (int)(y - strbounds.getMinY());
        } else if (align == 0) {
            xpos = (int)(x - strbounds.getCenterX());
            ypos = (int)(y - strbounds.getMinY());
        } else {
            xpos = (int)(x - strbounds.getMaxX());
            ypos = (int)(y - strbounds.getMinY());
        }
        if (this.el.outline_thickness > 0) {
            int i;
            Color origcol = g.getColor();
            this.setColor(this.el.outline_colour);
            int real_thickness = Math.max(this.el.scaleXPos(this.el.outline_thickness, false), 1);
            for (i = -real_thickness; i <= real_thickness; ++i) {
                if (i == 0) continue;
                g.drawString(str, xpos + i, ypos);
            }
            for (i = -real_thickness; i <= real_thickness; ++i) {
                if (i == 0) continue;
                g.drawString(str, xpos, ypos + i);
            }
            g.setColor(origcol);
        }
        g.drawString(str, xpos, ypos);
    }

    public void drawImageString(String string, double x, double y, int align, String imgmap, int char_offset, int spacing) {
        this.el.drawImageString(this, string, x, y, align, imgmap, char_offset, spacing, false);
    }

    public void drawImageString(String string, double x, double y, int align, String imgmap, int char_offset, int spacing, boolean pf_relative) {
        this.el.drawImageString(this, string, x, y, align, imgmap, char_offset, spacing, pf_relative);
    }

    public JGPoint getMousePos() {
        return new JGPoint(this.jre.mousepos.x, this.jre.mousepos.y);
    }

    public int getMouseX() {
        return this.jre.mousepos.x;
    }

    public int getMouseY() {
        return this.jre.mousepos.y;
    }

    public boolean getMouseButton(int nr) {
        return this.jre.mousebutton[nr];
    }

    public void clearMouseButton(int nr) {
        this.jre.mousebutton[nr] = false;
    }

    public void setMouseButton(int nr) {
        this.jre.mousebutton[nr] = true;
    }

    public boolean getMouseInside() {
        return this.jre.mouseinside;
    }

    public boolean getKey(int key) {
        return this.jre.keymap[key];
    }

    public void clearKey(int key) {
        this.jre.keymap[key] = false;
    }

    public void setKey(int key) {
        this.jre.keymap[key] = true;
    }

    public int getLastKey() {
        return this.jre.lastkey;
    }

    public char getLastKeyChar() {
        return this.jre.lastkeychar;
    }

    public void clearLastKey() {
        this.jre.clearLastKey();
    }

    public String getKeyDesc(int key) {
        return JREEngine.getKeyDescStatic(key);
    }

    public static String getKeyDescStatic(int key) {
        return JREEngine.getKeyDescStatic(key);
    }

    public int getKeyCode(String keydesc) {
        return JREEngine.getKeyCodeStatic(keydesc);
    }

    public static int getKeyCodeStatic(String keydesc) {
        return JREEngine.getKeyCodeStatic(keydesc);
    }

    public boolean hasAccelerometer() {
        return false;
    }

    public double getAccelX() {
        return 0.0;
    }

    public double getAccelY() {
        return 0.0;
    }

    public double getAccelZ() {
        return 1.0;
    }

    public double[] getAccelVec() {
        return new double[]{0.0, 0.0, 1.0};
    }

    public void defineAnimation(String id, String[] frames, double speed) {
        this.el.defineAnimation(id, frames, speed);
    }

    public void defineAnimation(String id, String[] frames, double speed, boolean pingpong) {
        this.el.defineAnimation(id, frames, speed, pingpong);
    }

    public Animation getAnimation(String id) {
        return this.el.getAnimation(id);
    }

    public String getConfigPath(String filename) {
        File jgamedir;
        if (this.isApplet()) {
            return null;
        }
        try {
            jgamedir = new File(System.getProperty("user.home"), ".jgame");
        }
        catch (Exception e) {
            return null;
        }
        if (!jgamedir.exists() && !jgamedir.mkdir()) {
            return null;
        }
        if (!jgamedir.isDirectory()) {
            return null;
        }
        File file = new File(jgamedir, filename);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        if (!file.canWrite()) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public int invokeUrl(String url, String target) {
        if (this.isApplet()) {
            try {
                this.getAppletContext().showDocument(new URL(url), target);
            }
            catch (MalformedURLException e) {
                return 0;
            }
            return -1;
        }
        return 0;
    }

    void paintExitMessage(Graphics g) {
        try {
            this.setFont(g, this.debugmessage_font);
            int height = (int)(this.getFontHeight(g, null) / this.el.y_scale_fac);
            this.setColor(g, this.el.bg_color);
            this.drawRect(g, (double)(this.el.viewWidth() / 2), (double)(this.el.viewHeight() / 2), (double)(9 * this.el.viewWidth() / 10), height * 5, true, true, false);
            this.setColor(g, this.debug_auxcolor2);
            this.drawRect(g, (double)(this.el.viewWidth() / 2), (double)(this.el.viewHeight() / 2 - 5 * height / 2), (double)(9 * this.viewWidth() / 10), 5.0, true, true, false);
            this.drawRect(g, (double)(this.el.viewWidth() / 2), (double)(this.el.viewHeight() / 2 + 5 * height / 2), (double)(9 * this.viewWidth() / 10), 5.0, true, true, false);
            this.setColor(g, this.el.fg_color);
            int ypos = this.el.viewHeight() / 2 - 3 * height / 2;
            StringTokenizer toker = new StringTokenizer(this.el.exit_message, "\n");
            while (toker.hasMoreTokens()) {
                this.drawString(g, toker.nextToken(), (double)(this.el.viewWidth() / 2), (double)ypos, 0, false);
                ypos += height + 1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean and(int value, int mask) {
        return this.el.and(value, mask);
    }

    public double random(double min, double max) {
        return this.el.random(min, max);
    }

    public double random(double min, double max, double interval) {
        return this.el.random(min, max, interval);
    }

    public int random(int min, int max, int interval) {
        return this.el.random(min, max, interval);
    }

    public double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public JGPoint getTileIndex(double x, double y) {
        return this.el.getTileIndex(x, y);
    }

    public JGPoint getTileCoord(int tilex, int tiley) {
        return this.el.getTileCoord(tilex, tiley);
    }

    public JGPoint getTileCoord(JGPoint tileidx) {
        return this.el.getTileCoord(tileidx);
    }

    public double snapToGridX(double x, double gridsnapx) {
        return this.el.snapToGridX(x, gridsnapx);
    }

    public double snapToGridY(double y, double gridsnapy) {
        return this.el.snapToGridY(y, gridsnapy);
    }

    public void snapToGrid(JGPoint p, int gridsnapx, int gridsnapy) {
        this.el.snapToGrid(p, gridsnapx, gridsnapy);
    }

    public boolean isXAligned(double x, double margin) {
        return this.el.isXAligned(x, margin);
    }

    public boolean isYAligned(double y, double margin) {
        return this.el.isYAligned(y, margin);
    }

    public double getXAlignOfs(double x) {
        return this.el.getXAlignOfs(x);
    }

    public double getYAlignOfs(double y) {
        return this.el.getYAlignOfs(y);
    }

    public double getXDist(double x1, double x2) {
        return this.el.getXDist(x1, x2);
    }

    public double getYDist(double y1, double y2) {
        return this.el.getYDist(y1, y2);
    }

    public void enableAudio() {
        this.jre.enableAudio();
    }

    public void disableAudio() {
        this.jre.disableAudio();
    }

    public void defineAudioClip(String clipid, String filename) {
        this.el.defineAudioClip(this, clipid, filename);
    }

    public String lastPlayedAudio(String channel) {
        return this.jre.lastPlayedAudio(channel);
    }

    public void playAudio(String clipid) {
        this.jre.playAudio(this, clipid);
    }

    public void playAudio(String channel, String clipid, boolean loop) {
        this.jre.playAudio(this, channel, clipid, loop);
    }

    public void stopAudio(String channel) {
        this.jre.stopAudio(channel);
    }

    public void stopAudio() {
        this.jre.stopAudio();
    }

    public void storeWriteInt(String id, int value) {
        this.jre.storeWriteInt(id, value);
    }

    public void storeWriteDouble(String id, double value) {
        this.jre.storeWriteDouble(id, value);
    }

    public void storeWriteString(String id, String value) {
        this.jre.storeWriteString(id, value);
    }

    public void storeRemove(String id) {
        this.jre.storeRemove(id);
    }

    public boolean storeExists(String id) {
        return this.jre.storeExists(id);
    }

    public int storeReadInt(String id, int undef) {
        return this.jre.storeReadInt(id, undef);
    }

    public double storeReadDouble(String id, double undef) {
        return this.jre.storeReadDouble(id, undef);
    }

    public String storeReadString(String id, String undef) {
        return this.jre.storeReadString(id, undef);
    }

    public void optsAddTitle(String title) {
        this.jre.optsAddTitle(title);
    }

    public void optsAddNumber(String varname, String title, String desc, int decimals, double lower, double upper, double step, double initial) {
        this.jre.optsAddNumber(varname, title, desc, decimals, lower, upper, step, initial);
    }

    public void optsAddBoolean(String varname, String title, String desc, boolean initial) {
        this.jre.optsAddBoolean(varname, title, desc, initial);
    }

    public void optsAddEnum(String varname, String title, String desc, String[] values, int initial) {
        this.jre.optsAddEnum(varname, title, desc, values, initial);
    }

    public void optsAddKey(String varname, String title, String desc, int initial) {
        this.jre.optsAddKey(varname, title, desc, initial);
    }

    public void optsAddString(String varname, String title, String desc, int maxlen, boolean isPassword, String initial) {
        this.jre.optsAddString(varname, title, desc, maxlen, isPassword, initial);
    }

    public void optsClear() {
        this.jre.optsClear();
    }

    class JGEngineThread
    implements Runnable {
        private long target_time = 0L;
        private int frames_skipped = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    JGEngine.this.initGame();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new JGameError("Exception during initGame(): " + e);
                }
                JGEngine.this.canvas.setInitialised();
                this.target_time = System.currentTimeMillis() + (long)(1000.0 / JGEngine.this.el.fps);
                while (!JGEngine.this.el.is_exited) {
                    int n;
                    SortedArray sortedArray;
                    if ((JGEngine.this.debugflags & 8) != 0) {
                        JGEngine.this.refreshDbgFrameLogs();
                    }
                    long cur_time = System.currentTimeMillis();
                    if (!JGEngine.this.running) {
                        Thread.sleep(500L);
                        this.target_time = cur_time + (long)(1000.0 / JGEngine.this.el.fps);
                        continue;
                    }
                    if (cur_time < this.target_time + (long)(500.0 / JGEngine.this.el.fps)) {
                        sortedArray = JGEngine.this.el.objects;
                        synchronized (sortedArray) {
                            JGEngine.this.doFrameAll();
                            JGEngine.this.el.updateViewOffset();
                        }
                        JGEngine.this.canvas.repaint();
                        this.frames_skipped = 0;
                        if (cur_time + 3L < this.target_time) {
                            Thread.sleep(this.target_time - cur_time);
                        } else {
                            Thread.yield();
                        }
                        this.target_time = (long)((double)this.target_time + 1000.0 / JGEngine.this.el.fps);
                        continue;
                    }
                    sortedArray = JGEngine.this.el.objects;
                    synchronized (sortedArray) {
                        JGEngine.this.doFrameAll();
                        JGEngine.this.el.updateViewOffset();
                    }
                    ++this.frames_skipped;
                    if ((double)n > JGEngine.this.el.maxframeskip) {
                        JGEngine.this.canvas.repaint();
                        this.frames_skipped = 0;
                        this.target_time = cur_time + (long)(1000.0 / JGEngine.this.el.fps);
                    } else {
                        this.target_time += (long)(1000.0 / JGEngine.this.el.fps);
                    }
                    Thread.yield();
                }
            }
            catch (InterruptedException e) {
                System.out.println("JGame thread exited.");
            }
            catch (Exception e) {
                JGEngine.this.dbgShowException("MAIN", e);
            }
            catch (JGameError e) {
                JGEngine.this.exitEngine("Error in main:\n" + JGEngine.this.dbgExceptionToString(e));
            }
        }
    }

    class JGCanvas
    extends Canvas {
        boolean is_initialised = false;
        private ListCellRenderer initpainter = null;
        String progress_message = "Please wait, loading files .....";
        String author_message = "JGame 3.6";
        double progress_bar = 0.0;

        public boolean isFocusTraversable() {
            return true;
        }

        public JGCanvas(int winwidth, int winheight) {
            this.setSize(winwidth, winheight);
        }

        void setInitialised() {
            this.is_initialised = true;
            this.initpainter = null;
        }

        void setInitPainter(ListCellRenderer painter) {
            this.initpainter = painter;
        }

        void setProgressBar(double pos) {
            this.progress_bar = pos;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        void setProgressMessage(String msg) {
            this.progress_message = msg;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        void setAuthorMessage(String msg) {
            this.author_message = msg;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            block16: {
                try {
                    if (JGEngine.this.el.is_exited) {
                        JGEngine.this.paintExitMessage(g);
                        return;
                    }
                    if (!this.is_initialised) {
                        if (this.initpainter != null) {
                            this.initpainter.getListCellRendererComponent(null, this.getGraphics(), 0, false, false);
                        }
                        return;
                    }
                    if (JGEngine.this.background == null || !JREImage.isScratchImageValid(JGEngine.this.background)) {
                        JGEngine.this.background = JREImage.createScratchImage(JGEngine.this.el.width + 3 * JGEngine.this.el.scaledtilex, JGEngine.this.el.height + 3 * JGEngine.this.el.scaledtiley);
                        JGEngine.this.el.invalidateBGTiles();
                    }
                    if (JGEngine.this.buffer == null || !JREImage.isScratchImageValid(JGEngine.this.buffer)) {
                        JGEngine.this.buffer = JREImage.createScratchImage(JGEngine.this.el.width, JGEngine.this.el.height);
                    }
                    if (JGEngine.this.buffer == null || JGEngine.this.background == null) break block16;
                    SortedArray sortedArray = JGEngine.this.el.objects;
                    synchronized (sortedArray) {
                        Graphics bufg;
                        JGEngine.this.el.repaintBG(JGEngine.this);
                        JGEngine.this.buf_gfx = bufg = JGEngine.this.buffer.getGraphics();
                        int tilexshift = JGEngine.this.el.moduloFloor(JGEngine.this.el.tilexofs + 1, JGEngine.this.el.viewnrtilesx + 3);
                        int tileyshift = JGEngine.this.el.moduloFloor(JGEngine.this.el.tileyofs + 1, JGEngine.this.el.viewnrtilesy + 3);
                        int sx1 = tilexshift + 1;
                        int sy1 = tileyshift + 1;
                        int sx2 = JGEngine.this.el.viewnrtilesx + 3;
                        int sy2 = JGEngine.this.el.viewnrtilesy + 3;
                        if (sx2 - sx1 > JGEngine.this.el.viewnrtilesx) {
                            sx2 = sx1 + JGEngine.this.el.viewnrtilesx;
                        }
                        if (sy2 - sy1 > JGEngine.this.el.viewnrtilesy) {
                            sy2 = sy1 + JGEngine.this.el.viewnrtilesy;
                        }
                        int bufmidx = sx2 - sx1;
                        int bufmidy = sy2 - sy1;
                        JGEngine.this.copyBGToBuf(bufg, sx1, sy1, sx2, sy2, 0, 0);
                        sx1 = 0;
                        sy1 = 0;
                        sx2 = tilexshift - 1;
                        sy2 = tileyshift - 1;
                        JGEngine.this.copyBGToBuf(bufg, sx1, sy1, sx2, sy2, bufmidx, bufmidy);
                        sx1 = 0;
                        sy1 = tileyshift + 1;
                        sx2 = tilexshift - 1;
                        sy2 = JGEngine.this.el.viewnrtilesy + 3;
                        if (sy2 - sy1 > JGEngine.this.el.viewnrtilesy) {
                            sy2 = sy1 + JGEngine.this.el.viewnrtilesy;
                        }
                        JGEngine.this.copyBGToBuf(bufg, sx1, sy1, sx2, sy2, bufmidx, 0);
                        sx1 = tilexshift + 1;
                        sy1 = 0;
                        sx2 = JGEngine.this.el.viewnrtilesx + 3;
                        sy2 = tileyshift - 1;
                        if (sx2 - sx1 > JGEngine.this.el.viewnrtilesx) {
                            sx2 = sx1 + JGEngine.this.el.viewnrtilesx;
                        }
                        JGEngine.this.copyBGToBuf(bufg, sx1, sy1, sx2, sy2, 0, bufmidy);
                        for (int i = 0; i < JGEngine.this.el.objects.size; ++i) {
                            JGEngine.this.drawObject(bufg, (JGObject)JGEngine.this.el.objects.values[i]);
                        }
                        JGEngine.this.buf_gfx = null;
                        if (bufg != null) {
                            JGEngine.this.paintFrame(bufg);
                        }
                        g.drawImage(JGEngine.this.buffer, 0, 0, this);
                    }
                    Toolkit.getDefaultToolkit().sync();
                }
                catch (JGameError e) {
                    JGEngine.this.exitEngine("Error during paint:\n" + JGEngine.this.dbgExceptionToString(e));
                }
            }
        }
    }
}

