/*
 * Decompiled with CFR 0.152.
 */
package examples.nebulaalpha;

import jgame.JGObject;
import jgame.JGTimer;
import jgame.platform.JGEngine;

public class NebulaAlpha
extends JGEngine {
    int timer = 0;
    int score = 0;
    double gamespeed = 1.0;

    public static void main(String[] args) {
        new NebulaAlpha(0, 0);
    }

    public NebulaAlpha() {
        this.initEngineApplet();
    }

    public NebulaAlpha(int x, int y) {
        this.initEngine(x, y);
    }

    public void initCanvas() {
        this.setCanvasSettings(20, 15, 32, 32, null, null, null);
    }

    public void initGame() {
        this.defineMedia("nebula_alpha.tbl");
        this.setBGImage("bgimg");
        this.setFrameRate(40.0, 4.0);
        this.setGameState("Title");
    }

    public void doFrameTitle() {
        if (this.getKey(32)) {
            new Player(this.pfWidth() / 2 - 25, this.pfHeight() - 113);
            this.setGameState("InGame");
            this.score = 0;
            this.gamespeed = 1.0;
        }
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(2, 1);
        this.checkCollision(4, 2);
        ++this.timer;
        if (this.gamespeed < 2.0) {
            this.gamespeed += 1.0E-4;
        }
        if (this.timer % (int)(20.0 / this.gamespeed) == 0) {
            new Robot(this.random(0.0, this.pfWidth() - 64), -90.0, this.random(-1, 1, 2));
        }
    }

    public void paintFrame() {
        this.drawImageString("SCORE " + this.score, 150.0, 0.0, -1, "font_map", 32, 0);
    }

    public void paintFrameGameOver() {
        this.drawImageString("GAME OVER", 165.0, 200.0, -1, "font_map", 32, 0);
    }

    public void paintFrameTitle() {
        this.drawImageString("NEBULA ALPHA", 120.0, 200.0, -1, "font_map", 32, 0);
    }

    public class Player
    extends JGObject {
        public Player(double x, double y) {
            super("player", false, x, y, 1, "player");
        }

        public void move() {
            if (NebulaAlpha.this.getKey(37) && this.x > 14.0) {
                this.x -= 14.0 * gamespeed;
            }
            if (NebulaAlpha.this.getKey(39) && this.x < (double)(NebulaAlpha.this.pfWidth() - 51 - 14)) {
                this.x += 14.0 * gamespeed;
            }
            if (NebulaAlpha.this.getKey(32) && NebulaAlpha.this.countObjects("bullet", 0) < 2) {
                new JGObject("bullet", true, this.x - 8.0, this.y - 8.0, 4, "bullet", 0.0, -14.0, -2);
                NebulaAlpha.this.playAudio("shoot");
                NebulaAlpha.this.clearKey(32);
            }
        }

        public void hit(JGObject obj) {
            new JGObject("explo", true, this.x, this.y, 0, "explo", 0.0, 0.0, 32);
            this.remove();
            NebulaAlpha.this.addGameState("GameOver");
            new JGTimer(100, true){

                public void alarm() {
                    NebulaAlpha.this.setGameState("Title");
                    NebulaAlpha.this.removeObjects(null, 0);
                }
            };
        }
    }

    public class Robot
    extends JGObject {
        public Robot(double x, double y, int dir) {
            super("robot", true, x, y, 2, null);
            this.setSpeedAbs((double)dir * 2.0 * gamespeed, 0.0);
        }

        public void move() {
            this.y = this.y < (double)(NebulaAlpha.this.pfHeight() - 200) ? (this.y += 2.0 * gamespeed) : (this.y += (2.0 - (this.y - (double)(NebulaAlpha.this.pfHeight() - 200)) / 200.0 * 3.5) * gamespeed);
            if (this.xdir < 0) {
                this.setAnim("robot_l");
            } else {
                this.setAnim("robot_r");
            }
            if (this.x < 0.0) {
                this.xdir = 1;
            }
            if (this.x > (double)(NebulaAlpha.this.pfWidth() - 64)) {
                this.xdir = -1;
            }
        }

        public void hit(JGObject obj) {
            new JGObject("explo", true, this.x, this.y, 0, "explo", 0.0, 0.0, 32);
            NebulaAlpha.this.playAudio("explo");
            this.remove();
            obj.remove();
            NebulaAlpha.this.score += 5;
        }
    }
}

