/*
 * Decompiled with CFR 0.152.
 */
package inkscape2physics;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InkscapetoPhysics
extends DefaultHandler {
    StringBuffer code = new StringBuffer();
    String layer = null;
    static final String ignorelayer = "sky";
    float[] layerofs = null;
    int g_level = 0;
    String chars;
    String textx;
    String texty;
    float[] textofs;
    String textcolstr;

    private float[] multvm(float[] vec, float[] m) {
        return new float[]{m[0] * vec[0] + m[2] * vec[1] + m[4], m[1] * vec[0] + m[3] * vec[1] + m[5]};
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        float[] ofs = this.getTransform(atts.getValue("", "transform"));
        int fillcol = this.getFillColor(atts.getValue("", "style"));
        String colstr = "-1";
        if (fillcol != -1) {
            colstr = "0x" + Integer.toString(fillcol, 16);
        }
        if (qName.equals("g")) {
            ++this.g_level;
            if (this.g_level == 1) {
                this.layer = atts.getValue("inkscape:label");
                this.layerofs = ofs;
                return;
            }
        }
        if (this.layer == null) {
            return;
        }
        if (this.layer.equals(ignorelayer)) {
            return;
        }
        if (qName.equals("path") && atts.getValue("", "sodipodi:type") != null && atts.getValue("", "sodipodi:type").equals("arc")) {
            float x = Float.parseFloat(atts.getValue("", "sodipodi:cx"));
            float y = Float.parseFloat(atts.getValue("", "sodipodi:cy"));
            float width = Float.parseFloat(atts.getValue("", "sodipodi:rx"));
            float height = Float.parseFloat(atts.getValue("", "sodipodi:ry"));
            float[] vt = this.multvm(this.multvm(new float[]{x, y}, this.layerofs), ofs);
            this.code.append("\t\tw.genCircle(\"" + this.layer + "\"," + colstr + ",");
            this.code.append(vt[0] + "f," + vt[1] + "f," + (width + height) / 2.0f + "f);\n");
        } else if (qName.equals("path")) {
            float x = 0.0f;
            float y = 0.0f;
            String d = atts.getValue("", "d");
            this.code.append("\t\tw.genPolygon(\"" + this.layer + "\"," + colstr + ",");
            this.code.append("new float[] {");
            String[] par = d.split("[ ,zZ]+");
            int i = 0;
            boolean relative = false;
            while (i < par.length) {
                if (par[i].length() == 0) continue;
                if (par[i].equals("c") || par[i].equals("C")) {
                    throw new Error("curve found in path - not supported!");
                }
                if (par[i].equals("m") || par[i].equals("l")) {
                    relative = true;
                } else if (par[i].equals("M") || par[i].equals("L")) {
                    relative = false;
                    ++i;
                }
                int n = ++i;
                float newx = Float.parseFloat(par[n]);
                int n2 = ++i;
                ++i;
                float newy = Float.parseFloat(par[n2]);
                if (relative) {
                    newx += x;
                    newy += y;
                }
                x = newx;
                y = newy;
                float[] vt = this.multvm(this.multvm(new float[]{x, y}, this.layerofs), ofs);
                this.code.append(vt[0] + "f," + vt[1] + "f");
                if (i >= par.length - 1) continue;
                this.code.append(",");
            }
            this.code.append("});\n");
        } else if (qName.equals("text")) {
            this.textofs = ofs;
            this.textcolstr = colstr;
        } else if (qName.equals("tspan")) {
            this.textx = atts.getValue("", "x");
            this.texty = atts.getValue("", "y");
            this.chars = "";
        } else if (qName.equals("rect")) {
            float x = Float.parseFloat(atts.getValue("", "x"));
            float y = Float.parseFloat(atts.getValue("", "y"));
            float width = Float.parseFloat(atts.getValue("", "width"));
            float height = Float.parseFloat(atts.getValue("", "height"));
            float transx = this.layerofs[4] + ofs[4];
            float transy = this.layerofs[5] + ofs[5];
            float scalex = this.layerofs[0] * ofs[0];
            float scaley = this.layerofs[3] * ofs[3];
            if (this.layerofs[1] != 0.0f || this.layerofs[2] != 0.0f || ofs[1] != 0.0f || ofs[2] != 0.0f) {
                throw new Error("Rect rotation not supported!");
            }
            this.code.append("\t\tw.genRect(\"" + this.layer + "\"," + colstr + ",");
            this.code.append(scalex * width / 2.0f + scalex * x + transx + "f,");
            this.code.append(scaley * height / 2.0f + scaley * y + transy + "f,");
            this.code.append(scalex * width + "f,");
            this.code.append(scaley * height + "f,0f);\n");
        }
    }

    float[] getTransform(String t) {
        if (t == null) {
            return new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        }
        if (t.indexOf("matrix") == 0) {
            String[] te = t.split("matrix\\(|,|\\)| ");
            if (te.length != 7) {
                throw new Error("Unexpected transform " + t);
            }
            return new float[]{Float.parseFloat(te[1]), Float.parseFloat(te[2]), Float.parseFloat(te[3]), Float.parseFloat(te[4]), Float.parseFloat(te[5]), Float.parseFloat(te[6])};
        }
        if (t.indexOf("scale") == 0) {
            String[] te = t.split("scale\\(|,|\\)| ");
            if (te.length != 3) {
                throw new Error("Unexpected transform " + t);
            }
            return new float[]{Float.parseFloat(te[1]), 0.0f, 0.0f, Float.parseFloat(te[2]), 0.0f, 0.0f};
        }
        if (t.indexOf("translate") == 0) {
            String[] te = t.split("translate\\(|,|\\)| ");
            if (te.length != 3) {
                throw new Error("Unexpected transform " + t);
            }
            return new float[]{1.0f, 0.0f, 0.0f, 1.0f, Float.parseFloat(te[1]), Float.parseFloat(te[2])};
        }
        throw new Error("Unexpected transform " + t);
    }

    int getFillColor(String t) {
        if (t == null) {
            return -1;
        }
        int idx = t.indexOf("fill:#");
        if (idx < 0) {
            return -1;
        }
        String col = t.substring(idx + 6, idx + 12);
        return Integer.parseInt(col.substring(0, 6), 16);
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        if (rawName.equals("g")) {
            --this.g_level;
        }
        if (this.layer == null || this.layer.equals(ignorelayer)) {
            return;
        }
        if (rawName.equals("tspan")) {
            float x = Float.parseFloat(this.textx);
            float y = Float.parseFloat(this.texty);
            float[] vt = this.multvm(this.multvm(new float[]{x, y}, this.layerofs), this.textofs);
            this.code.append("\t\tw.genSpecial(\"" + this.layer + "\",\"" + this.chars + "\",");
            this.code.append(this.textcolstr + "," + vt[0] + "f," + vt[1] + "f);\n");
        }
    }

    public void characters(char[] text, int start, int length) throws SAXException {
        this.chars = new String(text).substring(start, start + length);
    }

    public static void main(String[] args) {
        InkscapetoPhysics handler = new InkscapetoPhysics();
        if (args.length != 3) {
            System.err.println("Usage: inkscape2physics [filename.svg] [packagename] [classname]");
            System.exit(1);
        }
        String filename = args[0];
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(filename, (DefaultHandler)handler);
            System.out.println("package " + args[1] + ";\n" + "public class " + args[2] + " implements GenPhysWorld {\n" + "\tpublic void generate(PhysicsWorld w) {\n");
            System.out.println(handler.code.toString());
            System.out.println("\t}\n}\n");
        }
        catch (Exception e) {
            String errorMessage = "Error parsing " + filename + ": " + e;
            System.err.println(errorMessage);
            e.printStackTrace();
        }
    }
}

