/*
 * Decompiled with CFR 0.152.
 */
package createjad;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class Jar2Jad {
    public static boolean extractJarDir(String jarfile, String outfile) throws Exception {
        String line;
        long filesize = new File(jarfile).length();
        JarInputStream jar = new JarInputStream(new FileInputStream(jarfile));
        FileOutputStream outs = new FileOutputStream(outfile);
        Manifest man = jar.getManifest();
        if (man == null) {
            return false;
        }
        man.write(outs);
        byte[] buf = ("MIDlet-Jar-Size: " + filesize).getBytes();
        outs.write(buf, 0, buf.length);
        outs.close();
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(outfile));
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        in.close();
        PrintWriter outp = new PrintWriter(outfile);
        for (String s : lines) {
            if (s.trim().equals("")) continue;
            outp.println(s);
        }
        outp.close();
        return true;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java -jar jar2jad [jarfile] [jadfile]");
            System.exit(1);
        }
        if (!Jar2Jad.extractJarDir(args[0], args[1])) {
            System.out.println("Error: Could not find manifest in Jar.");
            System.exit(1);
        } else {
            System.out.println("Jad created.");
        }
    }
}

