/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JarInstaller
implements ActionListener {
    static JarInstaller instance;
    static String app_name;
    static String app_title;
    static String splashscreen;
    static String app_default_dir;
    static JFrame frame;
    static JTextField installdirtf;
    static String selected_dir;
    private static boolean overwriteConfirmed;

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand().toLowerCase();
        if (cmd.startsWith("browse")) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(installdirtf);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                installdirtf.setText("" + file + File.separator + app_default_dir);
            }
        } else if (cmd.startsWith("extract")) {
            selected_dir = installdirtf.getText();
        } else if (cmd.startsWith("cancel")) {
            System.exit(0);
        }
    }

    public static String getSystemArchitecture() {
        String arch = System.getProperty("os.name").toLowerCase();
        String bitness = System.getProperty("sun.arch.data.model");
        if (arch.startsWith("linux")) {
            return "linux" + bitness;
        }
        if (arch.startsWith("windows")) {
            return "win" + bitness;
        }
        if (arch.startsWith("mac")) {
            return "mac" + bitness;
        }
        return null;
    }

    public static int extractJarDir(String jarfile, String dir, String destdir) throws Exception {
        JarEntry jarentry;
        int nr_extracted = 0;
        System.out.println("Extracting from: " + jarfile);
        System.out.println("Subdirectory: " + dir);
        JarInputStream jar = new JarInputStream(new FileInputStream(jarfile));
        while ((jarentry = jar.getNextJarEntry()) != null) {
            int len;
            String maindir = jarentry.getName();
            if (maindir.startsWith(".")) {
                maindir = maindir.substring(1);
            }
            if (maindir.startsWith(File.separator)) {
                maindir = maindir.substring(1);
            }
            if (maindir.startsWith("META-INF") || !maindir.startsWith(dir)) continue;
            maindir = maindir.substring(dir.length() + 1);
            File outfile = new File(destdir + File.separator + maindir);
            System.out.println("Extracting: " + outfile);
            if (jarentry.isDirectory()) {
                if (outfile.exists() && outfile.isFile()) {
                    if (!JarInstaller.confirmOverwrite()) {
                        throw new Exception("Extraction aborted.");
                    }
                    outfile.delete();
                }
                if (!(outfile.exists() && outfile.isDirectory() || outfile.mkdir())) {
                    throw new Exception("Failed to create directory.");
                }
                ++nr_extracted;
                continue;
            }
            if (outfile.isDirectory()) {
                throw new Exception("A directory is in the way. Please remove files and directories and try again.");
            }
            if (outfile.exists()) {
                if (!JarInstaller.confirmOverwrite()) {
                    throw new Exception("Extraction aborted.");
                }
                outfile.delete();
            }
            JarInputStream ins = jar;
            FileOutputStream outs = new FileOutputStream(outfile);
            byte[] buf = new byte[8192];
            while ((len = ((InputStream)ins).read(buf)) >= 0) {
                outs.write(buf, 0, len);
            }
            ++nr_extracted;
            outs.close();
        }
        return nr_extracted;
    }

    private static String getDestinationDirectory(String initialpath) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        frame = new JFrame(app_title);
        frame.setDefaultCloseOperation(3);
        JPanel panel0 = new JPanel();
        panel0.setLayout(new BoxLayout(panel0, 1));
        JPanel panel0b = new JPanel(new FlowLayout(2));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        JPanel panel3a = new JPanel();
        panel3a.setLayout(new BoxLayout(panel3a, 0));
        JPanel panel3b = new JPanel();
        panel3b.setBackground(Color.white);
        Border border = BorderFactory.createEtchedBorder(1);
        installdirtf = new JTextField(initialpath + File.separator + app_default_dir);
        JButton browsebut = new JButton("Browse...");
        browsebut.addActionListener(instance);
        JButton extractbut = new JButton("Extract");
        extractbut.addActionListener(instance);
        JButton cancelbut = new JButton("Cancel");
        cancelbut.addActionListener(instance);
        URL imageURL = instance.getClass().getResource(splashscreen);
        JLabel msglab = new JLabel("<html><b>Extract Program</b><br><br>This will extract " + app_name + " to a directory" + " on your system." + "<br><br><br>" + "Select the installation directory below." + "</html>");
        msglab.setPreferredSize(new Dimension(400, 270));
        msglab.setVerticalAlignment(1);
        JLabel splashlab = new JLabel(new ImageIcon(imageURL));
        splashlab.setBorder(border);
        panel1.add(splashlab);
        panel1.add(panel2);
        panel2.setBorder(border);
        panel3a.add(installdirtf);
        panel3a.add(browsebut);
        panel3b.add(msglab);
        panel2.add(panel3b);
        panel2.add(panel3a);
        panel0.add(panel1);
        panel0.add(panel0b);
        panel0b.add(extractbut);
        panel0b.add(cancelbut);
        panel0b.setBorder(border);
        frame.add(panel0);
        frame.pack();
        frame.setVisible(true);
        selected_dir = null;
        try {
            while (selected_dir == null) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return selected_dir;
    }

    private static void showError(String error) {
        JOptionPane.showMessageDialog(frame, error, "Error", 0);
    }

    private static void showMessage(String msg) {
        JOptionPane.showMessageDialog(frame, msg);
    }

    private static boolean confirmOverwrite() {
        if (overwriteConfirmed) {
            return true;
        }
        if (!JarInstaller.requestYesNo("Files will be overwritten! Continue?", "Continue", "Cancel")) {
            return false;
        }
        overwriteConfirmed = true;
        return true;
    }

    private static boolean requestYesNo(String msg, String yesMsg, String noMsg) {
        Object[] options = new String[]{yesMsg, noMsg};
        int n = JOptionPane.showOptionDialog(frame, msg, msg, 0, 3, null, options, options[0]);
        return n == 0;
    }

    private static String requestSystemArch() {
        return "win32";
    }

    public static void main(String[] args) {
        instance = new JarInstaller();
        String myclass = instance.getClass().getName();
        String mypath = ClassLoader.getSystemClassLoader().getResource(myclass + ".class").getPath();
        int startjar = mypath.indexOf(":");
        int endjar = mypath.lastIndexOf("jar!");
        if (endjar >= 0) {
            String myjar = mypath.substring(startjar + 1, endjar + 3);
            String destination = JarInstaller.getDestinationDirectory(new File(myjar).getParent());
            String arch = JarInstaller.getSystemArchitecture();
            if (arch == null) {
                arch = JarInstaller.requestSystemArch();
            }
            try {
                int extracted = JarInstaller.extractJarDir(myjar, arch, destination);
                if (extracted == 0) {
                    JarInstaller.showError("System architecture not supported");
                }
                extracted = JarInstaller.extractJarDir(myjar, "generic", destination);
                JarInstaller.showMessage("Finished!");
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
                JarInstaller.showError("I/O error extracting files.");
            }
            catch (Exception e) {
                JarInstaller.showError(e.getMessage());
            }
        } else {
            JarInstaller.showError("JarInstaller cannot find its Jar!");
        }
        System.exit(0);
    }

    static {
        app_name = "MyApplication";
        app_title = app_name + " Installer";
        splashscreen = "install_splash.jpg";
        app_default_dir = "MyApplication";
        selected_dir = null;
        overwriteConfirmed = false;
    }

    class InstallPanel
    extends JPanel {
        Image bg = new ImageIcon(this.getClass().getResource(splashscreen)).getImage();

        InstallPanel() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.bg, 0, 0, null);
            g.setColor(new Color(255, 255, 255));
        }
    }
}

