/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactConstraint;
import org.jbox2d.dynamics.contacts.ContactConstraintPoint;

public class ContactSolver {
    public TimeStep m_step;
    public ContactConstraint[] m_constraints;
    public int m_constraintCount;
    static final float intToFloatMul = 1.5258789E-5f;
    long[] ccp_r1_x = new long[2];
    long[] ccp_r1_y = new long[2];
    long[] ccp_r2_x = new long[2];
    long[] ccp_r2_y = new long[2];
    int[] ccp_normalImpulse = new int[2];
    long[] ccp_tangentImpulse = new long[2];

    public ContactSolver(TimeStep step, Contact[] contacts, int contactCount) {
        int i;
        this.m_step = step;
        this.m_constraintCount = 0;
        for (i = 0; i < contactCount; ++i) {
            this.m_constraintCount += contacts[i].getManifoldCount();
        }
        this.m_constraints = new ContactConstraint[this.m_constraintCount];
        for (i = 0; i < this.m_constraintCount; ++i) {
            this.m_constraints[i] = new ContactConstraint();
        }
        int count = 0;
        for (int i2 = 0; i2 < contactCount; ++i2) {
            Contact contact = contacts[i2];
            Body b1 = contact.m_shape1.getBody();
            Body b2 = contact.m_shape2.getBody();
            int manifoldCount = contact.getManifoldCount();
            if (manifoldCount > 1) {
                System.err.println("ContactSolver: expecting manifoldCount 0 or 1 !");
            }
            float friction = contact.m_friction;
            float restitution = contact.m_restitution;
            Vec2 v1 = b1.m_linearVelocity.clone();
            Vec2 v2 = b2.m_linearVelocity.clone();
            float w1 = b1.m_angularVelocity;
            float w2 = b2.m_angularVelocity;
            for (int j = 0; j < manifoldCount; ++j) {
                Manifold manifold = contact.getManifold();
                Vec2 normal = manifold.normal.clone();
                ContactConstraint c = this.m_constraints[count];
                c.body1 = b1;
                c.body2 = b2;
                c.manifold = manifold;
                c.normal = normal.clone();
                c.pointCount = manifold.pointCount;
                c.friction = friction;
                c.restitution = restitution;
                for (int k = 0; k < c.pointCount; ++k) {
                    Vec2 buffer;
                    float vRel;
                    ManifoldPoint cp = manifold.points[k];
                    ContactConstraintPoint ccp = c.points[k];
                    ccp.normalImpulse = cp.normalImpulse;
                    ccp.tangentImpulse = cp.tangentImpulse;
                    ccp.separation = cp.separation;
                    ccp.positionImpulse = 0.0f;
                    ccp.localAnchor1.set(cp.localPoint1);
                    ccp.localAnchor2.set(cp.localPoint2);
                    ccp.r1 = Mat22.mul(b1.m_xf.R, cp.localPoint1.sub(b1.m_sweep.localCenter));
                    ccp.r2 = Mat22.mul(b2.m_xf.R, cp.localPoint2.sub(b2.m_sweep.localCenter));
                    float rn1 = Vec2.cross(ccp.r1, normal);
                    float rn2 = Vec2.cross(ccp.r2, normal);
                    rn1 *= rn1;
                    rn2 *= rn2;
                    float kNormal = b1.m_invMass + b2.m_invMass + b1.m_invI * rn1 + b2.m_invI * rn2;
                    ccp.normalMass = 1.0f / kNormal;
                    float kEqualized = b1.m_mass * b1.m_invMass + b2.m_mass * b2.m_invMass;
                    ccp.equalizedMass = 1.0f / (kEqualized += b1.m_mass * b1.m_invI * rn1 + b2.m_mass * b2.m_invI * rn2);
                    Vec2 tangent = Vec2.cross(normal, 1.0f);
                    float rt1 = Vec2.cross(ccp.r1, tangent);
                    float rt2 = Vec2.cross(ccp.r2, tangent);
                    rt1 *= rt1;
                    rt2 *= rt2;
                    float kTangent = b1.m_invMass + b2.m_invMass + b1.m_invI * rt1 + b2.m_invI * rt2;
                    ccp.tangentMass = 1.0f / kTangent;
                    ccp.velocityBias = 0.0f;
                    if (ccp.separation > 0.0f) {
                        ccp.velocityBias = -60.0f * ccp.separation;
                    }
                    if (!((vRel = Vec2.dot(c.normal, buffer = Vec2.cross(w2, ccp.r2).subLocal(Vec2.cross(w1, ccp.r1)).addLocal(v2).subLocal(v1))) < -1.0f)) continue;
                    ccp.velocityBias += -c.restitution * vRel;
                }
                ++count;
            }
        }
    }

    public void initVelocityConstraints(TimeStep step) {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraintPoint ccp;
            int j;
            float normaly;
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            float invMass1 = b1.m_invMass;
            float invI1 = b1.m_invI;
            float invMass2 = b2.m_invMass;
            float invI2 = b2.m_invI;
            float normalx = c.normal.x;
            float tangentx = normaly = c.normal.y;
            float tangenty = -normalx;
            if (step.warmStarting) {
                for (j = 0; j < c.pointCount; ++j) {
                    ccp = c.points[j];
                    ccp.normalImpulse *= step.dtRatio;
                    ccp.tangentImpulse *= step.dtRatio;
                    float px = ccp.normalImpulse * normalx + ccp.tangentImpulse * tangentx;
                    float py = ccp.normalImpulse * normaly + ccp.tangentImpulse * tangenty;
                    b1.m_angularVelocity -= invI1 * (ccp.r1.x * py - ccp.r1.y * px);
                    b1.m_linearVelocity.x -= px * invMass1;
                    b1.m_linearVelocity.y -= py * invMass1;
                    b2.m_angularVelocity += invI2 * (ccp.r2.x * py - ccp.r2.y * px);
                    b2.m_linearVelocity.x += px * invMass2;
                    b2.m_linearVelocity.y += py * invMass2;
                }
                continue;
            }
            for (j = 0; j < c.pointCount; ++j) {
                ccp = c.points[j];
                ccp.normalImpulse = 0.0f;
                ccp.tangentImpulse = 0.0f;
            }
        }
    }

    public void solveVelocityConstraints() {
        Vec2 v1 = new Vec2(0.0f, 0.0f);
        Vec2 v2 = new Vec2(0.0f, 0.0f);
        Vec2 tangent = new Vec2(0.0f, 0.0f);
        for (int i = 0; i < this.m_constraintCount; ++i) {
            float lambda;
            float dvy;
            float dvx;
            ContactConstraintPoint ccp;
            int j;
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            float w1 = b1.m_angularVelocity;
            float w2 = b2.m_angularVelocity;
            v1.x = b1.m_linearVelocity.x;
            v1.y = b1.m_linearVelocity.y;
            v2.x = b2.m_linearVelocity.x;
            v2.y = b2.m_linearVelocity.y;
            float invMass1 = b1.m_invMass;
            float invI1 = b1.m_invI;
            float invMass2 = b2.m_invMass;
            float invI2 = b2.m_invI;
            Vec2 normal = c.normal;
            tangent.x = normal.y;
            tangent.y = -normal.x;
            float friction = c.friction;
            for (j = 0; j < c.pointCount; ++j) {
                ccp = c.points[j];
                dvx = v2.x - w2 * ccp.r2.y - v1.x + w1 * ccp.r1.y;
                dvy = v2.y + w2 * ccp.r2.x - v1.y - w1 * ccp.r1.x;
                float vn = dvx * normal.x + dvy * normal.y;
                lambda = -ccp.normalMass * (vn - ccp.velocityBias);
                float newImpulse = MathUtils.max(ccp.normalImpulse + lambda, 0.0f);
                lambda = newImpulse - ccp.normalImpulse;
                float Px = lambda * normal.x;
                float Py = lambda * normal.y;
                v1.x -= invMass1 * Px;
                v1.y -= invMass1 * Py;
                w1 -= invI1 * (ccp.r1.x * Py - ccp.r1.y * Px);
                v2.x += invMass2 * Px;
                v2.y += invMass2 * Py;
                w2 += invI2 * (ccp.r2.x * Py - ccp.r2.y * Px);
                ccp.normalImpulse = newImpulse;
            }
            for (j = 0; j < c.pointCount; ++j) {
                ccp = c.points[j];
                dvx = v2.x - w2 * ccp.r2.y - v1.x + w1 * ccp.r1.y;
                dvy = v2.y + w2 * ccp.r2.x - v1.y - w1 * ccp.r1.x;
                float vt = dvx * tangent.x + dvy * tangent.y;
                lambda = ccp.tangentMass * -vt;
                float maxFriction = friction * ccp.normalImpulse;
                float newImpulse = MathUtils.max(-maxFriction, MathUtils.min(ccp.tangentImpulse + lambda, maxFriction));
                lambda = newImpulse - ccp.tangentImpulse;
                float px = lambda * tangent.x;
                float py = lambda * tangent.y;
                v1.x -= px * invMass1;
                v1.y -= py * invMass1;
                w1 -= invI1 * (ccp.r1.x * py - ccp.r1.y * px);
                v2.x += px * invMass2;
                v2.y += py * invMass2;
                w2 += invI2 * (ccp.r2.x * py - ccp.r2.y * px);
                ccp.tangentImpulse = newImpulse;
            }
            b1.m_linearVelocity.set(v1);
            b1.m_angularVelocity = w1;
            b2.m_linearVelocity.set(v2);
            b2.m_angularVelocity = w2;
        }
    }

    public void solveVelocityConstraintsFX() {
        int v1_x = 0;
        int v1_y = 0;
        int v2_x = 0;
        int v2_y = 0;
        int tangent_x = 0;
        int tangent_y = 0;
        for (int i = 0; i < this.m_constraintCount; ++i) {
            int dvy;
            int dvx;
            ContactConstraintPoint ccp;
            int j;
            int normal_y;
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            int w1 = (int)(b1.m_angularVelocity * 65536.0f);
            int w2 = (int)(b2.m_angularVelocity * 65536.0f);
            v1_x = (int)(b1.m_linearVelocity.x * 65536.0f);
            v1_y = (int)(b1.m_linearVelocity.y * 65536.0f);
            v2_x = (int)(b2.m_linearVelocity.x * 65536.0f);
            v2_y = (int)(b2.m_linearVelocity.y * 65536.0f);
            int invMass1 = (int)(b1.m_invMass * 65536.0f);
            int invI1 = (int)(b1.m_invI * 65536.0f);
            int invMass2 = (int)(b2.m_invMass * 65536.0f);
            int invI2 = (int)(b2.m_invI * 65536.0f);
            int normal_x = (int)(c.normal.x * 65536.0f);
            tangent_x = normal_y = (int)(c.normal.y * 65536.0f);
            tangent_y = -normal_x;
            int friction = (int)(c.friction * 65536.0f);
            for (j = 0; j < c.pointCount; ++j) {
                ccp = c.points[j];
                this.ccp_r1_x[j] = (long)(ccp.r1.x * 65536.0f);
                this.ccp_r1_y[j] = (long)(ccp.r1.y * 65536.0f);
                this.ccp_r2_x[j] = (long)(ccp.r2.x * 65536.0f);
                this.ccp_r2_y[j] = (long)(ccp.r2.y * 65536.0f);
                this.ccp_tangentImpulse[j] = (long)(ccp.tangentImpulse * 65536.0f);
                this.ccp_normalImpulse[j] = (int)(ccp.normalImpulse * 65536.0f);
                dvx = v2_x - (int)((long)w2 * this.ccp_r2_y[j] >> 16) - v1_x + (int)((long)w1 * this.ccp_r1_y[j] >> 16);
                dvy = v2_y + (int)((long)w2 * this.ccp_r2_x[j] >> 16) - v1_y - (int)((long)w1 * this.ccp_r1_x[j] >> 16);
                int vn = (int)((long)dvx * (long)normal_x + (long)dvy * (long)normal_y >> 16);
                long lambda = -((long)(ccp.normalMass * 65536.0f) * (long)(vn - (int)(ccp.velocityBias * 65536.0f))) >> 16;
                int newImpulse = this.ccp_normalImpulse[j] + (int)lambda;
                if (newImpulse < 0) {
                    newImpulse = 0;
                }
                lambda = newImpulse - this.ccp_normalImpulse[j];
                long Px = lambda * (long)normal_x >> 16;
                long Py = lambda * (long)normal_y >> 16;
                v1_x -= (int)((long)invMass1 * Px >> 16);
                v1_y -= (int)((long)invMass1 * Py >> 16);
                w1 -= (int)((long)invI1 * (this.ccp_r1_x[j] * Py - this.ccp_r1_y[j] * Px >> 16) >> 16);
                v2_x += (int)((long)invMass2 * Px >> 16);
                v2_y += (int)((long)invMass2 * Py >> 16);
                w2 += (int)((long)invI2 * (this.ccp_r2_x[j] * Py - this.ccp_r2_y[j] * Px >> 16) >> 16);
                ccp.normalImpulse = (float)newImpulse * 1.5258789E-5f;
                this.ccp_normalImpulse[j] = newImpulse;
            }
            for (j = 0; j < c.pointCount; ++j) {
                ccp = c.points[j];
                dvx = v2_x - (int)((long)w2 * this.ccp_r2_y[j] >> 16) - v1_x + (int)((long)w1 * this.ccp_r1_y[j] >> 16);
                dvy = v2_y + (int)((long)w2 * this.ccp_r2_x[j] >> 16) - v1_y - (int)((long)w1 * this.ccp_r1_x[j] >> 16);
                long vt = (long)dvx * (long)tangent_x + (long)dvy * (long)tangent_y >> 16;
                long lambda = (long)(ccp.tangentMass * 65536.0f) * -vt >> 16;
                long newImpulse = this.ccp_tangentImpulse[j] + lambda;
                long maxFriction = (long)friction * (long)this.ccp_normalImpulse[j] >> 16;
                if (newImpulse < -maxFriction) {
                    newImpulse = -maxFriction;
                } else if (newImpulse > maxFriction) {
                    newImpulse = maxFriction;
                }
                lambda = newImpulse - this.ccp_tangentImpulse[j];
                long px = lambda * (long)tangent_x >> 16;
                long py = lambda * (long)tangent_y >> 16;
                v1_x -= (int)(px * (long)invMass1 >> 16);
                v1_y -= (int)(py * (long)invMass1 >> 16);
                w1 -= (int)((long)invI1 * (this.ccp_r1_x[j] * py - this.ccp_r1_y[j] * px >> 16) >> 16);
                v2_x += (int)(px * (long)invMass2 >> 16);
                v2_y += (int)(py * (long)invMass2 >> 16);
                w2 += (int)((long)invI2 * (this.ccp_r2_x[j] * py - this.ccp_r2_y[j] * px >> 16) >> 16);
                ccp.tangentImpulse = (float)newImpulse * 1.5258789E-5f;
            }
            b1.m_linearVelocity.set(new Vec2((float)v1_x * 1.5258789E-5f, (float)v1_y * 1.5258789E-5f));
            b1.m_angularVelocity = (float)w1 * 1.5258789E-5f;
            b2.m_linearVelocity.set(new Vec2((float)v2_x * 1.5258789E-5f, (float)v2_y * 1.5258789E-5f));
            b2.m_angularVelocity = (float)w2 * 1.5258789E-5f;
        }
    }

    public void finalizeVelocityConstraints() {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint c = this.m_constraints[i];
            Manifold m = c.manifold;
            for (int j = 0; j < c.pointCount; ++j) {
                m.points[j].normalImpulse = c.points[j].normalImpulse;
                m.points[j].tangentImpulse = c.points[j].tangentImpulse;
            }
        }
    }

    public boolean solvePositionConstraints(float baumgarte) {
        float minSeparation = 0.0f;
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            float invMass1 = b1.m_mass * b1.m_invMass;
            float invI1 = b1.m_mass * b1.m_invI;
            float invMass2 = b2.m_mass * b2.m_invMass;
            float invI2 = b2.m_mass * b2.m_invI;
            Vec2 normal = c.normal;
            for (int j = 0; j < c.pointCount; ++j) {
                ContactConstraintPoint ccp = c.points[j];
                Vec2 r1 = Mat22.mul(b1.m_xf.R, ccp.localAnchor1.sub(b1.m_sweep.localCenter));
                Vec2 r2 = Mat22.mul(b2.m_xf.R, ccp.localAnchor2.sub(b2.m_sweep.localCenter));
                float dpx = b2.m_sweep.c.x + r2.x - b1.m_sweep.c.x - r1.x;
                float dpy = b2.m_sweep.c.y + r2.y - b1.m_sweep.c.y - r1.y;
                float separation = dpx * normal.x + dpy * normal.y + ccp.separation;
                minSeparation = MathUtils.min(minSeparation, separation);
                float C = baumgarte * MathUtils.clamp(separation + 0.005f, -0.2f, 0.0f);
                float dImpulse = -ccp.equalizedMass * C;
                float impulse0 = ccp.positionImpulse;
                ccp.positionImpulse = MathUtils.max(impulse0 + dImpulse, 0.0f);
                dImpulse = ccp.positionImpulse - impulse0;
                float impulsex = dImpulse * normal.x;
                float impulsey = dImpulse * normal.y;
                b1.m_sweep.c.x -= invMass1 * impulsex;
                b1.m_sweep.c.y -= invMass1 * impulsey;
                b1.m_sweep.a -= invI1 * (r1.x * impulsey - r1.y * impulsex);
                b1.synchronizeTransform();
                b2.m_sweep.c.x += invMass2 * impulsex;
                b2.m_sweep.c.y += invMass2 * impulsey;
                b2.m_sweep.a += invI2 * (r2.x * impulsey - r2.y * impulsex);
                b2.synchronizeTransform();
            }
        }
        return minSeparation >= -0.0075f;
    }
}

