/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactConstraint;
import org.jbox2d.dynamics.contacts.ContactConstraintPoint;
import org.jbox2d.dynamics.contacts.ContactResult;
import org.jbox2d.dynamics.contacts.ContactSolver;
import org.jbox2d.dynamics.joints.Joint;

public class Island {
    public Body[] m_bodies;
    public Contact[] m_contacts;
    public Joint[] m_joints;
    public int m_bodyCount;
    public int m_jointCount;
    public int m_contactCount;
    public int m_bodyCapacity;
    public int m_contactCapacity;
    public int m_jointCapacity;
    public static int m_positionIterationCount = 0;
    public float m_positionError;
    public ContactListener m_listener;

    public void clear() {
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
    }

    void add(Body body) {
        this.m_bodies[this.m_bodyCount++] = body;
    }

    void add(Contact contact) {
        this.m_contacts[this.m_contactCount++] = contact;
    }

    void add(Joint joint) {
        this.m_joints[this.m_jointCount++] = joint;
    }

    public Island(int bodyCapacity, int contactCapacity, int jointCapacity, ContactListener listener) {
        this.m_bodyCapacity = bodyCapacity;
        this.m_contactCapacity = contactCapacity;
        this.m_jointCapacity = jointCapacity;
        this.m_bodyCount = 0;
        this.m_contactCount = 0;
        this.m_jointCount = 0;
        this.m_listener = listener;
        this.m_bodies = new Body[bodyCapacity];
        this.m_contacts = new Contact[contactCapacity];
        this.m_joints = new Joint[jointCapacity];
        m_positionIterationCount = 0;
    }

    public void solve(TimeStep step, Vec2 gravity, boolean correctPositions, boolean allowSleep) {
        int i;
        for (int i2 = 0; i2 < this.m_bodyCount; ++i2) {
            Body b = this.m_bodies[i2];
            if (b.isStatic()) continue;
            b.m_linearVelocity.x += step.dt * (gravity.x + b.m_invMass * b.m_force.x);
            b.m_linearVelocity.y += step.dt * (gravity.y + b.m_invMass * b.m_force.y);
            b.m_angularVelocity += step.dt * b.m_invI * b.m_torque;
            b.m_force.set(0.0f, 0.0f);
            b.m_torque = 0.0f;
            b.m_linearVelocity.mulLocal(MathUtils.clamp(1.0f - step.dt * b.m_linearDamping, 0.0f, 1.0f));
            b.m_angularVelocity *= MathUtils.clamp(1.0f - step.dt * b.m_angularDamping, 0.0f, 1.0f);
            if (Vec2.dot(b.m_linearVelocity, b.m_linearVelocity) > 40000.0f) {
                b.m_linearVelocity.normalize();
                b.m_linearVelocity.mulLocal(200.0f);
            }
            if (!(b.m_angularVelocity * b.m_angularVelocity > 62500.0f)) continue;
            b.m_angularVelocity = b.m_angularVelocity < 0.0f ? -250.0f : 250.0f;
        }
        ContactSolver contactSolver = new ContactSolver(step, this.m_contacts, this.m_contactCount);
        contactSolver.initVelocityConstraints(step);
        for (i = 0; i < this.m_jointCount; ++i) {
            this.m_joints[i].initVelocityConstraints(step);
        }
        for (i = 0; i < step.maxIterations; ++i) {
            contactSolver.solveVelocityConstraints();
            for (int j = 0; j < this.m_jointCount; ++j) {
                this.m_joints[j].solveVelocityConstraints(step);
            }
        }
        contactSolver.finalizeVelocityConstraints();
        for (i = 0; i < this.m_bodyCount; ++i) {
            Body b = this.m_bodies[i];
            if (b.isStatic()) continue;
            b.m_sweep.c0.set(b.m_sweep.c);
            b.m_sweep.a0 = b.m_sweep.a;
            b.m_sweep.c.x += step.dt * b.m_linearVelocity.x;
            b.m_sweep.c.y += step.dt * b.m_linearVelocity.y;
            b.m_sweep.a += step.dt * b.m_angularVelocity;
            b.synchronizeTransform();
        }
        if (correctPositions) {
            for (i = 0; i < this.m_jointCount; ++i) {
                this.m_joints[i].initPositionConstraints();
            }
            for (m_positionIterationCount = 0; m_positionIterationCount < step.maxIterations; ++m_positionIterationCount) {
                boolean contactsOkay = contactSolver.solvePositionConstraints(0.2f);
                boolean jointsOkay = true;
                for (int i3 = 0; i3 < this.m_jointCount; ++i3) {
                    boolean jointOkay = this.m_joints[i3].solvePositionConstraints();
                    jointsOkay = jointsOkay && jointOkay;
                }
                if (contactsOkay && jointsOkay) break;
            }
        }
        this.report(contactSolver.m_constraints);
        if (allowSleep) {
            Body b;
            int i4;
            float minSleepTime = Float.MAX_VALUE;
            float linTolSqr = 1.0E-4f;
            float angTolSqr = 1.2345679E-4f;
            for (i4 = 0; i4 < this.m_bodyCount; ++i4) {
                b = this.m_bodies[i4];
                if (b.m_invMass == 0.0f) continue;
                if ((b.m_flags & 0x10) == 0) {
                    b.m_sleepTime = 0.0f;
                    minSleepTime = 0.0f;
                }
                if ((b.m_flags & 0x10) == 0 || b.m_angularVelocity * b.m_angularVelocity > 1.2345679E-4f || Vec2.dot(b.m_linearVelocity, b.m_linearVelocity) > 1.0E-4f) {
                    b.m_sleepTime = 0.0f;
                    minSleepTime = 0.0f;
                    continue;
                }
                b.m_sleepTime += step.dt;
                minSleepTime = Math.min(minSleepTime, b.m_sleepTime);
            }
            if (minSleepTime >= 0.5f) {
                for (i4 = 0; i4 < this.m_bodyCount; ++i4) {
                    b = this.m_bodies[i4];
                    b.m_flags |= 8;
                    b.m_linearVelocity = new Vec2(0.0f, 0.0f);
                    b.m_angularVelocity = 0.0f;
                }
            }
        }
    }

    public void solveTOI(TimeStep subStep) {
        boolean contactsOkay;
        int i;
        ContactSolver contactSolver = new ContactSolver(subStep, this.m_contacts, this.m_contactCount);
        for (i = 0; i < subStep.maxIterations; ++i) {
            contactSolver.solveVelocityConstraints();
        }
        for (i = 0; i < this.m_bodyCount; ++i) {
            Body b = this.m_bodies[i];
            if (b.isStatic()) continue;
            b.m_sweep.c0.set(b.m_sweep.c);
            b.m_sweep.a0 = b.m_sweep.a;
            b.m_sweep.c.x += subStep.dt * b.m_linearVelocity.x;
            b.m_sweep.c.y += subStep.dt * b.m_linearVelocity.y;
            b.m_sweep.a += subStep.dt * b.m_angularVelocity;
            b.synchronizeTransform();
        }
        float k_toiBaumgarte = 0.75f;
        for (int i2 = 0; i2 < subStep.maxIterations && !(contactsOkay = contactSolver.solvePositionConstraints(0.75f)); ++i2) {
        }
        this.report(contactSolver.m_constraints);
    }

    public void report(ContactConstraint[] constraints) {
        if (this.m_listener == null) {
            return;
        }
        for (int i = 0; i < this.m_contactCount; ++i) {
            Contact c = this.m_contacts[i];
            ContactConstraint cc = constraints[i];
            ContactResult cr = new ContactResult();
            cr.shape1 = c.getShape1();
            cr.shape2 = c.getShape2();
            Body b1 = cr.shape1.getBody();
            int manifoldCount = c.getManifoldCount();
            if (manifoldCount > 1) {
                System.err.println("Island.report: expecting manifoldCount 0 or 1!");
            }
            for (int j = 0; j < manifoldCount; ++j) {
                Manifold manifold = c.getManifold();
                cr.normal.set(manifold.normal);
                for (int k = 0; k < manifold.pointCount; ++k) {
                    ManifoldPoint point = manifold.points[k];
                    ContactConstraintPoint ccp = cc.points[k];
                    cr.position = XForm.mul(b1.getXForm(), point.localPoint1);
                    cr.normalImpulse = ccp.normalImpulse;
                    cr.tangentImpulse = ccp.tangentImpulse;
                    cr.id = new ContactID(point.id);
                    this.m_listener.result(cr);
                }
            }
        }
    }
}

