/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import java.util.Vector;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.OBB;
import org.jbox2d.collision.PolygonDef;
import org.jbox2d.collision.Shape;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.collision.SupportsGenericDistance;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class PolygonShape
extends Shape
implements SupportsGenericDistance {
    private static boolean m_debug = false;
    public Vec2 m_centroid;
    public OBB m_obb;
    public Vec2[] m_vertices;
    public Vec2[] m_normals;
    public Vec2[] m_coreVertices;
    public int m_vertexCount;
    static final double sq2p1 = 2.414213562373095;
    static final double sq2m1 = 0.41421356237309503;
    static final double p4 = 16.15364129822302;
    static final double p3 = 268.42548195503974;
    static final double p2 = 1153.029351540485;
    static final double p1 = 1780.406316433197;
    static final double p0 = 896.7859740366387;
    static final double q4 = 58.95697050844462;
    static final double q3 = 536.2653740312153;
    static final double q2 = 1666.7838148816338;
    static final double q1 = 2079.33497444541;
    static final double q0 = 896.7859740366387;
    static final double PIO2 = 1.5707963267948966;
    static final double nan = Double.NaN;

    public static double asin(double arg) {
        int sign = 0;
        if (arg < 0.0) {
            arg = -arg;
            ++sign;
        }
        if (arg > 1.0) {
            return Double.NaN;
        }
        double temp = Math.sqrt(1.0 - arg * arg);
        temp = arg > 0.7 ? 1.5707963267948966 - PolygonShape.atan(temp / arg) : PolygonShape.atan(arg / temp);
        if (sign > 0) {
            temp = -temp;
        }
        return temp;
    }

    private static double mxatan(double arg) {
        double argsq = arg * arg;
        double value = (((16.15364129822302 * argsq + 268.42548195503974) * argsq + 1153.029351540485) * argsq + 1780.406316433197) * argsq + 896.7859740366387;
        return (value /= ((((argsq + 58.95697050844462) * argsq + 536.2653740312153) * argsq + 1666.7838148816338) * argsq + 2079.33497444541) * argsq + 896.7859740366387) * arg;
    }

    private static double msatan(double arg) {
        if (arg < 0.41421356237309503) {
            return PolygonShape.mxatan(arg);
        }
        if (arg > 2.414213562373095) {
            return 1.5707963267948966 - PolygonShape.mxatan(1.0 / arg);
        }
        return 0.7853981633974483 + PolygonShape.mxatan((arg - 1.0) / (arg + 1.0));
    }

    public static double atan(double arg) {
        if (arg > 0.0) {
            return PolygonShape.msatan(arg);
        }
        return -PolygonShape.msatan(-arg);
    }

    public PolygonShape(ShapeDef def) {
        super(def);
        int i;
        this.m_type = 2;
        PolygonDef poly = (PolygonDef)def;
        this.m_vertexCount = poly.getVertexCount();
        this.m_vertices = new Vec2[this.m_vertexCount];
        this.m_normals = new Vec2[this.m_vertexCount];
        this.m_coreVertices = new Vec2[this.m_vertexCount];
        this.m_obb = new OBB();
        for (i = 0; i < this.m_vertexCount; ++i) {
            this.m_vertices[i] = ((Vec2)poly.vertices.elementAt(i)).clone();
        }
        for (i = 0; i < this.m_vertexCount; ++i) {
            int i1 = i;
            int i2 = i + 1 < this.m_vertexCount ? i + 1 : 0;
            Vec2 edge = this.m_vertices[i2].sub(this.m_vertices[i1]);
            this.m_normals[i] = Vec2.cross(edge, 1.0f);
            this.m_normals[i].normalize();
        }
        if (m_debug) {
            for (i = 0; i < this.m_vertexCount; ++i) {
                for (int j = 0; j < this.m_vertexCount; ++j) {
                    if (j == i || j == (i + 1) % this.m_vertexCount) continue;
                    float s = Vec2.dot(this.m_normals[i], this.m_vertices[j].sub(this.m_vertices[i]));
                }
            }
            for (i = 1; i < this.m_vertexCount; ++i) {
                float cross = Vec2.cross(this.m_normals[i - 1], this.m_normals[i]);
                cross = MathUtils.clamp(cross, -1.0f, 1.0f);
                float angle = (float)PolygonShape.asin(cross);
            }
        }
        this.m_centroid = PolygonShape.computeCentroid(poly.vertices);
        PolygonShape.computeOBB(this.m_obb, this.m_vertices);
        for (i = 0; i < this.m_vertexCount; ++i) {
            int i1 = i - 1 >= 0 ? i - 1 : this.m_vertexCount - 1;
            int i2 = i;
            Vec2 n1 = this.m_normals[i1];
            Vec2 n2 = this.m_normals[i2];
            Vec2 v = this.m_vertices[i].sub(this.m_centroid);
            Vec2 d = new Vec2();
            d.x = Vec2.dot(n1, v) - 0.04f;
            d.y = Vec2.dot(n2, v) - 0.04f;
            if (m_debug && (d.x < 0.0f || d.y < 0.0f)) {
                System.out.println("Error, dumping details: ");
                System.out.println("d.x: " + d.x + "d.y: " + d.y);
                System.out.println("n1: " + n1 + "; n2: " + n2);
                System.out.println("v: " + v);
            }
            Mat22 A = new Mat22();
            A.col1.x = n1.x;
            A.col2.x = n1.y;
            A.col1.y = n2.x;
            A.col2.y = n2.y;
            this.m_coreVertices[i] = A.solve(d).addLocal(this.m_centroid);
        }
        if (m_debug) {
            System.out.println("\nDumping polygon shape...");
            System.out.println("Vertices: ");
            for (i = 0; i < this.m_vertexCount; ++i) {
                System.out.println(this.m_vertices[i]);
            }
            System.out.println("Core Vertices: ");
            for (i = 0; i < this.m_vertexCount; ++i) {
                System.out.println(this.m_coreVertices[i]);
            }
            System.out.println("Normals: ");
            for (i = 0; i < this.m_vertexCount; ++i) {
                System.out.println(this.m_normals[i]);
            }
            System.out.println("Centroid: " + this.m_centroid);
        }
    }

    public void updateSweepRadius(Vec2 center) {
        this.m_sweepRadius = 0.0f;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            Vec2 d = this.m_coreVertices[i].sub(center);
            this.m_sweepRadius = Math.max(this.m_sweepRadius, d.length());
        }
    }

    public boolean testPoint(XForm xf, Vec2 p) {
        int i;
        Vec2 pLocal = Mat22.mulT(xf.R, p.sub(xf.position));
        if (m_debug) {
            System.out.println("--testPoint debug--");
            System.out.println("Vertices: ");
            for (i = 0; i < this.m_vertexCount; ++i) {
                System.out.println(this.m_vertices[i]);
            }
            System.out.println("pLocal: " + pLocal);
        }
        for (i = 0; i < this.m_vertexCount; ++i) {
            float dot = Vec2.dot(this.m_normals[i], pLocal.sub(this.m_vertices[i]));
            if (!(dot > 0.0f)) continue;
            return false;
        }
        return true;
    }

    public Vec2 support(XForm xf, Vec2 d) {
        Vec2 dLocal = Mat22.mulT(xf.R, d);
        int bestIndex = 0;
        float bestValue = Vec2.dot(this.m_coreVertices[0], dLocal);
        for (int i = 1; i < this.m_vertexCount; ++i) {
            float value = Vec2.dot(this.m_coreVertices[i], dLocal);
            if (!(value > bestValue)) continue;
            bestIndex = i;
            bestValue = value;
        }
        return XForm.mul(xf, this.m_coreVertices[bestIndex]);
    }

    public static Vec2 computeCentroid(Vector vs) {
        int count = vs.size();
        Vec2 c = new Vec2();
        float area = 0.0f;
        Vec2 pRef = new Vec2();
        float inv3 = 0.33333334f;
        for (int i = 0; i < count; ++i) {
            Vec2 p1 = pRef;
            Vec2 p2 = (Vec2)vs.elementAt(i);
            Vec2 p3 = i + 1 < count ? (Vec2)vs.elementAt(i + 1) : (Vec2)vs.elementAt(0);
            Vec2 e1 = p2.sub(p1);
            Vec2 e2 = p3.sub(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            c.x += triangleArea * 0.33333334f * (p1.x + p2.x + p3.x);
            c.y += triangleArea * 0.33333334f * (p1.y + p2.y + p3.y);
        }
        c.mulLocal(1.0f / area);
        return c;
    }

    public static void computeOBB(OBB obb, Vec2[] vs) {
        int count = vs.length;
        Vec2[] p = new Vec2[9];
        for (int i = 0; i < count; ++i) {
            p[i] = vs[i];
        }
        p[count] = p[0];
        float minArea = Float.MAX_VALUE;
        for (int i = 1; i <= count; ++i) {
            Vec2 root = p[i - 1];
            Vec2 ux = p[i].sub(root);
            float length = ux.normalize();
            Vec2 uy = new Vec2(-ux.y, ux.x);
            Vec2 lower = new Vec2(Float.MAX_VALUE, Float.MAX_VALUE);
            Vec2 upper = new Vec2(-3.4028235E38f, -3.4028235E38f);
            for (int j = 0; j < count; ++j) {
                Vec2 d = p[j].sub(root);
                Vec2 r = new Vec2();
                r.x = Vec2.dot(ux, d);
                r.y = Vec2.dot(uy, d);
                lower = Vec2.min(lower, r);
                upper = Vec2.max(upper, r);
            }
            float area = (upper.x - lower.x) * (upper.y - lower.y);
            if (!(area < 0.95f * minArea)) continue;
            minArea = area;
            obb.R.col1.set(ux);
            obb.R.col2.set(uy);
            Vec2 center = new Vec2(0.5f * (lower.x + upper.x), 0.5f * (lower.y + upper.y));
            obb.center = root.add(Mat22.mul(obb.R, center));
            obb.extents = new Vec2(0.5f * (upper.x - lower.x), 0.5f * (upper.y - lower.y));
        }
    }

    public void computeAABB(AABB aabb, XForm xf) {
        Mat22 R = Mat22.mul(xf.R, this.m_obb.R);
        Mat22 absR = Mat22.abs(R);
        Vec2 h = Mat22.mul(absR, this.m_obb.extents);
        Vec2 position = xf.position.add(Mat22.mul(xf.R, this.m_obb.center));
        aabb.lowerBound = position.sub(h);
        aabb.upperBound = position.add(h);
    }

    public void computeSweptAABB(AABB aabb, XForm transform1, XForm transform2) {
        AABB aabb1 = new AABB();
        AABB aabb2 = new AABB();
        this.computeAABB(aabb1, transform1);
        this.computeAABB(aabb2, transform2);
        aabb.lowerBound = Vec2.min(aabb1.lowerBound, aabb2.lowerBound);
        aabb.upperBound = Vec2.max(aabb1.upperBound, aabb2.upperBound);
    }

    public void computeMass(MassData massData) {
        Vec2 center = new Vec2(0.0f, 0.0f);
        float area = 0.0f;
        float I = 0.0f;
        Vec2 pRef = new Vec2(0.0f, 0.0f);
        float k_inv3 = 0.33333334f;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            Vec2 p1 = pRef;
            Vec2 p2 = this.m_vertices[i];
            Vec2 p3 = i + 1 < this.m_vertexCount ? this.m_vertices[i + 1] : this.m_vertices[0];
            Vec2 e1 = p2.sub(p1);
            Vec2 e2 = p3.sub(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            center.x += triangleArea * k_inv3 * (p1.x + p2.x + p3.x);
            center.y += triangleArea * k_inv3 * (p1.y + p2.y + p3.y);
            float px = p1.x;
            float py = p1.y;
            float ex1 = e1.x;
            float ey1 = e1.y;
            float ex2 = e2.x;
            float ey2 = e2.y;
            float intx2 = k_inv3 * (0.25f * (ex1 * ex1 + ex2 * ex1 + ex2 * ex2) + (px * ex1 + px * ex2)) + 0.5f * px * px;
            float inty2 = k_inv3 * (0.25f * (ey1 * ey1 + ey2 * ey1 + ey2 * ey2) + (py * ey1 + py * ey2)) + 0.5f * py * py;
            I += D * (intx2 + inty2);
        }
        massData.mass = this.m_density * area;
        center.mulLocal(1.0f / area);
        massData.center = center.clone();
        massData.I = I * this.m_density;
    }

    public Vec2 getFirstVertex(XForm xf) {
        return XForm.mul(xf, this.m_coreVertices[0]);
    }

    public OBB getOBB() {
        return this.m_obb.clone();
    }

    public Vec2 getCentroid() {
        return this.m_centroid.clone();
    }

    public int getVertexCount() {
        return this.m_vertexCount;
    }

    public Vec2[] getVertices() {
        return this.m_vertices;
    }

    public Vec2[] getCoreVertices() {
        return this.m_coreVertices;
    }

    public Vec2[] getNormals() {
        return this.m_normals;
    }

    public Vec2 centroid(XForm xf) {
        return XForm.mul(xf, this.m_centroid);
    }
}

