/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import java.util.Vector;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class PolygonDef
extends ShapeDef {
    public Vector vertices;

    public PolygonDef() {
        this.type = 2;
        this.vertices = new Vector(10, 40);
    }

    public void addVertex(Vec2 v) {
        this.vertices.addElement(v);
    }

    public void clearVertices() {
        this.vertices.removeAllElements();
    }

    public void setAsBox(float hx, float hy) {
        this.vertices.removeAllElements();
        this.vertices.addElement(new Vec2(-hx, -hy));
        this.vertices.addElement(new Vec2(hx, -hy));
        this.vertices.addElement(new Vec2(hx, hy));
        this.vertices.addElement(new Vec2(-hx, hy));
    }

    public void setAsBox(float hx, float hy, Vec2 center, float angle) {
        this.setAsBox(hx, hy);
        XForm xf = new XForm();
        xf.position.set(center);
        xf.R.set(angle);
        for (int i = 0; i < this.vertices.size(); ++i) {
            ((Vec2)this.vertices.elementAt(i)).set(XForm.mul(xf, (Vec2)this.vertices.elementAt(i)));
        }
    }

    public int getVertexCount() {
        return this.vertices.size();
    }
}

