/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.CircleShape;
import org.jbox2d.collision.Point;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.collision.Shape;
import org.jbox2d.collision.SupportsGenericDistance;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class Distance {
    public static int g_GJK_Iterations = 0;

    protected static int ProcessTwo(Vec2 x1, Vec2 x2, Vec2[] p1s, Vec2[] p2s, Vec2[] points) {
        Vec2 r = new Vec2(-points[1].x, -points[1].y);
        Vec2 d = new Vec2(points[0].x - points[1].x, points[0].y - points[1].y);
        float length = d.normalize();
        float lambda = Vec2.dot(r, d);
        if (lambda <= 0.0f || length < 1.1920929E-7f) {
            x1.set(p1s[1]);
            x2.set(p2s[1]);
            p1s[0].set(p1s[1]);
            p2s[0].set(p2s[1]);
            points[0].set(points[1]);
            return 1;
        }
        x1.set(p1s[1].x + (lambda /= length) * (p1s[0].x - p1s[1].x), p1s[1].y + lambda * (p1s[0].y - p1s[1].y));
        x2.set(p2s[1].x + lambda * (p2s[0].x - p2s[1].x), p2s[1].y + lambda * (p2s[0].y - p2s[1].y));
        return 2;
    }

    protected static int ProcessThree(Vec2 x1, Vec2 x2, Vec2[] p1s, Vec2[] p2s, Vec2[] points) {
        Vec2 a = points[0];
        Vec2 b = points[1];
        Vec2 c = points[2];
        Vec2 ab = b.sub(a);
        Vec2 ac = c.sub(a);
        Vec2 bc = c.sub(b);
        float sn = -Vec2.dot(a, ab);
        float sd = Vec2.dot(b, ab);
        float tn = -Vec2.dot(a, ac);
        float td = Vec2.dot(c, ac);
        float un = -Vec2.dot(b, bc);
        float ud = Vec2.dot(c, bc);
        if (td <= 0.0f && ud <= 0.0f) {
            x1.set(p1s[2]);
            x2.set(p2s[2]);
            p1s[0].set(p1s[2]);
            p2s[0].set(p2s[2]);
            points[0].set(points[2]);
            return 1;
        }
        float n = Vec2.cross(ab, ac);
        float vc = n * Vec2.cross(a, b);
        float va = n * Vec2.cross(b, c);
        if (va <= 0.0f && un >= 0.0f && ud >= 0.0f && un + ud > 0.0f) {
            float lambda = un / (un + ud);
            x1.set(p1s[1].x + lambda * (p1s[2].x - p1s[1].x), p1s[1].y + lambda * (p1s[2].y - p1s[1].y));
            x2.set(p2s[1].x + lambda * (p2s[2].x - p2s[1].x), p2s[1].y + lambda * (p2s[2].y - p2s[1].y));
            p1s[0].set(p1s[2]);
            p2s[0].set(p2s[2]);
            points[0].set(points[2]);
            return 2;
        }
        float vb = n * Vec2.cross(c, a);
        if (vb <= 0.0f && tn >= 0.0f && td >= 0.0f && tn + td > 0.0f) {
            float lambda = tn / (tn + td);
            x1.set(p1s[0].x + lambda * (p1s[2].x - p1s[0].x), p1s[0].y + lambda * (p1s[2].y - p1s[0].y));
            x2.set(p2s[0].x + lambda * (p2s[2].x - p2s[0].x), p2s[0].y + lambda * (p2s[2].y - p2s[0].y));
            p1s[1].set(p1s[2]);
            p2s[1].set(p2s[2]);
            points[1].set(points[2]);
            return 2;
        }
        float denom = va + vb + vc;
        denom = 1.0f / denom;
        float u = va * denom;
        float v = vb * denom;
        float w = 1.0f - u - v;
        x1.set(u * p1s[0].x + v * p1s[1].x + w * p1s[2].x, u * p1s[0].y + v * p1s[1].y + w * p1s[2].y);
        x2.set(u * p2s[0].x + v * p2s[1].x + w * p2s[2].x, u * p2s[0].y + v * p2s[1].y + w * p2s[2].y);
        return 3;
    }

    protected static boolean InPoints(Vec2 w, Vec2[] points, int pointCount) {
        float k_tolerance = 1.1920929E-5f;
        Vec2 d = new Vec2(0.0f, 0.0f);
        Vec2 m = new Vec2(0.0f, 0.0f);
        Vec2 abs_pi = new Vec2(0.0f, 0.0f);
        Vec2 wsubp = new Vec2(0.0f, 0.0f);
        for (int i = 0; i < pointCount; ++i) {
            Vec2 pi = points[i];
            wsubp.x = w.x - pi.x;
            wsubp.y = w.y - pi.y;
            d.x = wsubp.x > 0.0f ? d.x : -d.x;
            d.y = wsubp.y > 0.0f ? d.y : -d.y;
            m.x = w.x > 0.0f ? w.x : -w.x;
            m.y = w.y > 0.0f ? w.y : -w.y;
            abs_pi.x = pi.x > 0.0f ? pi.x : -pi.x;
            float f = abs_pi.y = pi.y > 0.0f ? pi.y : -pi.y;
            if (abs_pi.x > m.x) {
                m.x = abs_pi.x;
            }
            if (abs_pi.y > m.y) {
                m.y = abs_pi.y;
            }
            if (!(d.x < k_tolerance * (m.x + 1.0f)) || !(d.y < k_tolerance * (m.y + 1.0f))) continue;
            return true;
        }
        return false;
    }

    public static float DistanceGeneric(Vec2 x1, Vec2 x2, SupportsGenericDistance shape1, XForm xf1, SupportsGenericDistance shape2, XForm xf2) {
        Vec2[] p1s = new Vec2[3];
        Vec2[] p2s = new Vec2[3];
        Vec2[] points = new Vec2[3];
        for (int i = 0; i < 3; ++i) {
            p1s[i] = new Vec2();
            p2s[i] = new Vec2();
            points[i] = new Vec2();
        }
        int pointCount = 0;
        x1.set(shape1.getFirstVertex(xf1));
        x2.set(shape2.getFirstVertex(xf2));
        float vSqr = 0.0f;
        int maxIterations = 20;
        for (int iter = 0; iter < maxIterations; ++iter) {
            Vec2 w;
            float vw;
            Vec2 v = x2.sub(x1);
            Vec2 w1 = shape1.support(xf1, v);
            Vec2 w2 = shape2.support(xf2, v.negate());
            vSqr = Vec2.dot(v, v);
            if (vSqr - (vw = Vec2.dot(v, w = w2.sub(w1))) <= 0.01f * vSqr || Distance.InPoints(w, points, pointCount)) {
                if (pointCount == 0) {
                    x1.set(w1);
                    x2.set(w2);
                }
                g_GJK_Iterations = iter;
                return (float)Math.sqrt(vSqr);
            }
            switch (pointCount) {
                case 0: {
                    p1s[0].set(w1);
                    p2s[0].set(w2);
                    points[0].set(w);
                    x1.set(p1s[0]);
                    x2.set(p2s[0]);
                    ++pointCount;
                    break;
                }
                case 1: {
                    p1s[1].set(w1);
                    p2s[1].set(w2);
                    points[1].set(w);
                    pointCount = Distance.ProcessTwo(x1, x2, p1s, p2s, points);
                    break;
                }
                case 2: {
                    p1s[2].set(w1);
                    p2s[2].set(w2);
                    points[2].set(w);
                    pointCount = Distance.ProcessThree(x1, x2, p1s, p2s, points);
                }
            }
            if (pointCount == 3) {
                g_GJK_Iterations = iter;
                return 0.0f;
            }
            float maxSqr = -3.4028235E38f;
            for (int i = 0; i < pointCount; ++i) {
                maxSqr = Math.max(maxSqr, Vec2.dot(points[i], points[i]));
            }
            if (pointCount != 3 && !(vSqr <= 1.1920929E-5f * maxSqr)) continue;
            g_GJK_Iterations = iter;
            v.set(x2.x - x1.x, x2.y - x1.y);
            vSqr = Vec2.dot(v, v);
            return (float)Math.sqrt(vSqr);
        }
        g_GJK_Iterations = maxIterations;
        return (float)Math.sqrt(vSqr);
    }

    protected static float DistanceCC(Vec2 x1, Vec2 x2, CircleShape circle1, XForm xf1, CircleShape circle2, XForm xf2) {
        float r2;
        float r1;
        float r;
        Vec2 p1 = XForm.mul(xf1, circle1.getLocalPosition());
        Vec2 p2 = XForm.mul(xf2, circle2.getLocalPosition());
        Vec2 d = new Vec2(p2.x - p1.x, p2.y - p1.y);
        float dSqr = Vec2.dot(d, d);
        if (dSqr > (r = (r1 = circle1.getRadius() - 0.04f) + (r2 = circle2.getRadius() - 0.04f)) * r) {
            float dLen = d.normalize();
            float distance = dLen - r;
            x1.set(p1.x + r1 * d.x, p1.y + r1 * d.y);
            x2.set(p2.x - r2 * d.x, p2.y - r2 * d.y);
            return distance;
        }
        if (dSqr > 1.4210855E-14f) {
            d.normalize();
            x1.set(p1.x + r1 * d.x, p1.y + r1 * d.y);
            x2.set(x1);
            return 0.0f;
        }
        x1.set(p1);
        x2.set(x1);
        return 0.0f;
    }

    protected static float DistancePC(Vec2 x1, Vec2 x2, PolygonShape polygon, XForm xf1, CircleShape circle, XForm xf2) {
        float r;
        Point point = new Point(new Vec2(0.0f, 0.0f));
        point.p = XForm.mul(xf2, circle.getLocalPosition());
        float distance = Distance.DistanceGeneric(x1, x2, polygon, xf1, point, XForm.identity);
        if (distance > (r = circle.getRadius() - 0.04f)) {
            distance -= r;
            Vec2 d = x2.sub(x1);
            d.normalize();
            x2.x -= r * d.x;
            x2.y -= r * d.y;
        } else {
            distance = 0.0f;
            x2.set(x1);
        }
        return distance;
    }

    public static float distance(Vec2 x1, Vec2 x2, Shape shape1, XForm xf1, Shape shape2, XForm xf2) {
        int type1 = shape1.getType();
        int type2 = shape2.getType();
        if (type1 == 1 && type2 == 1) {
            return Distance.DistanceCC(x1, x2, (CircleShape)shape1, xf1, (CircleShape)shape2, xf2);
        }
        if (type1 == 2 && type2 == 1) {
            return Distance.DistancePC(x1, x2, (PolygonShape)shape1, xf1, (CircleShape)shape2, xf2);
        }
        if (type1 == 1 && type2 == 2) {
            return Distance.DistancePC(x2, x1, (PolygonShape)shape2, xf2, (CircleShape)shape1, xf1);
        }
        if (type1 == 2 && type2 == 2) {
            return Distance.DistanceGeneric(x1, x2, (PolygonShape)shape1, xf1, (PolygonShape)shape2, xf2);
        }
        return 0.0f;
    }
}

