/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.Bound;
import org.jbox2d.collision.BoundValues;
import org.jbox2d.collision.BufferedPair;
import org.jbox2d.collision.PairCallback;
import org.jbox2d.collision.PairManager;
import org.jbox2d.collision.Proxy;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;

public class BroadPhase {
    public static final int INVALID = Integer.MAX_VALUE;
    public static final int NULL_EDGE = Integer.MAX_VALUE;
    public PairManager m_pairManager;
    public Proxy[] m_proxyPool = new Proxy[256];
    int m_freeProxy;
    BufferedPair[] pairBuffer = new BufferedPair[2048];
    int m_pairBufferCount;
    public Bound[][] m_bounds = new Bound[2][512];
    int[] m_queryResults = new int[256];
    int m_queryResultCount;
    public AABB m_worldAABB;
    public Vec2 m_quantizationFactor;
    public int m_proxyCount;
    int m_timeStamp;
    private static final boolean debugPrint = false;
    public static final boolean s_validate = false;

    private void dump() {
        for (int i = 0; i < 10; ++i) {
            System.out.print("bounds[ %d ] = %d, %d \n" + i + " " + this.m_bounds[0][i].value + " " + this.m_bounds[1][i].value);
        }
    }

    public BroadPhase(AABB worldAABB, PairCallback callback) {
        int i;
        for (i = 0; i < 512; ++i) {
            this.m_bounds[0][i] = new Bound();
            this.m_bounds[1][i] = new Bound();
        }
        for (i = 0; i < 256; ++i) {
            this.pairBuffer[i] = new BufferedPair();
        }
        this.m_pairManager = new PairManager();
        this.m_pairManager.initialize(this, callback);
        this.m_worldAABB = new AABB(worldAABB);
        this.m_proxyCount = 0;
        Vec2 d = worldAABB.upperBound.sub(worldAABB.lowerBound);
        this.m_quantizationFactor = new Vec2(2.1474836E9f / d.x, 2.1474836E9f / d.y);
        for (int i2 = 0; i2 < 255; ++i2) {
            this.m_proxyPool[i2] = new Proxy();
            this.m_proxyPool[i2].setNext(i2 + 1);
            this.m_proxyPool[i2].timeStamp = 0;
            this.m_proxyPool[i2].overlapCount = Integer.MAX_VALUE;
            this.m_proxyPool[i2].userData = null;
        }
        this.m_proxyPool[255] = new Proxy();
        this.m_proxyPool[255].setNext(Integer.MAX_VALUE);
        this.m_proxyPool[255].timeStamp = 0;
        this.m_proxyPool[255].overlapCount = Integer.MAX_VALUE;
        this.m_proxyPool[255].userData = null;
        this.m_freeProxy = 0;
        this.m_timeStamp = 1;
        this.m_queryResultCount = 0;
    }

    protected boolean testOverlap(Proxy p1, Proxy p2) {
        for (int axis = 0; axis < 2; ++axis) {
            Bound[] bounds = this.m_bounds[axis];
            if (bounds[p1.lowerBounds[axis]].value > bounds[p2.upperBounds[axis]].value) {
                return false;
            }
            if (bounds[p1.upperBounds[axis]].value >= bounds[p2.lowerBounds[axis]].value) continue;
            return false;
        }
        return true;
    }

    private boolean testOverlap(BoundValues b, Proxy p) {
        for (int axis = 0; axis < 2; ++axis) {
            Bound[] bounds = this.m_bounds[axis];
            if (b.lowerValues[axis] > bounds[p.upperBounds[axis]].value) {
                return false;
            }
            if (b.upperValues[axis] >= bounds[p.lowerBounds[axis]].value) continue;
            return false;
        }
        return true;
    }

    public Proxy getProxy(int proxyId) {
        if (proxyId == Integer.MAX_VALUE || !this.m_proxyPool[proxyId].isValid()) {
            return null;
        }
        return this.m_proxyPool[proxyId];
    }

    int createProxy(AABB aabb, Object userData) {
        int proxyId = this.m_freeProxy;
        Proxy proxy = this.m_proxyPool[proxyId];
        this.m_freeProxy = proxy.getNext();
        proxy.overlapCount = 0;
        proxy.userData = userData;
        int boundCount = 2 * this.m_proxyCount;
        int[] lowerValues = new int[2];
        int[] upperValues = new int[2];
        this.computeBounds(lowerValues, upperValues, aabb);
        for (int axis = 0; axis < 2; ++axis) {
            int index;
            int i;
            Bound[] bounds = this.m_bounds[axis];
            int[] indexes = new int[2];
            this.query(indexes, lowerValues[axis], upperValues[axis], bounds, boundCount, axis);
            int lowerIndex = indexes[0];
            int upperIndex = indexes[1];
            System.arraycopy(this.m_bounds[axis], upperIndex, this.m_bounds[axis], upperIndex + 2, boundCount - upperIndex);
            for (i = 0; i < boundCount - upperIndex; ++i) {
                this.m_bounds[axis][upperIndex + 2 + i] = new Bound(this.m_bounds[axis][upperIndex + 2 + i]);
            }
            System.arraycopy(this.m_bounds[axis], lowerIndex, this.m_bounds[axis], lowerIndex + 1, upperIndex - lowerIndex);
            for (i = 0; i < upperIndex - lowerIndex; ++i) {
                this.m_bounds[axis][lowerIndex + 1 + i] = new Bound(this.m_bounds[axis][lowerIndex + 1 + i]);
            }
            bounds[lowerIndex].value = lowerValues[axis];
            bounds[lowerIndex].proxyId = proxyId;
            bounds[++upperIndex].value = upperValues[axis];
            bounds[upperIndex].proxyId = proxyId;
            bounds[lowerIndex].stabbingCount = lowerIndex == 0 ? 0 : bounds[lowerIndex - 1].stabbingCount;
            bounds[upperIndex].stabbingCount = bounds[upperIndex - 1].stabbingCount;
            for (index = lowerIndex; index < upperIndex; ++index) {
                ++bounds[index].stabbingCount;
            }
            for (index = lowerIndex; index < boundCount + 2; ++index) {
                Proxy proxyn = this.m_proxyPool[bounds[index].proxyId];
                if (bounds[index].isLower()) {
                    proxyn.lowerBounds[axis] = index;
                    continue;
                }
                proxyn.upperBounds[axis] = index;
            }
        }
        ++this.m_proxyCount;
        for (int i = 0; i < this.m_queryResultCount; ++i) {
            this.m_pairManager.addBufferedPair(proxyId, this.m_queryResults[i]);
        }
        this.m_pairManager.commit();
        this.m_queryResultCount = 0;
        this.incrementTimeStamp();
        return proxyId;
    }

    public void destroyProxy(int proxyId) {
        Proxy proxy = this.m_proxyPool[proxyId];
        int boundCount = 2 * this.m_proxyCount;
        for (int axis = 0; axis < 2; ++axis) {
            int index;
            int i;
            Bound[] bounds = this.m_bounds[axis];
            int lowerIndex = proxy.lowerBounds[axis];
            int upperIndex = proxy.upperBounds[axis];
            int lowerValue = bounds[lowerIndex].value;
            int upperValue = bounds[upperIndex].value;
            System.arraycopy(this.m_bounds[axis], lowerIndex + 1, this.m_bounds[axis], lowerIndex, upperIndex - lowerIndex - 1);
            for (i = 0; i < upperIndex - lowerIndex - 1; ++i) {
                this.m_bounds[axis][lowerIndex + i] = new Bound(this.m_bounds[axis][lowerIndex + i]);
            }
            System.arraycopy(this.m_bounds[axis], upperIndex + 1, this.m_bounds[axis], upperIndex - 1, boundCount - upperIndex - 1);
            for (i = 0; i < boundCount - upperIndex - 1; ++i) {
                this.m_bounds[axis][upperIndex - 1 + i] = new Bound(this.m_bounds[axis][upperIndex - 1 + i]);
            }
            for (index = lowerIndex; index < boundCount - 2; ++index) {
                Proxy proxyn = this.m_proxyPool[bounds[index].proxyId];
                if (bounds[index].isLower()) {
                    proxyn.lowerBounds[axis] = index;
                    continue;
                }
                proxyn.upperBounds[axis] = index;
            }
            for (index = lowerIndex; index < upperIndex - 1; ++index) {
                --bounds[index].stabbingCount;
            }
            int[] ignored = new int[2];
            this.query(ignored, lowerValue, upperValue, bounds, boundCount - 2, axis);
        }
        for (int i = 0; i < this.m_queryResultCount; ++i) {
            this.m_pairManager.removeBufferedPair(proxyId, this.m_queryResults[i]);
        }
        this.m_pairManager.commit();
        this.m_queryResultCount = 0;
        this.incrementTimeStamp();
        proxy.userData = null;
        proxy.overlapCount = Integer.MAX_VALUE;
        proxy.lowerBounds[0] = Integer.MAX_VALUE;
        proxy.lowerBounds[1] = Integer.MAX_VALUE;
        proxy.upperBounds[0] = Integer.MAX_VALUE;
        proxy.upperBounds[1] = Integer.MAX_VALUE;
        proxy.setNext(this.m_freeProxy);
        this.m_freeProxy = proxyId;
        --this.m_proxyCount;
    }

    void moveProxy(int proxyId, AABB aabb) {
        int axis;
        if (proxyId == Integer.MAX_VALUE || 256 <= proxyId) {
            return;
        }
        int boundCount = 2 * this.m_proxyCount;
        Proxy proxy = this.m_proxyPool[proxyId];
        BoundValues newValues = new BoundValues();
        this.computeBounds(newValues.lowerValues, newValues.upperValues, aabb);
        BoundValues oldValues = new BoundValues();
        for (axis = 0; axis < 2; ++axis) {
            oldValues.lowerValues[axis] = this.m_bounds[axis][proxy.lowerBounds[axis]].value;
            oldValues.upperValues[axis] = this.m_bounds[axis][proxy.upperBounds[axis]].value;
        }
        for (axis = 0; axis < 2; ++axis) {
            Proxy nextProxy;
            int nextProxyId;
            Bound nextBound;
            Bound tmp;
            Proxy prevProxy;
            int prevProxyId;
            Bound prevBound;
            Bound bound;
            int index;
            Bound[] bounds = this.m_bounds[axis];
            int lowerIndex = proxy.lowerBounds[axis];
            int upperIndex = proxy.upperBounds[axis];
            int lowerValue = newValues.lowerValues[axis];
            int upperValue = newValues.upperValues[axis];
            int deltaLower = lowerValue - bounds[lowerIndex].value;
            int deltaUpper = upperValue - bounds[upperIndex].value;
            bounds[lowerIndex].value = lowerValue;
            bounds[upperIndex].value = upperValue;
            if (deltaLower < 0) {
                for (index = lowerIndex; index > 0 && lowerValue < bounds[index - 1].value; --index) {
                    bound = bounds[index];
                    prevBound = bounds[index - 1];
                    prevProxyId = prevBound.proxyId;
                    prevProxy = this.m_proxyPool[prevBound.proxyId];
                    ++prevBound.stabbingCount;
                    if (prevBound.isUpper()) {
                        if (this.testOverlap(newValues, prevProxy)) {
                            this.m_pairManager.addBufferedPair(proxyId, prevProxyId);
                        }
                        int n = axis;
                        prevProxy.upperBounds[n] = prevProxy.upperBounds[n] + 1;
                        ++bound.stabbingCount;
                    } else {
                        int n = axis;
                        prevProxy.lowerBounds[n] = prevProxy.lowerBounds[n] + 1;
                        --bound.stabbingCount;
                    }
                    int n = axis;
                    proxy.lowerBounds[n] = proxy.lowerBounds[n] - 1;
                    tmp = new Bound(bound);
                    bound.set(prevBound);
                    prevBound.set(tmp);
                }
            }
            if (deltaUpper > 0) {
                for (index = upperIndex; index < boundCount - 1 && bounds[index + 1].value <= upperValue; ++index) {
                    bound = bounds[index];
                    nextBound = bounds[index + 1];
                    nextProxyId = nextBound.proxyId;
                    nextProxy = this.m_proxyPool[nextProxyId];
                    ++nextBound.stabbingCount;
                    if (nextBound.isLower()) {
                        if (this.testOverlap(newValues, nextProxy)) {
                            this.m_pairManager.addBufferedPair(proxyId, nextProxyId);
                        }
                        int n = axis;
                        nextProxy.lowerBounds[n] = nextProxy.lowerBounds[n] - 1;
                        ++bound.stabbingCount;
                    } else {
                        int n = axis;
                        nextProxy.upperBounds[n] = nextProxy.upperBounds[n] - 1;
                        --bound.stabbingCount;
                    }
                    int n = axis;
                    proxy.upperBounds[n] = proxy.upperBounds[n] + 1;
                    tmp = new Bound(bound);
                    bound.set(nextBound);
                    nextBound.set(tmp);
                }
            }
            if (deltaLower > 0) {
                for (index = lowerIndex; index < boundCount - 1 && bounds[index + 1].value <= lowerValue; ++index) {
                    bound = bounds[index];
                    nextBound = bounds[index + 1];
                    nextProxyId = nextBound.proxyId;
                    nextProxy = this.m_proxyPool[nextProxyId];
                    --nextBound.stabbingCount;
                    if (nextBound.isUpper()) {
                        if (this.testOverlap(oldValues, nextProxy)) {
                            this.m_pairManager.removeBufferedPair(proxyId, nextProxyId);
                        }
                        int n = axis;
                        nextProxy.upperBounds[n] = nextProxy.upperBounds[n] - 1;
                        --bound.stabbingCount;
                    } else {
                        int n = axis;
                        nextProxy.lowerBounds[n] = nextProxy.lowerBounds[n] - 1;
                        ++bound.stabbingCount;
                    }
                    int n = axis;
                    proxy.lowerBounds[n] = proxy.lowerBounds[n] + 1;
                    tmp = new Bound(bound);
                    bound.set(nextBound);
                    nextBound.set(tmp);
                }
            }
            if (deltaUpper >= 0) continue;
            for (index = upperIndex; index > 0 && upperValue < bounds[index - 1].value; --index) {
                bound = bounds[index];
                prevBound = bounds[index - 1];
                prevProxyId = prevBound.proxyId;
                prevProxy = this.m_proxyPool[prevProxyId];
                --prevBound.stabbingCount;
                if (prevBound.isLower()) {
                    if (this.testOverlap(oldValues, prevProxy)) {
                        this.m_pairManager.removeBufferedPair(proxyId, prevProxyId);
                    }
                    int n = axis;
                    prevProxy.lowerBounds[n] = prevProxy.lowerBounds[n] + 1;
                    --bound.stabbingCount;
                } else {
                    int n = axis;
                    prevProxy.upperBounds[n] = prevProxy.upperBounds[n] + 1;
                    ++bound.stabbingCount;
                }
                int n = axis;
                proxy.upperBounds[n] = proxy.upperBounds[n] - 1;
                tmp = new Bound(bound);
                bound.set(prevBound);
                prevBound.set(tmp);
            }
        }
    }

    public void commit() {
        this.m_pairManager.commit();
    }

    public Object[] query(AABB aabb, int maxCount) {
        int[] lowerValues = new int[2];
        int[] upperValues = new int[2];
        this.computeBounds(lowerValues, upperValues, aabb);
        int[] indexes = new int[2];
        this.query(indexes, lowerValues[0], upperValues[0], this.m_bounds[0], 2 * this.m_proxyCount, 0);
        this.query(indexes, lowerValues[1], upperValues[1], this.m_bounds[1], 2 * this.m_proxyCount, 1);
        Object[] results = new Object[maxCount];
        int count = 0;
        for (int i = 0; i < this.m_queryResultCount && count < maxCount; ++i, ++count) {
            Proxy proxy = this.m_proxyPool[this.m_queryResults[i]];
            proxy.isValid();
            results[i] = proxy.userData;
        }
        Object[] copy = new Object[count];
        System.arraycopy(results, 0, copy, 0, count);
        this.m_queryResultCount = 0;
        this.incrementTimeStamp();
        return copy;
    }

    public void validate() {
        for (int axis = 0; axis < 2; ++axis) {
            Bound[] bounds = this.m_bounds[axis];
            int boundCount = 2 * this.m_proxyCount;
            int stabbingCount = 0;
            for (int i = 0; i < boundCount; ++i) {
                Bound bound = bounds[i];
                if (bound.isLower()) {
                    ++stabbingCount;
                    continue;
                }
                --stabbingCount;
            }
        }
    }

    private void computeBounds(int[] lowerValues, int[] upperValues, AABB aabb) {
        Vec2 minVertex = MathUtils.clamp(aabb.lowerBound, this.m_worldAABB.lowerBound, this.m_worldAABB.upperBound);
        Vec2 maxVertex = MathUtils.clamp(aabb.upperBound, this.m_worldAABB.lowerBound, this.m_worldAABB.upperBound);
        lowerValues[0] = (int)(this.m_quantizationFactor.x * (minVertex.x - this.m_worldAABB.lowerBound.x)) & 0x7FFFFFFE;
        upperValues[0] = (int)(this.m_quantizationFactor.x * (maxVertex.x - this.m_worldAABB.lowerBound.x)) | 1;
        lowerValues[1] = (int)(this.m_quantizationFactor.y * (minVertex.y - this.m_worldAABB.lowerBound.y)) & 0x7FFFFFFE;
        upperValues[1] = (int)(this.m_quantizationFactor.y * (maxVertex.y - this.m_worldAABB.lowerBound.y)) | 1;
    }

    private void query(int[] results, int lowerValue, int upperValue, Bound[] bounds, int boundCount, int axis) {
        int i;
        int lowerQuery = BroadPhase.binarySearch(bounds, boundCount, lowerValue);
        int upperQuery = BroadPhase.binarySearch(bounds, boundCount, upperValue);
        for (i = lowerQuery; i < upperQuery; ++i) {
            if (!bounds[i].isLower()) continue;
            this.incrementOverlapCount(bounds[i].proxyId);
        }
        if (lowerQuery > 0) {
            i = lowerQuery - 1;
            int s = bounds[i].stabbingCount;
            while (s != 0) {
                if (bounds[i].isLower()) {
                    Proxy proxy = this.m_proxyPool[bounds[i].proxyId];
                    if (lowerQuery <= proxy.upperBounds[axis]) {
                        this.incrementOverlapCount(bounds[i].proxyId);
                        --s;
                    }
                }
                --i;
            }
        }
        results[0] = lowerQuery;
        results[1] = upperQuery;
    }

    private void incrementOverlapCount(int proxyId) {
        Proxy proxy = this.m_proxyPool[proxyId];
        if (proxy.timeStamp < this.m_timeStamp) {
            proxy.timeStamp = this.m_timeStamp;
            proxy.overlapCount = 1;
        } else {
            proxy.overlapCount = 2;
            this.m_queryResults[this.m_queryResultCount] = proxyId;
            ++this.m_queryResultCount;
        }
    }

    private void incrementTimeStamp() {
        if (this.m_timeStamp == Integer.MAX_VALUE) {
            for (int i = 0; i < 256; ++i) {
                this.m_proxyPool[i].timeStamp = 0;
            }
            this.m_timeStamp = 1;
        } else {
            ++this.m_timeStamp;
        }
    }

    static int binarySearch(Bound[] bounds, int count, int value) {
        int low = 0;
        int high = count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            if (bounds[mid].value > value) {
                high = mid - 1;
                continue;
            }
            if (bounds[mid].value < value) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    public boolean inRange(AABB aabb) {
        Vec2 d = Vec2.max(aabb.lowerBound.sub(this.m_worldAABB.upperBound), this.m_worldAABB.lowerBound.sub(aabb.upperBound));
        return Math.max(d.x, d.y) < 0.0f;
    }
}

