/*
 * Decompiled with CFR 0.152.
 */
package examples.billiardberzerk;

import examples.StdPhysicsObject;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.platform.StdGame;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.ContactPoint;
import org.jbox2d.dynamics.contacts.ContactResult;

public class Main
extends StdGame
implements ContactListener {
    World world;
    int stars_this_hit = 0;
    int nr_aliens_this_hit = 0;
    int nr_aliens_this_frame = 0;
    int nr_aliens_last_frame = 0;
    public static final float PXMUL = 20.0f;
    public static final int NRROT = 80;
    static final int r = 1;
    static final int R = 2;
    static final int h = 3;
    static final int H = 4;
    static final int V = 5;
    static final int C = 6;
    int[] lv_fireballs = new int[]{3, 2, 1, 0, 3, 2, 1, 0, 2, 1, 0, 1, 1, 0, 0, 0};
    int[] lv_crates = new int[]{0, 0, 2, 3, 0, 0, 1, 3, 0, 0, 3, 1, 0, 0, 3, 2};
    int[] lv_barrels = new int[]{0, 2, 0, 2, 3, 0, 2, 0, 0, 3, 0, 3, 0, 6, 2, 0};
    int[] lv_wall = new int[]{0, 5, 0, 1, 0, 3, 0, 2, 0, 6, 0, 1, 0, 5, 0, 4};
    String globalMsg = "";
    int globalMsgTime = 0;
    JGFont globalmsg_font = new JGFont("Sans", 0, 30.0);
    int startlevel = 1;

    public static void main(String[] args) {
        new Main(Main.parseSizeArgs(args, 0));
    }

    public Main() {
        this.initEngineApplet();
    }

    public Main(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(30, 40, 16, 16, null, null, null);
    }

    public void initGame() {
        this.setMsgFont(new JGFont("Sans", 0, 23.0));
        this.defineMedia("media.tbl");
        this.setFrameRate(this.isMidlet() ? 15.0 : 25.0, 1.0);
        this.key_startgame = 0;
        if (!this.isAndroid() && !this.isOpenGL()) {
            int i;
            for (i = 0; i < 80; ++i) {
                this.defineImageRotated("crate" + i, "-", 0, "crate", (double)i * 2.0 * Math.PI / 80.0);
            }
            for (i = 0; i < 80; ++i) {
                this.defineImageRotated("barrel" + i, "-", 0, "barrel", (double)i * 2.0 * Math.PI / 80.0);
            }
        }
        this.startgame_ticks = 45;
        this.startgame_ingame = true;
        this.leveldone_ingame = true;
        this.lifelost_ingame = true;
        this.lifelost_ticks = 45;
        this.leveldone_ticks = 50;
        this.gameover_ticks = 45;
        this.status_font = new JGFont("Sans", 0, 23.0);
        this.title_font = new JGFont("Sans", 0, 23.0);
    }

    public void incrementLevel() {
        if (this.level < 16) {
            ++this.level;
        }
        ++this.stage;
    }

    public void defineLevel() {
        int i;
        this.resetHitCounts();
        this.setTileSettings("", 1, 0);
        this.fillBG("");
        this.setBGImage("bg" + this.stage % 7);
        this.world = StdPhysicsObject.createWorld(-100.0f, -100.0f, 200.0f, 200.0f);
        this.world.setContactListener(this);
        StdPhysicsObject.world = this.world;
        StdPhysicsObject.PXMUL = 20.0f;
        StdPhysicsObject.createRect(0.0f, this.pfHeight() + 400, this.pfWidth(), 400.0f, 0.0f, 0.0f);
        StdPhysicsObject.createRect(-400.0f, 0.0f, 400.0f, this.pfHeight() + 400, 0.0f, 0.0f);
        StdPhysicsObject.createRect(0.0f, -400.0f, this.pfWidth(), 400.0f, 0.0f, 0.0f);
        StdPhysicsObject.createRect(this.pfWidth() + 400, 0.0f, 400.0f, this.pfHeight() + 400, 0.0f, 0.0f);
        this.removeObjects(null, 0);
        new Player(32, 32);
        this.fillTileCid(0, 0, 48, 48, 2);
        int stage8 = 8 + this.stage % 8;
        int stagewall = 6 + (this.stage - 6) % 10;
        int thestage = Math.min(stage8, this.stage);
        int thewallstage = Math.min(stagewall, this.stage);
        int nr_fireballs = this.lv_fireballs[thestage];
        int nr_crates = this.lv_crates[thestage];
        int nr_aliens = 4 + (this.isMidlet() ? this.level / 3 : this.level / 2);
        int nr_barrels = this.lv_barrels[thestage];
        int walltype = this.lv_wall[thewallstage];
        for (i = 0; i < nr_fireballs; ++i) {
            new Fireball(this.random(50, 200, 1), this.random(50, 200, 1));
        }
        for (i = 0; i < nr_crates; ++i) {
            new Crate(this.random(80, this.pfWidth() - 50, 1), this.random(80, this.pfHeight() - 50, 1));
        }
        for (i = 0; i < nr_barrels; ++i) {
            new Barrel(this.random(80, this.pfWidth() - 50, 1), this.random(80, this.pfHeight() - 50, 1));
        }
        if (walltype == 5) {
            StdPhysicsObject o = new StdPhysicsObject("crate", 0, (double)(this.pfWidth() / 2), (double)(this.pfHeight() / 2), 0.0, 16.0, 144.0, 0.0, 0.0, 0.0);
            o.setAppearance(null, null, 0.0, 0.0, true, 1, 1);
            this.fillTileCid(this.pfWidth() / 2 - 16, this.pfWidth() / 2 + 16, this.pfHeight() / 2 - 144, this.pfHeight() / 2 + 144, 1);
        }
        if (walltype == 3) {
            StdPhysicsObject o = new StdPhysicsObject("wall", 0, (double)(this.pfWidth() / 2), (double)(this.pfHeight() / 2), 0.0, 128.0, 16.0, 0.0, 0.0, 0.0);
            o.setAppearance(null, null, 0.0, 0.0, true, 1, 1);
            this.fillTileCid(this.pfWidth() / 2 - 128, this.pfWidth() / 2 + 128, this.pfHeight() / 2 - 16, this.pfHeight() / 2 + 16, 1);
        }
        if (walltype == 4) {
            StdPhysicsObject o = new StdPhysicsObject("wall", 0, (double)(this.pfWidth() / 2), (double)(this.pfHeight() / 4), 0.0, 128.0, 16.0, 0.0, 0.0, 0.0);
            o.setAppearance(null, null, 0.0, 0.0, true, 1, 1);
            this.fillTileCid(this.pfWidth() / 2 - 128, this.pfWidth() / 2 + 128, this.pfHeight() / 4 - 16, this.pfHeight() / 4 + 16, 1);
            o = new StdPhysicsObject("wall", 0, (double)(this.pfWidth() / 2), (double)(3 * this.pfHeight() / 4), 0.0, 128.0, 16.0, 0.0, 0.0, 0.0);
            o.setAppearance(null, null, 0.0, 0.0, true, 1, 1);
            this.fillTileCid(this.pfWidth() / 2 - 128, this.pfWidth() / 2 + 128, 3 * this.pfHeight() / 4 - 16, 3 * this.pfHeight() / 4 + 16, 1);
        }
        if (walltype == 1) {
            StdPhysicsObject o = new StdPhysicsObject("wall", 0, (double)(this.pfWidth() / 2), (double)(this.pfHeight() / 2), 0.0, 144.0, 16.0, 3.0, 0.15, 0.8);
            o.createRevoluteJoint(null, this.pfWidth() / 2, this.pfHeight() / 2, true, 1.0f, 6000.0f);
            o.setAppearance(new JGColor(230, 150, 30), null, 0.0, 0.0, true, 1, 1);
            this.fillTileCid(this.pfWidth() / 2 - 144, this.pfWidth() / 2 + 144, this.pfHeight() / 2 - 144, this.pfHeight() / 2 + 144, 2);
        }
        if (walltype == 2) {
            StdPhysicsObject o = new StdPhysicsObject("wall", 0, (double)(this.pfWidth() / 2), (double)(this.pfHeight() / 4), 0.0, 96.0, 16.0, 3.0, 0.15, 0.8);
            o.createRevoluteJoint(null, this.pfWidth() / 2, this.pfHeight() / 4, false, 1.0f, 6000.0f);
            o.setAppearance(new JGColor(230, 150, 30), null, 0.0, 0.0, true, 1, 1);
            this.fillTileCid(this.pfWidth() / 2 - 96, this.pfWidth() / 2 + 96, this.pfHeight() / 4 - 96, this.pfHeight() / 4 + 96, 2);
            o = new StdPhysicsObject("wall", 0, (double)(this.pfWidth() / 2), (double)(3 * this.pfHeight() / 4), 0.0, 96.0, 16.0, 3.0, 0.15, 0.8);
            o.createRevoluteJoint(null, this.pfWidth() / 2, 3 * this.pfHeight() / 4, false, 1.0f, 6000.0f);
            o.setAppearance(new JGColor(230, 150, 30), null, 0.0, 0.0, true, 1, 1);
            this.fillTileCid(this.pfWidth() / 2 - 96, this.pfWidth() / 2 + 96, 3 * this.pfHeight() / 4 - 96, 3 * this.pfHeight() / 4 + 96, 2);
        }
        if (walltype == 6) {
            StdPhysicsObject.createRect(this.pfWidth() / 2, this.pfHeight() / 4, 96.0f, 16.0f, 0.0f, 0.0f);
            this.fillTileCid(this.pfWidth() / 2 - 96, this.pfWidth() / 2 + 96, this.pfHeight() / 4 - 16, this.pfHeight() / 4 + 16, 1);
            StdPhysicsObject.createRect(this.pfWidth() / 2 + 96 + 16, this.pfHeight() / 4 + 64 + 16, 16.0f, 64.0f, 0.0f, 0.0f);
            this.fillTileCid(this.pfWidth() / 2 + 96, this.pfWidth() / 2 + 96 + 16 + 16, this.pfHeight() / 4 + 16, this.pfHeight() / 4 + 16 + 64 + 64, 1);
            StdPhysicsObject.createRect(this.pfWidth() / 2, 3 * this.pfHeight() / 4, 96.0f, 16.0f, 0.0f, 0.0f);
            this.fillTileCid(this.pfWidth() / 2 - 96, this.pfWidth() / 2 + 96, 3 * this.pfHeight() / 4 - 16, 3 * this.pfHeight() / 4 + 16, 1);
            StdPhysicsObject.createRect(this.pfWidth() / 2 - 96 - 16, 3 * this.pfHeight() / 4 - 64 - 16, 16.0f, 64.0f, 0.0f, 0.0f);
            this.fillTileCid(this.pfWidth() / 2 - 96 - 16 - 16, this.pfWidth() / 2 - 96, 3 * this.pfHeight() / 4 - 16 - 64 - 64, 3 * this.pfHeight() / 4 - 16, 1);
        }
        block3: for (int i2 = 0; i2 < nr_aliens; ++i2) {
            for (int t = 0; t < 5; ++t) {
                int ypos;
                int xpos = this.random(80, this.pfWidth() - 50, 1);
                JGRectangle tiler = this.getTiles(new JGRectangle(xpos, ypos = this.random(80, this.pfHeight() - 50, 1), 36, 36));
                if (this.and(this.getTileCid(tiler), 3)) continue;
                new Alien(xpos, ypos, 0.5 + 0.1 * (double)this.level);
                continue block3;
            }
        }
        if (this.stage > 0 && this.stage % 2 == 0) {
            int radius = 70 + 7 * this.level;
            int cenx = this.random(32 + radius, this.pfWidth() - 64 - radius, 1);
            int ceny = this.random(32 + radius, this.pfHeight() - 64 - radius, 1);
            double ang = this.random(0.0, Math.PI * 2);
            new Star((double)cenx + (double)radius * Math.sin(ang), (double)ceny + (double)radius * Math.cos(ang));
            new Star((double)cenx - (double)radius * Math.sin(ang), (double)ceny - (double)radius * Math.cos(ang));
        }
    }

    void fillTileCid(int x1, int x2, int y1, int y2, int cid) {
        JGRectangle tiles = this.getTiles(new JGRectangle(x1, y1, x2 - x1, y2 - y1));
        for (int y = tiles.y; y < tiles.y + tiles.height; ++y) {
            for (int x = tiles.x; x < tiles.x + tiles.width; ++x) {
                if (cid == 1) {
                    this.setTile(x, y, "#");
                    continue;
                }
                this.setTileCid(x, y, cid);
            }
        }
    }

    public void initNewLife() {
        this.removeObjects("player", 0);
        new Player(32, 32);
    }

    public void doFrameInGame() {
        this.nr_aliens_last_frame = this.nr_aliens_this_frame;
        this.nr_aliens_this_frame = 0;
        float timeStep = 0.025f;
        int iterations = 2;
        this.world.step(timeStep, iterations);
        if (this.countObjects("alien", 0) == 0) {
            this.levelDone();
        }
        this.moveObjects(null, 0);
        this.checkCollision(2, 4);
        this.checkCollision(4, 1);
        this.checkCollision(1, 32);
        this.checkCollision(8, 16);
        this.checkBGCollision(1, 4);
        this.moveObjects("_shadow", 0);
    }

    void setGlobalMsg(String msg, int time) {
        this.globalMsg = msg;
        this.globalMsgTime = time;
    }

    public void paintFrameInGame() {
        if (this.globalMsgTime > 0) {
            --this.globalMsgTime;
            if (this.globalMsg != null) {
                this.setColor(JGColor.white);
                this.setFont(this.globalmsg_font);
                this.drawString(this.globalMsg, this.pfWidth() / 2, this.pfHeight() / 2 - 15, 0);
            }
        }
    }

    public void startTitle() {
        this.setBGImage(null);
        this.fillBG("");
        this.removeObjects(null, 0);
    }

    public void doFrameTitle() {
        if (this.getKey(256)) {
            this.clearMouseButton(1);
            this.clearKey(256);
            if (this.getMouseY() > this.pfHeight() / 2 - 100 - 50 && this.getMouseY() < this.pfHeight() / 2 - 100 + 50) {
                this.invokeUrl("http://tmtg.net/", "_blank");
            }
            if (this.getMouseY() > this.pfHeight() / 2 - 50 && this.getMouseY() < this.pfHeight() / 2 + 50) {
                this.startlevel += 4;
                if (this.startlevel >= 16) {
                    this.startlevel = 1;
                }
            }
            if (this.getMouseY() > this.pfHeight() / 2 + 100 - 50 && this.getMouseY() < this.pfHeight() / 2 + 100 + 50) {
                this.startGame(this.startlevel - 1);
            }
        }
        if (this.getKey(this.key_fire)) {
            this.startGame(this.startlevel - 1);
        }
        if (this.getKey(this.key_left)) {
            if (this.startlevel > 0) {
                this.startlevel -= 4;
            }
            this.clearKey(this.key_left);
        }
        if (this.getKey(this.key_right)) {
            if (this.startlevel < 14) {
                this.startlevel += 4;
            }
            this.clearKey(this.key_right);
        }
    }

    public void paintFrameTitle() {
        this.drawImage("splash_image", (double)(this.pfWidth() / 2 - 80), this.pfHeight() / 7);
        this.setFont(new JGFont("Sans", 0, 23.0));
        this.drawString("More games on tmtg.net", this.pfWidth() / 2, this.pfHeight() / 2 - 100, 0);
        this.drawString("Start on level: " + this.startlevel, this.pfWidth() / 2, this.pfHeight() / 2, 0);
        this.drawString("Touch here or", this.pfWidth() / 2, this.pfHeight() / 2 + 85, 0);
        this.drawString("press fire to start", this.pfWidth() / 2, this.pfHeight() / 2 + 115, 0);
        this.setColor(JGColor.orange);
        this.setFont(new JGFont("Sans", 0, 21.0));
        this.drawString("Credits:", this.pfWidth() / 2, this.pfHeight() / 2 + 160, 0);
        this.drawString("Some gfx by: webtreats", this.pfWidth() / 2, this.pfHeight() / 2 + 195, 0);
        this.drawString("Some sounds by:", this.pfWidth() / 2, this.pfHeight() / 2 + 230, 0);
        this.drawString("mwmarsh,justkiddink,bunyi", this.pfWidth() / 2, this.pfHeight() / 2 + 265, 0);
    }

    public void add(ContactPoint point) {
        StdPhysicsObject o1 = (StdPhysicsObject)point.shape1.m_body.m_userData;
        StdPhysicsObject o2 = (StdPhysicsObject)point.shape2.m_body.m_userData;
        int stone = 0;
        int wood = 0;
        if (o1 instanceof Player || o1 instanceof Fireball) {
            ++stone;
        }
        if (o2 instanceof Player || o2 instanceof Fireball) {
            ++stone;
        }
        if (o1 instanceof Crate || o1 instanceof Barrel) {
            ++wood;
        }
        if (o2 instanceof Crate || o2 instanceof Barrel) {
            ++wood;
        }
        if (stone == 2) {
            this.playAudio("ballhit");
        } else if (stone == 1 && wood == 1) {
            this.playAudio("woodhit");
        }
    }

    public void persist(ContactPoint point) {
    }

    public void remove(ContactPoint point) {
    }

    public void result(ContactResult point) {
    }

    public void resetHitCounts() {
        this.stars_this_hit = 0;
        this.nr_aliens_this_hit = 0;
        if (this.countObjects("star", 0) == 1) {
            this.removeObjects("star", 0);
        }
    }

    public void genExplo(double x, double y, int nr, int radius, int time, boolean deadly) {
        for (int i = 0; i < nr; ++i) {
            new Fire(this.random(x - (double)radius, x + (double)radius), this.random(y - (double)radius, y + (double)radius), this.random(0, time, 1), this.random(time / 2, time, 1), deadly);
        }
        this.playAudio("explo");
    }

    class Alien
    extends JGObject {
        double speed;
        double newdirtimer = 0.0;

        Alien(double x, double y, double speed) {
            super("alien", true, x, y, 4, "alien" + Main.this.stage % 8);
            this.speed = speed;
            new AlienShadow(this);
        }

        public void move() {
            if (this.newdirtimer <= 0.0) {
                this.newdirtimer = this.random(15.0, 35.0);
                double ang = this.random(0.0, Math.PI * 2);
                this.setSpeedAbs(this.speed * Math.sin(ang), this.speed * Math.cos(ang));
            } else {
                this.newdirtimer -= gamespeed;
            }
            JGRectangle tiles = this.getTiles();
            int t = tiles.x;
            int l = tiles.y;
            int b = t + tiles.height;
            int r = l + tiles.width;
            int oldxdir = this.xdir;
            int oldydir = this.ydir;
            if (Alien.and(Main.this.getTileCid(t - 1, l), 3)) {
                this.xdir = 1;
            }
            if (Alien.and(Main.this.getTileCid(b + 1, r), 3)) {
                this.xdir = -1;
            }
            if (Alien.and(Main.this.getTileCid(t, l - 1), 3)) {
                this.ydir = 1;
            }
            if (Alien.and(Main.this.getTileCid(b, r + 1), 3)) {
                this.ydir = -1;
            }
            if (Alien.and(Main.this.getTileCid(t - 1, l - 1), 3)) {
                this.xdir = 1;
                this.ydir = 1;
            }
            if (Alien.and(Main.this.getTileCid(b + 1, l - 1), 3)) {
                this.xdir = -1;
                this.ydir = 1;
            }
            if (Alien.and(Main.this.getTileCid(t - 1, r + 1), 3)) {
                this.xdir = 1;
                this.ydir = -1;
            }
            if (Alien.and(Main.this.getTileCid(b + 1, r + 1), 3)) {
                this.xdir = -1;
                this.ydir = -1;
            }
        }

        void die() {
            ++Main.this.nr_aliens_this_hit;
            ++Main.this.nr_aliens_this_frame;
            int nr = Math.max(Main.this.nr_aliens_this_hit, Main.this.nr_aliens_this_frame + Main.this.nr_aliens_last_frame);
            Main.this.score += 10 * nr;
            if (nr == 3) {
                Main.this.score += 100;
                Main.this.setGlobalMsg("3 hits! +100", 60);
            } else if (nr == 5) {
                Main.this.score += 250;
                Main.this.setGlobalMsg("5 hits! +250", 60);
            }
            Main.this.genExplo(this.x + 18.0, this.y + 18.0, 5, 20, 10, false);
            this.remove();
        }

        public void hit(JGObject obj) {
            if (obj instanceof Fire) {
                this.die();
                return;
            }
            StdPhysicsObject o = (StdPhysicsObject)obj;
            Vec2 ospeed = o.getSpeedPixelsPerFrame();
            if (!(o instanceof Fireball) || ospeed.x * ospeed.x + ospeed.y * ospeed.y < 9.0f) {
                double dx = this.x - 18.0 - o.x;
                double dy = this.y - 18.0 - o.y;
                double atan = Main.this.atan2(dx, dy);
                this.x += (double)ospeed.x;
                this.y += (double)ospeed.y;
                this.x += 2.0 * Math.sin(atan);
                this.y += 2.0 * Math.cos(atan);
                if (this.x < 0.0 || this.x > (double)(pfwidth - 36) || this.y < 0.0 || this.y > (double)(pfheight - 36)) {
                    this.die();
                }
            } else {
                this.die();
            }
        }

        public void hit_bg(int tilecid, int tilex, int tiley) {
            this.die();
        }
    }

    class Fire
    extends JGObject {
        double waittime;
        int expires;

        Fire(double xcen, double ycen, int waittime, int expires, boolean deadly) {
            super("fire", true, xcen - 24.0, ycen - 24.0, deadly ? 10 : 8, null);
            this.waittime = waittime;
            this.expires = expires;
        }

        public void move() {
            if (this.waittime >= 0.0) {
                this.waittime -= gamespeed;
                if (this.waittime < 0.0) {
                    this.setGraphic("fire");
                    this.expiry = this.expires;
                }
            }
        }
    }

    class Star
    extends JGObject {
        Star(double x, double y) {
            super("star", true, x, y, 32, "star");
        }

        public void hit(JGObject obj) {
            this.remove();
            ++Main.this.stars_this_hit;
            if (Main.this.stars_this_hit >= 2) {
                ++Main.this.lives;
                Main.this.score += 50;
                Main.this.playAudio("bonus");
            }
        }
    }

    class Barrel
    extends StdPhysicsObject {
        int expires = 0;

        Barrel(int x, int y) {
            super("barrel", 18, (double)x, (double)y, 0.0, 20.0, 3.0, 0.15, 0.5);
            this.setAppearance(null, "barrel", -20.0, -20.0, true, 80, 1);
            new BallShadow(this);
        }

        public void move() {
            super.move();
            this.applyBackgroundFriction(5.0f, 0.99f);
            if (this.expires > 0) {
                if (this.expires % 5 == 0) {
                    new Fire(this.x + this.random(-10.0, 10.0), this.y + this.random(-10.0, 10.0), 0, 15, false);
                }
                if (this.expires == 1) {
                    this.remove();
                    Main.this.genExplo(this.x, this.y, 25, 110, 20, true);
                }
                --this.expires;
            }
        }

        public void hit(JGObject obj) {
            if (this.expires == 0) {
                this.expires = 100;
            }
        }
    }

    class Crate
    extends StdPhysicsObject {
        Crate(int x, int y) {
            super("crate", 2, (double)x, (double)y, 0.0, 40.0, 40.0, 1.5, 0.25, 0.6);
            this.setAppearance(null, "crate", -40.0, -40.0, true, 80, 1);
            new BallShadow(this);
        }

        public void move() {
            super.move();
            this.applyBackgroundFriction(60.0f, 0.965f);
        }
    }

    class Fireball
    extends StdPhysicsObject {
        Fireball(int x, int y) {
            super("fireball", 10, (double)x, (double)y, 0.0, 20.0, 3.0, 0.15, 0.8);
            this.setAppearance(null, "ball2", -22.0, -22.0, false, 1, 1);
            new BallShadow(this);
        }

        public void move() {
            super.move();
            this.applyBackgroundFriction(3.0f, 0.99f);
        }
    }

    class AlienShadow
    extends JGObject {
        JGObject obj;

        AlienShadow(JGObject o) {
            super("_shadow", true, o.x, o.y, 0, "alienshadow");
            this.obj = o;
        }

        public void move() {
            if (!this.obj.isAlive()) {
                this.remove();
            }
            this.x = this.obj.x;
            this.y = this.obj.y;
        }
    }

    class BallShadow
    extends JGObject {
        JGObject obj;

        BallShadow(JGObject o) {
            super("_shadow", true, o.x, o.y, 0, "ballshadow");
            this.obj = o;
        }

        public void move() {
            if (!this.obj.isAlive()) {
                this.remove();
            }
            this.x = this.obj.x - 15.0;
            this.y = this.obj.y - 15.0;
        }
    }

    class Player
    extends StdPhysicsObject {
        int immunity = 20;
        boolean drag = false;
        boolean drag_kb = false;
        int holding = 0;
        boolean holding_inc = false;
        boolean continuous = false;
        boolean continuous_kb = false;
        int startx;
        int starty;
        int dx_kb = 0;
        int dy_kb = 0;

        Player(int x, int y) {
            super("player", 1, (double)x, (double)y, 0.0, 20.0, 3.0, 0.15, 0.8);
            this.setAppearance(null, "ball1", -22.0, -22.0, false, 1, 1);
            new BallShadow(this);
            this.setBBox(-16, -16, 32, 32);
        }

        public void move() {
            super.move();
            --this.immunity;
            this.holding_inc = false;
            this.applyBackgroundFriction(3.0f, 0.99f);
            if (!this.drag) {
                if (Main.this.getMouseButton(1)) {
                    this.drag = true;
                    this.holding = 0;
                    this.continuous = false;
                    this.startx = Main.this.getMouseX();
                    this.starty = Main.this.getMouseY();
                }
            } else {
                int fy;
                int fx = -this.startx + Main.this.getMouseX();
                if (fx * fx + (fy = -this.starty + Main.this.getMouseY()) * fy <= 256) {
                    ++this.holding;
                    this.holding_inc = true;
                    if (this.holding > 9) {
                        this.continuous = true;
                    }
                }
                if (this.continuous) {
                    Main.this.resetHitCounts();
                    this.body.applyForce(new Vec2(100.0f * (float)fx, 100.0f * (float)fy), this.body.getWorldCenter());
                    this.startx = Main.this.getMouseX();
                    this.starty = Main.this.getMouseY();
                    if (!Main.this.getMouseButton(1)) {
                        this.drag = false;
                        this.continuous = false;
                    }
                } else if (!Main.this.getMouseButton(1)) {
                    this.drag = false;
                    Main.this.resetHitCounts();
                    Main.this.playAudio("polehit");
                    this.body.applyForce(new Vec2(80.0f * (float)fx, 80.0f * (float)fy), this.body.getWorldCenter());
                }
            }
            this.continuous_kb = false;
            if (!this.drag_kb) {
                if (Main.this.getKey(Main.this.key_fire)) {
                    this.drag_kb = true;
                    this.dx_kb = 0;
                    this.dy_kb = 0;
                    Main.this.clearKey(Main.this.key_fire);
                }
                if (Main.this.getKey(Main.this.key_up)) {
                    this.continuous_kb = true;
                    Main.this.resetHitCounts();
                    this.body.applyForce(new Vec2(0.0f, -600.0f), this.body.getWorldCenter());
                }
                if (Main.this.getKey(Main.this.key_down)) {
                    this.continuous_kb = true;
                    Main.this.resetHitCounts();
                    this.body.applyForce(new Vec2(0.0f, 600.0f), this.body.getWorldCenter());
                }
                if (Main.this.getKey(Main.this.key_left)) {
                    this.continuous_kb = true;
                    Main.this.resetHitCounts();
                    this.body.applyForce(new Vec2(-600.0f, 0.0f), this.body.getWorldCenter());
                }
                if (Main.this.getKey(Main.this.key_right)) {
                    this.continuous_kb = true;
                    Main.this.resetHitCounts();
                    this.body.applyForce(new Vec2(600.0f, 0.0f), this.body.getWorldCenter());
                }
            } else {
                if (Main.this.getKey(Main.this.key_fire)) {
                    this.drag_kb = false;
                    Main.this.clearKey(Main.this.key_fire);
                    Main.this.resetHitCounts();
                    Main.this.playAudio("polehit");
                    this.body.applyForce(new Vec2(80.0f * (float)this.dx_kb, 80.0f * (float)this.dy_kb), this.body.getWorldCenter());
                }
                if (Main.this.getKey(Main.this.key_up)) {
                    this.dy_kb -= 8;
                }
                if (Main.this.getKey(Main.this.key_down)) {
                    this.dy_kb += 8;
                }
                if (Main.this.getKey(Main.this.key_left)) {
                    this.dx_kb -= 8;
                }
                if (Main.this.getKey(Main.this.key_right)) {
                    this.dx_kb += 8;
                }
            }
        }

        public void hit(JGObject obj) {
            if (this.immunity > 0) {
                obj.remove();
            } else {
                obj.remove();
                Main.this.genExplo(obj.x + 18.0, obj.y + 18.0, 5, 20, 20, false);
                this.remove();
                Main.this.lifeLost();
                Main.this.genExplo(this.x, this.y, 5, 10, 20, false);
            }
        }

        public void paint() {
            super.paint();
            Main.this.setColor(JGColor.white);
            Main.this.setStroke(4.0);
            if (this.drag) {
                if (this.holding_inc && !this.continuous) {
                    Main.this.drawOval(this.x, this.y, 40.0, 40.0, false, true);
                }
                if (!this.continuous) {
                    Main.this.drawLine(this.x, this.y, this.x + (double)Main.this.getMouseX() - (double)this.startx, this.y + (double)Main.this.getMouseY() - (double)this.starty);
                } else {
                    Main.this.drawLine(this.x - 10.0, this.y, this.x + 10.0, this.y);
                    Main.this.drawLine(this.x, this.y - 10.0, this.x, this.y + 10.0);
                }
            } else if (this.drag_kb && !this.continuous) {
                Main.this.drawLine(this.x, this.y, this.x + (double)this.dx_kb, this.y + (double)this.dy_kb);
            }
        }
    }
}

