/*
 * Decompiled with CFR 0.152.
 */
package examples;

import jgame.JGColor;
import jgame.JGObject;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.CircleDef;
import org.jbox2d.collision.PolygonDef;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;

public class StdPhysicsObject
extends JGObject {
    public static float PXMUL = 20.0f;
    public static World world = null;
    public ShapeDef shapedef;
    public BodyDef bodydef;
    public Body body;
    public float mass;
    public float rot;
    public float friction = 0.15f;
    public float restitution = 0.8f;
    public boolean do_rotate = true;
    float width = 0.0f;
    float height = 0.0f;
    float radius = 0.0f;
    String physgraphic = null;
    double graphicxofs;
    double graphicyofs;
    JGColor color = null;
    int nr_rot_levels = 1;
    int spritesymmetry = 1;
    double[] polyx = new double[4];
    double[] polyy = new double[4];

    public static void setWorld(World world) {
        StdPhysicsObject.world = world;
    }

    public static World createWorld(float lowerx, float lowery, float upperx, float uppery) {
        AABB m_worldAABB = new AABB();
        m_worldAABB.lowerBound = new Vec2(lowerx, lowery);
        m_worldAABB.upperBound = new Vec2(upperx, uppery);
        Vec2 gravity = new Vec2(0.0f, 0.0f);
        return new World(m_worldAABB, gravity, true);
    }

    public static Body createRect(float x, float y, float width, float height, float rot, float mass) {
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(width / PXMUL, height / PXMUL);
        sd.density = mass;
        BodyDef bd = new BodyDef();
        bd.position = new Vec2(x / PXMUL, y / PXMUL);
        bd.angle = rot;
        Body ret = world.createBody(bd);
        ret.createShape(sd);
        if (mass != 0.0f) {
            ret.setMassFromShapes();
        }
        return ret;
    }

    public Joint createRevoluteJoint(StdPhysicsObject other, float x, float y, boolean enableMotor, float motorSpeed, float maxMotorTorque) {
        Vec2 cen = new Vec2(x / PXMUL, y / PXMUL);
        RevoluteJointDef jointd = new RevoluteJointDef();
        jointd.enableMotor = enableMotor;
        jointd.motorSpeed = motorSpeed;
        jointd.maxMotorTorque = maxMotorTorque;
        if (other == null) {
            jointd.initialize(this.body, world.getGroundBody(), cen);
        } else {
            jointd.initialize(this.body, other.body, cen);
        }
        return world.createJoint(jointd);
    }

    public StdPhysicsObject(String name, int colid, double x, double y, double rot, double radius, double mass, double friction, double restitution) {
        super(name, true, x, y, colid, null);
        this.rot = (float)rot;
        this.radius = (float)radius;
        this.mass = (float)mass;
        this.friction = (float)friction;
        this.restitution = (float)restitution;
        CircleDef shape = new CircleDef();
        shape.radius = (float)radius / PXMUL;
        this.initObject(shape);
        this.setBBox(-((int)radius), -((int)radius), 2 * (int)radius, 2 * (int)radius);
    }

    public StdPhysicsObject(String name, int colid, double x, double y, double rot, double width, double height, double mass, double friction, double restitution) {
        super(name, true, x, y, colid, null);
        this.rot = (float)rot;
        this.width = (float)width;
        this.height = (float)height;
        this.mass = (float)mass;
        this.friction = (float)friction;
        this.restitution = (float)restitution;
        PolygonDef sd = new PolygonDef();
        sd.setAsBox((float)width / PXMUL, (float)height / PXMUL);
        this.initObject(sd);
        int radius = (int)(1.42 * Math.max(width, height));
        this.setBBox(-radius, -radius, 2 * radius, 2 * radius);
    }

    private void initObject(ShapeDef sd) {
        this.shapedef = sd;
        this.shapedef.density = this.mass;
        this.bodydef = new BodyDef();
        this.shapedef.friction = this.friction;
        this.shapedef.restitution = this.restitution;
        this.bodydef.position = new Vec2((float)this.x / PXMUL, (float)this.y / PXMUL);
        this.bodydef.angle = this.rot;
        this.body = world.createBody(this.bodydef);
        this.body.createShape(this.shapedef);
        this.body.setUserData(this);
        if (this.mass != 0.0f) {
            this.body.setMassFromShapes();
        }
    }

    public void setAppearance(JGColor col, String graphic, double xofs, double yofs, boolean do_rotate, int nr_rot_levels, int spritesymmetry) {
        this.physgraphic = graphic;
        this.color = col;
        this.graphicxofs = xofs;
        this.graphicyofs = yofs;
        this.do_rotate = do_rotate;
        this.nr_rot_levels = nr_rot_levels;
        this.spritesymmetry = spritesymmetry;
    }

    public void applyBackgroundFriction(float linearfriction, float angulardamping) {
        Vec2 v = this.body.getLinearVelocity();
        v.x = -linearfriction * v.x;
        v.y = -linearfriction * v.y;
        this.body.applyForce(v, this.body.getWorldCenter());
        this.body.setAngularVelocity(angulardamping * this.body.getAngularVelocity());
    }

    public Vec2 getSpeedPixelsPerFrame() {
        if (this.getLastX() == 0.0 && this.getLastY() == 0.0) {
            return new Vec2(0.0f, 0.0f);
        }
        return new Vec2((float)(gamespeed * (this.x - this.getLastX())), (float)(gamespeed * (this.y - this.getLastY())));
    }

    public void move() {
        Vec2 position = this.body.getPosition();
        this.rot = -this.body.getAngle();
        this.x = position.x * PXMUL;
        this.y = position.y * PXMUL;
        if (this.body.m_world != world) {
            this.remove();
        }
    }

    public void destroy() {
        if (this.body.m_world == world) {
            world.destroyBody(this.body);
        }
    }

    public void paint() {
        if (this.physgraphic == null && this.color == null) {
            return;
        }
        if (this.radius != 0.0f && this.physgraphic == null) {
            this.eng.setColor(this.color);
            this.eng.drawOval(this.x, this.y, 2.0f * this.radius, 2.0f * this.radius, true, true);
        } else if (this.radius == 0.0f && this.physgraphic == null) {
            this.eng.setColor(this.color);
            float cos = (float)Math.cos(this.do_rotate ? (double)this.rot : 0.0);
            float sin = (float)Math.sin(this.do_rotate ? (double)this.rot : 0.0);
            this.polyx[0] = (int)(this.x - (double)(this.width * cos) - (double)(this.height * sin));
            this.polyy[0] = (int)(this.y + (double)(this.width * sin) - (double)(this.height * cos));
            this.polyx[1] = (int)(this.x + (double)(this.width * cos) - (double)(this.height * sin));
            this.polyy[1] = (int)(this.y - (double)(this.width * sin) - (double)(this.height * cos));
            this.polyx[2] = (int)(this.x + (double)(this.width * cos) + (double)(this.height * sin));
            this.polyy[2] = (int)(this.y - (double)(this.width * sin) + (double)(this.height * cos));
            this.polyx[3] = (int)(this.x - (double)(this.width * cos) + (double)(this.height * sin));
            this.polyy[3] = (int)(this.y + (double)(this.width * sin) + (double)(this.height * cos));
            this.eng.drawPolygon(this.polyx, this.polyy, null, 4, true, true);
        } else if (this.do_rotate && this.nr_rot_levels > 1 && !this.eng.isAndroid() && !this.eng.isOpenGL()) {
            int roti = (int)Math.floor(0.5 - (double)(this.rot * (float)this.nr_rot_levels) / (Math.PI * 2));
            roti += 100000 * this.nr_rot_levels;
            this.eng.drawImage(this.x + 1.42 * this.graphicxofs, this.y + 1.42 * this.graphicyofs, this.physgraphic + (roti %= this.nr_rot_levels / this.spritesymmetry));
        } else {
            this.eng.drawImage(this.x + this.graphicxofs, this.y + this.graphicyofs, this.physgraphic, null, 1.0, this.do_rotate ? (double)this.rot : 0.0, 1.0, true);
        }
    }
}

