/*
 * Decompiled with CFR 0.152.
 */
package tutorial;

import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.JGEngine;

public class Example9
extends JGEngine {
    double zoom = 1.0;
    double rotate = 0.0;
    double[] xpos = new double[5];
    double[] ypos = new double[5];
    double rot = 0.0;

    public static void main(String[] args) {
        new Example9(new JGPoint(640, 480));
    }

    public Example9(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public Example9() {
        this.initEngineApplet();
    }

    public void initCanvas() {
        this.setCanvasSettings(40, 30, 16, 16, null, null, null);
    }

    public void initGame() {
        this.setFrameRate(35.0, 1.0);
        this.setVideoSyncedUpdate(true);
        this.defineImage("neon1", "-", 0, "diamond1.png", "-");
        this.defineImage("neon2", "-", 0, "diamond2.png", "-");
        this.defineImage("neon3", "-", 0, "diamond3.png", "-");
        this.defineImage("bgimage", "-", 0, "twirly-192-rev-trans2.png", "-");
        this.defineImage("bgimage-sm", "-", 0, "twirly-192-trans-sm.png", "-");
        this.defineImage("bgimage-sm2", "-", 0, "twirly-192-trans-smsm.png", "-");
        this.defineImage("bgimage-text", "-", 0, "parallax-illustration.png", "-");
        this.setBGImage("bgimage");
        this.setBGImage(1, "bgimage-text", false, false);
        this.setBGImage(2, "bgimage-sm", true, true);
        this.setBGImage(3, "bgimage-sm2", true, true);
        this.setBGColor(JGColor.yellow);
        for (int i = 0; i < 25; ++i) {
            new NeonObject();
        }
        this.setPFWrap(true, true, -50, -50);
        this.setPFSize(46, 36);
    }

    public void doFrame() {
        this.setViewOffset((int)(200.0 * Math.sin(this.rot)), (int)(200.0 * Math.cos(this.rot)), false);
        this.setBGImgOffset(1, -this.getMouseX(), -this.getMouseY(), false);
        this.setBGImgOffset(2, 200.0 * Math.sin(this.rot) / 2.0, 200.0 * Math.cos(this.rot) / 2.0, false);
        this.setBGImgOffset(3, 200.0 * Math.sin(this.rot) / 4.0, 200.0 * Math.cos(this.rot) / 4.0, false);
        this.moveObjects(null, 0);
        this.rot += this.getGameSpeed() * 0.01;
        if (this.getKey(86)) {
            this.setVideoSyncedUpdate(!this.getVideoSyncedUpdate());
            this.clearKey(86);
        }
        if (this.getKey(27)) {
            this.exitEngine("User exit");
        }
        if (this.getMouseButton(1)) {
            this.zoom += 0.02;
            this.rotate += 0.01;
        } else {
            if (this.zoom > 1.0) {
                this.zoom -= 0.02;
            }
            if (this.zoom < 1.0) {
                this.zoom = 1.0;
            }
            if (this.rotate > 0.0) {
                this.rotate -= 0.01;
            }
            if (this.rotate < 0.0) {
                this.rotate = 0.0;
            }
        }
        this.setViewZoomRotate(this.zoom, this.rotate);
    }

    public void paintFrame() {
        double r;
        this.setColor(JGColor.blue);
        this.setStroke(3.0);
        this.setBlendMode(1, 0);
        this.drawRect((double)(this.viewWidth() / 2), 180.0, 400.0, 150.0, true, true, false, new JGColor[]{JGColor.yellow, JGColor.red, JGColor.magenta, JGColor.blue});
        int i = 0;
        for (r = this.rot; r < this.rot + Math.PI * 2; r += 1.2572653799666351) {
            this.xpos[i] = (double)this.viewWidth() * (0.5 + 0.25 * Math.sin(r));
            this.ypos[i++] = (double)this.viewHeight() * (0.5 + 0.4 * Math.cos(r));
        }
        this.drawPolygon(this.xpos, this.ypos, new JGColor[]{JGColor.blue, JGColor.red, JGColor.magenta, JGColor.cyan, JGColor.yellow}, this.xpos.length, true, false);
        i = 0;
        for (r = -this.rot; r < -this.rot + Math.PI * 2; r += 1.2572653799666351) {
            this.xpos[i] = (double)this.viewWidth() * (0.5 + 0.3 * Math.sin(r));
            this.ypos[i++] = (double)this.viewHeight() * (0.5 + 0.45 * Math.cos(r));
        }
        this.drawPolygon(this.xpos, this.ypos, new JGColor[]{JGColor.blue, JGColor.red, JGColor.magenta, JGColor.cyan, JGColor.yellow}, this.xpos.length, false, false);
        this.setFont(new JGFont("arial", 0, 15.0));
        this.setColor(new JGColor(0.0, 0.2, 0.0, 0.8));
        this.drawString("Back-end used: " + (this.isOpenGL() ? "OpenGL" : "AWT"), this.viewWidth() / 2, 135.0, 0);
        if (this.isOpenGL()) {
            this.drawString("Press 'V' to switch between normal and video synced.", this.viewWidth() / 2, 160.0, 0);
        } else {
            this.drawString("(No video synced mode available in AWT)", this.viewWidth() / 2, 160.0, 0);
        }
        this.setFont(new JGFont("arial", 0, 25.0));
        this.drawString("Video synced now: " + (this.getVideoSyncedUpdate() ? "ON" : "OFF"), this.viewWidth() / 2, 200.0, 0);
    }

    class NeonObject
    extends JGObject {
        int type;
        double rot;
        double rotinc;

        NeonObject() {
            super("neon", true, Example9.this.random(0.0, Example9.this.viewWidth() - 50), Example9.this.random(0.0, Example9.this.viewHeight() - 50), 1, null, Example9.this.random(-2.0, 2.0), Example9.this.random(-2.0, 2.0));
            this.rot = 0.0;
            this.rotinc = this.random(-0.07, 0.07);
            this.type = this.random(1, 3, 1);
        }

        public void move() {
            this.rot += this.rotinc * Example9.this.getGameSpeed();
        }

        public void paint() {
            Example9.this.setBlendMode(1, 0);
            Example9.this.drawImage(this.x, this.y, "neon" + this.type, new JGColor(1.0, 1.0, 1.0), 0.5, this.rot, 1.0 + 0.15 * Math.sin(this.rot * 4.3), true);
        }
    }
}

