/*
 * Decompiled with CFR 0.152.
 */
package jgame.impl;

import java.util.Random;

public class SortedArray {
    int capacity;
    int growspeed;
    public int size = 0;
    public String[] keys;
    public Object[] values;

    public SortedArray(int initialcapacity) {
        this.capacity = initialcapacity;
        this.growspeed = initialcapacity;
        this.keys = new String[this.capacity];
        this.values = new Object[this.capacity];
    }

    public void clear() {
        this.clear(0);
    }

    void clear(int startidx) {
        for (int i = startidx; i < this.size; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = startidx;
    }

    public void put(SortedArray elem) {
        int[] idxes = new int[elem.size];
        int oldsize = this.size;
        int newsize = this.size;
        for (int i = elem.size - 1; i >= 0; --i) {
            int idx = this.get(elem.keys[i]);
            if (idx >= 0) {
                this.keys[idx] = elem.keys[i];
                this.values[idx] = elem.values[i];
                this.size = idx;
            } else {
                this.size = -1 - idx;
                ++newsize;
            }
            idxes[i] = -1 - idx;
        }
        this.size = oldsize;
        if (newsize > this.capacity) {
            this.grow(newsize - oldsize);
        }
        int oldi = oldsize - 1;
        int newi = newsize - 1;
        for (int i = elem.size - 1; i >= 0; --i) {
            if (idxes[i] < 0) continue;
            while (oldi >= idxes[i]) {
                this.keys[newi] = this.keys[oldi];
                this.values[newi--] = this.values[oldi--];
            }
            this.keys[newi] = elem.keys[i];
            this.values[newi--] = elem.values[i];
        }
        this.size = newsize;
    }

    public void put(String key, Object value) {
        int idx = this.get(key);
        if (idx >= 0) {
            this.keys[idx] = key;
            this.values[idx] = value;
            return;
        }
        if (this.size + 1 > this.capacity) {
            this.grow(1);
        }
        ++this.size;
        idx = -1 - idx;
        for (int i = this.size - 1; i > idx; --i) {
            this.keys[i] = this.keys[i - 1];
            this.values[i] = this.values[i - 1];
        }
        this.keys[idx] = key;
        this.values[idx] = value;
    }

    void grow(int amount) {
        this.capacity += amount + this.growspeed;
        String[] newkeys = new String[this.capacity];
        Object[] newvalues = new Object[this.capacity];
        for (int i = 0; i < this.size; ++i) {
            newkeys[i] = this.keys[i];
            newvalues[i] = this.values[i];
        }
        this.keys = newkeys;
        this.values = newvalues;
    }

    public void remove(String key) {
        int idx = this.get(key);
        if (idx >= 0) {
            this.values[idx] = null;
            this.removeNullValues(idx);
        }
    }

    public void remove(SortedArray elem) {
        int lowidx = this.size;
        int oldsize = this.size;
        for (int i = elem.size - 1; i >= 0; --i) {
            int idx = this.get(elem.keys[i]);
            if (idx >= 0) {
                this.values[idx] = null;
                lowidx = idx;
                this.size = idx;
                continue;
            }
            this.size = -1 - idx;
        }
        this.size = oldsize;
        if (lowidx < this.size) {
            this.removeNullValues(lowidx);
        }
    }

    void removeNullValues(int firstidx) {
        for (int i = firstidx; i < this.size; ++i) {
            if (this.values[i] == null) continue;
            this.keys[firstidx] = this.keys[i];
            this.values[firstidx++] = this.values[i];
        }
        this.clear(firstidx);
    }

    public int get(String key) {
        int low = 0;
        int high = this.size - 1;
        int cmp = 0;
        while (low <= high) {
            int mid = (low + high) / 2;
            cmp = this.keys[mid].compareTo(key);
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1 - low;
    }

    public String toString() {
        String res = "SortedArray";
        for (int i = 0; i < this.size; ++i) {
            res = res + "{" + this.keys[i] + "/" + this.values[i] + "},";
        }
        return res;
    }

    void checkSanity() {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != null && this.values[i] != null) continue;
            System.err.println("####### Sanity check failed! ######");
            System.err.println(this.toString());
            throw new Error("Assertion failure!");
        }
    }

    public static void main(String[] args) {
        System.out.println("Testing SortedArray ...");
        String dummyobject = "dummy";
        SortedArray arr_accum = new SortedArray(20);
        Random random = new Random();
        for (int n = 0; n < 1000; ++n) {
            int i;
            SortedArray arr1 = new SortedArray(21);
            SortedArray arr2 = new SortedArray(22);
            for (i = 0; i < 100; ++i) {
                arr2.put("key" + (int)(100.0 + 20.0 * random.nextDouble()), dummyobject);
                arr2.remove("key" + (int)(100.0 + 20.0 * random.nextDouble()));
            }
            for (i = 0; i < 100; ++i) {
                arr1.put("key" + (int)(100.0 + 100.0 * random.nextDouble()), dummyobject);
                arr1.remove("key" + (int)(100.0 + 100.0 * random.nextDouble()));
            }
            arr1.checkSanity();
            arr2.checkSanity();
            arr1.remove(arr2);
            arr1.checkSanity();
            SortedArray arr_added = new SortedArray(23);
            arr_added.put(arr2);
            arr_added.put(arr1);
            arr_added.checkSanity();
            arr_added.remove(arr2);
            arr_added.checkSanity();
            arr_added.remove(arr1);
            arr_added.checkSanity();
            arr_accum.put(arr1);
            arr_accum.remove(arr2);
            arr_accum.checkSanity();
        }
    }
}

