/*
 * Decompiled with CFR 0.152.
 */
package examples.pacmanandzombies;

import examples.StdDungeonMonster;
import examples.StdMazeMonster;
import examples.StdMazePlayer;
import examples.StdScoring;
import examples.StdVirtualKeyboard;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class PacmanAndZombies
extends StdGame {
    Player player = null;
    JGObject ghost_house = null;
    int nr_pills;
    double powerpilltime = 0.0;
    double powerpillmax;
    int powerpillcaught;
    int moantimer = 2000;
    JGObject newpill = null;
    int newpillanimtmr = 0;
    double newzombietime = 10.0;
    int nr_extra_pills_left = 0;
    StdVirtualKeyboard virtkey = null;
    JGColor keyReleasedCol = new JGColor(255, 255, 255, 60);
    JGColor keyPressedCol = new JGColor(255, 255, 255, 135);
    JGFont scorefont = new JGFont("Helvetica", 0, 18.0);
    boolean place_left = true;
    int pacmaneattimer = 0;

    public static void main(String[] args) {
        new PacmanAndZombies(PacmanAndZombies.parseSizeArgs(args, 0));
    }

    public PacmanAndZombies() {
        this.initEngineApplet();
    }

    public PacmanAndZombies(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(19, 15, 32, 32, null, null, null);
        if (this.isMidlet()) {
            this.setScalingPreferences(0.75, 1.3333333333333333, 0, 5, 5, 5);
        }
    }

    public void initGame() {
        if (this.isAndroid()) {
            this.defineMedia("media-android.tbl");
            this.optsAddEnum("controls", "Controls", "", new String[]{"Accelerometer", "Virtual keys", "Swipe"}, 2);
            this.optsAddBoolean("visualise_dir", "Visualise direction", "Show virtual keyboard and accelerometer direction as overlay", true);
        } else {
            this.defineMedia("media.tbl");
        }
        this.setVideoSyncedUpdate(true);
        if (this.isMidlet()) {
            this.setFrameRate(15.0, 4.0);
            this.setGameSpeed(2.0);
        } else if (this.isAndroid()) {
            this.setFrameRate(30.0, 4.0);
            this.virtkey = new StdVirtualKeyboard(this);
            this.virtkey.paintVirtualKeyboardInit(0, 480, 0, 608, 0.82, 0.82, 0.5, 0.5);
        } else {
            this.setFrameRate(40.0, 4.0);
        }
        this.startgame_ticks = 120;
        this.leveldone_ticks = 120;
        this.lifelost_ticks = 300;
        this.gameover_ticks = 160;
        this.startgame_ingame = true;
        this.lifelost_ingame = true;
        this.accel_set_zero_menu = true;
        this.stage = 1;
        this.setTextOutline(1, JGColor.black);
    }

    public void doFrameInGame() {
        if (this.getKey(76)) {
            this.levelDone();
        }
        if (this.virtkey != null) {
            switch (this.storeReadInt("controls", 0)) {
                case 0: {
                    this.virtkey.accelerometerToKeys(this.getAccelZeroCorrected(), 1.0);
                    break;
                }
                case 1: {
                    this.virtkey.handleVirtualKeyboard(-10, 490, -10, 618);
                    break;
                }
                case 2: {
                    this.virtkey.swipeToKeys4Dir(24);
                }
            }
        }
        this.moveObjects();
        this.checkBGCollision(2, 1);
        this.checkBGCollision(4, 1);
        this.checkCollision(6, 1);
        if (this.powerpilltime > 0.0) {
            this.powerpilltime -= this.getGameSpeed();
        }
        if (this.newzombietime > 0.0) {
            this.newzombietime -= this.getGameSpeed();
        } else {
            this.newzombietime = 70.0 - (double)this.level * 5.714285714285714;
            this.newzombietime = this.random(this.newzombietime - 8.0, this.newzombietime + 8.0);
            if (this.countObjects("zombie", 0) < 25 && this.player != null) {
                int ty;
                double dy;
                int tx;
                double dx;
                while ((dx = (double)((tx = this.random(1, 18, 1)) * 32) - this.player.x) * dx + (dy = (double)((ty = this.random(1, 14, 1)) * 32) - this.player.y) * dy < 50176.0 || this.and(this.getTileCid(tx, ty), 9)) {
                }
                this.playAudio("spawn" + this.random(1, 2, 1));
                new Zombie(tx, ty);
            }
        }
        this.moantimer -= this.countObjects("zombie", 0);
        if (this.player != null && this.player.is_dead) {
            this.moantimer -= 20;
        }
        if (this.moantimer < 0) {
            this.playAudio("moan" + this.random(1, 3, 1));
            this.moantimer = this.random(2000, 2300, 1);
        }
    }

    public void paintFrameInGame() {
        if (this.virtkey != null && this.storeReadInt("controls", 0) == 1) {
            this.virtkey.paintVirtualKeyboard(this.keyPressedCol, this.keyReleasedCol);
        }
        if (this.newpillanimtmr > 0) {
            this.newpillanimtmr = (int)((double)this.newpillanimtmr - 2.0 * this.getGameSpeed());
            if (this.seqtimer % 4.0 < 2.0) {
                this.setColor(JGColor.orange);
            } else {
                this.setColor(JGColor.red);
            }
            this.setStroke(3.0);
            this.drawOval(this.newpill.x + 16.0, this.newpill.y + 16.0, 4 * (this.newpillanimtmr + 8), 4 * (this.newpillanimtmr + 8), false, true);
        }
    }

    public void paintFrame() {
        this.setFont(this.scorefont);
        this.drawString("" + this.score, 16.0, 0.0, -1);
        for (int i = 1; i < this.lives; ++i) {
            this.drawImage(this.pfWidth() - 32 - 32 * i, 0.0, "pacman_r2");
        }
    }

    public void startTitle() {
        this.stopAudio("ambient");
        this.fillBG(".");
    }

    public void doFrameTitle() {
        if (this.getMouseButton(1)) {
            this.startGame(0);
        }
    }

    public void paintFrameTitle() {
        this.drawImage(150.0, 40.0, "splash_image");
        this.setFont(new JGFont("Helvetica", 0, 25.0));
        this.setColor(JGColor.white);
        if (!this.isMidlet()) {
            this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " or tap to start", this.pfWidth() / 2, 420.0, 0);
        } else {
            this.drawImageString("STAR TO START", this.pfWidth() / 2, 130.0, 0, "font_map", 32, 2);
            this.drawImageString("POUND TO QUIT", this.pfWidth() / 2, 160.0, 0, "font_map", 32, 2);
        }
        this.drawString("by Boris van Schooten", this.pfWidth() / 2, 260.0, 0);
        this.drawString("Visit tmtg.net for more games", this.pfWidth() / 2, 290.0, 0);
        this.setFont(new JGFont("Helvetica", 0, 14.0));
        this.drawString("Credits:", this.pfWidth() / 2, 360.0, 0);
        this.drawString("Zombie sprite by Tsuyoshi. Zombie sounds by Kathol. Backgrounds by freestockimages.org", this.pfWidth() / 2, 380.0, 0);
    }

    public void paintFrameLifeLost() {
        this.setColor(JGColor.white);
        this.setFont(new JGFont("Helvetica", 0, 30.0));
        int ypos = this.posWalkForwards(-32, this.pfHeight(), this.seqtimer, 300, 75, 10, 160);
        this.drawString("Zombies ate your brain!", this.pfWidth() / 2, ypos, 0);
    }

    public void paintFrameGameOver() {
        this.setColor(JGColor.white);
        this.setFont(new JGFont("Helvetica", 0, 30.0));
        this.drawString("Game Over!", this.pfWidth() / 2, 150.0, 0);
    }

    public void paintFrameLevelDone() {
        this.setColor(JGColor.white);
        this.setFont(new JGFont("Helvetica", 0, 30.0));
        int ypos = this.posWalkForwards(-32, this.pfHeight(), this.seqtimer, 120, 150, 10, 70);
        this.drawString("Level Clear!", this.pfWidth() / 2, ypos, 0);
    }

    public void paintFrameStartLevel() {
        this.setColor(JGColor.white);
        this.setFont(new JGFont("Helvetica", 0, 30.0));
        int ypos = this.posWalkForwards(this.pfHeight() - 8, this.pfHeight() - 8, this.seqtimer, 120, 110, 55, 50);
        this.drawString("Level " + (this.stage + 1), this.pfWidth() / 2, ypos, 0);
    }

    public void paintFrameStartGame() {
        this.setColor(JGColor.white);
        this.setFont(new JGFont("Helvetica", 0, 30.0));
        int ypos = this.posWalkForwards(this.pfHeight() + 24, this.pfHeight() + 24, this.seqtimer, 100, 150, 55, 10);
        this.drawString("Ready!", this.pfWidth() / 2, ypos, 0);
    }

    public void incrementLevel() {
        if (this.level < 7) {
            ++this.level;
        }
        ++this.stage;
    }

    public void startInGame() {
        this.powerpillmax = 300.0;
        this.powerpilltime = 0.0;
        this.removeObjects("zombie", 0);
        this.player = new Player(288.0, 352.0, this.key_up, this.key_down, this.key_left, this.key_right);
        this.stopAudio("ambient");
        this.ghost_house = new JGObject("ghost_house", false, 9 * this.tileWidth(), 5 * this.tileHeight() - 2, 8, null);
        this.ghost_house.setBBox(0, 0, 32, 32);
        for (int i = 0; i < 1; ++i) {
        }
        this.setGameSpeed(1.0);
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void defineLevel() {
        int i;
        int x;
        int y;
        this.nr_extra_pills_left = 4;
        this.setBGImage("bg" + this.stage % 4);
        this.removeObjects(null, 0);
        this.fillBG(".");
        for (y = 0; y < this.pfTilesY(); ++y) {
            for (x = 0; x <= this.pfTilesX() / 2; ++x) {
                if (!this.and(x, 1) && !this.and(y, 1)) {
                    this.setTile(x, y, "#" + this.stage % 5);
                    continue;
                }
                if (x != 0 && x != this.pfTilesX() - 1 && y != 0 && y != this.pfTilesY() - 1) continue;
                this.setTile(x, y, "#" + this.stage % 5);
            }
        }
        for (i = 6; i <= 9; ++i) {
            this.setTileCid(i, 11, 64);
        }
        this.setTileCid(9, 12, 64);
        this.setTileCid(2, 1, 64);
        this.setTileCid(17, 1, 64);
        for (i = 0; i < 6 + this.level; ++i) {
            int wy;
            int wx;
            while (this.and(this.getTileCid(wx = this.random(1, this.pfTilesX() / 2, 1), wy = this.random(1, this.pfTilesY() - 1, 2) + ((wx & 1) != 0 ? 1 : 0)), 101) || wx == 5 && wy == 6 || wx == 5 && wy == 8) {
            }
            this.setTile(wx, wy, "#" + this.stage % 5);
        }
        this.setTile(8, 6, "#" + this.stage % 5);
        this.setTile(9, 6, "#" + this.stage % 5);
        for (y = 0; y < this.pfTilesY(); ++y) {
            for (x = 0; x < this.pfTilesX() / 2; ++x) {
                String tile = this.getTileStr(x, y);
                if (tile.equals(">")) {
                    tile = "<";
                } else if (tile.equals("<")) {
                    tile = ">";
                }
                this.setTile(this.pfTilesX() - 1 - x, y, tile);
            }
        }
        this.floodFillPills(9, 11);
        this.placePowerPill();
        this.placePowerPill();
        this.placePowerPill();
        this.nr_pills = this.countTiles(2);
        int tunnelpos = this.random(5, 9, 2);
        this.setTile(0, tunnelpos, ".");
        this.setTile(18, tunnelpos, ".");
    }

    JGObject placePowerPill() {
        int ty;
        double dy;
        int tx;
        double dx;
        do {
            tx = this.place_left ? this.random(1, 8, 1) : this.random(10, 18, 1);
            ty = this.random(1, 14, 1);
        } while (this.player != null && (dx = (double)(tx * 32) - this.player.x) * dx + (dy = (double)(ty * 32) - this.player.y) * dy < 36864.0 || this.and(this.getTileCid(tx, ty), 1));
        this.place_left = !this.place_left;
        return new JGObject("powerpill", true, tx * this.tileWidth(), ty * this.tileHeight(), 4, "powerpill");
    }

    void floodFillPills(int x, int y) {
        if (this.and(this.getTileCid(x, y), 11)) {
            return;
        }
        if (!this.and(this.getTileCid(x, y), 36)) {
            this.setTile(x, y, "o");
        }
        if (x > 0) {
            this.floodFillPills(x - 1, y);
        }
        if (y > 0) {
            this.floodFillPills(x, y - 1);
        }
        if (x < this.pfTilesX() - 1) {
            this.floodFillPills(x + 1, y);
        }
        if (y < this.pfTilesY() - 1) {
            this.floodFillPills(x, y + 1);
        }
    }

    public class Enemy
    extends StdMazeMonster {
        boolean is_eaten = false;
        boolean is_restored = false;

        public Enemy(double x, double y, int xdir, int ydir, double speed) {
            super("enemy", true, 32.0 * x, 32.0 * y, 2, "enemy_", true, 5, xdir, ydir, speed, null, false, 0.4);
        }

        public void move() {
            if (this.is_eaten) {
                this.avoid = false;
                this.home_in = PacmanAndZombies.this.ghost_house;
                this.gfx_prefix = "enemy_bk_";
                this.block_mask = 1;
                this.random_proportion = 0.25;
            } else {
                this.random_proportion = 0.4;
                this.block_mask = 5;
                if (PacmanAndZombies.this.powerpilltime >= PacmanAndZombies.this.powerpillmax) {
                    this.xdir = -this.xdir;
                    this.ydir = -this.ydir;
                }
                if (PacmanAndZombies.this.powerpilltime > 0.0 && !this.is_restored) {
                    this.home_in = PacmanAndZombies.this.player;
                    this.avoid = true;
                    this.gfx_prefix = PacmanAndZombies.this.powerpilltime < 80.0 && ((int)PacmanAndZombies.this.powerpilltime & 8) != 0 ? "enemy_w_" : "enemy_b_";
                } else if (PacmanAndZombies.this.powerpilltime <= 0.0 || PacmanAndZombies.this.powerpilltime >= PacmanAndZombies.this.powerpillmax) {
                    this.is_restored = false;
                    this.home_in = PacmanAndZombies.this.player;
                    this.avoid = false;
                    this.gfx_prefix = "enemy_";
                } else {
                    this.home_in = PacmanAndZombies.this.player;
                    this.avoid = false;
                    this.gfx_prefix = "enemy_";
                }
            }
            super.move();
        }

        public void hit(JGObject obj) {
            if (!(obj instanceof Player)) {
                if (this.is_eaten) {
                    this.is_eaten = false;
                    this.is_restored = true;
                }
            } else {
                if (PacmanAndZombies.this.powerpilltime > 0.0 && !this.is_eaten && !this.is_restored) {
                    this.is_eaten = true;
                    this.xdir = -this.xdir;
                    this.ydir = -this.ydir;
                    PacmanAndZombies.this.score += 100 * (1 << PacmanAndZombies.this.powerpillcaught);
                    new StdScoring("Scoring", this.x + 8.0, this.y + 4.0, 0.0, 0.0, 80, "" + 100 * (1 << PacmanAndZombies.this.powerpillcaught), new JGFont("Helvetica", 0, 10.0), new JGColor[]{JGColor.white, JGColor.green}, 16);
                    ++PacmanAndZombies.this.powerpillcaught;
                }
                if ((PacmanAndZombies.this.powerpilltime <= 0.0 && !this.is_eaten || this.is_restored) && !((Player)obj).is_dead) {
                    ((Player)obj).is_dead = true;
                    PacmanAndZombies.this.lifeLost();
                }
            }
        }
    }

    public class Player
    extends StdMazePlayer {
        public boolean is_dead = false;

        public Player(double x, double y, int k_u, int k_d, int k_l, int k_r) {
            super("player", x, y, 1, "pacman_", true, true, 1, 5.0, k_u, k_d, k_l, k_r);
        }

        public void move() {
            if (this.is_dead) {
                this.setSpeed(0.0, 0.0);
                this.stopAnim();
                return;
            }
            this.gfx_prefix = PacmanAndZombies.this.powerpilltime > 80.0 ? "pacman_p_" : (PacmanAndZombies.this.powerpilltime > 0.0 ? (PacmanAndZombies.this.powerpilltime % 16.0 < 8.0 ? "pacman_p_" : "pacman_") : "pacman_");
            this.setGraphic(this.gfx_prefix + this.cur_gfx_suffix);
            if (this.x < -16.0) {
                this.x = PacmanAndZombies.this.pfWidth() - 16;
            }
            if (this.x > (double)(PacmanAndZombies.this.pfWidth() - 16)) {
                this.x = -16.0;
            }
            super.move();
        }

        public void hit(JGObject obj) {
            if (obj.colid == 4) {
                obj.remove();
                PacmanAndZombies.this.score += 50;
                if (PacmanAndZombies.this.powerpilltime <= 0.0) {
                    PacmanAndZombies.this.powerpillcaught = 0;
                }
                PacmanAndZombies.this.powerpilltime = PacmanAndZombies.this.powerpillmax + 1.0;
                PacmanAndZombies.this.playAudio("eatpill");
            } else if (obj.colid == 2) {
                if (PacmanAndZombies.this.powerpilltime > 0.0) {
                    PacmanAndZombies.this.score += 1 * (1 << PacmanAndZombies.this.powerpillcaught);
                    new StdScoring("Scoring", this.x + 16.0, this.y + 8.0, 0.0, 0.0, 80, "" + 1 * (1 << PacmanAndZombies.this.powerpillcaught), new JGFont("Helvetica", 0, 20.0), new JGColor[]{JGColor.white, JGColor.green}, 16);
                    if (PacmanAndZombies.this.powerpillcaught == 11 && PacmanAndZombies.this.nr_extra_pills_left > 0) {
                        PacmanAndZombies.this.newpill = PacmanAndZombies.this.placePowerPill();
                        PacmanAndZombies.this.playAudio("newpill");
                        PacmanAndZombies.this.newpillanimtmr = 200;
                        --PacmanAndZombies.this.nr_extra_pills_left;
                    }
                    if (PacmanAndZombies.this.powerpillcaught < 12) {
                        ++PacmanAndZombies.this.powerpillcaught;
                    }
                    obj.remove();
                    JGPoint cen = obj.getCenterTile();
                    String cen_t = PacmanAndZombies.this.getTileStr(cen.x, cen.y);
                    if (cen_t.equals("b1")) {
                        PacmanAndZombies.this.setTile(cen.x, cen.y, "b2");
                    } else if (cen_t.equals("b2")) {
                        PacmanAndZombies.this.setTile(cen.x, cen.y, "b3");
                    } else if (cen_t.equals("c1")) {
                        PacmanAndZombies.this.setTile(cen.x, cen.y, "c2");
                    } else if (cen_t.equals("c2")) {
                        PacmanAndZombies.this.setTile(cen.x, cen.y, "c3");
                    } else if (cen_t.equals(".")) {
                        PacmanAndZombies.this.setTile(cen.x, cen.y, this.random(1, 2, 1) == 1 ? "b1" : "c1");
                    }
                    PacmanAndZombies.this.playAudio("eatzombie");
                } else {
                    PacmanAndZombies.this.playAudio("ambient", "zombieeating", true);
                    if (!this.is_dead) {
                        this.is_dead = true;
                        PacmanAndZombies.this.lifeLost();
                        PacmanAndZombies.this.setGameSpeed(2.0);
                    }
                    String anim = ((StdDungeonMonster)obj).gfx_prefix;
                    anim = anim + ((StdDungeonMonster)obj).cur_gfx_suffix;
                    JGObject zombieeat = new JGObject("zombie_eat", true, obj.x, obj.y, 0, anim, 300);
                    zombieeat.setSpeed((double)obj.xdir * obj.xspeed / 20.0, (double)obj.ydir * obj.yspeed / 20.0);
                    obj.remove();
                }
            }
        }

        public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
            JGPoint cen;
            for (int dy = 0; dy < tysize; ++dy) {
                for (int dx = 0; dx < txsize; ++dx) {
                    if (!Player.and(PacmanAndZombies.this.getTileCid(tx + dx, ty + dy), 2)) continue;
                    PacmanAndZombies.this.setTile(tx + dx, ty + dy, ".");
                    --PacmanAndZombies.this.nr_pills;
                    PacmanAndZombies.this.score += 5;
                    PacmanAndZombies.this.playAudio("pacmaneat" + PacmanAndZombies.this.pacmaneattimer);
                    PacmanAndZombies.this.pacmaneattimer = (PacmanAndZombies.this.pacmaneattimer + 1) % 2;
                }
            }
            if (PacmanAndZombies.this.nr_pills <= 0) {
                PacmanAndZombies.this.levelDone();
            }
            if (Player.and(PacmanAndZombies.this.getTileCid(cen = this.getCenterTile(), 0, 0), 4)) {
                String door = PacmanAndZombies.this.getTileStr(cen, 0, 0);
                if (door.equals("^")) {
                    PacmanAndZombies.this.setTile(cen.x, cen.y, ".");
                    PacmanAndZombies.this.setTile(cen.x, cen.y - 2, ".");
                    PacmanAndZombies.this.setTile(cen.x - 1, cen.y - 1, ">");
                    PacmanAndZombies.this.setTile(cen.x + 1, cen.y - 1, "<");
                } else if (door.equals("v")) {
                    PacmanAndZombies.this.setTile(cen.x, cen.y, ".");
                    PacmanAndZombies.this.setTile(cen.x, cen.y + 2, ".");
                    PacmanAndZombies.this.setTile(cen.x - 1, cen.y + 1, ">");
                    PacmanAndZombies.this.setTile(cen.x + 1, cen.y + 1, "<");
                } else if (door.equals("<")) {
                    PacmanAndZombies.this.setTile(cen.x, cen.y, ".");
                    PacmanAndZombies.this.setTile(cen.x - 2, cen.y, ".");
                    PacmanAndZombies.this.setTile(cen.x - 1, cen.y - 1, "v");
                    PacmanAndZombies.this.setTile(cen.x - 1, cen.y + 1, "^");
                } else if (door.equals(">")) {
                    PacmanAndZombies.this.setTile(cen.x, cen.y, ".");
                    PacmanAndZombies.this.setTile(cen.x + 2, cen.y, ".");
                    PacmanAndZombies.this.setTile(cen.x + 1, cen.y - 1, "v");
                    PacmanAndZombies.this.setTile(cen.x + 1, cen.y + 1, "^");
                }
            }
        }

        public void paint() {
            double[] ci = null;
            if (PacmanAndZombies.this.virtkey != null) {
                ci = PacmanAndZombies.this.virtkey.getCompassInfo();
            }
            if (ci != null) {
                PacmanAndZombies.this.setColor(new JGColor(255, 255, 255, 128));
                PacmanAndZombies.this.drawOval(12.0 + this.x + ci[0] * 20.0, 12.0 + this.y + ci[1] * 20.0, 24.0, 24.0, true, true);
            }
        }
    }

    public class Zombie
    extends JGObject {
        public Zombie(int tx, int ty) {
            super("appear", true, tx * 32, ty * 32, 0, "zombie_appear", 24);
        }

        public void move() {
            if ((int)this.expiry == 1) {
                new StdDungeonMonster("zombie", true, this.x, this.y, 2, "zombie_", true, false, 9, 8, 0.5 + 0.75 * (double)PacmanAndZombies.this.level / 7.0, PacmanAndZombies.this.player, false, 0.0);
            }
        }
    }
}

