/*
 * Decompiled with CFR 0.152.
 */
package examples;

import jgame.JGColor;
import jgame.impl.JGameError;
import jgame.platform.JGEngine;

public class StdVirtualKeyboard {
    protected boolean show_compass = false;
    protected double compassx = 0.0;
    protected double compassy = 0.0;
    public int KeyUp = 38;
    public int KeyDown = 40;
    public int KeyLeft = 37;
    public int KeyRight = 39;
    public double relativethreshold = 0.3;
    protected boolean[] keyset = new boolean[259];
    protected JGEngine eng;
    protected double xdist = 0.0;
    protected double ydist = 0.0;
    protected double[][][] keycoords = null;
    public int mposstationaryreset = 1;
    protected boolean was_pressed = false;
    protected boolean stop_when_no_motion = true;
    protected int dir_was_set = 0;
    protected int mxstart = 0;
    protected int mystart = 0;
    protected int prevdx = 0;
    protected int prevdy = 0;
    protected int mposstationary = 0;

    public double[] getCompassInfo() {
        if (!this.show_compass) {
            return null;
        }
        return new double[]{this.compassx, this.compassy};
    }

    public StdVirtualKeyboard(JGEngine eng) {
        this.eng = eng;
    }

    private boolean getKey(int keycode) {
        return this.eng.getKey(keycode);
    }

    private void setKey(int keycode) {
        this.eng.setKey(keycode);
        this.keyset[keycode] = true;
    }

    private void clearKey(int keycode) {
        if (!this.keyset[keycode]) {
            return;
        }
        this.eng.clearKey(keycode);
        this.keyset[keycode] = false;
    }

    public void clearKeys() {
        this.clearKey(this.KeyUp);
        this.clearKey(this.KeyDown);
        this.clearKey(this.KeyLeft);
        this.clearKey(this.KeyRight);
    }

    public void accelerometerToKeys(double[] accel, double threshold) {
        this.xdist = 0.5 * this.xdist + 0.5 * accel[0];
        this.ydist = 0.5 * this.ydist + 0.5 * accel[1];
        this.show_compass = true;
        this.compassx = this.xdist;
        this.compassy = this.ydist;
        boolean xlarger = Math.abs(this.xdist) > Math.abs(this.ydist);
        double relxy = Math.abs(xlarger ? this.ydist / this.xdist : this.xdist / this.ydist);
        this.clearKeys();
        if (this.xdist > threshold && (xlarger || relxy > this.relativethreshold)) {
            this.setKey(this.KeyRight);
            this.keyset[this.KeyRight] = true;
        } else if (this.xdist < -threshold && (xlarger || relxy > this.relativethreshold)) {
            this.setKey(this.KeyLeft);
        }
        if (this.ydist > threshold && (!xlarger || relxy > this.relativethreshold)) {
            this.setKey(this.KeyDown);
        } else if (this.ydist < -threshold && (!xlarger || relxy > this.relativethreshold)) {
            this.setKey(this.KeyUp);
        }
    }

    public void handleVirtualKeyboard(int top, int bottom, int left, int right) {
        this.show_compass = false;
        if (this.eng.getMouseButton(1)) {
            int x = this.eng.getMouseX();
            int y = this.eng.getMouseY();
            if (x >= left && x < right && y >= top && y < bottom) {
                double xr = (double)(x - left) / ((double)right - (double)left);
                double yr = (double)(y - top) / ((double)bottom - (double)top);
                if (xr < yr) {
                    if (xr > 1.0 - yr) {
                        this.clearKeys();
                        this.setKey(this.KeyDown);
                    } else {
                        this.clearKeys();
                        this.setKey(this.KeyLeft);
                    }
                } else if (xr > 1.0 - yr) {
                    this.clearKeys();
                    this.setKey(this.KeyRight);
                } else {
                    this.clearKeys();
                    this.setKey(this.KeyUp);
                }
            }
        } else {
            this.clearKeys();
        }
    }

    public void paintVirtualKeyboardInit(int top, int bottom, int left, int right, double xgap, double ygap, double cxmargin, double cymargin) {
        this.keycoords = new double[4][2][3];
        double centerx = (double)(left + right) / 2.0;
        double centery = (double)(top + bottom) / 2.0;
        double xscale = right - left;
        double yscale = bottom - top;
        this.keycoords[0][0][0] = (double)left + xscale * 0.5 * cxmargin;
        this.keycoords[0][1][0] = top;
        this.keycoords[0][0][1] = (double)right - xscale * 0.5 * cxmargin;
        this.keycoords[0][1][1] = top;
        this.keycoords[0][0][2] = centerx;
        this.keycoords[0][1][2] = centery - yscale * 0.5 * ygap;
        this.keycoords[1][0][0] = (double)left + xscale * 0.5 * cxmargin;
        this.keycoords[1][1][0] = bottom;
        this.keycoords[1][0][1] = (double)right - xscale * 0.5 * cxmargin;
        this.keycoords[1][1][1] = bottom;
        this.keycoords[1][0][2] = centerx;
        this.keycoords[1][1][2] = centery + yscale * 0.5 * ygap;
        this.keycoords[2][0][0] = left;
        this.keycoords[2][1][0] = (double)top + yscale * 0.5 * cymargin;
        this.keycoords[2][0][1] = left;
        this.keycoords[2][1][1] = (double)bottom - yscale * 0.5 * cymargin;
        this.keycoords[2][0][2] = centerx - xscale * 0.5 * xgap;
        this.keycoords[2][1][2] = centery;
        this.keycoords[3][0][0] = right;
        this.keycoords[3][1][0] = (double)top + yscale * 0.5 * cymargin;
        this.keycoords[3][0][1] = right;
        this.keycoords[3][1][1] = (double)bottom - yscale * 0.5 * cymargin;
        this.keycoords[3][0][2] = centerx + xscale * 0.5 * xgap;
        this.keycoords[3][1][2] = centery;
    }

    public void paintVirtualKeyboard(JGColor colorPressed, JGColor colorReleased) {
        if (this.keycoords == null) {
            throw new JGameError("Call paintVirtualKeyboardInit() first!");
        }
        for (int i = 0; i < 4; ++i) {
            boolean dirPressed = false;
            if (this.getKey(this.KeyUp) && i == 0) {
                dirPressed = true;
            }
            if (this.getKey(this.KeyDown) && i == 1) {
                dirPressed = true;
            }
            if (this.getKey(this.KeyLeft) && i == 2) {
                dirPressed = true;
            }
            if (this.getKey(this.KeyRight) && i == 3) {
                dirPressed = true;
            }
            this.eng.setColor(dirPressed ? colorPressed : colorReleased);
            this.eng.drawPolygon(this.keycoords[i][0], this.keycoords[i][1], null, 3, true, false);
        }
    }

    public void swipeToKeys4Dir(int threshold) {
        this.show_compass = false;
        if (this.eng.getMouseButton(1)) {
            if (!this.was_pressed) {
                this.was_pressed = true;
                this.dir_was_set = 0;
                this.mxstart = this.eng.getMouseX();
                this.mystart = this.eng.getMouseY();
                if (this.stop_when_no_motion) {
                    this.clearKeys();
                }
            } else {
                int dx = this.eng.getMouseX() - this.mxstart;
                int dy = this.eng.getMouseY() - this.mystart;
                if (Math.abs(dx - this.prevdx) + Math.abs(dy - this.prevdy) < 3) {
                    ++this.mposstationary;
                    if (this.mposstationary >= this.mposstationaryreset) {
                        this.was_pressed = false;
                        this.stop_when_no_motion = false;
                    }
                } else {
                    this.mposstationary = 0;
                }
                this.prevdx = dx;
                this.prevdy = dy;
                if ((this.dir_was_set == 0 || this.dir_was_set == 4) && dx > threshold && dx > dy) {
                    this.clearKeys();
                    this.setKey(this.KeyRight);
                    this.mxstart += dx;
                    this.mystart += dy;
                    this.dir_was_set = 2;
                } else if ((this.dir_was_set == 0 || this.dir_was_set == 2) && dx < -threshold && dx < dy) {
                    this.clearKeys();
                    this.setKey(this.KeyLeft);
                    this.mxstart += dx;
                    this.mystart += dy;
                    this.dir_was_set = 4;
                } else if ((this.dir_was_set == 0 || this.dir_was_set == 1) && dy > threshold && dy > dx) {
                    this.clearKeys();
                    this.setKey(this.KeyDown);
                    this.mxstart += dx;
                    this.mystart += dy;
                    this.dir_was_set = 3;
                } else if ((this.dir_was_set == 0 || this.dir_was_set == 3) && dy < -threshold && dy < dx) {
                    this.clearKeys();
                    this.setKey(this.KeyUp);
                    this.mxstart += dx;
                    this.mystart += dy;
                    this.dir_was_set = 1;
                }
            }
        } else {
            this.was_pressed = false;
            this.stop_when_no_motion = true;
        }
    }
}

