/*
 * Decompiled with CFR 0.152.
 */
package examples;

import jgame.JGObject;
import jgame.JGPoint;

public class StdMazeMonster
extends JGObject {
    public String gfx_prefix = null;
    public int block_mask;
    public double speed;
    public JGObject home_in;
    public boolean avoid;
    public double random_proportion;
    int newxdir;
    int newydir;
    JGPoint cen;

    public StdMazeMonster(String name, boolean unique_id, double x, double y, int cid, String graphic, boolean is_directional, int block_mask, int xdir, int ydir, double speed, JGObject home_in, boolean avoid, double random_proportion) {
        super(name, unique_id, x, y, cid, null);
        this.setDirSpeed(xdir, ydir, speed);
        this.snapToGrid(this.eng.tileWidth(), this.eng.tileHeight());
        this.setTileBBox(0, 0, this.eng.tileWidth(), this.eng.tileHeight());
        if (is_directional) {
            this.gfx_prefix = graphic;
        }
        this.block_mask = block_mask;
        this.speed = speed;
        this.home_in = home_in;
        this.avoid = avoid;
        this.random_proportion = random_proportion;
    }

    public void move() {
        this.cen = this.getCenterTile();
        double gamespeed = this.eng.getGameSpeed();
        if (this.isXAligned(this.xspeed * gamespeed / 1.1) && this.isYAligned(this.yspeed * gamespeed / 1.1)) {
            this.snapToGrid(this.xspeed * gamespeed / 1.1, this.yspeed * gamespeed / 1.1);
            if (this.home_in == null || this.eng.random(0.0, 0.9999) < this.random_proportion) {
                this.chooseRandomDir();
            } else {
                int basedir;
                int n = basedir = this.avoid ? -1 : 1;
                if (!this.avoid) {
                    if (Math.abs(this.x - this.home_in.x) > Math.abs(this.y - this.home_in.y)) {
                        this.newxdir = this.x > this.home_in.x ? -basedir : basedir;
                        this.newydir = 0;
                    } else {
                        this.newxdir = 0;
                        this.newydir = this.y > this.home_in.y ? -basedir : basedir;
                    }
                } else if (Math.abs(this.x - this.home_in.x) < Math.abs(this.y - this.home_in.y)) {
                    this.newxdir = this.x > this.home_in.x ? -basedir : basedir;
                    this.newydir = 0;
                } else {
                    this.newxdir = 0;
                    if (Math.abs(this.y - this.home_in.y) < 1.0) {
                        this.newydir = this.eng.random(-1, 1, 2);
                    } else {
                        int n2 = this.newydir = this.y > this.home_in.y ? -basedir : basedir;
                    }
                }
                if (StdMazeMonster.and(this.eng.getTileCid(this.cen, this.newxdir, this.newydir), this.block_mask) || this.newxdir == -this.xdir && this.newydir == -this.ydir) {
                    if (this.newxdir != 0) {
                        this.newxdir = 0;
                        this.newydir = this.y > this.home_in.y ? -basedir : basedir;
                    } else {
                        this.newxdir = this.x > this.home_in.x ? -basedir : basedir;
                        this.newydir = 0;
                    }
                }
            }
            if (this.newxdir == -this.xdir && this.newydir == -this.ydir) {
                this.newxdir = this.xdir;
                this.newydir = this.ydir;
            }
            if (StdMazeMonster.and(this.eng.getTileCid(this.cen, this.newxdir, this.newydir), this.block_mask)) {
                this.chooseRandomDir();
            }
            this.setDir(this.newxdir, this.newydir);
        }
        if (this.gfx_prefix != null) {
            if (this.xdir == 1) {
                this.setGraphic(this.gfx_prefix + "r");
            } else if (this.xdir == -1) {
                this.setGraphic(this.gfx_prefix + "l");
            } else if (this.ydir == 1) {
                this.setGraphic(this.gfx_prefix + "d");
            } else if (this.ydir == -1) {
                this.setGraphic(this.gfx_prefix + "u");
            }
        }
    }

    private void chooseRandomDir() {
        this.newxdir = -this.xdir;
        this.newydir = -this.ydir;
        int rot_dir = this.eng.random(-1, 1, 2);
        for (int i = 0; i < 4; ++i) {
            int newxdir_t = rot_dir * this.newydir;
            this.newydir = -rot_dir * this.newxdir;
            this.newxdir = newxdir_t;
            if (StdMazeMonster.and(this.eng.getTileCid(this.cen, this.newxdir, this.newydir), this.block_mask)) continue;
            return;
        }
        this.newxdir = 0;
        this.newydir = 0;
    }
}

