/*
 * Decompiled with CFR 0.152.
 */
package examples;

import jgame.JGObject;
import jgame.JGPoint;

public class StdDungeonMonster
extends JGObject {
    public String gfx_prefix = null;
    public String cur_gfx_suffix = "";
    public boolean continuous_anim = true;
    public int block_mask = 0;
    public int occupy_mask;
    public JGObject home_in = null;
    public boolean avoid = false;
    public double random_proportion;
    JGPoint occupied = null;

    public StdDungeonMonster(String name, boolean unique_id, double x, double y, int cid, String graphic, boolean is_directional, boolean continuous_anim, int block_mask, int occupy_mask, double speed, JGObject home_in, boolean avoid, double random_proportion) {
        super(name, unique_id, x, y, cid, graphic);
        this.setTileBBox(0, 0, this.eng.tileWidth(), this.eng.tileHeight());
        this.setDirSpeed(0, 0, speed);
        if (is_directional) {
            this.gfx_prefix = graphic;
        }
        this.continuous_anim = continuous_anim;
        this.block_mask = block_mask;
        this.occupy_mask = occupy_mask;
        this.home_in = home_in;
        this.avoid = avoid;
        this.random_proportion = random_proportion;
    }

    public StdDungeonMonster(String name, boolean unique_id, double x, double y, int cid, String graphic, int occupy_mask) {
        super(name, unique_id, x, y, cid, graphic);
        this.setTileBBox(0, 0, this.eng.tileWidth(), this.eng.tileHeight());
        this.setDirSpeed(0, 0, 0.0);
        this.occupy_mask = occupy_mask;
    }

    public void move() {
        if (this.occupied == null || this.xspeed == 0.0 && this.yspeed == 0.0 || this.xdir == 0 && this.ydir == 0 && (!this.isXAligned() || !this.isYAligned())) {
            if (this.occupied != null) {
                this.eng.andTileCid(this.occupied.x, this.occupied.y, ~this.occupy_mask);
            }
            this.snapToGrid(this.eng.tileWidth(), this.eng.tileHeight());
            this.occupied = this.getCenterTile();
            this.eng.orTileCid(this.occupied.x, this.occupied.y, this.occupy_mask);
        } else if (!this.isXAligned() || !this.isYAligned()) {
            if (!this.continuous_anim) {
                this.startAnim();
            }
        } else {
            int prevxdir = this.xdir;
            int prevydir = this.ydir;
            this.snapToGrid();
            JGPoint cen = this.getCenterTile();
            this.setDir(0, 0);
            int newxdir = 0;
            int newydir = 0;
            boolean xdir_any = false;
            boolean ydir_any = false;
            if (this.home_in != null && this.eng.random(1.0E-4, 0.9999) > this.random_proportion) {
                int basedir;
                int n = basedir = this.avoid ? -1 : 1;
                if (this.home_in.x < this.x) {
                    newxdir = -basedir;
                }
                if (this.home_in.x > this.x) {
                    newxdir = basedir;
                }
                if (this.home_in.y < this.y) {
                    newydir = -basedir;
                }
                if (this.home_in.y > this.y) {
                    newydir = basedir;
                }
                if (Math.abs(this.home_in.x - this.x) > Math.abs(this.home_in.y - this.y)) {
                    ydir_any = true;
                } else {
                    xdir_any = true;
                }
            } else {
                newxdir = this.eng.random(-1, 1, 1);
                newydir = this.eng.random(-1, 1, 1);
                xdir_any = true;
                ydir_any = true;
            }
            this.xdir = newxdir;
            this.ydir = newydir;
            StdDungeonMonster.checkIfBlocked(this, this.block_mask, prevxdir, prevydir);
            if (this.xdir == 0 && this.ydir == 0) {
                if (xdir_any) {
                    this.xdir = newxdir != 0 ? -newxdir : this.eng.random(-1, 1, 2);
                    this.ydir = newydir;
                    StdDungeonMonster.checkIfBlocked(this, this.block_mask, prevxdir, prevydir);
                } else if (ydir_any) {
                    this.xdir = newxdir;
                    this.ydir = newydir != 0 ? -newydir : this.eng.random(-1, 1, 2);
                    StdDungeonMonster.checkIfBlocked(this, this.block_mask, prevxdir, prevydir);
                }
            }
            if (this.occupied != null) {
                this.eng.andTileCid(this.occupied.x, this.occupied.y, ~this.occupy_mask);
            }
            this.occupied = new JGPoint(cen.x + this.xdir, cen.y + this.ydir);
            this.eng.orTileCid(this.occupied.x, this.occupied.y, this.occupy_mask);
            if (!this.continuous_anim) {
                if (this.xdir != 0 || this.ydir != 0) {
                    this.startAnim();
                } else {
                    this.stopAnim();
                }
            }
            if (this.gfx_prefix != null) {
                if (this.ydir < 0 && this.xdir < 0) {
                    this.cur_gfx_suffix = "ul";
                }
                if (this.ydir < 0 && this.xdir == 0) {
                    this.cur_gfx_suffix = "u";
                }
                if (this.ydir < 0 && this.xdir > 0) {
                    this.cur_gfx_suffix = "ur";
                }
                if (this.ydir == 0 && this.xdir < 0) {
                    this.cur_gfx_suffix = "l";
                }
                if (this.ydir == 0 && this.xdir > 0) {
                    this.cur_gfx_suffix = "r";
                }
                if (this.ydir > 0 && this.xdir < 0) {
                    this.cur_gfx_suffix = "dl";
                }
                if (this.ydir > 0 && this.xdir == 0) {
                    this.cur_gfx_suffix = "d";
                }
                if (this.ydir > 0 && this.xdir > 0) {
                    this.cur_gfx_suffix = "dr";
                }
                this.setGraphic(this.gfx_prefix + this.cur_gfx_suffix);
            }
        }
    }

    public void destroy() {
        if (this.occupied != null) {
            this.eng.andTileCid(this.occupied.x, this.occupied.y, ~this.occupy_mask);
        }
    }

    public static void checkIfBlocked(JGObject o, int block_mask, int prevxdir, int prevydir) {
        boolean can_go_v;
        JGPoint cen = o.getCenterTile();
        boolean can_go_h = !StdDungeonMonster.and(o.eng.getTileCid(cen, o.xdir, 0), block_mask);
        boolean bl = can_go_v = !StdDungeonMonster.and(o.eng.getTileCid(cen, 0, o.ydir), block_mask);
        if (o.xdir != 0 && o.ydir != 0 && StdDungeonMonster.and(o.eng.getTileCid(cen, o.xdir, o.ydir), block_mask)) {
            if (can_go_h && can_go_v) {
                if (prevxdir != 0) {
                    o.xdir = 0;
                } else if (prevydir != 0) {
                    o.ydir = 0;
                } else {
                    o.xdir = 0;
                }
            } else if (can_go_h) {
                o.ydir = 0;
            } else if (can_go_v) {
                o.xdir = 0;
            } else {
                o.xdir = 0;
                o.ydir = 0;
            }
        }
        if (o.xdir != 0 && !can_go_h) {
            o.xdir = 0;
        }
        if (o.ydir != 0 && !can_go_v) {
            o.ydir = 0;
        }
    }
}

