/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jgame.impl.JGameError;
import jgame.platform.JGEngine;

public class AppConfig {
    Vector fields = new Vector(20, 50);
    Hashtable fieldtypes = new Hashtable();
    Hashtable fieldguinames = new Hashtable();
    Hashtable fieldcomponents = new Hashtable();
    Hashtable fieldvalues = new Hashtable();
    Object obj = null;
    Class cls = null;
    String filename = null;
    String title;
    Object gui_lock = new Object();
    boolean gui_open = false;
    ActionListener listener = null;
    Font mainfont = new Font("Helvetica", 0, 16);
    Font bigfont = new Font("Helvetica", 1, 20);
    Color textcolor = new Color(0, 0, 100);
    Color bgcolor = new Color(180, 180, 255);
    Color hltcolor = new Color(230, 230, 255);
    Border border = BorderFactory.createEtchedBorder(this.hltcolor, this.textcolor);
    JPanel mainpanel = new JPanel();
    JPanel butpanel = new JPanel();
    JPanel toppanel = new JPanel();
    JButton save_but = new JButton("Save");
    JButton apply_but = new JButton("Apply");
    JButton cancel_but = new JButton("Close");
    JFrame topframe = new JFrame("Application Config");
    JScrollPane scrollpane = null;
    static /* synthetic */ Class class$java$awt$Point;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public String toString() {
        return this.title;
    }

    public void setGuiSettings(Font mainfont, Font bigfont, Color textcolor, Color bgcolor, Color hltcolor) {
        this.mainfont = mainfont;
        this.bigfont = bigfont;
        this.textcolor = textcolor;
        this.bgcolor = bgcolor;
        this.hltcolor = hltcolor;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Please supply filename of config to edit.");
        }
        AppConfig appconf = new AppConfig(args[0], args[0]);
        appconf.loadFromFile();
        appconf.openGui();
        appconf.waitUntilGuiClosed();
        System.exit(0);
    }

    public Object getObject() {
        return this.obj;
    }

    public void setObject(Object obj) {
        this.obj = obj;
        this.cls = obj.getClass();
    }

    public Class getObjectClass() {
        return this.cls;
    }

    public String getFilename() {
        return this.filename;
    }

    public AppConfig(String title, String filename) {
        this.title = title;
        this.filename = filename;
        this.initGui();
    }

    public AppConfig(String title, Object obj, String filename) {
        this.title = title;
        this.filename = filename;
        this.obj = obj;
        this.cls = obj.getClass();
        this.initGui();
    }

    public AppConfig(String title, Class cls, String filename) {
        this.title = title;
        this.filename = filename;
        this.cls = cls;
        this.initGui();
    }

    public AppConfig(String title, Object obj) {
        this.title = title;
        this.obj = obj;
        this.cls = obj.getClass();
        this.initGui();
    }

    public AppConfig(String title, Class cls) {
        this.title = title;
        this.cls = cls;
        this.initGui();
    }

    void initGui() {
        this.mainpanel.setBackground(this.bgcolor);
        this.butpanel.setBackground(this.bgcolor);
        this.toppanel.setBackground(this.bgcolor);
        this.save_but.setBackground(this.bgcolor);
        this.save_but.setForeground(this.textcolor);
        this.save_but.setFont(this.bigfont);
        this.apply_but.setBackground(this.bgcolor);
        this.apply_but.setForeground(this.textcolor);
        this.apply_but.setFont(this.bigfont);
        this.cancel_but.setBackground(this.bgcolor);
        this.cancel_but.setForeground(this.textcolor);
        this.cancel_but.setFont(this.bigfont);
        this.mainpanel.setLayout(new BoxLayout(this.mainpanel, 1));
        if (this.filename != null) {
            this.butpanel.add(this.save_but);
            this.save_but.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AppConfig.this.saveToFile();
                    if (AppConfig.this.cls != null) {
                        AppConfig.this.saveToObject();
                    }
                    AppConfig.this.topframe.setVisible(false);
                    AppConfig.this.signalCloseGui();
                }
            });
        }
        if (this.cls != null) {
            this.butpanel.add(this.apply_but);
            this.apply_but.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AppConfig.this.saveToObject();
                    AppConfig.this.topframe.setVisible(false);
                    AppConfig.this.signalCloseGui();
                }
            });
        }
        this.butpanel.add(this.cancel_but);
        this.cancel_but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppConfig.this.topframe.setVisible(false);
                AppConfig.this.signalCloseGui();
            }
        });
        this.toppanel.setLayout(new BoxLayout(this.toppanel, 1));
        JLabel titlelabel = new JLabel(this.title);
        JPanel titlepanel = new JPanel();
        titlepanel.setBackground(this.bgcolor);
        titlelabel.setForeground(this.textcolor);
        titlelabel.setFont(this.bigfont);
        titlepanel.setLayout(new BoxLayout(titlepanel, 0));
        titlepanel.add(titlelabel);
        this.toppanel.add(titlepanel);
        this.toppanel.add(this.mainpanel);
        this.toppanel.add(this.butpanel);
        this.scrollpane = new JScrollPane(this.toppanel);
        this.topframe.getContentPane().add(this.scrollpane);
        this.topframe.setLocation(50, 50);
        this.topframe.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AppConfig.this.topframe.setVisible(false);
                AppConfig.this.signalCloseGui();
            }
        });
    }

    public void setListener(ActionListener list) {
        this.listener = list;
    }

    public void loadFromFile() {
        if (this.filename == null) {
            return;
        }
        try {
            String line;
            BufferedReader reader;
            try {
                File file = new File(this.filename);
                if (!file.exists()) {
                    return;
                }
                reader = new BufferedReader(new FileReader(file));
            }
            catch (AccessControlException e) {
                URL url = new URL(this.filename);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            while ((line = reader.readLine()) != null) {
                String name = line.substring(0, line.indexOf("\t"));
                String rest1 = line.substring(line.indexOf("\t") + 1);
                String guiname = rest1.substring(0, rest1.indexOf("\t"));
                String rest2 = rest1.substring(rest1.indexOf("\t") + 1);
                String type = rest2.substring(0, rest2.indexOf("\t"));
                String value = rest2.substring(rest2.indexOf("\t") + 1);
                this.defineField(name, guiname, type);
                this.setField(name, value, true);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new JGameError("Error reading file '" + this.filename + "'.", false);
        }
    }

    public void saveToFile() {
        try {
            if (this.filename == null) {
                return;
            }
            PrintWriter writer = new PrintWriter(new FileWriter(new File(this.filename)));
            for (int i = 0; i < this.fields.size(); ++i) {
                String fieldname = (String)this.fields.get(i);
                String fieldguiname = (String)this.fieldguinames.get(fieldname);
                Object fieldvalue = this.fieldvalues.get(fieldname);
                String fieldtype = (String)this.fieldtypes.get(fieldname);
                writer.println(fieldname + "\t" + fieldguiname + "\t" + fieldtype + "\t" + fieldvalue);
            }
            writer.close();
        }
        catch (IOException e) {
            throw new JGameError("Error writing file '" + this.filename + "'.", false);
        }
    }

    public void loadFromObject() {
        try {
            if (this.cls == null) {
                return;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                String fieldname = (String)this.fields.get(i);
                String fieldtype = (String)this.fieldtypes.get(fieldname);
                if (fieldtype.equals("key") || fieldtype.equals("int") || fieldtype.equals("double") || fieldtype.equals("boolean") || fieldtype.equals("String")) {
                    Field field = this.cls.getField(fieldname);
                    this.fieldvalues.put(fieldname, field.get(this.obj));
                    continue;
                }
                System.out.println("not implemented!");
            }
        }
        catch (NoSuchFieldException e) {
            throw new JGameError("Field not found.");
        }
        catch (IllegalAccessException e) {
            throw new JGameError("Field cannot be accessed.");
        }
    }

    public void saveToObject() {
        String fieldname = null;
        try {
            if (this.cls == null) {
                return;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                fieldname = (String)this.fields.get(i);
                Object fieldvalue = this.fieldvalues.get(fieldname);
                String fieldtype = (String)this.fieldtypes.get(fieldname);
                if (fieldtype.equals("key") || fieldtype.equals("int") || fieldtype.equals("double") || fieldtype.equals("boolean") || fieldtype.equals("String")) {
                    Field field = this.cls.getField(fieldname);
                    field.set(this.obj, fieldvalue);
                    continue;
                }
                System.out.println("not implemented!");
            }
        }
        catch (NoSuchFieldException e) {
            System.out.println("Cls:" + this.cls);
            throw new JGameError("Field " + fieldname + " not found.");
        }
        catch (IllegalAccessException e) {
            throw new JGameError("Field " + fieldname + " cannot be accessed.");
        }
        catch (IllegalArgumentException e) {
            throw new JGameError("Illegal field argument for field " + fieldname + ".");
        }
    }

    public void defineField(String fieldname, String guiname, String type) {
        try {
            if (this.fields.contains(fieldname)) {
                return;
            }
            if (guiname == null) {
                guiname = fieldname;
            }
            this.fields.add(fieldname);
            this.fieldtypes.put(fieldname, type);
            this.fieldguinames.put(fieldname, guiname);
            this.addGuiComponent(fieldname);
            if (this.cls != null) {
                Field field = this.cls.getField(fieldname);
                this.setField(fieldname, field.get(this.obj), true);
            }
        }
        catch (NoSuchFieldException e) {
            System.out.println("Cls:" + this.cls);
            throw new JGameError("Field " + fieldname + " not found.");
        }
        catch (IllegalAccessException e) {
            throw new JGameError("Field " + fieldname + " has access error.");
        }
    }

    String classToType(Class cls) {
        if (cls == (class$java$awt$Point == null ? (class$java$awt$Point = AppConfig.class$("java.awt.Point")) : class$java$awt$Point)) {
            return "int2";
        }
        if (cls == Integer.TYPE || cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = AppConfig.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return "int";
        }
        if (cls == Double.TYPE || cls == (class$java$lang$Double == null ? (class$java$lang$Double = AppConfig.class$("java.lang.Double")) : class$java$lang$Double)) {
            return "double";
        }
        if (cls == (class$java$lang$String == null ? (class$java$lang$String = AppConfig.class$("java.lang.String")) : class$java$lang$String)) {
            return "String";
        }
        if (cls == Boolean.TYPE || cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AppConfig.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return "boolean";
        }
        return null;
    }

    public void defineFields(String prefix, String suffix, String guiprefix, String guisuffix) {
        this.defineFields(prefix, suffix, guiprefix, guisuffix, null);
    }

    public void defineFields(String prefix, String suffix, String guiprefix, String guisuffix, String type) {
        Field[] fields = this.cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String fieldname;
            if (!Modifier.isPublic(fields[i].getModifiers()) || !(fieldname = fields[i].getName()).startsWith(prefix) || !fieldname.endsWith(suffix)) continue;
            String guiname = guiprefix + fieldname.substring(prefix.length(), fieldname.length() - suffix.length()) + guisuffix;
            String fieldtype = type;
            if (fieldtype == null) {
                fieldtype = this.classToType(fields[i].getType());
            }
            this.defineField(fieldname, guiname, fieldtype);
        }
    }

    public void setField(String field, Object value, boolean update_gui) {
        String fieldtype = (String)this.fieldtypes.get(field);
        if (fieldtype.equals("String")) {
            if (value != null) {
                this.fieldvalues.put(field, value);
            } else {
                this.fieldvalues.remove(field);
            }
        } else if (!(value instanceof String)) {
            this.fieldvalues.put(field, value);
        } else {
            String valstr = (String)value;
            if (fieldtype.equals("int")) {
                try {
                    this.fieldvalues.put(field, new Integer(Integer.parseInt(valstr)));
                }
                catch (Exception e) {}
            } else if (fieldtype.equals("key")) {
                try {
                    this.fieldvalues.put(field, new Integer(Integer.parseInt(valstr)));
                }
                catch (Exception e) {}
            } else if (fieldtype.equals("double")) {
                try {
                    this.fieldvalues.put(field, new Double(Double.parseDouble(valstr)));
                }
                catch (Exception e) {}
            } else if (fieldtype.equals("boolean")) {
                this.fieldvalues.put(field, new Boolean(valstr.equals("true")));
            } else {
                if (fieldtype.equals("int2")) {
                    throw new JGameError("Unimplemented type " + fieldtype, false);
                }
                if (fieldtype.equals("int4")) {
                    throw new JGameError("Unimplemented type " + fieldtype, false);
                }
                if (fieldtype.equals("File")) {
                    throw new JGameError("Unimplemented type " + fieldtype, false);
                }
                if (fieldtype.equals("Color")) {
                    throw new JGameError("Unimplemented type " + fieldtype, false);
                }
                if (fieldtype.equals("Font")) {
                    throw new JGameError("Unimplemented type " + fieldtype, false);
                }
                throw new JGameError("Unknown type " + fieldtype, false);
            }
        }
        if (update_gui) {
            this.updateGui(field);
        }
    }

    void addGuiComponent(String fieldname) {
        String fieldguiname = (String)this.fieldguinames.get(fieldname) + "  ";
        String fieldtype = (String)this.fieldtypes.get(fieldname);
        Object fieldval = this.fieldvalues.get(fieldname);
        JPanel subpanel = new JPanel(new GridLayout(1, 2));
        subpanel.setBackground(this.bgcolor);
        this.mainpanel.add(subpanel);
        JLabel namelabel = new JLabel(fieldguiname, 4);
        namelabel.setBackground(this.bgcolor);
        namelabel.setForeground(this.textcolor);
        namelabel.setFont(this.mainfont);
        if (fieldtype.equals("int") || fieldtype.equals("double")) {
            JTextField numfield = new JTextField("" + fieldval, 8);
            numfield.addCaretListener(new FieldChangeHandler(fieldname){

                public void caretUpdate(CaretEvent e) {
                    JTextField tf = (JTextField)AppConfig.this.fieldcomponents.get(this.fieldname);
                    AppConfig.this.processAction(this.fieldname, tf.getText());
                }
            });
            if (fieldtype.equals("int")) {
                numfield.setToolTipText("Enter an integer.");
            } else {
                numfield.setToolTipText("Enter a real number.");
            }
            numfield.setFont(this.mainfont);
            numfield.setForeground(this.textcolor);
            numfield.setBackground(this.hltcolor);
            this.fieldcomponents.put(fieldname, numfield);
            subpanel.add(namelabel);
            subpanel.add(numfield);
        } else if (fieldtype.equals("String")) {
            JTextField strfield = new JTextField("" + fieldval, 8);
            strfield.addCaretListener(new FieldChangeHandler(fieldname){

                public void caretUpdate(CaretEvent e) {
                    JTextField tf = (JTextField)AppConfig.this.fieldcomponents.get(this.fieldname);
                    AppConfig.this.processAction(this.fieldname, tf.getText());
                }
            });
            strfield.setToolTipText("Enter a text.");
            strfield.setFont(this.mainfont);
            strfield.setForeground(this.textcolor);
            strfield.setBackground(this.hltcolor);
            this.fieldcomponents.put(fieldname, strfield);
            subpanel.add(namelabel);
            subpanel.add(strfield);
        } else if (fieldtype.equals("boolean")) {
            JCheckBox boolfield = new JCheckBox("yes");
            boolfield.addItemListener(new FieldChangeHandler(fieldname){

                public void itemStateChanged(ItemEvent e) {
                    Boolean val = new Boolean(e.getStateChange() == 1);
                    AppConfig.this.processAction(this.fieldname, val);
                }
            });
            boolfield.setFont(this.mainfont);
            boolfield.setForeground(this.textcolor);
            boolfield.setBackground(this.bgcolor);
            this.fieldcomponents.put(fieldname, boolfield);
            subpanel.add(namelabel);
            subpanel.add(boolfield);
        } else if (fieldtype.equals("key")) {
            KeyField keyfield = new KeyField(fieldname, this.bgcolor, this.hltcolor);
            this.fieldcomponents.put(fieldname, keyfield);
            keyfield.setToolTipText("Click then press a key to define keystroke.");
            keyfield.setFont(this.mainfont);
            keyfield.setForeground(this.textcolor);
            subpanel.add(namelabel);
            subpanel.add(keyfield);
        }
    }

    void processAction(String name, Object value) {
        this.setField(name, value, false);
    }

    public void openGui() {
        this.gui_open = true;
        this.topframe.pack();
        this.topframe.setVisible(true);
        this.topframe.requestFocus();
    }

    public void closeGui() {
        this.topframe.setVisible(false);
        this.signalCloseGui();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalCloseGui() {
        Object object = this.gui_lock;
        synchronized (object) {
            this.gui_open = false;
            this.gui_lock.notifyAll();
        }
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public boolean isGuiOpen() {
        return this.gui_open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilGuiClosed() {
        Object object = this.gui_lock;
        synchronized (object) {
            try {
                while (this.gui_open) {
                    this.gui_lock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void updateGui(String fieldname) {
        Object fieldval = this.fieldvalues.get(fieldname);
        Object fieldcom = this.fieldcomponents.get(fieldname);
        String fieldtype = (String)this.fieldtypes.get(fieldname);
        if (fieldcom instanceof JCheckBox) {
            ((JCheckBox)fieldcom).setSelected((Boolean)fieldval);
        } else if (fieldcom instanceof JColorChooser) {
            JColorChooser jcc = (JColorChooser)fieldcom;
            jcc.setColor((Color)fieldval);
        } else if (fieldcom instanceof KeyField) {
            ((KeyField)fieldcom).setValue((Integer)fieldval);
        } else if (fieldcom instanceof JTextField) {
            JTextField textfield = (JTextField)fieldcom;
            if (fieldtype.equals("int") || fieldtype.equals("double")) {
                textfield.setText("" + fieldval);
            } else if (fieldtype.equals("String")) {
                textfield.setText("" + fieldval);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class KeyField
    extends JTextField
    implements KeyListener,
    FocusListener {
        String fieldname;
        Color norm_bg;
        Color hlt_bg;

        public KeyField(String fieldname, Color norm_bg, Color hlt_bg) {
            super(10);
            this.fieldname = fieldname;
            this.setEditable(true);
            this.addKeyListener(this);
            this.addFocusListener(this);
            this.norm_bg = norm_bg;
            this.hlt_bg = hlt_bg;
            this.setBackground(norm_bg);
            this.setBorder(AppConfig.this.border);
        }

        public void setValue(int keyval) {
            this.setText(JGEngine.getKeyDescStatic(keyval));
        }

        public int getValue() {
            return JGEngine.getKeyCodeStatic(this.getText());
        }

        public void processKeyEvent(KeyEvent e) {
            int keycode = e.getKeyCode();
            if (keycode != 0) {
                this.setText(JGEngine.getKeyDescStatic(keycode));
                AppConfig.this.processAction(this.fieldname, new Integer(keycode));
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void focusGained(FocusEvent e) {
            this.setBackground(this.hlt_bg);
        }

        public void focusLost(FocusEvent e) {
            this.setBackground(this.norm_bg);
        }
    }

    class FieldChangeHandler
    implements ActionListener,
    ChangeListener,
    ItemListener,
    CaretListener {
        String fieldname = null;
        Component component;

        public FieldChangeHandler(String fname) {
            this.fieldname = fname;
        }

        public FieldChangeHandler(String fname, Component comp) {
            this.fieldname = fname;
            this.component = comp;
        }

        public FieldChangeHandler(Component comp) {
            this.component = comp;
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println(e);
        }

        public void stateChanged(ChangeEvent e) {
            System.out.println(e);
        }

        public void itemStateChanged(ItemEvent e) {
            System.out.println(e);
        }

        public void caretUpdate(CaretEvent e) {
            System.out.println(e);
        }
    }
}

