/*
 * Decompiled with CFR 0.152.
 */
package jgame;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import jgame.impl.EngineLogic;

public class Highscore {
    public int score;
    public String name;
    public String[] fields = null;

    public Highscore(int score, String name) {
        this.score = score;
        this.name = name;
    }

    public Highscore(int score, String name, String field1) {
        this.score = score;
        this.name = name;
        this.fields = new String[]{field1};
    }

    public Highscore(int score, String name, String field1, String field2) {
        this.score = score;
        this.name = name;
        this.fields = new String[]{field1, field2};
    }

    public Highscore(int score, String name, String field1, String field2, String field3) {
        this.score = score;
        this.name = name;
        this.fields = new String[]{field1, field2, field3};
    }

    public static int findPos(Highscore[] highscores, int newscore) {
        for (int i = 0; i < highscores.length; ++i) {
            if (newscore <= highscores[i].score) continue;
            return i;
        }
        return -1;
    }

    public static Highscore[] insert(Highscore[] highscores, Highscore newscore) {
        if (Highscore.findPos(highscores, newscore.score) >= 0) {
            highscores[highscores.length - 1] = newscore;
            return Highscore.sort(highscores);
        }
        return highscores;
    }

    public static Highscore[] load(InputStream in) throws IOException {
        String line;
        Vector<Highscore> highscores = new Vector<Highscore>(20, 40);
        InputStreamReader inr = new InputStreamReader(in);
        while ((line = EngineLogic.readline(inr)) != null) {
            Vector<String> fields = new Vector<String>(5, 10);
            Vector tokens = EngineLogic.tokenizeString(line, '\t');
            Enumeration e = tokens.elements();
            while (e.hasMoreElements()) {
                String tok = (String)e.nextElement();
                if (tok.equals("`")) {
                    tok = "";
                }
                fields.addElement(tok);
            }
            Highscore hs = null;
            if (fields.size() == 1) {
                hs = new Highscore(Integer.parseInt((String)fields.elementAt(0)), "");
            }
            if (fields.size() >= 2) {
                hs = new Highscore(Integer.parseInt((String)fields.elementAt(0)), (String)fields.elementAt(1));
            }
            if (fields.size() >= 3) {
                hs.fields = new String[fields.size() - 2];
                for (int i = 2; i < fields.size(); ++i) {
                    hs.fields[i - 2] = (String)fields.elementAt(i);
                }
            }
            highscores.addElement(hs);
        }
        Highscore[] ret = new Highscore[highscores.size()];
        for (int i = 0; i < highscores.size(); ++i) {
            ret[i] = (Highscore)highscores.elementAt(i);
        }
        return ret;
    }

    public static void save(Highscore[] highscores, OutputStream out) throws IOException {
        PrintStream outp = new PrintStream(out);
        for (int i = 0; i < highscores.length; ++i) {
            outp.print(highscores[i].score);
            outp.print('\t');
            if (highscores[i].name.equals("")) {
                outp.print("`");
            } else {
                outp.print(highscores[i].name);
            }
            if (highscores[i].fields != null) {
                for (int j = 0; j < highscores[i].fields.length; ++j) {
                    outp.print('\t');
                    outp.print(highscores[i].fields[j]);
                }
            }
            outp.println();
        }
        outp.flush();
    }

    static Highscore[] sort(Highscore[] a) {
        int temp;
        int index = a.length - 1;
        for (int i = temp = (index - 1) / 2; i >= 0; --i) {
            Highscore.BubbleDown(index, i, a);
        }
        while (index > 0) {
            Highscore.swap(a, 0, index);
            Highscore.BubbleDown(--index, 0, a);
        }
        return a;
    }

    private static void BubbleDown(int index, int i, Highscore[] a) {
        int child = (i + 1) * 2 - 1;
        if (child < index && a[child + 1].score < a[child].score) {
            ++child;
        }
        if (child <= index && a[i].score > a[child].score) {
            Highscore.swap(a, i, child);
            Highscore.BubbleDown(index, child, a);
        }
    }

    private static void swap(Highscore[] a, int i, int j) {
        Highscore T = a[i];
        a[i] = a[j];
        a[j] = T;
    }
}

