/*
 * Decompiled with CFR 0.152.
 */
package examples.cavernsoffire;

import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class CavernsOfFire
extends StdGame {
    boolean do_scroll = false;
    boolean large_pf = false;
    JGFont title_font = new JGFont("Arial", 0, 25.0);
    JGFont lastscore_font = new JGFont("Arial", 0, 15.0);
    int start_difficulty = 0;
    Player player = null;
    int lavalevel = 0;
    int nr_pads = 0;
    int non_preferred_monster = 0;
    int lavaarea = 0;
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);
    static JGFont msgfont = new JGFont("Arial", 0, 20.0);
    static JGColor[] cyclecol = new JGColor[]{JGColor.yellow, JGColor.green, JGColor.cyan, JGColor.blue, JGColor.magenta, JGColor.red};

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Please supply \"scroll\" or \"noscroll\" as first argument.");
            System.exit(0);
        }
        boolean do_scroll = false;
        boolean large_pf = false;
        if (args[0].equals("scroll")) {
            do_scroll = true;
            large_pf = false;
        }
        new CavernsOfFire(CavernsOfFire.parseSizeArgs(args, 1), do_scroll, large_pf);
    }

    public CavernsOfFire() {
        this.initEngineApplet();
    }

    public CavernsOfFire(JGPoint size, boolean do_scroll, boolean large_pf) {
        this.do_scroll = do_scroll;
        this.large_pf = large_pf;
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        if (this.isApplet()) {
            boolean bl = this.do_scroll = this.getParameter("scrolling") != null;
        }
        if (this.isMidlet()) {
            this.setScalingPreferences(0.8333333333333334, 1.2, 0, 5, 5, 5);
            this.setCanvasSettings(15, 20, 16, 16, null, null, null);
            this.do_scroll = true;
        } else if (this.isAndroid()) {
            this.setScalingPreferences(0.8333333333333334, 1.2, 0, 5, 5, 5);
            this.setCanvasSettings(18, 24, 16, 16, null, null, null);
            this.do_scroll = true;
        } else if (this.do_scroll && !this.large_pf) {
            this.setCanvasSettings(18, 24, 16, 16, null, null, null);
        } else {
            this.setCanvasSettings(40, 30, 16, 16, null, null, null);
        }
    }

    public void initGame() {
        this.setProgressMessage("");
        this.defineMedia(this.isMidlet() ? "media-midp.tbl" : "media.tbl");
        this.setVideoSyncedUpdate(true);
        if (!this.isMidlet()) {
            this.setFrameRate(40.0, 1.0);
        } else {
            this.setFrameRate(15.0, 1.0);
            this.setGameSpeed(2.5);
        }
        this.startgame_ticks = 0;
        this.lifelost_ingame = true;
        if (this.isAndroid()) {
            this.key_startgame = 255;
            this.startgame_ingame = true;
        }
        this.setTileSettings("", 1, 0);
        if (this.large_pf) {
            this.setPFSize(100, 40);
        } else {
            this.setPFSize(40, 30);
        }
    }

    public void startTitle() {
        this.setViewOffset(0, 0, false);
        this.removeObjects(null, 0);
        this.stopAudio("bgchan");
    }

    public void paintFrameTitle() {
        if (this.isAndroid()) {
            this.drawImage(0.0, 0.0, "intro_image");
        } else {
            this.drawString(this.isMidlet() ? "Touch here" : "Press space to start", this.viewWidth() / 2, this.viewHeight() / 4, 0);
            this.drawString(this.isMidlet() ? "or \"*\" to start" : "", this.viewWidth() / 2, this.viewHeight() / 4 + 20, 0);
            this.drawString("Difficulty (touch or", this.viewWidth() / 2, this.viewHeight() / 2 - 12, 0);
            this.drawString("left/right to change):", this.viewWidth() / 2, this.viewHeight() / 2 + 5, 0);
            this.drawString("Get more at tmtg.net", this.viewWidth() / 2, 3 * this.viewHeight() / 4, 0);
        }
        this.setFont(this.title_font);
        this.drawString(this.start_difficulty == 0 ? "Easy" : (this.start_difficulty == 1 ? "Medium" : "Hard"), this.viewWidth() / 2, (int)((double)this.viewHeight() * 0.57), 0);
        if (this.score > 0) {
            this.setFont(this.lastscore_font);
            this.drawString("Last score: " + this.score, 0.0, 0.0, -1);
        }
    }

    public void doFrameTitle() {
        int startlevel = this.start_difficulty * 6;
        if (this.getMouseButton(1)) {
            if (this.getMouseY() < this.viewHeight() / 2) {
                this.startGame(startlevel);
            } else if (this.getMouseY() < 4 * this.viewHeight() / 6) {
                this.start_difficulty = (this.start_difficulty + 1) % 3;
            } else if (this.getMouseY() < 5 * this.viewHeight() / 6) {
                this.exitEngine(null);
            } else {
                this.invokeUrl("http://tmtg.net/", "_blank");
            }
            this.clearMouseButton(1);
        }
        if (this.getKey(37)) {
            this.clearKey(37);
            this.start_difficulty = (this.start_difficulty + 2) % 3;
        }
        if (this.getKey(39)) {
            this.clearKey(39);
            this.start_difficulty = (this.start_difficulty + 1) % 3;
        }
    }

    public void defineLevel() {
        int difficulty;
        int x;
        JGPoint loc;
        int x2;
        double bot2a;
        double bot2;
        double bot1a;
        double bot1;
        double botph;
        double top2a;
        double top2;
        double top1a;
        double top1;
        double topph;
        int cave_tightness;
        this.setBGImage("cave_bg" + this.stage % 4);
        double scrollxf = 1.0;
        double scrollyf = 1.0;
        if (this.large_pf) {
            scrollxf = 2.5;
            scrollyf = 1.6666666666666667;
        }
        double amplitude = scrollyf * (double)this.random(7, this.level < 8 ? 8 + 5 * this.level / 4 : 18, 1);
        int lavalevel_min = 0;
        int lavalevel_max = (int)Math.min(amplitude - 2.0, this.level < 7 ? (double)(1 + this.level) : 8.0);
        if (this.level >= 6) {
            if (this.stage % 4 == 0) {
                lavalevel_min = lavalevel_max - 3;
                if (lavalevel_min < 0) {
                    lavalevel_min = 0;
                }
            } else if (this.stage % 4 == 2) {
                lavalevel_max = 2;
            }
        }
        this.lavalevel = (int)(scrollyf * (double)this.random(lavalevel_min, lavalevel_max, 1));
        this.fillBG(".");
        for (int i = 0; i < 500; ++i) {
            this.setTile(this.random(0, this.pfTilesX(), 1), this.random(0, this.pfTilesY(), 1), ",");
        }
        this.removeObjects(null, 0);
        this.player = new Player(16.0, this.pfHeight() / 2);
        this.setViewOffset((int)this.player.x, (int)this.player.y, true);
        int cave_overlap = 0;
        block1: while (true) {
            cave_tightness = 30;
            int cave_highfloor = this.pfTilesY();
            int cave_lowceil = 0;
            topph = this.random(0.0, 6.0);
            top1 = this.random(1.5, 4.0);
            top1a = amplitude / 10.0 * this.random(2.5, 3.5);
            top2 = this.random(0.5, 1.5);
            top2a = amplitude / 10.0 * this.random(0.5, 2.0);
            botph = this.random(0.0, 6.0);
            bot1 = this.random(1.5, 4.0);
            bot1a = amplitude / 10.0 * this.random(2.5, 3.5);
            bot2 = this.random(0.5, 1.5);
            bot2a = amplitude / 10.0 * this.random(0.5, 2.0);
            for (x2 = 0; x2 < this.pfTilesX(); ++x2) {
                int upper = (int)(amplitude / 2.0 + top1a * Math.sin(topph + (double)x2 / top1) + top2a * Math.sin(topph + (double)x2 / top2));
                int lowerl2 = (int)(amplitude / 2.0 + bot1a * Math.sin(botph + (double)(x2 - 2) / bot1) + bot2a * Math.sin(botph + (double)(x2 - 2) / bot2));
                int lowerl = (int)(amplitude / 2.0 + bot1a * Math.sin(botph + (double)(x2 - 1) / bot1) + bot2a * Math.sin(botph + (double)(x2 - 1) / bot2));
                int lower = (int)(amplitude / 2.0 + bot1a * Math.sin(botph + (double)x2 / bot1) + bot2a * Math.sin(botph + (double)x2 / bot2));
                int lowerr = (int)(amplitude / 2.0 + bot1a * Math.sin(botph + (double)(x2 + 1) / bot1) + bot2a * Math.sin(botph + (double)(x2 + 1) / bot2));
                int lowerr2 = (int)(amplitude / 2.0 + bot1a * Math.sin(botph + (double)(x2 + 2) / bot1) + bot2a * Math.sin(botph + (double)(x2 + 2) / bot2));
                double segment_tightness = Math.min(this.pfTilesY() - upper - lowerl2, Math.min(this.pfTilesY() - upper - lowerl, Math.min(this.pfTilesY() - upper - lower, Math.min(this.pfTilesY() - upper - lowerr, this.pfTilesY() - upper - lowerr2))));
                if (segment_tightness < 4.0) continue block1;
                if (x2 > 4) {
                    cave_tightness = (int)Math.min((double)cave_tightness, segment_tightness);
                }
                cave_highfloor = Math.min(cave_highfloor, this.pfTilesY() - lower);
                cave_lowceil = Math.max(cave_lowceil, upper);
                cave_overlap = cave_lowceil - cave_highfloor;
            }
            break;
        }
        for (x2 = 0; x2 < this.pfTilesX(); ++x2) {
            int y = 0;
            while ((double)y < amplitude / 2.0 + top1a * Math.sin(topph + (double)x2 / top1) + top2a * Math.sin(topph + (double)x2 / top2)) {
                this.setTile(x2, y, "#");
                ++y;
            }
            y = 0;
            while ((double)y < amplitude / 2.0 + bot1a * Math.sin(botph + (double)x2 / bot1) + bot2a * Math.sin(botph + (double)x2 / bot2)) {
                this.setTile(x2, this.pfTilesY() - y, "#");
                ++y;
            }
        }
        this.setTiles(0, this.pfTilesY() / 2 - 1, new String[]{"...", ".,.", "..,", ",.."});
        for (int y = this.lavalevel = this.pfTilesY() - this.lavalevel; y < this.pfTilesY(); ++y) {
            for (int x3 = 0; x3 < this.pfTilesX(); ++x3) {
                if (this.and(this.getTileCid(x3, y), 1)) continue;
                this.setTile(x3, y, this.random(0.0, 1.0) > 0.5 ? "<" : ">");
            }
        }
        this.nr_pads = 0;
        block8: while (true) {
            int goodyofs = 1;
            int triesleft = 102;
            for (int i = 0; i < (this.large_pf ? 7 : 4); ++i) {
                block10: while (true) {
                    int check_topmost = -11 + triesleft / 18;
                    if (triesleft > 100) {
                        loc = new JGPoint(this.random(this.pfTilesX() - 9, this.pfTilesX() - 2, 1), this.pfTilesY() - 1);
                        check_topmost = -12;
                    } else {
                        loc = new JGPoint(this.random(4, this.pfTilesX() - 2, 1), this.pfTilesY() - 1);
                    }
                    if (triesleft-- <= 0) break;
                    goodyofs = 1;
                    for (int y = 0; y > -12 - (this.large_pf ? 5 : 0); --y) {
                        if (this.and(this.getTileCid(loc, 0, y), 6) || this.and(this.getTileCid(loc, 1, y), 6)) continue block10;
                        if (this.and(this.getTileCid(loc, 0, y) | this.getTileCid(loc, 1, y), 1) || goodyofs != 1 || y < check_topmost) continue;
                        goodyofs = y;
                    }
                    if (goodyofs != 1) break;
                }
                if (goodyofs < 1) {
                    if (loc.y + goodyofs == this.lavalevel - 1) {
                        --goodyofs;
                    }
                    if (loc.y + goodyofs == this.lavalevel - 2) {
                        --goodyofs;
                    }
                    this.setTiles(loc.x, loc.y + goodyofs, new String[]{"[]", "##", "##"});
                    ++this.nr_pads;
                }
                if (this.nr_pads >= (this.large_pf ? 4 : 3)) break block8;
            }
            for (int x4 = 0; x4 < this.pfTilesX(); ++x4) {
                if (!this.and(this.getTileCid(x4, this.lavalevel), 2)) continue;
                this.setTile(x4, this.lavalevel, ".");
            }
            ++this.lavalevel;
        }
        for (int y = 0; y < this.pfTilesY(); ++y) {
            for (x = 0; x < this.pfTilesX(); ++x) {
                int context;
                if ((this.getTileCid(x, y) & 7) == 1) {
                    context = this.getTileCid(x, y - 1) & 1 | (this.getTileCid(x, y + 1) & 1) * 2 | (this.getTileCid(x - 1, y) & 1) * 4 | (this.getTileCid(x + 1, y) & 1) * 8;
                    this.setTile(x, y, "#" + (15 - context));
                    continue;
                }
                if (!this.and(this.getTileCid(x, y), 2) || (context = (this.getTileCid(x, y - 1) == 1 ? 1 : 0) | (this.getTileCid(x, y + 1) == 1 ? 2 : 0) | (this.getTileCid(x - 1, y) == 1 ? 4 : 0) | (this.getTileCid(x + 1, y) == 1 ? 8 : 0)) == 0) continue;
                this.setTile(x, y, "<" + context);
            }
        }
        double[][] monster_difficulty = new double[][]{{0.4, 0.5, 0.7, 1.2}, {0.5, 0.6, 0.8, 0.9}, {0.5, 0.6, 0.8, 0.8}, {0.6, 0.7, 1.0, 0.7}};
        this.lavaarea = 0;
        for (x = 0; x < this.pfTilesX(); ++x) {
            if (!this.and(this.getTileCid(x, this.lavalevel), 2)) continue;
            ++this.lavaarea;
        }
        this.lavaarea = (int)((double)this.lavaarea / scrollxf);
        int cave_tight_level = 0;
        if (cave_tightness <= 13) {
            cave_tight_level = 1;
        }
        if (cave_tightness <= 10) {
            cave_tight_level = 2;
        }
        if (cave_tightness <= 8) {
            cave_tight_level = 3;
        }
        if (cave_tightness <= 6) {
            cave_tight_level = 4;
        }
        if (cave_tightness <= 5) {
            cave_tight_level = 5;
        }
        if (cave_overlap > -6) {
            ++cave_tight_level;
        }
        if (cave_overlap > -1) {
            ++cave_tight_level;
        }
        if ((difficulty = this.lavaarea / 4 + cave_tight_level) > 10) {
            difficulty = 10;
        }
        int nr_coils = 0;
        int nr_jellies = 0;
        int nr_bats = 0;
        int nr_tanks = 0;
        int difficulty_left = 5 + this.level - difficulty;
        boolean has_placed_monsters = false;
        while (true) {
            double dif;
            int nrmonsters;
            int monstertype = this.level;
            if (this.level >= 0) {
                while ((monstertype = this.random(0, 3, 1)) == this.non_preferred_monster) {
                }
            }
            if ((nrmonsters = (int)((double)difficulty_left / (dif = monster_difficulty[cave_tight_level / 2][monstertype]))) <= 0) break;
            if (nrmonsters > 10) {
                nrmonsters = 10;
                this.non_preferred_monster = monstertype;
            }
            if (!has_placed_monsters) {
                this.non_preferred_monster = monstertype;
            }
            difficulty_left = (int)((double)difficulty_left - dif * (double)nrmonsters);
            if (monstertype == 0) {
                nr_coils += nrmonsters;
            }
            if (monstertype == 1) {
                nr_jellies += nrmonsters;
            }
            if (monstertype == 2) {
                nr_bats += nrmonsters;
            }
            if (monstertype == 3) {
                nr_tanks += nrmonsters;
            }
            has_placed_monsters = true;
        }
        int i = 0;
        while ((double)i < (double)nr_coils * scrollxf) {
            while (this.and(this.getTileCid(loc = new JGPoint(this.random(5, this.pfTilesX() - 1, 1), this.random(0, this.pfTilesY(), 1)), 0, 0), 1)) {
            }
            new Coil(loc.x * this.tileWidth(), (double)(loc.y * this.tileHeight()), 0, this.random(-1, 1, 2), 4.0);
            ++i;
        }
        i = 0;
        while ((double)i < (double)nr_jellies * scrollxf) {
            while (this.and(this.getTileCid(loc = new JGPoint(this.random(9, this.pfTilesX() - 1, 1), this.random(0, this.pfTilesY(), 1)), 0, 0), 1) || this.and(this.getTileCid(loc, 1, 0), 1) || this.and(this.getTileCid(loc, -1, 0), 1) || this.and(this.getTileCid(loc, 0, 1), 1) || this.and(this.getTileCid(loc, 0, -1), 1)) {
            }
            new Jelly(loc.x * this.tileWidth(), loc.y * this.tileHeight(), this.random(-1, 1, 2), 2.5);
            ++i;
        }
        i = 0;
        while ((double)i < (double)nr_bats * scrollxf) {
            loc = new JGPoint(this.random(9, this.pfTilesX() - 1, 1), 0);
            while (this.and(this.getTileCid(loc, 0, 0), 1)) {
                ++loc.y;
            }
            new Bat(loc.x * this.tileWidth(), loc.y * this.tileHeight(), 1, 4.0);
            ++i;
        }
        i = 0;
        while ((double)i < (double)nr_tanks * scrollxf / 2.0) {
            loc = new JGPoint(this.random(5, this.pfTilesX() - 1, 1), this.pfTilesY() - 1);
            while (this.and(this.getTileCid(loc, 0, 0), 1)) {
                --loc.y;
            }
            new Tank(loc.x * this.tileWidth(), loc.y * this.tileHeight(), 1, 0.6);
            ++i;
        }
        i = 0;
        while ((double)i < (double)nr_tanks * scrollxf / 2.0) {
            loc = new JGPoint(this.random(5, this.pfTilesX() - 1, 1), 0);
            while (this.and(this.getTileCid(loc, 0, 0), 1)) {
                ++loc.y;
            }
            new Tank(loc.x * this.tileWidth(), loc.y * this.tileHeight(), -1, 0.6);
            ++i;
        }
        if (!this.isMidlet()) {
            if (this.lavaarea > 12) {
                this.playAudio("bgchan", "lava", true);
            } else {
                this.playAudio("bgchan", "drip", true);
            }
        }
    }

    public void initNewGame(int level_selected) {
        this.level = level_selected;
        this.stage = level_selected;
        this.score = 0;
        this.lives = 5;
    }

    public void incrementLevel() {
        if (this.level < 16) {
            ++this.level;
        }
        ++this.stage;
    }

    public void initNewLife() {
        this.player = new Player(16.0, this.pfHeight() / 2);
    }

    public void doFrameStartLevel() {
        if (this.seqtimer == 1.0) {
            this.moveObjects();
        }
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(28, 1);
        this.checkCollision(20, 2);
        this.checkBGCollision(1, 31);
        JGPoint loc = new JGPoint(this.random(0, this.pfTilesX() - 1, 1), this.lavalevel);
        if (this.and(this.getTileCid(loc, 0, 0), 2) && this.and(this.getTileCid(loc, 1, 0), 2)) {
            double ballx = (double)(loc.x * this.tileWidth()) + this.random(0.0, 15.0);
            double bally = loc.y * this.tileHeight();
            if (this.checkTime(15)) {
                new Fireball(ballx, bally, this.random(-1.0, 1.0), this.random(-3.5, -1.5), false, -2);
            } else {
                new Fireball(ballx, bally, 0.0, -0.5, !(this.random(0.0, 1.0) > 0.5), this.random(3, 11, 1));
            }
            if (this.getTileStr(loc.x, loc.y).equals("<")) {
                this.setTile(loc.x, loc.y, ">");
            } else if (this.getTileStr(loc.x, loc.y).equals(">")) {
                this.setTile(loc.x, loc.y, "<");
            }
        }
        if (this.nr_pads == 0 || this.countObjects(null, 4) == 0 && this.lavaarea <= 12 || this.getKey(76)) {
            this.levelDone();
        }
        if (this.player != null) {
            int ofsx = (int)this.player.x - this.viewWidth() / 2;
            int ofsy = (int)this.player.y - this.viewHeight() / 2;
            this.setViewOffset((int)((double)ofsx + this.player.xspeed * 5.0), (int)((double)ofsy + this.player.yspeed * 5.0), false);
        }
    }

    public void paintFrameInGame() {
        if (this.getMouseButton(1)) {
            this.drawImage(this.getMouseX() - 16, (double)(this.getMouseY() - 16), "crosshairs" + (int)this.seqtimer / 3 % 3, false);
        }
    }

    public void doFrameLevelDone() {
        this.moveObjects("zexplo", 0);
    }

    public void doFrameStartGame() {
        this.moveObjects("zexplo", 0);
    }

    public void startLifeLost() {
        this.player.remove();
    }

    public void doFrameLifeLost() {
        if (this.checkTime(8)) {
            new Explo(this.player.x + 8.0 + this.random(-15.0, 15.0), this.player.y + 8.0 + this.random(-15.0, 15.0));
        }
    }

    public class Explo
    extends JGObject {
        public Explo(double x, double y) {
            super("zexplo", true, x - 32.0, y - 32.0, 0, !CavernsOfFire.this.isMidlet() ? "explo" + CavernsOfFire.this.random(1, 4, 1) : null, 17);
        }

        public void paint() {
            if (CavernsOfFire.this.isAndroid() || CavernsOfFire.this.isOpenGL()) {
                double phase = (17.0 - this.expiry) / 17.0;
                double sinphase = Math.sin(phase * Math.PI);
                CavernsOfFire.this.setBlendMode(1, 0);
                CavernsOfFire.this.drawImage(this.x, this.y, "light1", null, 0.9 * (1.0 - phase), 0.0, 0.8 + 1.6 * sinphase, true);
                CavernsOfFire.this.setBlendMode(1, -1);
            }
            if (CavernsOfFire.this.isMidlet()) {
                CavernsOfFire.this.setColor(CavernsOfFire.this.cycleColor(cyclecol, CavernsOfFire.this.gametime, 0.25));
                CavernsOfFire.this.setStroke(1.0);
                for (int i = 0; i < 2; ++i) {
                    double size = this.random(7.0, 10.0 + this.expiry);
                    double radius = 20.0 - this.expiry;
                    CavernsOfFire.this.drawOval((int)(this.x + 32.0 + this.random(-radius, radius)), (int)(this.y + 32.0 + this.random(-radius, radius)), (int)size, (int)size, true, true);
                }
            }
        }
    }

    public class Fireball
    extends JGObject {
        boolean is_small;
        int timer = 0;
        int invulnerability = (int)(10.0 / CavernsOfFire.this.getGameSpeed());

        public Fireball(double x, double y, double xspeed, double yspeed, boolean is_small, int expiry) {
            super("fireball", true, x, y, 16, expiry > 0 && expiry < 20 ? (is_small ? "fireball_p_sm" : "fireball_p") : (is_small ? "fireball_sm" : "fireball"), expiry);
            this.setSpeed(xspeed, yspeed);
            this.is_small = is_small;
        }

        public void move() {
            this.yspeed += 0.03 + (this.is_small ? 0.03 : 0.0);
            --this.invulnerability;
            this.timer = (int)((double)this.timer + gamespeed);
        }

        public void hit_bg(int tilecid, int tilex, int tiley) {
            if (!this.isAlive()) {
                return;
            }
            if (!this.is_small && this.invulnerability < 0) {
                if (!Fireball.and(tilecid, 2)) {
                    this.remove();
                    if (!CavernsOfFire.this.isMidlet()) {
                        CavernsOfFire.this.playAudio("rumble" + this.random(0, 1, 1));
                    }
                    for (int i = 0; i < (CavernsOfFire.this.isMidlet() ? 4 : 6); ++i) {
                        new Fireball(this.x, this.y, this.xspeed + this.random(-2.0, 2.0), this.random(-2.0, 1.0), true, this.random(20, 50, 1));
                    }
                } else if (this.y >= (double)(tiley * tilewidth)) {
                    this.remove();
                }
            }
        }

        public void paint() {
            if (CavernsOfFire.this.isAndroid() || CavernsOfFire.this.isOpenGL()) {
                double intensity;
                double phase = (double)this.timer / 9.0;
                double sinphase = 0.7 + 0.3 * Math.cos(phase * Math.PI);
                double d = (double)this.timer < 20.0 ? 0.6 - 0.5 * (double)this.timer / 20.0 : (intensity = this.is_small ? 0.0 : 0.0);
                if (this.is_small) {
                    intensity *= 0.3;
                }
                if (intensity == 0.0) {
                    return;
                }
                CavernsOfFire.this.setBlendMode(1, 0);
                CavernsOfFire.this.drawImage(this.x - 24.0, this.y - 24.0, "light1", this.is_small ? JGColor.orange : JGColor.red, intensity * sinphase, 0.0, 1.0, true);
                CavernsOfFire.this.setBlendMode(1, -1);
            }
        }
    }

    public class EnemyBullet
    extends JGObject {
        public EnemyBullet(double x, double y, double xspeed, double yspeed) {
            super("Enemybullet", true, x, y, 8, "bomb", -2);
            this.setSpeed(xspeed, yspeed);
        }

        public void move() {
            this.yspeed += 0.05;
        }

        public void hit_bg(int tilecid) {
            this.remove();
        }
    }

    public class Tank
    extends JGObject {
        double speed;
        int move_timer = this.random(100, 500, 1);
        int shoot_timer = 0;

        public Tank(double x, double y, int yorient, double speed) {
            super("tank", true, x, y, 4, null);
            this.speed = speed;
            this.ydir = yorient;
            this.xdir = this.random(-1, 1, 2);
            this.setTileBBox(2, yorient * 8, 10, 14);
        }

        public void move() {
            String gfx = "tank_";
            gfx = gfx + (this.ydir > 0 ? "u" : "d");
            gfx = gfx + (this.xdir > 0 ? "r" : "l");
            if ((double)this.xdir * this.yspeed > 0.5) {
                gfx = gfx + "d";
            }
            if ((double)this.xdir * this.yspeed < -0.5) {
                gfx = gfx + "u";
            }
            this.setGraphic(gfx);
            if (this.move_timer > 0) {
                JGPoint cen;
                this.startAnim();
                if (--this.move_timer <= 0) {
                    this.shoot_timer = 80;
                }
                this.yspeed = Tank.and(CavernsOfFire.this.getTileCid(cen = this.getCenterTile(), 0, 0), 1) || Tank.and(CavernsOfFire.this.getTileCid(cen, this.xdir, 0), 1) ? (this.yspeed > 0.0 ? 0.0 : (this.yspeed += -0.05 * this.speed)) : (this.yspeed < 0.0 ? 0.0 : (this.yspeed += 0.1 * this.speed));
                this.xspeed = this.speed * 1.2 - Math.abs(this.yspeed);
                if (this.xspeed < 0.1) {
                    this.xspeed = 0.1;
                }
                if (this.x <= 8.0 && this.xdir < 0) {
                    this.xdir = 1;
                }
                if (this.x > (double)(CavernsOfFire.this.pfWidth() - 24) && this.xdir > 0) {
                    this.xdir = -1;
                }
            } else {
                this.stopAnim();
                if (--this.shoot_timer <= 0) {
                    this.move_timer = this.random(300, 600, 1);
                    this.xdir = -this.xdir;
                }
                this.xspeed = 0.0;
                this.yspeed = 0.0;
                if (this.shoot_timer % 20 == 10) {
                    if (!CavernsOfFire.this.isMidlet()) {
                        CavernsOfFire.this.playAudio("tankshoot");
                    }
                    double angle = CavernsOfFire.this.atan2(CavernsOfFire.this.player.x - this.x, CavernsOfFire.this.player.y - this.y);
                    if (this.y < CavernsOfFire.this.player.y) {
                        new EnemyBullet(this.x, this.y, 2.0 * Math.sin(angle), 0.5 * Math.cos(angle));
                    } else {
                        new EnemyBullet(this.x, this.y, 2.0 * Math.sin(angle), 5.5 * Math.cos(angle));
                    }
                }
            }
        }
    }

    public class Bat
    extends JGObject {
        double speed;
        int orient;
        int delay = 0;

        public Bat(double x, double y, int orient, double speed) {
            super("nat", true, x, y, 4, "bat_d");
            this.speed = speed;
            this.orient = orient;
            this.stopAnim();
        }

        public void move() {
            if (CavernsOfFire.this.player != null) {
                if (Math.abs(CavernsOfFire.this.player.x - this.x) < 100.0 && this.xspeed == 0.0 && this.yspeed == 0.0 && this.delay == 0) {
                    this.delay = this.random(5, 25, 1);
                }
                if (this.delay > 0 && --this.delay == 0) {
                    JGPoint cen = this.getCenterTile();
                    if ((this.y > CavernsOfFire.this.player.y && this.orient == -1 || this.y < CavernsOfFire.this.player.y && this.orient == 1) && (this.x < CavernsOfFire.this.player.x && !Bat.and(CavernsOfFire.this.getTileCid(cen, 1, 0), 1) || this.x >= CavernsOfFire.this.player.x && !Bat.and(CavernsOfFire.this.getTileCid(cen, -1, 0), 1))) {
                        double angle = CavernsOfFire.this.atan2(CavernsOfFire.this.player.x - this.x, CavernsOfFire.this.player.y - this.y);
                        if (this.y > CavernsOfFire.this.player.y) {
                            this.xspeed = 2.0 * Math.sin(angle);
                            this.yspeed = 7.0 * Math.cos(angle);
                        } else {
                            this.xspeed = 2.0 * Math.sin(angle);
                            this.yspeed = 0.5 * Math.cos(angle);
                        }
                        this.startAnim();
                    } else if (Bat.and(CavernsOfFire.this.getTileCid(cen, 1, 0), 1) && Bat.and(CavernsOfFire.this.getTileCid(cen, -1, 0), 1)) {
                        this.yspeed = this.y > CavernsOfFire.this.player.y ? -7.0 : 0.5;
                        this.startAnim();
                    }
                }
            }
            if (this.xspeed != 0.0 || this.yspeed != 0.0) {
                this.yspeed += 0.07;
            }
        }

        public void hit_bg(int tilecid) {
            this.xspeed = 0.0;
            this.yspeed = 0.0;
            this.snapToGrid(16.0, 16.0);
            JGPoint cen = this.getCenterTile();
            this.orient = -1;
            for (int yofs = 0; yofs < 20 && !Bat.and(CavernsOfFire.this.getTileCid(cen, 0, yofs), 1); ++yofs) {
                if (!Bat.and(CavernsOfFire.this.getTileCid(cen, 0, -yofs), 1)) continue;
                this.orient = 1;
                break;
            }
            this.setGraphic("bat_" + (this.orient > 0 ? "d" : "u"));
            this.stopAnim();
            int foundx = 0;
            int foundy = 0;
            for (int yofs = 20; yofs >= 0; --yofs) {
                for (int xofs = -1; xofs <= 1; xofs += 2) {
                    if (Bat.and(CavernsOfFire.this.getTileCid(cen, xofs, -this.orient * (yofs - 1)), 1) && !Bat.and(CavernsOfFire.this.getTileCid(cen, xofs, -this.orient * (yofs - 2)), 1)) {
                        foundx = xofs;
                        foundy = -this.orient * (yofs - 2);
                    }
                    if (!Bat.and(CavernsOfFire.this.getTileCid(cen, 0, -this.orient * yofs), 1) || Bat.and(CavernsOfFire.this.getTileCid(cen, 0, -this.orient * (yofs - 1)), 1)) continue;
                    foundx = 0;
                    foundy = -this.orient * (yofs - 1);
                }
            }
            this.x = (cen.x + foundx) * CavernsOfFire.this.tileWidth();
            this.y = (cen.y + foundy) * CavernsOfFire.this.tileHeight();
        }
    }

    public class Jelly
    extends JGObject {
        double speed;

        public Jelly(double x, double y, int xdir, double speed) {
            super("jelly", true, x, y, 4, null);
            this.setDirSpeed(xdir, 0, speed, speed / 10.0);
            this.speed = speed;
        }

        public void move() {
            this.ydir = Math.abs(this.x - CavernsOfFire.this.player.x) < 64.0 ? (this.y > CavernsOfFire.this.player.y ? -1 : 1) : 0;
            this.setGraphic("jelly" + (this.xdir < 0 ? "l" : "r"));
        }

        public void hit_bg(int tilecid) {
            this.xdir = -this.xdir;
            this.ydir = -this.ydir;
        }
    }

    public class Coil
    extends JGObject {
        double accel;

        public Coil(double x, double y, int xdir, int ydir, double accel) {
            super("coil", true, x, y, 4, "coil");
            this.setDirSpeed(xdir, ydir, 0.0, accel / 2.0);
            this.accel = accel;
        }

        public void move() {
            JGPoint cen = this.getCenterTile();
            if (Coil.and(CavernsOfFire.this.getTileCid(cen, 0, this.ydir * 5), 1)) {
                this.ydir = -this.ydir;
                this.yspeed = -this.yspeed;
            }
            if (this.yspeed < this.accel) {
                this.yspeed += this.accel * 0.05;
            }
            this.setAnimSpeed((double)this.ydir * this.yspeed / 5.0);
        }
    }

    public class Bullet
    extends JGObject {
        public Bullet(double x, double y, double xspeed, double yspeed) {
            super("bullet", true, x, y, 2, "bullet", -2);
            this.setSpeed(xspeed, yspeed);
            if (!CavernsOfFire.this.isMidlet()) {
                CavernsOfFire.this.playAudio("shoot");
            }
        }

        public void move() {
            this.yspeed += 0.1;
        }

        public void hit(JGObject obj) {
            this.remove();
            if (!Bullet.and(obj.colid, 16)) {
                obj.remove();
                CavernsOfFire.this.score = obj instanceof Bat ? (CavernsOfFire.this.score += 10) : (obj instanceof Tank ? (CavernsOfFire.this.score += 20) : (CavernsOfFire.this.score += 5));
                new Explo(this.x + 8.0, this.y + 8.0);
                if (CavernsOfFire.this.isMidlet()) {
                    CavernsOfFire.this.playAudio("explo0");
                } else {
                    CavernsOfFire.this.playAudio("explo" + this.random(0, 1, 1));
                }
            }
        }

        public void hit_bg(int tilecid) {
            this.remove();
        }
    }

    public class Player
    extends JGObject {
        int invulnerability;
        int landed;
        int gassing;
        double firedelay;
        boolean started;
        double lastang;

        public Player(double x, double y) {
            super("player", false, x, y, 1, "ship");
            this.invulnerability = (int)(80.0 / CavernsOfFire.this.getGameSpeed());
            this.landed = 0;
            this.gassing = 0;
            this.firedelay = 0.0;
            this.started = false;
            this.lastang = 0.0;
        }

        public void move() {
            if (this.invulnerability > 0) {
                this.setGraphic(CavernsOfFire.this.seqtimer % 8.0 < 4.0 ? "ship" : null);
                if (this.started) {
                    --this.invulnerability;
                }
            } else {
                this.setGraphic("ship");
            }
            if (!this.started) {
                if (CavernsOfFire.this.getMouseButton(1) || CavernsOfFire.this.getKey(42) || CavernsOfFire.this.getKey(90)) {
                    this.started = true;
                }
                return;
            }
            JGPoint tl = this.getTopLeftTile();
            if (this.xspeed == 0.0 && this.yspeed < 1.0 && tl != null && Player.and(CavernsOfFire.this.getTileCid(tl, 0, 1), 4)) {
                int n = this.landed++;
                if ((double)n > 30.0 / CavernsOfFire.this.getGameSpeed() && CavernsOfFire.this.getTileStr(tl.x, tl.y + 1).equals("[")) {
                    CavernsOfFire.this.setTiles(tl.x, tl.y + 1, new String[]{"()"});
                    --CavernsOfFire.this.nr_pads;
                    CavernsOfFire.this.score += 25;
                    CavernsOfFire.this.playAudio("land");
                }
                if (CavernsOfFire.this.hasAccelerometer()) {
                    if (CavernsOfFire.this.getAccelY() < 0.0) {
                        this.yspeed = 0.95 * (this.yspeed + 0.05 * CavernsOfFire.this.getAccelY()) + 0.05 * CavernsOfFire.this.getAccelY();
                    }
                } else if (CavernsOfFire.this.isMidlet() && CavernsOfFire.this.getMouseButton(1)) {
                    this.lastang = CavernsOfFire.this.atan2((double)(CavernsOfFire.this.getMouseX() - 8 + CavernsOfFire.this.viewXOfs()) - this.x, (double)(CavernsOfFire.this.getMouseY() - 8 + CavernsOfFire.this.viewYOfs()) - this.y);
                    double dx = 0.2 * Math.sin(this.lastang);
                    double dy = 0.2 * Math.cos(this.lastang);
                    if (dy < 0.0) {
                        this.yspeed += dy;
                    }
                }
            } else {
                this.landed = 0;
                if (!CavernsOfFire.this.hasAccelerometer()) {
                    this.yspeed += 0.01;
                }
                if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_down)) {
                    this.yspeed += 0.3;
                }
                if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_left)) {
                    this.xspeed -= 0.3;
                }
                if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_right)) {
                    this.xspeed += 0.3;
                }
                if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_fire) && CavernsOfFire.this.countObjects("bullet", 0) < 7) {
                    CavernsOfFire.this.clearKey(CavernsOfFire.this.key_fire);
                    new Bullet(this.x, this.y, (int)(this.xspeed * 2.5), (int)(this.yspeed * 2.5 - 1.0));
                }
                if (this.x + this.xspeed * gamespeed < 0.0) {
                    this.xspeed = -this.xspeed;
                }
                if (this.x + this.xspeed * gamespeed >= (double)(CavernsOfFire.this.pfWidth() - 16)) {
                    this.xspeed = -this.xspeed;
                }
                if (CavernsOfFire.this.hasAccelerometer()) {
                    this.xspeed = 0.95 * (this.xspeed + 0.05 * CavernsOfFire.this.getAccelX()) + 0.05 * CavernsOfFire.this.getAccelX();
                    this.yspeed = 0.95 * (this.yspeed + 0.05 * CavernsOfFire.this.getAccelY()) + 0.05 * CavernsOfFire.this.getAccelY();
                    if (CavernsOfFire.this.getMouseButton(1) && CavernsOfFire.this.countObjects("bullet", 0) < 7 && this.firedelay <= 0.0) {
                        double ang = CavernsOfFire.this.atan2((double)(CavernsOfFire.this.getMouseX() - 8 + CavernsOfFire.this.viewXOfs()) - this.x, (double)(CavernsOfFire.this.getMouseY() - 8 + CavernsOfFire.this.viewYOfs()) - this.y);
                        new Bullet(this.x, this.y, (int)(7.0 * Math.sin(ang)), (int)(7.0 * Math.cos(ang)));
                        this.firedelay = 6.0;
                    }
                } else if (CavernsOfFire.this.getMouseButton(1) && (CavernsOfFire.this.getMouseX() >= 48 || CavernsOfFire.this.getMouseY() <= viewheight - 48)) {
                    this.lastang = CavernsOfFire.this.atan2((double)(CavernsOfFire.this.getMouseX() - 8 + CavernsOfFire.this.viewXOfs()) - this.x, (double)(CavernsOfFire.this.getMouseY() - 8 + CavernsOfFire.this.viewYOfs()) - this.y);
                    if (CavernsOfFire.this.isMidlet()) {
                        this.xspeed += 0.2 * Math.sin(this.lastang);
                        this.yspeed += 0.2 * Math.cos(this.lastang);
                    }
                    if (CavernsOfFire.this.countObjects("bullet", 0) < 7 && this.firedelay <= 0.0) {
                        new Bullet(this.x, this.y, (int)(7.0 * Math.sin(this.lastang)), (int)(7.0 * Math.cos(this.lastang)));
                        this.firedelay = 6.0;
                    }
                }
            }
            if (this.firedelay > 0.0) {
                this.firedelay -= gamespeed;
            }
            if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_up)) {
                this.yspeed -= 0.3;
            }
            if (CavernsOfFire.this.getKey(CavernsOfFire.this.key_up) || CavernsOfFire.this.hasAccelerometer() && CavernsOfFire.this.getAccelY() < this.random(-0.4, 0.2) || !CavernsOfFire.this.hasAccelerometer() && CavernsOfFire.this.getMouseButton(1) && Math.cos(this.lastang) < -0.2) {
                if (this.gassing < 6) {
                    ++this.gassing;
                }
            } else if (this.gassing > 0) {
                --this.gassing;
            }
        }

        public void hit(JGObject obj) {
            if (this.invulnerability <= 0) {
                CavernsOfFire.this.lifeLost();
                obj.remove();
                CavernsOfFire.this.playAudio("playerexplo");
            }
        }

        public void hit_bg(int tilecid, int tx, int ty, int twidth, int theight) {
            if (!Player.and(tilecid, 4)) {
                CavernsOfFire.this.lifeLost();
                CavernsOfFire.this.playAudio("playerexplo");
            } else {
                JGPoint padpos = new JGPoint(tx, ty);
                for (int dy = 0; dy < theight; ++dy) {
                    for (int dx = 0; dx < twidth; ++dx) {
                        String tile = CavernsOfFire.this.getTileStr(tx + dx, ty + dy);
                        if (tile.equals("[") || tile.equals("(")) {
                            padpos.x = tx + dx;
                            padpos.y = ty + dy;
                        }
                        if (!tile.equals("]") && !tile.equals(")")) continue;
                        padpos.x = tx + dx - 1;
                        padpos.y = ty + dy;
                    }
                }
                double newx = padpos.x * CavernsOfFire.this.tileWidth() + 8;
                double newy = padpos.y * CavernsOfFire.this.tileHeight() - 16;
                if (Math.abs(newx - this.x) + Math.abs(newy - this.y) > 16.0) {
                    CavernsOfFire.this.lifeLost();
                    CavernsOfFire.this.playAudio("playerexplo");
                } else {
                    this.setPos(newx, newy);
                    this.setSpeed(0.0, 0.0);
                }
            }
        }

        public void paint() {
            CavernsOfFire.this.setColor(CavernsOfFire.this.cycleColor(new JGColor[]{JGColor.red, JGColor.yellow}, CavernsOfFire.this.timer, 0.5));
            if (this.gassing > 1) {
                CavernsOfFire.this.drawOval((int)this.x + 8, (int)this.y + 17 + this.gassing, 3 * this.gassing / 2, this.gassing * 3, true, true);
            }
            if (this.started) {
                return;
            }
            CavernsOfFire.this.setColor(JGColor.white);
            CavernsOfFire.this.setFont(msgfont);
            if (CavernsOfFire.this.hasAccelerometer()) {
                CavernsOfFire.this.drawString("Hold device horizontally.", CavernsOfFire.this.viewWidth() / 2, 2 * CavernsOfFire.this.viewHeight() / 3 - 20, 0);
            }
            CavernsOfFire.this.drawString("Touch / * / Z to begin.", CavernsOfFire.this.viewWidth() / 2, 2 * CavernsOfFire.this.viewHeight() / 3 + 10, 0);
            CavernsOfFire.this.drawString("Level " + (CavernsOfFire.this.stage + 1), CavernsOfFire.this.viewWidth() / 2, CavernsOfFire.this.viewHeight() / 3 - 50, 0);
            if (CavernsOfFire.this.lavaarea > 12) {
                CavernsOfFire.this.drawString("Lava level.", CavernsOfFire.this.viewWidth() / 2, CavernsOfFire.this.viewHeight() / 3 - 20, 0);
                CavernsOfFire.this.drawString("Land on all platforms!", CavernsOfFire.this.viewWidth() / 2, CavernsOfFire.this.viewHeight() / 3 + 10, 0);
            } else {
                CavernsOfFire.this.drawString("Shoot all monsters or", CavernsOfFire.this.viewWidth() / 2, CavernsOfFire.this.viewHeight() / 3 - 20, 0);
                CavernsOfFire.this.drawString("land on all platforms.", CavernsOfFire.this.viewWidth() / 2, CavernsOfFire.this.viewHeight() / 3 + 10, 0);
            }
        }
    }
}

