/*
 * Decompiled with CFR 0.152.
 */
package examples.packetstorm;

import jgame.Highscore;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class PacketStorm
extends StdGame {
    static final int nrxsegs = 7;
    static final int xsegsize = 5;
    static final int nrysegs = 7;
    static final int ysegsize = 4;
    int prevxseg = -1;
    int prevyseg = -1;
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);

    public static void main(String[] args) {
        new PacketStorm(PacketStorm.parseSizeArgs(args, 0));
    }

    public PacketStorm() {
        this.initEngineApplet();
    }

    public PacketStorm(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(36, 29, 16, 16, null, null, null);
    }

    public void initGame() {
        this.defineMedia("packet_storm.tbl");
        this.setFrameRate(35.0, 1.0);
        this.key_startgame = 256;
        this.key_continuegame = 256;
        this.setHighscores(10, new Highscore(0, "nobody"), 15);
    }

    public void initNewLife() {
        this.removeObjects(null, 0);
        new Cursor();
    }

    public void incrementLevel() {
        if (this.level < 5) {
            ++this.level;
        }
        ++this.stage;
    }

    public void defineLevel() {
        int y;
        int x;
        this.removeObjects(null, 0);
        this.fillBG("lb");
        for (x = 0; x < this.pfTilesX(); x += 35) {
            for (y = 0; y < this.pfTilesY(); ++y) {
                this.setTile(x, y, "k");
            }
        }
        for (int y2 = 0; y2 < this.pfTilesY(); y2 += 28) {
            for (int x2 = 0; x2 < this.pfTilesX(); ++x2) {
                this.setTile(x2, y2, "k");
            }
        }
        for (x = 0; x < this.pfTilesX(); x += 5) {
            for (y = 0; y < this.pfTilesY(); y += 4) {
                this.setTile(x, y, "k");
            }
        }
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void startInGame() {
        this.clearMouseButton(1);
    }

    public void startLifeLost() {
        this.playAudio("die");
        this.clearKey(this.key_continuegame);
    }

    public void doFrameLifeLost() {
        this.moveObjects(null, 2);
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(1, 2);
        if (this.checkTime(0, 2500, 210 - 20 * this.stage)) {
            for (int i = 0; i < 2; ++i) {
                int ydir;
                int xdir;
                int ypos;
                int xpos;
                do {
                    if (this.random(0.0, 1.0) > 0.5) {
                        xpos = this.random(5, 30, 5);
                        ypos = this.random(0, 28, 28);
                        xdir = 0;
                        ydir = ypos == 0 ? 1 : -1;
                        continue;
                    }
                    xpos = this.random(0, 35, 35);
                    ypos = this.random(4, 24, 4);
                    xdir = xpos == 0 ? 1 : -1;
                    ydir = 0;
                } while (this.getTileCid(xpos, ypos) != 0);
                if (i == 0) {
                    new Packet(xpos * this.tileWidth(), ypos * this.tileHeight(), xdir, ydir);
                    continue;
                }
                new Sink(xpos * this.tileWidth(), ypos * this.tileHeight());
            }
        }
        if (this.gametime >= 2500.0 && this.countObjects("packet", 0) == 0) {
            this.levelDone();
        }
        if (this.getMouseButton(1)) {
            int xseg = this.getMouseX() / (this.tileWidth() * 5);
            int yseg = this.getMouseY() / (this.tileHeight() * 4);
            if (this.prevxseg != xseg || this.prevyseg != yseg) {
                this.prevxseg = xseg;
                this.prevyseg = yseg;
                this.flipSegment(xseg, yseg);
            }
        } else {
            this.prevxseg = -1;
            this.prevyseg = -1;
        }
    }

    void flipSegment(int xseg, int yseg) {
        if (xseg < 0 || xseg >= 7 || yseg < 0 || yseg >= 7) {
            return;
        }
        int left = xseg * 5;
        int top = yseg * 4;
        int right = (xseg + 1) * 5;
        int bottom = (yseg + 1) * 4;
        int oncount = 0;
        for (int x = 0; x <= 5; x += 5) {
            for (int yi = 1; yi < 4; ++yi) {
                if (left + x <= 0 || left + x >= 35) continue;
                if (this.and(this.getTileCid(left + x, top + yi), 1)) {
                    ++oncount;
                }
                this.setTile(left + x, top + yi, this.and(this.getTileCid(left + x, top + yi), 1) ? "k" : "lb");
            }
        }
        for (int y = 0; y <= 4; y += 4) {
            for (int xi = 1; xi < 5; ++xi) {
                if (top + y <= 0 || top + y >= 28) continue;
                if (this.and(this.getTileCid(left + xi, top + y), 1)) {
                    ++oncount;
                }
                this.setTile(left + xi, top + y, this.and(this.getTileCid(left + xi, top + y), 1) ? "k" : "lb");
            }
        }
        if (oncount > 8) {
            this.playAudio("toggle1");
        } else {
            this.playAudio("toggle2");
        }
    }

    public class Sink
    extends JGObject {
        public Sink(double x, double y) {
            super("sink", true, x, y, 2, "white16");
            JGPoint cen = this.getCenterTile();
            PacketStorm.this.setTileCid(cen.x, cen.y, 2);
        }

        public void hit(JGObject obj) {
            JGPoint cen = this.getCenterTile();
            this.remove();
            obj.remove();
            PacketStorm.this.playAudio("packetdone");
        }

        public void destroy() {
            JGPoint cen = this.getCenterTile();
            PacketStorm.this.setTileCid(cen.x, cen.y, 0);
        }
    }

    public class Packet
    extends JGObject {
        int waittime = 150;
        JGPoint[] trail = new JGPoint[100];
        int traillen = 0;

        public Packet(double x, double y, int xdir, int ydir) {
            super("packet", true, x, y, 1, "packet_wait");
            this.setDir(xdir, ydir);
            JGPoint cen = this.getCenterTile();
            PacketStorm.this.setTileCid(cen.x, cen.y, 1);
            PacketStorm.this.playAudio("newpacket");
            for (int i = 0; i < 100; ++i) {
                this.trail[i] = new JGPoint(0, 0);
            }
        }

        void clearTrail() {
            for (int i = 0; i < this.traillen; ++i) {
            }
            this.traillen = 0;
        }

        boolean checkAhead(int tx, int ty, int xdir, int ydir) {
            if (Packet.and(PacketStorm.this.getTileCid(tx, ty), 1)) {
                return false;
            }
            if (Packet.and(PacketStorm.this.getTileCid(tx, ty), 2)) {
                return true;
            }
            if (Packet.and(PacketStorm.this.getTileCid(tx, ty), 4)) {
                return false;
            }
            if (tx <= 0 || tx >= 35) {
                return false;
            }
            if (ty <= 0 || ty >= 28) {
                return false;
            }
            if (this.traillen == 100) {
                return false;
            }
            ++this.traillen;
            if (Packet.and(PacketStorm.this.getTileCid(tx + xdir, ty + ydir), 1)) {
                if (PacketStorm.this.getTileCid(tx + ydir, ty + xdir) == 0) {
                    return this.checkAhead(tx + ydir, ty + xdir, ydir, xdir);
                }
                if (PacketStorm.this.getTileCid(tx - ydir, ty - xdir) == 0) {
                    return this.checkAhead(tx - ydir, ty - xdir, -ydir, -xdir);
                }
                return false;
            }
            return this.checkAhead(tx + xdir, ty + ydir, xdir, ydir);
        }

        public void move() {
            JGPoint cen = this.getCenterTile();
            if (this.waittime > 0) {
                --this.waittime;
                if (this.waittime == 0) {
                    PacketStorm.this.setTileCid(cen.x, cen.y, 0);
                    this.setSpeed(0.8, 0.8);
                    this.x += (double)this.xdir * this.xspeed;
                    this.y += (double)this.ydir * this.yspeed;
                    this.setGraphic("packet_move");
                    PacketStorm.this.playAudio("release");
                    if (Packet.and(PacketStorm.this.getTileCid(this.getCenterTile(), this.xdir, this.ydir), 1)) {
                        this.setGraphic("packet_die");
                        this.setSpeed(0.0, 0.0);
                        PacketStorm.this.lifeLost();
                    }
                }
            }
            if (this.waittime <= 0) {
                if (this.isXAligned() && this.isYAligned()) {
                    if (cen.x <= 0 || cen.x >= 35 || cen.y <= 0 || cen.y >= 28) {
                        PacketStorm.this.lifeLost();
                    }
                    this.snapToGrid();
                    if (Packet.and(PacketStorm.this.getTileCid(cen, this.xdir, this.ydir), 1)) {
                        if (PacketStorm.this.getTileCid(cen, this.ydir, this.xdir) == 0) {
                            int t = this.xdir;
                            this.xdir = this.ydir;
                            this.ydir = t;
                        } else if (PacketStorm.this.getTileCid(cen, -this.ydir, -this.xdir) == 0) {
                            int t = this.xdir;
                            this.xdir = -this.ydir;
                            this.ydir = -t;
                        } else {
                            this.setGraphic("packet_die");
                            this.setSpeed(0.0, 0.0);
                            PacketStorm.this.lifeLost();
                        }
                    }
                }
                if (this.checkAhead(cen.x, cen.y, this.xdir, this.ydir)) {
                    this.setGraphic("packet_die");
                    this.setSpeed(3.0, 3.0);
                } else {
                    this.setGraphic("packet_move");
                    this.setSpeed(0.8, 0.8);
                }
                this.clearTrail();
            }
        }

        public void destroy() {
            this.clearTrail();
        }
    }

    public class Cursor
    extends JGObject {
        public Cursor() {
            super("cursor", false, 16.0, 16.0, 1, null);
        }

        public void move() {
            this.setDir(0, 0);
            if (PacketStorm.this.getKey(PacketStorm.this.key_up) && this.y > this.yspeed) {
                this.ydir = -1;
            }
            if (PacketStorm.this.getKey(PacketStorm.this.key_down) && this.y < (double)(PacketStorm.this.pfHeight() - 16) - this.yspeed) {
                this.ydir = 1;
            }
            if (PacketStorm.this.getKey(PacketStorm.this.key_left) && this.x > this.xspeed) {
                this.xdir = -1;
            }
            if (PacketStorm.this.getKey(PacketStorm.this.key_right) && this.x < (double)(PacketStorm.this.pfWidth() - 32) - this.yspeed) {
                this.xdir = 1;
            }
        }
    }
}

