/*
 * Decompiled with CFR 0.152.
 */
package jgame;

import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.impl.Animation;
import jgame.impl.JGEngineInterface;

public class JGObject {
    static int next_id = 0;
    static JGEngineInterface default_engine = null;
    public static int viewwidth;
    public static int viewheight;
    public static int tilewidth;
    public static int tileheight;
    public static boolean pfwrapx;
    public static boolean pfwrapy;
    public static double gamespeed;
    public static int pfwidth;
    public static int pfheight;
    public static int viewxofs;
    public static int viewyofs;
    public static final int expire_never = -1;
    public static final int expire_off_pf = -2;
    public static final int expire_off_view = -3;
    public static final int suspend_off_view = -4;
    public static final int suspend_off_view_expire_off_pf = -5;
    public double x = 0.0;
    public double y = 0.0;
    public double xspeed = 0.0;
    public double yspeed = 0.0;
    public int xdir = 1;
    public int ydir = 1;
    public int colid;
    String name;
    public double expiry = -1.0;
    public boolean resume_in_view = true;
    private boolean is_alive = true;
    public boolean is_suspended = false;
    String imgname = null;
    Animation anim = null;
    String animid = null;
    JGRectangle imgbbox = null;
    JGRectangle tilebbox = null;
    JGRectangle bbox = null;
    public JGEngineInterface eng;
    double lastx = 0.0;
    double lasty = 0.0;
    JGRectangle lastbbox_copy = new JGRectangle();
    JGRectangle lasttilebbox_copy = new JGRectangle();
    JGRectangle lastbbox = null;
    JGRectangle lasttilebbox = null;
    JGRectangle temp_bbox_copy = new JGRectangle();
    JGRectangle tiles_copy = null;
    JGRectangle last_tiles_copy = null;
    JGRectangle center_tiles_copy = new JGRectangle();
    JGRectangle last_center_tiles_copy = null;
    JGPoint center_tile_copy = null;
    JGPoint tl_tile_copy = null;

    public static boolean setEngine(JGEngineInterface engine) {
        if (engine == null) {
            default_engine = null;
            return true;
        }
        if (default_engine != null) {
            return false;
        }
        default_engine = engine;
        viewwidth = engine.viewWidth();
        viewheight = engine.viewHeight();
        tilewidth = engine.tileWidth();
        tileheight = engine.tileHeight();
        JGObject.updateEngineSettings();
        return true;
    }

    public static void updateEngineSettings() {
        pfwrapx = default_engine.pfWrapX();
        pfwrapy = default_engine.pfWrapY();
        gamespeed = default_engine.getGameSpeed();
        pfwidth = default_engine.pfWidth();
        pfheight = default_engine.pfHeight();
        viewxofs = default_engine.viewXOfs();
        viewyofs = default_engine.viewYOfs();
    }

    public void dbgPrint(String msg) {
        this.eng.dbgPrint(this.name, msg);
    }

    public String getName() {
        return this.name;
    }

    public String getImageName() {
        return this.imgname;
    }

    private void initObject(JGEngineInterface engine, String name, int collisionid) {
        this.eng = engine;
        this.name = name;
        this.colid = collisionid;
        if (!((int)this.expiry != -4 && (int)this.expiry != -5 || this.isInView(this.eng.getOffscreenMarginX(), this.eng.getOffscreenMarginY()))) {
            this.suspend();
        }
        this.eng.markAddObject(this);
    }

    public void clearTileBBox() {
        this.tilebbox = null;
    }

    public void setTileBBox(int x, int y, int width, int height) {
        this.tilebbox = new JGRectangle(x, y, width, height);
    }

    public void setBBox(int x, int y, int width, int height) {
        this.bbox = new JGRectangle(x, y, width, height);
    }

    public void clearBBox() {
        this.bbox = null;
    }

    public void setPos(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setSpeedAbs(double xspeed, double yspeed) {
        if (xspeed < 0.0) {
            this.xdir = -1;
            this.xspeed = -xspeed;
        } else if (xspeed == 0.0) {
            this.xdir = 0;
            this.xspeed = 0.0;
        } else {
            this.xdir = 1;
            this.xspeed = xspeed;
        }
        if (yspeed < 0.0) {
            this.ydir = -1;
            this.yspeed = -yspeed;
        } else if (yspeed == 0.0) {
            this.ydir = 0;
            this.yspeed = 0.0;
        } else {
            this.ydir = 1;
            this.yspeed = yspeed;
        }
    }

    public void setDirSpeed(int xdir, int ydir, double xspeed, double yspeed) {
        this.xdir = xdir;
        this.ydir = ydir;
        this.xspeed = xspeed;
        this.yspeed = yspeed;
    }

    public void setDirSpeed(int xdir, int ydir, double speed) {
        this.xdir = xdir;
        this.ydir = ydir;
        this.xspeed = speed;
        this.yspeed = speed;
    }

    public void setSpeed(double xspeed, double yspeed) {
        this.xspeed = xspeed;
        this.yspeed = yspeed;
    }

    public void setSpeed(double speed) {
        this.xspeed = speed;
        this.yspeed = speed;
    }

    public void setDir(int xdir, int ydir) {
        this.xdir = xdir;
        this.ydir = ydir;
    }

    public void setGraphic(String gfxname) {
        if (gfxname == null) {
            this.setImage(gfxname);
        } else {
            Animation newanim = this.eng.getAnimation(gfxname);
            if (newanim != null) {
                this.setAnim(gfxname);
            } else {
                this.setImage(gfxname);
            }
        }
    }

    public void setImage(String imgname) {
        this.imgname = imgname;
        this.imgbbox = null;
        this.anim = null;
        this.animid = null;
    }

    public String getGraphic() {
        if (this.animid != null) {
            return this.animid;
        }
        return this.imgname;
    }

    public void setAnim(String anim_id) {
        if (this.animid == null || !this.animid.equals(anim_id)) {
            this.anim = this.eng.getAnimation(anim_id);
            if (this.anim == null) {
                this.eng.dbgPrint(this.name, "Warning: animation " + anim_id + " not found.");
                return;
            }
            this.anim = this.anim.copy();
            this.animid = anim_id;
            this.imgname = this.anim.getCurrentFrame();
        }
    }

    public void resetAnim(String anim_id) {
        this.anim = this.eng.getAnimation(anim_id).copy();
        this.animid = anim_id;
    }

    public void clearAnim() {
        this.anim = null;
        this.animid = null;
    }

    public String getAnimId() {
        return this.animid;
    }

    public void setAnimSpeed(double speed) {
        if (this.anim != null) {
            if (speed >= 0.0) {
                this.anim.speed = speed;
                this.anim.increment = 1;
            } else {
                this.anim.speed = -speed;
                this.anim.increment = -1;
            }
        }
    }

    public void setAnimPingpong(boolean pingpong) {
        if (this.anim != null) {
            this.anim.pingpong = pingpong;
        }
    }

    public void startAnim() {
        if (this.anim != null) {
            this.anim.start();
        }
    }

    public void stopAnim() {
        if (this.anim != null) {
            this.anim.stop();
        }
    }

    public void resetAnim() {
        if (this.anim != null) {
            this.anim.reset();
        }
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname) {
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setPos(x, y);
        this.setGraphic(gfxname);
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int expiry) {
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setPos(x, y);
        this.setGraphic(gfxname);
        this.expiry = expiry;
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int tilebbox_x, int tilebbox_y, int tilebbox_width, int tilebbox_height) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setTileBBox(tilebbox_x, tilebbox_y, tilebbox_width, tilebbox_height);
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int tilebbox_x, int tilebbox_y, int tilebbox_width, int tilebbox_height, int expiry) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setTileBBox(tilebbox_x, tilebbox_y, tilebbox_width, tilebbox_height);
        this.expiry = expiry;
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, double xspeed, double yspeed) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setSpeedAbs(xspeed, yspeed);
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, double xspeed, double yspeed, int expiry) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setSpeedAbs(xspeed, yspeed);
        this.expiry = expiry;
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int tilebbox_x, int tilebbox_y, int tilebbox_width, int tilebbox_height, double xspeed, double yspeed) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setTileBBox(tilebbox_x, tilebbox_y, tilebbox_width, tilebbox_height);
        this.setSpeedAbs(xspeed, yspeed);
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int tilebbox_x, int tilebbox_y, int tilebbox_width, int tilebbox_height, double xspeed, double yspeed, int expiry) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setTileBBox(tilebbox_x, tilebbox_y, tilebbox_width, tilebbox_height);
        this.setSpeedAbs(xspeed, yspeed);
        this.expiry = expiry;
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int xdir, int ydir, double xspeed, double yspeed, int expiry) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setDirSpeed(xdir, ydir, xspeed, yspeed);
        this.expiry = expiry;
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int tilebbox_x, int tilebbox_y, int tilebbox_width, int tilebbox_height, int xdir, int ydir, double xspeed, double yspeed, int expiry) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setTileBBox(tilebbox_x, tilebbox_y, tilebbox_width, tilebbox_height);
        this.setDirSpeed(xdir, ydir, xspeed, yspeed);
        this.expiry = expiry;
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int expiry, double xspeed, double yspeed) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setTileBBox(this.tilebbox.x, this.tilebbox.y, this.tilebbox.width, this.tilebbox.height);
        this.setSpeedAbs(xspeed, yspeed);
        this.expiry = expiry;
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int expiry, double xspeed, double yspeed, int xdir, int ydir) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setDirSpeed(xdir, ydir, xspeed, yspeed);
        this.expiry = expiry;
    }

    public JGObject(String name, boolean unique_id, double x, double y, int collisionid, String gfxname, int expiry, double xspeed, double yspeed, int xdir, int ydir, JGRectangle tilebbox) {
        this.setPos(x, y);
        this.initObject(default_engine, name + (unique_id ? "" + next_id++ : ""), collisionid);
        this.setGraphic(gfxname);
        this.setTileBBox(tilebbox.x, tilebbox.y, tilebbox.width, tilebbox.height);
        this.setDirSpeed(xdir, ydir, xspeed, yspeed);
        this.expiry = expiry;
    }

    public boolean getBBox(JGRectangle bbox_copy) {
        if (this.bbox != null) {
            bbox_copy.x = this.bbox.x + (int)this.x;
            bbox_copy.y = this.bbox.y + (int)this.y;
            bbox_copy.width = this.bbox.width;
            bbox_copy.height = this.bbox.height;
            return true;
        }
        if (this.imgbbox == null && this.imgname != null) {
            this.imgbbox = this.eng.getImageBBox(this.imgname);
        }
        if (this.imgbbox != null) {
            bbox_copy.x = this.imgbbox.x + (int)this.x;
            bbox_copy.y = this.imgbbox.y + (int)this.y;
            bbox_copy.width = this.imgbbox.width;
            bbox_copy.height = this.imgbbox.height;
            return true;
        }
        return false;
    }

    public JGRectangle getBBox() {
        if (this.bbox != null) {
            return new JGRectangle(this.bbox.x + (int)this.x, this.bbox.y + (int)this.y, this.bbox.width, this.bbox.height);
        }
        this.updateImageBBox();
        if (this.imgbbox != null) {
            return new JGRectangle(this.imgbbox.x + (int)this.x, this.imgbbox.y + (int)this.y, this.imgbbox.width, this.imgbbox.height);
        }
        return null;
    }

    public boolean getTileBBox(JGRectangle bbox_copy) {
        if (this.tilebbox == null) {
            return this.getBBox(bbox_copy);
        }
        bbox_copy.x = (int)this.x + this.tilebbox.x;
        bbox_copy.y = (int)this.y + this.tilebbox.y;
        bbox_copy.width = this.tilebbox.width;
        bbox_copy.height = this.tilebbox.height;
        return true;
    }

    public JGRectangle getTileBBox() {
        if (this.tilebbox == null) {
            return this.getBBox();
        }
        return new JGRectangle((int)this.x + this.tilebbox.x, (int)this.y + this.tilebbox.y, this.tilebbox.width, this.tilebbox.height);
    }

    public JGRectangle getImageBBox() {
        this.updateImageBBox();
        if (this.imgbbox == null) {
            return null;
        }
        return new JGRectangle(this.imgbbox);
    }

    public JGRectangle getImageBBoxConst() {
        this.updateImageBBox();
        return this.imgbbox;
    }

    void updateImageBBox() {
        if (this.imgbbox == null && this.imgname != null) {
            this.imgbbox = this.eng.getImageBBox(this.imgname);
        }
    }

    public double getLastX() {
        return this.lastx;
    }

    public double getLastY() {
        return this.lasty;
    }

    public void snapToGrid() {
        this.x = this.eng.snapToGridX(this.x, Math.abs(this.xspeed * gamespeed - 0.001));
        this.y = this.eng.snapToGridY(this.y, Math.abs(this.yspeed * gamespeed - 0.001));
    }

    public void snapToGrid(double gridsnapx, double gridsnapy) {
        this.x = this.eng.snapToGridX(this.x, gridsnapx);
        this.y = this.eng.snapToGridY(this.y, gridsnapy);
    }

    public void snapBBoxToGrid(double gridsnapx, double gridsnapy, boolean snap_right, boolean snap_bottom) {
        JGRectangle bbox = this.getTileBBox();
        double bx = this.x + (double)bbox.x;
        double by = this.y + (double)bbox.y;
        if (snap_right) {
            bx += (double)bbox.width;
        }
        if (snap_bottom) {
            by += (double)bbox.height;
        }
        double bxs = this.eng.snapToGridX(bx, gridsnapx);
        double bys = this.eng.snapToGridY(by, gridsnapy);
        bxs -= (double)bbox.x;
        bys -= (double)bbox.y;
        if (snap_right) {
            bxs -= (double)bbox.width;
        }
        if (snap_bottom) {
            bys -= (double)bbox.height;
        }
        this.x = bxs;
        this.y = bys;
    }

    public JGRectangle getTiles() {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            return null;
        }
        if (this.tiles_copy == null) {
            this.tiles_copy = new JGRectangle();
        }
        if (this.eng.getTiles(this.tiles_copy, this.temp_bbox_copy)) {
            return this.tiles_copy;
        }
        return null;
    }

    private JGRectangle getCenterTiles(JGRectangle bbox, JGRectangle tiles_copy) {
        if (bbox.x >= 0) {
            int px = (bbox.x + bbox.width / 2) / tilewidth * tilewidth + tilewidth / 2;
            bbox.x = tilewidth * ((px - bbox.width / 2) / tilewidth);
        } else {
            int px = (bbox.x + bbox.width / 2 - tilewidth + 1) / tilewidth * tilewidth + tilewidth / 2;
            bbox.x = tilewidth * ((px - bbox.width / 2 - tilewidth + 1) / tilewidth);
        }
        if (bbox.y >= 0) {
            int py = (bbox.y + bbox.height / 2) / tileheight * tileheight + tileheight / 2;
            bbox.y = tileheight * ((py - bbox.height / 2) / tileheight);
        } else {
            int py = (bbox.y + bbox.height / 2 - tileheight + 1) / tileheight * tileheight + tileheight / 2;
            bbox.y = tileheight * ((py - bbox.height / 2 - tileheight + 1) / tileheight);
        }
        this.eng.getTiles(tiles_copy, bbox);
        return tiles_copy;
    }

    public JGRectangle getCenterTiles() {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            return null;
        }
        return this.getCenterTiles(this.temp_bbox_copy, this.center_tiles_copy);
    }

    public JGPoint getCenterTile() {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            return null;
        }
        if (this.center_tile_copy == null) {
            this.center_tile_copy = new JGPoint();
        }
        this.getCenterTiles(this.temp_bbox_copy, this.center_tiles_copy);
        this.center_tile_copy.x = this.center_tiles_copy.x;
        this.center_tile_copy.y = this.center_tiles_copy.y;
        return this.center_tile_copy;
    }

    public JGPoint getTopLeftTile() {
        JGRectangle r = this.getTiles();
        if (r == null) {
            return null;
        }
        if (this.tl_tile_copy == null) {
            this.tl_tile_copy = new JGPoint();
        }
        this.tl_tile_copy.x = r.x;
        this.tl_tile_copy.y = r.y;
        return this.tl_tile_copy;
    }

    public boolean isAligned() {
        return this.isXAligned() && this.isYAligned();
    }

    public boolean isXAligned() {
        return this.eng.isXAligned(this.x, Math.abs(this.xspeed * gamespeed - 0.001));
    }

    public boolean isYAligned() {
        return this.eng.isYAligned(this.y, Math.abs(this.yspeed * gamespeed - 0.001));
    }

    public boolean isXAligned(double margin) {
        return this.eng.isXAligned(this.x, margin);
    }

    public boolean isYAligned(double margin) {
        return this.eng.isYAligned(this.y, margin);
    }

    public boolean isLeftAligned(double margin) {
        JGRectangle bbox = this.getTileBBox();
        if (bbox != null) {
            return this.eng.isXAligned(bbox.x, margin);
        }
        return this.eng.isXAligned(this.x, margin);
    }

    public boolean isTopAligned(double margin) {
        JGRectangle bbox = this.getTileBBox();
        if (bbox != null) {
            return this.eng.isYAligned(bbox.y, margin);
        }
        return this.eng.isYAligned(this.y, margin);
    }

    public boolean isRightAligned(double margin) {
        JGRectangle bbox = this.getTileBBox();
        if (bbox != null) {
            return this.eng.isXAligned(bbox.x + bbox.width, margin);
        }
        return this.eng.isXAligned(this.x, margin);
    }

    public boolean isBottomAligned(double margin) {
        JGRectangle bbox = this.getTileBBox();
        if (bbox != null) {
            return this.eng.isYAligned(bbox.y + bbox.height, margin);
        }
        return this.eng.isYAligned(this.y, margin);
    }

    public int checkCollision(int cid, double xofs, double yofs) {
        double oldx = this.x;
        double oldy = this.y;
        this.x += xofs;
        this.y += yofs;
        int retcid = this.eng.checkCollision(cid, this);
        this.x = oldx;
        this.y = oldy;
        return retcid;
    }

    public int checkBGCollision(JGRectangle r) {
        return this.eng.checkBGCollision(r);
    }

    public int checkBGCollision(double xofs, double yofs) {
        double oldx = this.x;
        double oldy = this.y;
        this.x += xofs;
        this.y += yofs;
        JGRectangle bbox = this.getTileBBox();
        this.x = oldx;
        this.y = oldy;
        if (bbox == null) {
            return 0;
        }
        return this.checkBGCollision(bbox);
    }

    public boolean isOnScreen(int marginx, int marginy) {
        return this.isOnPF(marginx, marginy);
    }

    public boolean isInView(int marginx, int marginy) {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            this.temp_bbox_copy.x = (int)this.x;
            this.temp_bbox_copy.y = (int)this.y;
            this.temp_bbox_copy.width = 0;
            this.temp_bbox_copy.height = 0;
        }
        if (this.temp_bbox_copy.x + this.temp_bbox_copy.width < viewxofs - marginx) {
            return false;
        }
        if (this.temp_bbox_copy.y + this.temp_bbox_copy.height < viewyofs - marginy) {
            return false;
        }
        if (this.temp_bbox_copy.x > viewxofs + viewwidth + marginx) {
            return false;
        }
        return this.temp_bbox_copy.y <= viewyofs + viewheight + marginy;
    }

    public boolean isOnPF(int marginx, int marginy) {
        if (!this.getTileBBox(this.temp_bbox_copy)) {
            this.temp_bbox_copy.x = (int)this.x;
            this.temp_bbox_copy.y = (int)this.y;
            this.temp_bbox_copy.width = 0;
            this.temp_bbox_copy.height = 0;
        }
        if (!pfwrapx) {
            if (this.temp_bbox_copy.x + this.temp_bbox_copy.width < -marginx) {
                return false;
            }
            if (this.temp_bbox_copy.x > pfwidth + marginx) {
                return false;
            }
        }
        if (!pfwrapy) {
            if (this.temp_bbox_copy.y + this.temp_bbox_copy.height < -marginy) {
                return false;
            }
            if (this.temp_bbox_copy.y > pfheight + marginy) {
                return false;
            }
        }
        return true;
    }

    public static boolean and(int value, int mask) {
        return (value & mask) != 0;
    }

    public double random(double min, double max) {
        return this.eng.random(min, max);
    }

    public double random(double min, double max, double interval) {
        return this.eng.random(min, max, interval);
    }

    public int random(int min, int max, int interval) {
        return this.eng.random(min, max, interval);
    }

    public void updateAnimation(double gamespeed) {
        if (this.anim != null) {
            this.imgname = this.anim.animate(gamespeed);
            this.imgbbox = null;
        }
    }

    public void frameFinished() {
        this.lastx = this.x;
        this.lasty = this.y;
    }

    public void moduloPos() {
        if (pfwrapx) {
            this.x = this.eng.moduloXPos(this.x);
        }
        if (pfwrapy) {
            this.y = this.eng.moduloYPos(this.y);
        }
    }

    public void suspend() {
        this.is_suspended = true;
    }

    public void resume() {
        this.is_suspended = false;
    }

    public boolean isSuspended() {
        return this.is_suspended;
    }

    public void setResumeMode(boolean resume_in_view) {
        this.resume_in_view = resume_in_view;
    }

    public boolean isAlive() {
        return this.is_alive;
    }

    public final void removeDone() {
        this.destroy();
        this.is_alive = false;
    }

    public void remove() {
        if (this.isAlive()) {
            this.eng.removeObject(this);
        }
        this.is_alive = false;
    }

    public void destroy() {
    }

    public void move() {
    }

    public void hit(JGObject obj) {
    }

    public void hit_bg(int tilecid) {
    }

    public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
    }

    public void hit_bg(int tilecid, int tx, int ty) {
    }

    public void paint() {
    }
}

