/*
 * Decompiled with CFR 0.152.
 */
package examples.insecticide;

import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.JGTimer;
import jgame.platform.JGEngine;

public class Insecticide
extends JGEngine {
    int timer = 0;
    int score = 0;
    int lives = 3;
    int level = 0;
    int stage = 0;
    JGColor bg_color = new JGColor(255, 240, 0);
    JGColor fg_color = new JGColor(100, 50, 0);

    public static void main(String[] args) {
        new Insecticide(0, 0);
    }

    public Insecticide(int w, int h) {
        this.initEngine(w, h);
    }

    public Insecticide() {
        this.initEngineApplet();
    }

    public void initCanvas() {
        this.setCanvasSettings(24, 18, 32, 32, this.fg_color, this.bg_color, null);
    }

    public void initGame() {
        this.defineMedia("insecticide.tbl");
        this.setFrameRate(40.0, 4.0);
        this.setGameState("Title");
        this.createBackground();
        this.setMsgFont(new JGFont("Helvetica", 0, 32.0));
    }

    public void doFrameTitle() {
        if (this.getKey(90)) {
            this.score = 0;
            this.timer = 0;
            this.level = 0;
            this.stage = 0;
            this.lives = 3;
            this.createBackground();
            this.setGameState("InGame");
        }
    }

    public void doFrameInGame() {
        int xdir;
        if (this.timer % 220 - 10 * this.level == 0 && this.timer < 1500 && this.existsObject("player")) {
            int xpos = this.getObject((String)"player").x < (double)(this.pfWidth() / 2) ? this.pfWidth() : -this.tileWidth();
            new Spider(xpos, this.random(this.pfHeight() / 2, this.pfHeight() - this.tileHeight()), (double)this.random(-1, 1, 2) * this.random(2.0, 4.0), (double)this.random(-1, 1, 2) * this.random(2.0, 4.0));
        }
        if (this.timer % 380 - 15 * this.level == 20 && this.timer < 1500) {
            xdir = this.random(-1, 1, 2);
            double xpos = xdir < 0 ? this.random(320.0, this.pfWidth() - 32) : this.random(0.0, this.pfWidth() - 352);
            for (int i = 0; i < 15; ++i) {
                new Scorpion(xpos, 0.0, 1);
                xpos += (double)(32 * xdir);
            }
        }
        if (this.stage > 2 && this.timer % 250 - 5 * this.level - 70 * (this.stage % 3) == 20 && this.timer < 1500 && this.existsObject("player")) {
            xdir = this.getObject((String)"player").x < (double)(this.pfWidth() / 2) ? -1 : 1;
            int xpos = xdir < 0 ? this.pfWidth() : -this.tileWidth();
            new Beetle(xpos, this.random(0.0, this.pfHeight() - 3 * this.tileHeight()), this.random(1.0, 2.0) * (double)xdir, this.random(0.05, 0.2));
        }
        if (this.stage > 1 && this.timer % 250 - 5 * this.level - 90 * (this.stage % 2) == 30 && this.timer < 1500 && this.existsObject("player")) {
            xdir = this.getObject((String)"player").x < (double)(this.pfWidth() / 2) ? -1 : 1;
            int xpos = xdir < 0 ? this.pfWidth() : -this.tileWidth();
            new Worm(xpos, this.random(0.0, this.pfHeight() - 2 * this.tileHeight()), (double)xdir * 4.0);
        }
        this.moveObjects();
        this.checkCollision(2, 1);
        this.checkCollision(1, 4);
        this.checkBGCollision(15, 7);
        ++this.timer;
        if (this.timer > 1500 && this.countObjects(null, 1) == 0 && !this.inGameState("EndLevel")) {
            this.addGameState("EndLevel");
            new JGTimer(100, true, "EndLevel"){

                public void alarm() {
                    Insecticide.this.setGameState("InGame");
                    if (Insecticide.this.level < 10) {
                        ++Insecticide.this.level;
                    }
                    ++Insecticide.this.stage;
                    Insecticide.this.timer = 0;
                    Insecticide.this.createBackground();
                }
            };
        }
    }

    void createBackground() {
        new Player();
        this.setBGImage("empty_" + this.stage % 3);
        this.fillBG("");
        for (int i = 0; i < 15 + this.level; ++i) {
            this.setTile((int)this.random(0.0, this.pfTilesX()), (int)this.random(0.0, this.pfTilesY() - 1), "m");
        }
    }

    public void paintFrame() {
        this.setColor(new JGColor(0, 0, 0));
        this.drawString("Score:" + this.score, 0.0, 0.0, -1);
        this.drawString("Level:" + (this.stage + 1), this.pfWidth() / 2, 0.0, 0);
        this.drawString("Lives:" + this.lives, this.pfWidth(), 0.0, 1);
    }

    public void paintFrameTitle() {
        this.setColor(new JGColor(0, 0, 0));
        this.drawString("Insecticide", this.pfWidth() / 2, this.pfHeight() / 3, 0);
        this.drawString("Press Z to start", this.pfWidth() / 2, 2 * this.pfHeight() / 3, 0);
    }

    public void paintFrameDead() {
        if (this.lives == 1) {
            this.drawString("Game Over", this.pfWidth() / 2, this.pfHeight() / 3, 0);
        }
    }

    public void paintFrameEndLevel() {
        this.drawString("Insects eradicated!", this.pfWidth() / 2, this.pfHeight() / 3, 0);
    }

    public void createExplo(double x, double y, int intensity) {
        for (int i = 0; i < intensity; ++i) {
            new JGObject("explo", true, x, y, 0, "explo", this.random(-5.0, 5.0), this.random(-5.0, 5.0), (int)this.random(10.0, 10 + intensity));
        }
    }

    public class Worm
    extends JGObject {
        int hibernating = -1;

        public Worm(double x, double y, double xspeed) {
            super("worm", true, x, y, 1, null, 0, 0, 32, 32, xspeed, 0.0);
            this.snapToGrid(0.0, 32.0);
        }

        public void move() {
            if (this.random(0.0, 1.0) > 0.96) {
                Insecticide.this.setTile(this.getCenterTile(), "m");
            }
            if (this.xdir < 0) {
                this.setGraphic("worm_l");
            }
            if (this.xdir > 0) {
                this.setGraphic("worm_r");
            }
            if (!this.isOnPF(16, 16)) {
                this.remove();
            }
        }

        public void hit(JGObject obj) {
            Insecticide.this.createExplo(this.x, this.y, 8);
            this.remove();
            obj.remove();
            Insecticide.this.score += 50;
        }
    }

    public class Beetle
    extends JGObject {
        int hibernating = -1;

        public Beetle(double x, double y, double xspeed, double yspeed) {
            super("beetle", true, x, y, 1, null, xspeed, yspeed);
        }

        public void move() {
            if (this.xdir < 0) {
                this.setGraphic("beetle_l");
            }
            if (this.xdir > 0) {
                this.setGraphic("beetle_r");
            }
            if (this.x < 0.0 && this.xdir < 0) {
                this.xdir = -this.xdir;
            }
            if (this.y < 0.0 && this.ydir < 0) {
                this.ydir = -this.ydir;
            }
            if (this.x > (double)(Insecticide.this.pfWidth() - 16) && this.xdir > 0) {
                this.xdir = -this.xdir;
            }
            if (this.y > (double)(Insecticide.this.pfHeight() - 16) && this.ydir > 0) {
                this.ydir = -this.ydir;
            }
            if (this.hibernating == 0) {
                if (Insecticide.this.countObjects("beetle", 0) < 25) {
                    this.remove();
                    new Beetle(this.x - 8.0, this.y - 8.0, -this.xspeed, this.yspeed - 0.05);
                    new Beetle(this.x - 8.0, this.y + 8.0, -this.xspeed, this.yspeed + 0.1);
                    new Beetle(this.x + 8.0, this.y - 8.0, this.xspeed, this.yspeed - 0.05);
                    new Beetle(this.x + 8.0, this.y + 8.0, this.xspeed, this.yspeed + 0.1);
                }
            } else {
                --this.hibernating;
            }
        }

        public void hit(JGObject obj) {
            Insecticide.this.createExplo(this.x, this.y, 8);
            this.remove();
            obj.remove();
            Insecticide.this.score += 15;
        }

        public void hit_bg(int tilecid) {
            if (this.hibernating < 0) {
                this.hibernating = (int)this.random(100.0, 140.0);
                this.setGraphic("mushroom_gr");
                this.setDir(0, 0);
            }
        }

        public void hit_bg(int tilecid, int tx, int ty) {
            Insecticide.this.setTile(tx, ty, "");
            this.setPos(tx * Insecticide.this.tileWidth(), ty * Insecticide.this.tileHeight());
        }
    }

    public class Scorpion
    extends JGObject {
        boolean descending = false;
        int dir = 1;

        public Scorpion(double x, double y, int dir) {
            super("scorpion", true, x, y, 1, "scorpion_r", 0, 0, 32, 32, 0, 0, 5.0, 9.5, -1);
        }

        public void move() {
            if (this.dir > 0) {
                this.setImage("scorpion_r");
            } else {
                this.setImage("scorpion_l");
            }
            if (this.descending) {
                this.y += this.yspeed;
                if (this.isYAligned()) {
                    this.descending = false;
                    this.snapToGrid();
                }
            } else {
                this.x += (double)this.dir * this.xspeed;
                if (this.x < 0.0 && this.dir < 0 || this.x > 608.0 && this.dir > 0) {
                    this.descending = true;
                    this.dir = -this.dir;
                }
                this.snapToGrid();
            }
            if (this.y >= (double)Insecticide.this.pfHeight()) {
                this.y = Insecticide.this.pfHeight() / 2;
                this.snapToGrid(0.0, 32.0);
            }
        }

        public void hit(JGObject obj) {
            Insecticide.this.createExplo(this.x, this.y, 8);
            JGRectangle r = this.getCenterTiles();
            Insecticide.this.setTile(r.x + this.dir, r.y, "m");
            this.remove();
            obj.remove();
            Insecticide.this.score += 5;
        }

        public void hit_bg(int tilecid) {
            this.snapToGrid(16.0, this.yspeed / 2.0);
            if (!this.descending) {
                this.dir = -this.dir;
            }
            this.descending = true;
        }
    }

    public class Spider
    extends JGObject {
        int frames_collided = 0;

        public Spider(double x, double y, double xdir, double ydir) {
            super("spider", true, x, y, 1, "spider", 0, 0, 32, 32, xdir, ydir);
        }

        public void move() {
            --this.frames_collided;
            if (this.x < 0.0 && this.xdir < 0) {
                this.xdir = -this.xdir;
            }
            if (this.y < (double)Insecticide.this.pfHeight() * 0.5 && this.ydir < 0) {
                this.ydir = -this.ydir;
            }
            if (this.x > (double)(Insecticide.this.pfWidth() - 32) && this.xdir > 0) {
                this.xdir = -this.xdir;
            }
            if (this.y > (double)(Insecticide.this.pfHeight() - 32) && this.ydir > 0) {
                this.ydir = -this.ydir;
            }
        }

        public void hit(JGObject obj) {
            Insecticide.this.createExplo(this.x, this.y, 8);
            this.remove();
            obj.remove();
            Insecticide.this.score += 25;
        }

        public void hit_bg(int tilecid) {
            this.frames_collided += 3;
            if (this.frames_collided > 3) {
                return;
            }
            JGRectangle rthis = this.getTileBBox();
            if (rthis == null) {
                return;
            }
            JGRectangle r = new JGRectangle(rthis);
            r.x = (int)((double)r.x + (this.getLastX() - this.x));
            int cidydir = this.checkBGCollision(r);
            r.x = rthis.x;
            r.y = (int)((double)r.y + (this.getLastY() - this.y));
            int cidxdir = this.checkBGCollision(r);
            if (cidxdir != 0) {
                this.xdir = -this.xdir;
                this.snapToGrid(5.0, 0.0);
            }
            if (cidydir != 0) {
                this.ydir = -this.ydir;
                this.snapToGrid(0.0, 5.0);
            }
        }
    }

    public class Bullet
    extends JGObject {
        public Bullet(String name, double x, double y) {
            super(name, false, x, y, 2, "bullet");
        }

        public void move() {
            this.y -= 32.0;
            if (this.y < -16.0) {
                this.remove();
            }
        }

        public void hit(JGObject obj) {
            this.remove();
        }

        public void hit_bg(int tilecid) {
            this.remove();
        }

        public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
            for (int x = 0; x < txsize; ++x) {
                for (int y = 0; y < tysize; ++y) {
                    int thiscid = Insecticide.this.getTileCid(tx + x, ty + y);
                    Insecticide.this.setTile(tx + x, ty + y, "");
                    if (thiscid < 1 || thiscid >= 7) continue;
                    Insecticide.this.setTile(tx + x, ty + y, "m" + (thiscid + 1));
                }
            }
        }
    }

    public class Player
    extends JGObject {
        public Player() {
            super("player", false, Insecticide.this.pfWidth() / 2, Insecticide.this.pfHeight() - Insecticide.this.tileWidth(), 4, "ship");
        }

        public void move() {
            JGPoint ct = this.getCenterTile();
            if (Insecticide.this.getKey(38) && (!this.isYAligned(8.0) || (Insecticide.this.getTileCid(ct.x, ct.y - 1) & 7) == 0)) {
                this.y -= 8.0;
            }
            if (Insecticide.this.getKey(40) && (!this.isYAligned(8.0) || (Insecticide.this.getTileCid(ct.x, ct.y + 1) & 7) == 0)) {
                this.y += 8.0;
            }
            if (Insecticide.this.getKey(37) && (!this.isXAligned(8.0) || (Insecticide.this.getTileCid(ct.x - 1, ct.y) & 7) == 0)) {
                this.x -= 8.0;
            }
            if (Insecticide.this.getKey(39) && (!this.isXAligned(8.0) || (Insecticide.this.getTileCid(ct.x + 1, ct.y) & 7) == 0)) {
                this.x += 8.0;
            }
            if (this.x < 0.0 || this.x > (double)(Insecticide.this.pfWidth() - 32)) {
                this.snapToGrid(16.0, 0.0);
            }
            if (this.y > (double)(Insecticide.this.pfHeight() - 32) || this.y <= (double)Insecticide.this.pfHeight() * 0.45) {
                this.snapToGrid(0.0, 16.0);
            }
            if (Insecticide.this.getKey(90) && !Insecticide.this.existsObject("bullet")) {
                new Bullet("bullet", this.x, this.y - 16.0);
            }
        }

        public void hit(JGObject obj) {
            this.remove();
            Insecticide.this.createExplo(this.x, this.y, 32);
            Insecticide.this.addGameState("Dead");
            new JGTimer(100, true, "Dead"){

                public void alarm() {
                    Insecticide.this.removeObjects(null, 0);
                    if (--((Player)Player.this).Insecticide.this.lives <= 0) {
                        Insecticide.this.setGameState("Title");
                    } else {
                        new Player();
                        Insecticide.this.setGameState("InGame");
                    }
                }
            };
        }

        public void hit_bg(int tilecid) {
            this.snapToGrid(16.0, 16.0);
        }
    }
}

