/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Hashtable;
import jgame.JGPoint;
import jgame.impl.EngineLogic;
import jgame.impl.JGEngineInterface;
import jgame.impl.JGameError;

class JREEngine
implements MouseListener,
MouseMotionListener,
FocusListener,
KeyListener,
WindowListener {
    JGEngineInterface eng;
    EngineLogic el;
    Component canvas;
    Window my_win;
    Frame my_frame;
    boolean win_decoration = true;
    boolean create_frame = true;
    boolean has_focus = false;
    Point mousepos = new Point(0, 0);
    boolean[] mousebutton = new boolean[]{false, false, false, false};
    boolean mouseinside = false;
    boolean[] keymap = new boolean[259];
    int lastkey = 0;
    char lastkeychar = '\u0000';
    int wakeup_key = 0;
    Hashtable channels = new Hashtable();
    Hashtable lastplayed = new Hashtable();
    Hashtable islooping = new Hashtable();
    Hashtable clipstriggered = new Hashtable();
    int unnamedchnr = 0;
    int nr_unnamedch = 12;
    boolean audioenabled = true;
    String localstorefile;
    Hashtable localstore = new Hashtable();
    static /* synthetic */ Class class$java$awt$GraphicsConfiguration;
    static /* synthetic */ Class class$java$awt$Frame;

    public JREEngine(EngineLogic el, JGEngineInterface eng) {
        this.el = el;
        this.eng = eng;
    }

    void updateMouse(MouseEvent e, boolean pressed, boolean released, boolean inside) {
        this.mousepos = e.getPoint();
        this.mousepos.x = (int)((double)this.mousepos.x / this.el.x_scale_fac);
        this.mousepos.y = (int)((double)this.mousepos.y / this.el.y_scale_fac);
        this.mouseinside = inside;
        int button = 0;
        if ((e.getModifiers() & 0x10) != 0) {
            button = 1;
        }
        if ((e.getModifiers() & 8) != 0) {
            button = 2;
        }
        if ((e.getModifiers() & 4) != 0) {
            button = 3;
        }
        if (button == 0) {
            return;
        }
        if (pressed) {
            this.mousebutton[button] = true;
            this.keymap[255 + button] = true;
            if (!(this.wakeup_key != -1 && this.wakeup_key != 255 + button || this.eng.isRunning())) {
                this.eng.start();
                this.mousebutton[button] = false;
                this.keymap[255 + button] = false;
            }
        }
        if (released) {
            this.mousebutton[button] = false;
            this.keymap[255 + button] = false;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.has_focus) {
            this.canvas.requestFocus();
        }
        this.updateMouse(e, false, false, true);
    }

    public void mouseEntered(MouseEvent e) {
        this.updateMouse(e, false, false, true);
    }

    public void mouseExited(MouseEvent e) {
        this.updateMouse(e, false, false, false);
    }

    public void mousePressed(MouseEvent e) {
        this.updateMouse(e, true, false, true);
    }

    public void mouseReleased(MouseEvent e) {
        this.updateMouse(e, false, true, true);
    }

    public void mouseDragged(MouseEvent e) {
        this.updateMouse(e, false, false, true);
    }

    public void mouseMoved(MouseEvent e) {
        this.updateMouse(e, false, false, true);
    }

    public void focusGained(FocusEvent e) {
        this.has_focus = true;
    }

    public void focusLost(FocusEvent e) {
        this.has_focus = false;
    }

    public void keyPressed(KeyEvent e) {
        char keychar = e.getKeyChar();
        int keycode = e.getKeyCode();
        if (keycode >= 0 && keycode < 256) {
            this.keymap[keycode] = true;
            this.lastkey = keycode;
            this.lastkeychar = keychar;
            if (!(this.wakeup_key != -1 && this.wakeup_key != keycode || this.eng.isRunning())) {
                this.eng.start();
                this.keymap[keycode] = false;
            }
        }
        if (e.isShiftDown() && e.getKeyCode() == 27 && !this.eng.isApplet()) {
            System.exit(0);
        }
    }

    public void keyReleased(KeyEvent e) {
        char keychar = e.getKeyChar();
        int keycode = e.getKeyCode();
        if (keycode >= 0 && keycode < 256) {
            this.keymap[keycode] = false;
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        System.out.println("Closed");
    }

    public void windowClosing(WindowEvent e) {
        System.out.println("Window closed; exiting.");
        this.closeWindow();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void clearKeymap() {
        for (int i = 0; i < 259; ++i) {
            this.keymap[i] = false;
        }
    }

    public void wakeUpOnKey(int key) {
        this.wakeup_key = key;
    }

    public JGPoint getMousePos() {
        return new JGPoint(this.mousepos.x, this.mousepos.y);
    }

    public int getMouseX() {
        return this.mousepos.x;
    }

    public int getMouseY() {
        return this.mousepos.y;
    }

    public boolean getMouseButton(int nr) {
        return this.mousebutton[nr];
    }

    public void clearMouseButton(int nr) {
        this.mousebutton[nr] = false;
    }

    public void setMouseButton(int nr) {
        this.mousebutton[nr] = true;
    }

    public boolean getMouseInside() {
        return this.mouseinside;
    }

    public boolean getKey(int key) {
        return this.keymap[key];
    }

    public void clearKey(int key) {
        this.keymap[key] = false;
    }

    public void setKey(int key) {
        this.keymap[key] = true;
    }

    public int getLastKey() {
        return this.lastkey;
    }

    public char getLastKeyChar() {
        return this.lastkeychar;
    }

    public void clearLastKey() {
        this.lastkey = 0;
        this.lastkeychar = '\u0000';
    }

    public static String getKeyDescStatic(int key) {
        if (key == 32) {
            return "space";
        }
        if (key == 0) {
            return "(none)";
        }
        if (key == 10) {
            return "enter";
        }
        if (key == 27) {
            return "escape";
        }
        if (key == 38) {
            return "cursor up";
        }
        if (key == 40) {
            return "cursor down";
        }
        if (key == 37) {
            return "cursor left";
        }
        if (key == 39) {
            return "cursor right";
        }
        if (key == 16) {
            return "shift";
        }
        if (key == 18) {
            return "alt";
        }
        if (key == 17) {
            return "control";
        }
        if (key == 256) {
            return "left mouse button";
        }
        if (key == 257) {
            return "middle mouse button";
        }
        if (key == 258) {
            return "right mouse button";
        }
        if (key == 27) {
            return "escape";
        }
        if (key >= 33 && key <= 95) {
            return new String(new char[]{(char)key});
        }
        return "keycode " + key;
    }

    public static int getKeyCodeStatic(String keydesc) {
        if ((keydesc = keydesc.toLowerCase().trim()).equals("space")) {
            return 32;
        }
        if (keydesc.equals("escape")) {
            return 27;
        }
        if (keydesc.equals("(none)")) {
            return 0;
        }
        if (keydesc.equals("enter")) {
            return 10;
        }
        if (keydesc.equals("cursor up")) {
            return 38;
        }
        if (keydesc.equals("cursor down")) {
            return 40;
        }
        if (keydesc.equals("cursor left")) {
            return 37;
        }
        if (keydesc.equals("cursor right")) {
            return 39;
        }
        if (keydesc.equals("shift")) {
            return 16;
        }
        if (keydesc.equals("alt")) {
            return 18;
        }
        if (keydesc.equals("control")) {
            return 17;
        }
        if (keydesc.equals("left mouse button")) {
            return 256;
        }
        if (keydesc.equals("middle mouse button")) {
            return 257;
        }
        if (keydesc.equals("right mouse button")) {
            return 258;
        }
        if (keydesc.startsWith("keycode")) {
            return Integer.parseInt(keydesc.substring(7));
        }
        if (keydesc.length() == 1) {
            return keydesc.charAt(0);
        }
        return 0;
    }

    public String getConfigPath(String filename) {
        File jgamedir;
        if (this.eng.isApplet()) {
            return null;
        }
        try {
            jgamedir = new File(System.getProperty("user.home"), ".jgame");
        }
        catch (Exception e) {
            return null;
        }
        if (!jgamedir.exists() && !jgamedir.mkdir()) {
            return null;
        }
        if (!jgamedir.isDirectory()) {
            return null;
        }
        File file = new File(jgamedir, filename);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        if (!file.canWrite()) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    static Method getMethod(Class cls, String name, Object[] args) {
        Class[] args_cls = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            args_cls[i] = args[i] instanceof Boolean ? Boolean.TYPE : (args[i] instanceof Character ? Character.TYPE : (args[i] instanceof Integer ? Integer.TYPE : (args[i] instanceof Double ? Double.TYPE : (args[i] instanceof Float ? Float.TYPE : (args[i] instanceof GraphicsConfiguration ? (class$java$awt$GraphicsConfiguration == null ? JREEngine.class$("java.awt.GraphicsConfiguration") : class$java$awt$GraphicsConfiguration) : args[i].getClass())))));
        }
        try {
            return cls.getMethod(name, args_cls);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    boolean tryMethod(Object o, String name, Object[] args) {
        try {
            Method met = JREEngine.getMethod(o.getClass(), name, args);
            if (met == null) {
                return false;
            }
            met.invoke(o, args);
        }
        catch (InvocationTargetException ex) {
            Throwable ex_t = ex.getTargetException();
            if (ex_t instanceof JGameError) {
                this.eng.exitEngine(this.eng.dbgExceptionToString(ex_t));
            } else {
                this.eng.dbgShowException("MAIN", ex_t);
            }
            return false;
        }
        catch (IllegalAccessException ex) {
            System.err.println("Unexpected exception:");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean existsMethod(Class cls, String name, Object[] args) {
        return JREEngine.getMethod(cls, name, args) != null;
    }

    static boolean existsMethod(Class cls, String name, Class[] args) {
        try {
            cls.getMethod(name, args);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    void createWindow(Component appwin, boolean add_decoration) {
        if (JREEngine.existsMethod(class$java$awt$Frame == null ? (class$java$awt$Frame = JREEngine.class$("java.awt.Frame")) : class$java$awt$Frame, "setUndecorated", new Class[]{Boolean.TYPE})) {
            this.my_win = new Frame();
            this.tryMethod(this.my_win, "setUndecorated", new Object[]{new Boolean(!add_decoration)});
        } else if (!add_decoration) {
            this.my_frame = new Frame();
            this.my_win = new Window(this.my_frame);
            this.tryMethod(this.my_win, "setFocusableWindowState", new Object[]{new Boolean(true)});
            this.my_frame.setVisible(true);
        } else {
            this.my_win = new Frame();
        }
        this.my_win.setLayout(new FlowLayout(1, 0, 0));
        this.setWindowSize(add_decoration);
        this.my_win.add(appwin);
        this.my_win.addWindowListener(this);
    }

    void setWindowSize(boolean add_decoration) {
        if (!add_decoration) {
            this.my_win.setSize(this.el.winwidth, this.el.winheight);
        } else {
            Insets insets = this.my_win.getInsets();
            this.my_win.setSize(this.el.winwidth + insets.left + insets.right, this.el.winheight + insets.top + insets.bottom);
        }
    }

    void closeWindow() {
        this.my_win.setVisible(false);
        System.exit(0);
    }

    void audioNewFrame() {
        this.clipstriggered = new Hashtable();
    }

    public void enableAudio() {
        if (this.audioenabled) {
            return;
        }
        this.audioenabled = true;
        Enumeration e = this.channels.keys();
        while (e.hasMoreElements()) {
            Hashtable chan;
            AudioClip clip;
            String channel = (String)e.nextElement();
            String lastclipid = (String)this.islooping.get(channel);
            if (lastclipid == null || (clip = (AudioClip)(chan = (Hashtable)this.channels.get(channel)).get(lastclipid)) == null) continue;
            clip.loop();
        }
    }

    public void disableAudio() {
        if (!this.audioenabled) {
            return;
        }
        this.audioenabled = false;
        Enumeration e = this.channels.keys();
        while (e.hasMoreElements()) {
            Hashtable chan;
            AudioClip clip;
            String channel = (String)e.nextElement();
            String lastclipid = (String)this.lastplayed.get(channel);
            if (lastclipid == null || (clip = (AudioClip)(chan = (Hashtable)this.channels.get(channel)).get(lastclipid)) == null) continue;
            clip.stop();
        }
    }

    private AudioClip loadAudioClip(Applet applet, String clipid) {
        URL clipres = this.getClass().getResource((String)this.el.audioclips.get(clipid));
        AudioClip clip = this.eng.isApplet() ? applet.getAudioClip(clipres) : Applet.newAudioClip(clipres);
        return clip;
    }

    public String lastPlayedAudio(String channel) {
        return (String)this.lastplayed.get(channel);
    }

    public void playAudio(Applet applet, String clipid) {
        if (this.clipstriggered.containsKey(clipid)) {
            return;
        }
        this.clipstriggered.put(clipid, "yes");
        this.playAudio(applet, "_unnamed" + this.unnamedchnr, clipid, false);
        this.unnamedchnr = (this.unnamedchnr + 1) % this.nr_unnamedch;
    }

    public void playAudio(Applet applet, String channel, String clipid, boolean loop) {
        AudioClip clip = null;
        Hashtable<String, AudioClip> chan = (Hashtable<String, AudioClip>)this.channels.get(channel);
        String clipplaying = (String)this.lastplayed.get(channel);
        if (chan != null) {
            clip = (AudioClip)chan.get(clipid);
        } else {
            chan = new Hashtable<String, AudioClip>();
            this.channels.put(channel, chan);
        }
        if (clip == null) {
            clip = this.loadAudioClip(applet, clipid);
            chan.put(clipid, clip);
        }
        boolean restart = true;
        if (clipplaying != null && !clipplaying.equals(clipid)) {
            AudioClip prevclip = (AudioClip)chan.get(clipplaying);
            if (this.audioenabled) {
                prevclip.stop();
            }
        } else {
            String looping = (String)this.islooping.get(channel);
            restart = !loop || looping == null || !looping.equals(clipid);
        }
        if (loop) {
            if (restart) {
                if (this.audioenabled) {
                    clip.loop();
                }
                this.islooping.put(channel, clipid);
            }
        } else {
            if (this.audioenabled) {
                clip.play();
            }
            this.islooping.remove(channel);
        }
        this.lastplayed.put(channel, clipid);
    }

    public void stopAudio(String channel) {
        String lastclipid = (String)this.lastplayed.get(channel);
        if (lastclipid == null) {
            return;
        }
        Hashtable chan = (Hashtable)this.channels.get(channel);
        AudioClip clip = (AudioClip)chan.get(lastclipid);
        if (clip != null && this.audioenabled) {
            clip.stop();
        }
        this.lastplayed.remove(channel);
        this.islooping.remove(channel);
    }

    public void stopAudio() {
        Enumeration e = this.channels.keys();
        while (e.hasMoreElements()) {
            this.stopAudio((String)e.nextElement());
        }
    }

    void storeInit() {
        this.localstorefile = this.getConfigPath(this.eng.getClass().getName() + ".store");
        if (this.localstorefile == null) {
            return;
        }
        try {
            String line;
            BufferedReader reader;
            try {
                File file = new File(this.localstorefile);
                if (!file.exists()) {
                    return;
                }
                reader = new BufferedReader(new FileReader(file));
            }
            catch (AccessControlException e) {
                URL url = new URL(this.localstorefile);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            while ((line = reader.readLine()) != null) {
                String name = line.substring(0, line.indexOf("\t"));
                String rest1 = line.substring(line.indexOf("\t") + 1);
                String type = rest1.substring(0, rest1.indexOf("\t"));
                String value = rest1.substring(rest1.indexOf("\t") + 1);
                if (type.equals("int")) {
                    this.localstore.put(name, new Integer(Integer.parseInt(value)));
                    continue;
                }
                if (type.equals("double")) {
                    this.localstore.put(name, new Double(Double.parseDouble(value)));
                    continue;
                }
                if (type.equals("String")) {
                    this.localstore.put(name, value);
                    continue;
                }
                throw new JGameError("Unknown type " + type);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new JGameError("Error reading file '" + this.localstorefile + "'.", false);
        }
    }

    private void storeWrite() {
        try {
            if (this.localstorefile == null) {
                return;
            }
            PrintWriter writer = new PrintWriter(new FileWriter(new File(this.localstorefile)));
            Enumeration e = this.localstore.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                Object o = this.localstore.get(k);
                if (o instanceof Integer) {
                    writer.println(k + "\tint\t" + o);
                    continue;
                }
                if (o instanceof Double) {
                    writer.println(k + "\tdouble\t" + o);
                    continue;
                }
                if (!(o instanceof String)) continue;
                writer.println(k + "\tString\t" + o);
            }
            writer.close();
        }
        catch (IOException e) {
            throw new JGameError("Error writing file '" + this.localstorefile + "'.", false);
        }
    }

    public void storeWriteInt(String id, int value) {
        this.localstore.put(id, new Integer(value));
        this.storeWrite();
    }

    public void storeWriteDouble(String id, double value) {
        this.localstore.put(id, new Double(value));
        this.storeWrite();
    }

    public void storeWriteString(String id, String value) {
        this.localstore.put(id, value);
        this.storeWrite();
    }

    public void storeRemove(String id) {
        this.localstore.remove(id);
        this.storeWrite();
    }

    public boolean storeExists(String id) {
        return this.localstore.containsKey(id);
    }

    public int storeReadInt(String id, int undef) {
        if (!this.localstore.containsKey(id)) {
            return undef;
        }
        return (Integer)this.localstore.get(id);
    }

    public double storeReadDouble(String id, double undef) {
        if (!this.localstore.containsKey(id)) {
            return undef;
        }
        return (Double)this.localstore.get(id);
    }

    public String storeReadString(String id, String undef) {
        if (!this.localstore.containsKey(id)) {
            return undef;
        }
        return (String)this.localstore.get(id);
    }

    public void optsAddTitle(String title) {
    }

    public void optsAddNumber(String varname, String title, String desc, int decimals, double lower, double upper, double step, double initial) {
    }

    public void optsAddBoolean(String varname, String title, String desc, boolean initial) {
    }

    public void optsAddEnum(String varname, String title, String desc, String[] values, int initial) {
    }

    public void optsAddKey(String varname, String title, String desc, int initial) {
    }

    public void optsAddString(String varname, String title, String desc, int maxlen, boolean isPassword, String initial) {
    }

    public void optsClear() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

