/*
 * Decompiled with CFR 0.152.
 */
package jgame;

import jgame.JGObject;
import jgame.impl.JGEngineInterface;

public abstract class JGTimer {
    int frames = 0;
    double frames_left = 0.0;
    public boolean running = true;
    public boolean one_shot;
    public JGObject parent_obj = null;
    public String parent_state = null;
    JGEngineInterface eng;

    public JGTimer(int frames_to_alarm, boolean one_shot) {
        this.set(frames_to_alarm, one_shot);
        this.eng = JGObject.default_engine;
        this.eng.registerTimer(this);
    }

    public JGTimer(int frames_to_alarm, boolean one_shot, JGObject parent) {
        this.set(frames_to_alarm, one_shot);
        this.eng = JGObject.default_engine;
        this.eng.registerTimer(this);
        this.parent_obj = parent;
    }

    public JGTimer(int frames_to_alarm, boolean one_shot, String parent) {
        this.set(frames_to_alarm, one_shot);
        this.eng = JGObject.default_engine;
        this.eng.registerTimer(this);
        this.parent_state = parent;
    }

    public void set(int frames_to_alarm, boolean one_shot) {
        this.frames = frames_to_alarm;
        this.frames_left = this.frames;
        this.one_shot = one_shot;
    }

    public boolean tick(double speed) {
        if (this.parent_state != null && !this.eng.inGameStateNextFrame(this.parent_state)) {
            return true;
        }
        if (this.parent_obj != null && !this.parent_obj.isAlive()) {
            return true;
        }
        if (this.running) {
            if (this.frames_left <= 0.0) {
                this.frames_left = this.frames;
                this.alarm();
                if (this.one_shot) {
                    return true;
                }
            } else {
                this.frames_left -= speed;
            }
        }
        return false;
    }

    public abstract void alarm();
}

