/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Hashtable;
import jgame.JGColor;
import jgame.JGImage;
import jgame.JGPoint;
import jgame.impl.JGameError;
import jgame.platform.JREEngine;

class JREImage
implements JGImage {
    static Component output_comp = null;
    static MediaTracker mediatracker = null;
    DummyObserver observer = new DummyObserver();
    static Hashtable loadedimages = new Hashtable();
    public Image img = null;
    public Object texture = null;
    public Object stretched_texture = null;

    public void setComponent(Component comp) {
        output_comp = comp;
        mediatracker = new MediaTracker(output_comp);
        loadedimages = new Hashtable();
    }

    JREImage(Image img) {
        this.img = img;
    }

    JREImage() {
    }

    public JGImage loadImage(String imgfile) {
        Image img = (Image)loadedimages.get(imgfile);
        if (img == null) {
            URL imgurl = this.getClass().getResource(imgfile);
            if (imgurl == null) {
                try {
                    File imgf = new File(imgfile);
                    imgurl = imgf.canRead() ? imgf.toURL() : new URL(imgfile);
                }
                catch (MalformedURLException e) {
                    throw new JGameError("File not found or malformed path or URL '" + imgfile + "'.", true);
                }
            }
            img = output_comp.getToolkit().createImage(imgurl);
            loadedimages.put(imgfile, img);
        }
        try {
            JREImage.ensureLoaded(img);
        }
        catch (Exception e) {
            throw new JGameError("Error loading image " + imgfile);
        }
        return new JREImage(img);
    }

    public static JGImage loadImage(URL imgurl) {
        Image img = (Image)loadedimages.get(imgurl);
        if (img == null) {
            img = output_comp.getToolkit().createImage(imgurl);
            loadedimages.put(imgurl, img);
        }
        try {
            JREImage.ensureLoaded(img);
        }
        catch (Exception e) {
            System.err.println("Error loading image " + imgurl);
            return null;
        }
        return new JREImage(img);
    }

    public void purgeImage(String imgfile) {
        if (loadedimages.containsKey(imgfile)) {
            loadedimages.remove(imgfile);
        }
    }

    public JGPoint getSize() {
        return new JGPoint(this.img.getWidth(this.observer), this.img.getHeight(this.observer));
    }

    public boolean isOpaque(int alpha_thresh) {
        int[] alpha = this.getPixels();
        for (int i = 0; i < alpha.length; ++i) {
            if ((alpha[i] >> 24 & 0xFF) >= alpha_thresh) continue;
            return false;
        }
        return true;
    }

    public int[] getPixels() {
        JGPoint size = this.getSize();
        int[] buffer = new int[size.x * size.y];
        PixelGrabber grabber = new PixelGrabber(this.img, 0, 0, size.x, size.y, buffer, 0, size.x);
        this.grabPixels(grabber);
        return buffer;
    }

    public int[] getPixels(int x, int y, int width, int height) {
        int[] buffer = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(this.img, x, y, width, height, buffer, 0, width);
        this.grabPixels(grabber);
        return buffer;
    }

    private void grabPixels(PixelGrabber grabber) {
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public JGImage rotate(int angle) {
        Object rot = null;
        JGPoint size = this.getSize();
        int[] buffer = this.getPixels();
        int[] rotate = new int[size.x * size.y];
        int angletype = angle / 90 & 3;
        if (angletype == 0) {
            return this;
        }
        if (angletype == 1) {
            for (int y = 0; y < size.y; ++y) {
                for (int x = 0; x < size.x; ++x) {
                    rotate[x * size.y + (size.y - 1 - y)] = buffer[y * size.x + x];
                }
            }
            return new JREImage(output_comp.createImage(new MemoryImageSource(size.y, size.x, rotate, 0, size.y)));
        }
        if (angletype == 3) {
            for (int y = 0; y < size.y; ++y) {
                for (int x = 0; x < size.x; ++x) {
                    rotate[(size.x - x - 1) * size.y + y] = buffer[y * size.x + x];
                }
            }
            return new JREImage(output_comp.createImage(new MemoryImageSource(size.y, size.x, rotate, 0, size.y)));
        }
        if (angletype == 2) {
            for (int y = 0; y < size.y; ++y) {
                for (int x = 0; x < size.x; ++x) {
                    rotate[(size.y - y - 1) * size.x + (size.x - x - 1)] = buffer[y * size.x + x];
                }
            }
        }
        return new JREImage(output_comp.createImage(new MemoryImageSource(size.x, size.y, rotate, 0, size.x)));
    }

    public JGImage rotateAny(double angle) {
        int dw;
        JGPoint size = this.getSize();
        int sw = size.x;
        int sh = size.y;
        int dh = dw = (int)Math.max((double)Math.max(sw, sh), 0.75 * (double)(sw + sh));
        int xtrans = (dw - sw) / 2;
        int ytrans = (dh - sh) / 2;
        BufferedImage dst = JREImage.createCompatibleImage(dw, dh, 2);
        Graphics2D g = (Graphics2D)dst.getGraphics();
        AffineTransform tt = AffineTransform.getTranslateInstance(xtrans, ytrans);
        AffineTransform tr = AffineTransform.getRotateInstance(angle, sw / 2, sh / 2);
        tt.concatenate(tr);
        g.drawImage(this.img, tt, null);
        return new JREImage(dst);
    }

    public JGImage flip(boolean horiz, boolean vert) {
        int[] flipbuf;
        JGPoint size;
        block7: {
            int[] buffer;
            block8: {
                block6: {
                    Object flipped = null;
                    size = this.getSize();
                    buffer = this.getPixels();
                    flipbuf = new int[size.x * size.y];
                    if (!vert || horiz) break block6;
                    for (int y = 0; y < size.y; ++y) {
                        for (int x = 0; x < size.x; ++x) {
                            flipbuf[(size.y - y - 1) * size.x + x] = buffer[y * size.x + x];
                        }
                    }
                    break block7;
                }
                if (!horiz || vert) break block8;
                for (int y = 0; y < size.y; ++y) {
                    for (int x = 0; x < size.x; ++x) {
                        flipbuf[y * size.x + (size.x - x - 1)] = buffer[y * size.x + x];
                    }
                }
                break block7;
            }
            if (!horiz || !vert) break block7;
            for (int y = 0; y < size.y; ++y) {
                for (int x = 0; x < size.x; ++x) {
                    flipbuf[(size.y - y - 1) * size.x + (size.x - x - 1)] = buffer[y * size.x + x];
                }
            }
        }
        return new JREImage(output_comp.createImage(new MemoryImageSource(size.x, size.y, flipbuf, 0, size.x)));
    }

    public JGImage scale(int width, int height) {
        Image scaledimg = this.img.getScaledInstance(width, height, 4);
        try {
            JREImage.ensureLoaded(scaledimg);
        }
        catch (Exception e) {
            System.err.println("Error scaling image.");
        }
        return new JREImage(scaledimg);
    }

    public static void ensureLoaded(Image img) throws Exception {
        mediatracker.addImage(img, 0);
        try {
            mediatracker.waitForAll();
            if (mediatracker.getErrorsAny() != null) {
                mediatracker.removeImage(img);
                throw new Exception("Error loading image");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        mediatracker.removeImage(img);
    }

    public JGImage crop(int x, int y, int width, int height) {
        JGPoint size = this.getSize();
        int[] buffer = this.getPixels(x, y, width, height);
        return new JREImage(output_comp.createImage(new MemoryImageSource(width, height, buffer, 0, width)));
    }

    public JGImage toDisplayCompatible(int thresh, JGColor bg_col, boolean fast, boolean bitmask) {
        int[] bg_buf;
        Color bgcol = new Color(bg_col.r, bg_col.g, bg_col.b);
        int bgcol_rgb = bgcol.getRed() << 16 | bgcol.getGreen() << 8 | bgcol.getBlue();
        JGPoint size = this.getSize();
        int[] buffer = this.getPixels();
        BufferedImage img_bg = bitmask ? JREImage.createCompatibleImage(size.x, size.y, 2) : JREImage.createCompatibleImage(size.x, size.y, 3);
        if (!fast) {
            Graphics g = img_bg.getGraphics();
            g.setColor(bgcol);
            g.fillRect(0, 0, size.x, size.y);
            g.drawImage(this.img, 0, 0, null);
            bg_buf = new JREImage(img_bg).getPixels();
        } else {
            bg_buf = buffer;
        }
        int[] thrsbuf = new int[size.x * size.y];
        for (int y = 0; y < size.y; ++y) {
            for (int x = 0; x < size.x; ++x) {
                thrsbuf[y * size.x + x] = (buffer[y * size.x + x] >> 24 & 0xFF) >= thresh ? bg_buf[y * size.x + x] | 0xFF000000 : bgcol_rgb;
            }
        }
        return new JREImage(output_comp.createImage(new MemoryImageSource(size.x, size.y, img_bg.getColorModel(), bitmask ? thrsbuf : bg_buf, 0, size.x)));
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        BufferedImage bimage = gc.createCompatibleImage(width, height, transparency);
        return bimage;
    }

    public static BufferedImage createRGBA8Image(int[] pix, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        img.setRGB(0, 0, width, height, pix, 0, width);
        return img;
    }

    public static Image createScratchImage(int width, int height) {
        try {
            Image img = (Image)JREImage.tryMethod(output_comp, "createVolatileImage", new Object[]{new Integer(width), new Integer(height)});
            if (img == null) {
                return output_comp.createImage(width, height);
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            Integer valid = (Integer)JREImage.tryMethod(img, "validate", new Object[]{gc});
            if (valid == 2) {
                return output_comp.createImage(width, height);
            }
            return img;
        }
        catch (AccessControlException e) {
            return output_comp.createImage(width, height);
        }
    }

    public static boolean isScratchImageValid(Image img) {
        try {
            Boolean lost = (Boolean)JREImage.tryMethod(img, "contentsLost", new Object[0]);
            if (lost == null) {
                return true;
            }
            return lost == false;
        }
        catch (AccessControlException e) {
            return true;
        }
    }

    static Object tryMethod(Object o, String name, Object[] args) {
        try {
            Method met = JREEngine.getMethod(o.getClass(), name, args);
            if (met == null) {
                return null;
            }
            return met.invoke(o, args);
        }
        catch (InvocationTargetException ex) {
            Throwable ex_t = ex.getTargetException();
            ex_t.printStackTrace();
            return null;
        }
        catch (IllegalAccessException ex) {
            System.err.println("Unexpected exception:");
            ex.printStackTrace();
            return null;
        }
    }

    class DummyObserver
    implements ImageObserver {
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            return true;
        }
    }
}

