/*
 * Decompiled with CFR 0.152.
 */
package examples.dungeonsofhack;

import examples.StdDungeonMonster;
import examples.StdDungeonPlayer;
import examples.StdScoring;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class DungeonsOfHack
extends StdGame {
    public static final int WALL_T = 1;
    public static final int SHWALL_T = 2;
    public static final int DOOR_T = 4;
    public static final int PLAYER_T = 16;
    public static final int MONSTER_T = 32;
    public static final int GEN_T = 64;
    public static final int BONUS_T = 128;
    public static final int KEY_T = 256;
    public static final int HEALTH_T = 512;
    public static final int PLAYERBLOCK_T = 71;
    public static final int MONSTERBLOCK_T = 999;
    public static final int BULLETBLOCK_T = 901;
    boolean do_scroll = false;
    JGObject player = null;
    int keys = 0;
    int health = 0;
    int kills = 0;
    int gold_left = 0;
    public int nr_mushrooms = 0;
    public int nr_demons = 0;
    JGFont scoring_font = new JGFont("Arial", 0, 8.0);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Please supply \"scroll\" or \"noscroll\" as first argument.");
            System.exit(0);
        }
        boolean do_scroll = false;
        if (args[0].equals("scroll")) {
            do_scroll = true;
        }
        new DungeonsOfHack(DungeonsOfHack.parseSizeArgs(args, 1), do_scroll);
    }

    public DungeonsOfHack() {
        this.initEngineApplet();
    }

    public DungeonsOfHack(JGPoint size, boolean do_scroll) {
        this.do_scroll = do_scroll;
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        if (this.isApplet()) {
            boolean bl = this.do_scroll = this.getParameter("scrolling") != null;
        }
        if (this.isMidlet()) {
            this.do_scroll = true;
        }
        if (this.isMidlet()) {
            this.setCanvasSettings(18, 18, 10, 10, null, null, null);
            this.setScalingPreferences(0.75, 1.3333333333333333, 0, 4, 0, 4);
        } else if (this.do_scroll) {
            this.setCanvasSettings(20, 15, 10, 10, null, null, null);
        } else {
            this.setCanvasSettings(60, 40, 10, 10, null, null, null);
        }
    }

    public void initGame() {
        this.defineMedia("dungeons_of_hack.tbl");
        this.setVideoSyncedUpdate(true);
        if (this.isMidlet()) {
            this.setFrameRate(10.0, 1.0);
            this.setGameSpeed(1.8);
        } else {
            this.setFrameRate(30.0, 4.0);
        }
        this.startgame_ticks = 1000;
        this.gameover_ingame = true;
        this.title_font = new JGFont("Helvetica", 1, 17.0);
        this.setPFSize(60, 40);
    }

    public void initNewGame(int level_selected) {
        this.health = 10;
        this.keys = 0;
        this.level = 0;
        this.kills = 0;
    }

    public void defineLevel() {
        int i;
        int y;
        int demon_firerate;
        int turret_firerate;
        int demonrate;
        int mushroomrate;
        int nr_turrets;
        int nr_mushroomgen;
        int nr_demongen;
        int nr_health;
        int nr_bonuses;
        int nr_keys;
        int[][] cells;
        int[] walls_y;
        int[] walls_x;
        this.fillBG("");
        this.removeObjects(null, 0);
        this.player = new Player(10.0, 10.0, 5.0, this.key_up, this.key_down, this.key_left, this.key_right);
        this.setViewOffset((int)this.player.x - 8, (int)this.player.y - 8, true);
        double door_rate = this.random(0.0, 1.0);
        double shootablewall_rate = this.random(0.0, 0.6);
        if (this.random(0.0, 1.0) > 0.42) {
            walls_x = this.defineWallPos(2, 8, this.pfTilesX() - 1, true);
            walls_y = this.defineWallPos(2, 8, this.pfTilesY() - 1, true);
            cells = this.defineCells(walls_x.length + 1, walls_y.length + 1, this.random(0.0, 0.1));
            nr_keys = 4;
            nr_bonuses = 10;
            nr_health = 5;
            nr_demongen = 5;
            nr_mushroomgen = 10;
            nr_turrets = 10;
            mushroomrate = 80;
            demonrate = 100;
            turret_firerate = 200;
            demon_firerate = 250;
        } else {
            walls_x = this.defineWallPos(9, 16, this.pfTilesX() - 1, false);
            walls_y = this.defineWallPos(9, 16, this.pfTilesY() - 1, false);
            cells = this.defineCells(walls_x.length + 1, walls_y.length + 1, this.random(0.0, 0.15));
            nr_keys = 10;
            nr_bonuses = 25;
            nr_health = 12;
            nr_demongen = 12;
            nr_mushroomgen = 25;
            nr_turrets = 25;
            mushroomrate = 140;
            demonrate = 200;
            turret_firerate = 120;
            demon_firerate = 180;
        }
        for (int x = 0; x < this.pfTilesX(); ++x) {
            this.setTile(x, 0, "#");
            this.setTile(x, this.pfTilesY() - 1, "#");
        }
        for (y = 0; y < this.pfTilesY(); ++y) {
            this.setTile(0, y, "#");
            this.setTile(this.pfTilesX() - 1, y, "#");
        }
        for (y = 0; y < cells[0].length; ++y) {
            for (int x = 0; x < cells.length; ++x) {
                int i2;
                String tile;
                int wx1 = x == 0 ? 0 : walls_x[x - 1];
                int wx2 = x == walls_x.length ? this.pfTilesX() - 1 : walls_x[x];
                int wy1 = y == 0 ? 0 : walls_y[y - 1];
                int wy2 = y == walls_y.length ? this.pfTilesY() - 1 : walls_y[y];
                this.setTile(wx1, wy1, "#");
                this.setTile(wx1, wy2, "#");
                this.setTile(wx2, wy1, "#");
                this.setTile(wx2, wy2, "#");
                if (x < walls_x.length) {
                    String string = this.random(0.0, 1.0) < door_rate ? "|" : (tile = this.random(0.0, 1.0) < shootablewall_rate ? "%" : "#");
                    if (!this.and(cells[x][y], 8)) {
                        for (i2 = wy1 + 1; i2 < wy2; ++i2) {
                            this.setTile(wx2, i2, tile);
                        }
                    }
                }
                if (y >= walls_y.length) continue;
                String string = this.random(0.0, 1.0) < door_rate ? "-" : (tile = this.random(0.0, 1.0) < shootablewall_rate ? "%" : "#");
                if (this.and(cells[x][y], 2)) continue;
                for (i2 = wx1 + 1; i2 < wx2; ++i2) {
                    this.setTile(i2, wy2, tile);
                }
            }
        }
        for (i = 0; i < nr_bonuses; ++i) {
            this.setTile(this.getFreeTile(), "o");
        }
        for (i = 0; i < nr_keys; ++i) {
            this.setTile(this.getFreeTile(), "k");
        }
        for (i = 0; i < nr_health; ++i) {
            this.setTile(this.getFreeTile(), "h");
        }
        for (i = 0; i < nr_mushroomgen; ++i) {
            JGPoint pos = this.getTileCoord(this.getFreeTile());
            new Generator(pos.x, pos.y, (int)(this.random(mushroomrate, (double)mushroomrate * 1.5) / this.getGameSpeed()), 0);
        }
        for (i = 0; i < nr_demongen; ++i) {
            JGPoint pos = this.getTileCoord(this.getFreeTile());
            new Generator(pos.x, pos.y, (int)(this.random(demonrate, (double)demonrate * 1.5) / this.getGameSpeed()), (int)((double)demon_firerate / this.getGameSpeed()));
        }
        for (i = 0; i < nr_turrets; ++i) {
            JGPoint pos = this.getTileCoord(this.getFreeTile());
            new Turret(pos.x, pos.y, (int)(this.random((double)turret_firerate / this.getGameSpeed(), (double)turret_firerate * 2.5) / this.getGameSpeed()));
        }
        this.gold_left = this.countTiles(128);
    }

    public JGPoint getFreeTile() {
        int y;
        int x;
        while (this.and(this.getTileCid(x = this.random(1, this.pfTilesX() - 2, 1), y = this.random(1, this.pfTilesY() - 2, 1)), 1023) || x < 6 && y < 6) {
        }
        return new JGPoint(x, y);
    }

    public int[][] defineCells(int xsize, int ysize, double openness) {
        int[][] cells = new int[xsize][ysize];
        this.digMazePath(cells, 0, 0, openness);
        return cells;
    }

    public void digMazePath(int[][] cells, int x, int y, double openness) {
        int[] nArray = cells[x];
        int n = y;
        nArray[n] = nArray[n] | 0x10;
        int[] try_dirs = new int[]{1, 2, 4, 8};
        for (int n2 = 0; n2 < 9; ++n2) {
            int swap1 = this.random(0, 3, 1);
            int swap2 = this.random(0, 3, 1);
            int try_dirs_swap1_tmp = try_dirs[swap1];
            try_dirs[swap1] = try_dirs[swap2];
            try_dirs[swap2] = try_dirs_swap1_tmp;
        }
        for (int i = 0; i < 4; ++i) {
            int xdir = 0;
            int ydir = 0;
            int otherdir = 0;
            if (try_dirs[i] == 1) {
                ydir = -1;
                otherdir = 2;
            }
            if (try_dirs[i] == 2) {
                ydir = 1;
                otherdir = 1;
            }
            if (try_dirs[i] == 4) {
                xdir = -1;
                otherdir = 8;
            }
            if (try_dirs[i] == 8) {
                xdir = 1;
                otherdir = 4;
            }
            if (x + xdir < 0 || y + ydir < 0 || x + xdir >= cells.length || y + ydir >= cells[0].length || this.and(cells[x + xdir][y + ydir], 16) && this.random(0.001, 1.0) > openness) continue;
            int[] nArray2 = cells[x];
            int n3 = y;
            nArray2[n3] = nArray2[n3] | try_dirs[i];
            int[] nArray3 = cells[x + xdir];
            int n4 = y + ydir;
            nArray3[n4] = nArray3[n4] | otherdir;
            this.digMazePath(cells, x + xdir, y + ydir, openness);
        }
    }

    public int[] defineWallPos(int minwalls, int maxwalls, int maxpos, boolean random_pos) {
        int[] wallpos = new int[this.random(minwalls, maxwalls, 1)];
        for (int i = 0; i < wallpos.length; ++i) {
            wallpos[i] = (int)(((double)i + 1.0) / ((double)wallpos.length + 1.0) * (double)maxpos);
        }
        if (wallpos.length == 0) {
            return wallpos;
        }
        if (!random_pos) {
            return wallpos;
        }
        for (int n = 0; n < wallpos.length * 3; ++n) {
            int wall = this.random(0, wallpos.length - 1, 1);
            int leftpos = wall == 0 ? 0 : wallpos[wall - 1];
            int rightpos = wall == wallpos.length - 1 ? maxpos : wallpos[wall + 1];
            wallpos[wall] = this.random(leftpos + 2, rightpos - 2, 1);
        }
        return wallpos;
    }

    public void startTitle() {
        this.removeObjects(null, 0);
    }

    public void startGameOver() {
        if (this.player != null) {
            new JGObject("zexplo", true, this.player.x, this.player.y, 0, "explo", 48);
            this.player.remove();
        }
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(4, 2);
        this.checkCollision(12, 1);
        this.checkBGCollision(903, 10);
        this.checkBGCollision(896, 1);
        this.nr_mushrooms = this.countObjects("mushroom", 0);
        this.nr_demons = this.countObjects("demon", 0);
        if (this.gold_left <= 0) {
            this.levelDone();
        }
        if (this.health < 0) {
            this.gameOver();
        }
        if (this.player != null) {
            this.setViewOffset((int)this.player.x - 8, (int)this.player.y - 8, true);
        }
    }

    public void incrementLevel() {
        ++this.level;
        ++this.stage;
        this.keys = 0;
        if (this.health <= 5) {
            this.health = 6;
        }
    }

    public void paintFrame() {
        this.setFont(this.status_font);
        this.setColor(this.status_color);
        this.drawString("GP " + this.score, 8.0, 0.0, -1);
        this.drawString("Kills " + this.kills, 70.0, 0.0, -1);
        this.drawString("Lvl " + (this.level + 1), 145.0, 0.0, -1);
        if (this.isMidlet()) {
            this.drawString("Keys " + this.keys, 8.0, this.viewHeight() - 15, -1);
            this.drawString("HP " + this.health, this.viewWidth() - 8, this.viewHeight() - 15, 1);
        } else if (!this.do_scroll) {
            this.drawCount(this.keys, "key", this.viewWidth() - 280, 0, 12);
            this.drawCount(this.health, "health", this.viewWidth() - 10 * this.health, 0, 10);
        } else {
            this.drawCount(this.keys, "key", 0, this.viewHeight() - 10, 12);
            this.drawCount(this.health, "health", this.viewWidth() - 10 * this.health, this.viewHeight() - 10, 10);
        }
    }

    public void paintFrameTitle() {
        this.drawImage(this.viewWidth() / 2 - 68, (double)(this.viewHeight() / 3 - 20), "splash_image", false);
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", this.viewWidth() / 2, 250.0, 0, this.title_font, this.title_color);
    }

    void openDoor(int x, int y) {
        if (!this.and(this.getTileCid(x, y), 4)) {
            return;
        }
        this.setTile(x, y, "");
        if (x > 0) {
            this.openDoor(x - 1, y);
        }
        if (y > 0) {
            this.openDoor(x, y - 1);
        }
        if (x < this.pfTilesX() - 1) {
            this.openDoor(x + 1, y);
        }
        if (y < this.pfTilesY() - 1) {
            this.openDoor(x, y + 1);
        }
    }

    public class Bullet
    extends JGObject {
        public Bullet(double x, double y, int xdir, int ydir, double speed) {
            super("bullet", true, x, y, 2, "axe", 35);
            this.setDirSpeed(xdir, ydir, speed);
        }

        public void hit(JGObject obj) {
            ++DungeonsOfHack.this.kills;
            new JGObject("zexplo", true, obj.x, obj.y, 0, "explo", 12);
            obj.remove();
            this.remove();
        }

        public void hit_bg(int tilecid) {
            this.remove();
        }

        public void hit_bg(int tilecid, int tx, int ty) {
            if (Bullet.and(tilecid, 2)) {
                DungeonsOfHack.this.setTile(tx, ty, "");
            }
        }
    }

    public class Player
    extends StdDungeonPlayer {
        int prevxdir = 1;
        int prevydir = 0;

        public Player(double x, double y, double speed, int upkey, int downkey, int leftkey, int rightkey) {
            super("player", x, y, 1, "human_l", false, false, 71, 16, 2.3, upkey, downkey, leftkey, rightkey);
            this.stopAnim();
        }

        public void move() {
            int checkxdir = 0;
            int checkydir = 0;
            if (DungeonsOfHack.this.getKey(this.key_left)) {
                checkxdir = -1;
                this.prevxdir = -1;
                this.prevydir = 0;
            }
            if (DungeonsOfHack.this.getKey(this.key_right)) {
                checkxdir = 1;
                this.prevxdir = 1;
                this.prevydir = 0;
            }
            if (DungeonsOfHack.this.getKey(this.key_up)) {
                checkydir = -1;
                this.prevxdir = 0;
                this.prevydir = -1;
            }
            if (DungeonsOfHack.this.getKey(this.key_down)) {
                checkydir = 1;
                this.prevxdir = 0;
                this.prevydir = 1;
            }
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_fire)) {
                this.stop_moving = true;
                JGPoint cen = this.getCenterTile();
                if (Player.and(DungeonsOfHack.this.getTileCid(cen, this.prevxdir, this.prevydir), 4) && DungeonsOfHack.this.keys > 0) {
                    DungeonsOfHack.this.openDoor(cen.x + this.prevxdir, cen.y + this.prevydir);
                    --DungeonsOfHack.this.keys;
                }
            } else {
                this.stop_moving = false;
            }
            checkxdir = 0;
            checkydir = 0;
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_fireleft)) {
                checkxdir = -1;
            }
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_fireright)) {
                checkxdir = 1;
            }
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_fireup)) {
                checkydir = -1;
            }
            if (DungeonsOfHack.this.getKey(DungeonsOfHack.this.key_firedown)) {
                checkydir = 1;
            }
            if (DungeonsOfHack.this.countObjects("bullet", 0) < 1 && (checkxdir != 0 || checkydir != 0)) {
                new Bullet(this.x, this.y, checkxdir, checkydir, 6.0);
            }
            super.move();
            if (this.xdir > 0) {
                this.setGraphic("human_r");
            }
            if (this.xdir < 0) {
                this.setGraphic("human_l");
            }
        }

        public void hit_bg(int tilecid, int tx, int ty) {
            if (Player.and(tilecid, 128)) {
                DungeonsOfHack.this.setTile(tx, ty, "");
                ++DungeonsOfHack.this.score;
                --DungeonsOfHack.this.gold_left;
            } else if (Player.and(tilecid, 256)) {
                ++DungeonsOfHack.this.keys;
                DungeonsOfHack.this.setTile(tx, ty, "");
            } else if (Player.and(tilecid, 512) && DungeonsOfHack.this.health < 15) {
                DungeonsOfHack.this.health += 2;
                DungeonsOfHack.this.setTile(tx, ty, "");
                new StdScoring("msg", this.x, this.y - 10.0, 0.0, -0.5, 40, "Potion! +2 health", new JGFont("Helvetica", 0, 10.0), new JGColor[]{JGColor.white, JGColor.red}, 2);
            }
        }

        public void hit(JGObject obj) {
            if (obj.colid == 4) {
                obj.remove();
                DungeonsOfHack.this.health -= 2;
                new StdScoring("msg", this.x, this.y - 10.0, 0.0, -0.5, 40, "Hit! -2 health", new JGFont("Helvetica", 0, 10.0), new JGColor[]{JGColor.white, JGColor.magenta}, 2);
            } else if (obj.colid == 8) {
                obj.remove();
                --DungeonsOfHack.this.health;
                new StdScoring("msg", this.x, this.y - 10.0, 0.0, -0.5, 40, "Shot! -1 health", new JGFont("Helvetica", 0, 10.0), new JGColor[]{JGColor.white, JGColor.blue}, 2);
            }
        }
    }

    public class Demon
    extends StdDungeonMonster {
        int firerate;
        int firecount;

        public Demon(double x, double y, int firerate) {
            super("demon", true, x, y, 4, "face", false, false, 999, 32, 1.0, null, false, 0.0);
            this.home_in = DungeonsOfHack.this.player;
            this.firerate = firerate;
            this.firecount = (int)this.random(0.0, firerate);
            if (DungeonsOfHack.this.isMidlet()) {
                this.expiry = -4.0;
            }
        }

        public void move() {
            super.move();
            if (DungeonsOfHack.this.player != null) {
                this.avoid = !(Math.abs(this.x - DungeonsOfHack.this.player.x) + Math.abs(this.y - DungeonsOfHack.this.player.y) > 150.0);
            }
            if (this.firecount-- <= 0) {
                this.firecount = this.firerate;
                if (DungeonsOfHack.this.player != null) {
                    double angle = DungeonsOfHack.this.atan2(DungeonsOfHack.this.player.x - this.x, DungeonsOfHack.this.player.y - this.y);
                    new TurretBullet(this.x, this.y, 1.0 * Math.sin(angle), 1.0 * Math.cos(angle), 120);
                }
            }
        }
    }

    public class Generator
    extends StdDungeonMonster {
        int genspeed;
        int gencount;
        int monster_firerate;

        public Generator(double x, double y, int genspeed, int monster_firerate) {
            super("generator", true, x, y, 4, null, 64);
            this.genspeed = genspeed;
            this.gencount = (int)this.random(0.0, genspeed);
            this.monster_firerate = monster_firerate;
            if (monster_firerate == 0) {
                this.setGraphic("hole");
            } else {
                this.setGraphic("coffin");
            }
            if (DungeonsOfHack.this.isMidlet()) {
                this.expiry = -4.0;
            }
        }

        public void move() {
            super.move();
            if (!Generator.and(DungeonsOfHack.this.getTileCid(this.getCenterTile(), 0, 0), 32) && this.gencount-- <= 0) {
                this.gencount = this.genspeed;
                if (this.monster_firerate == 0) {
                    if (DungeonsOfHack.this.nr_mushrooms < 80) {
                        StdDungeonMonster mushroom = new StdDungeonMonster("mushroom", true, this.x, this.y, 4, "mushroom", false, false, 999, 32, 1.0, DungeonsOfHack.this.player, false, 0.0);
                        if (DungeonsOfHack.this.isMidlet()) {
                            mushroom.expiry = -4.0;
                        }
                    }
                } else if (DungeonsOfHack.this.nr_demons < 40) {
                    new Demon(this.x, this.y, this.monster_firerate);
                }
            }
        }
    }

    public class TurretBullet
    extends JGObject {
        public TurretBullet(double x, double y, double xspeed, double yspeed, int expiry) {
            super("turretbullet", true, x, y, 8, "bullet", xspeed, yspeed, expiry);
        }

        public void hit_bg(int tilecid) {
            this.remove();
        }

        public void hit_bg(int tilecid, int tx, int ty) {
            if (TurretBullet.and(tilecid, 2)) {
                DungeonsOfHack.this.setTile(tx, ty, "");
            }
        }
    }

    public class Turret
    extends StdDungeonMonster {
        int bulletrate;
        int bulletcount;

        public Turret(double x, double y, int bulletrate) {
            super("turret", true, x, y, 4, "turret", 32);
            this.bulletrate = bulletrate;
            this.bulletcount = (int)this.random(0.0, bulletrate);
            if (DungeonsOfHack.this.isMidlet()) {
                this.expiry = -4.0;
            }
        }

        public void move() {
            super.move();
            if (this.bulletcount-- <= 0) {
                this.bulletcount = this.bulletrate;
            }
            if (this.bulletcount < (int)(50.0 / gamespeed) && this.bulletcount % (int)(8.0 / gamespeed) == 0 && DungeonsOfHack.this.player != null) {
                double angle = DungeonsOfHack.this.atan2(DungeonsOfHack.this.player.x - this.x, DungeonsOfHack.this.player.y - this.y);
                new TurretBullet(this.x, this.y, 2.0 * Math.sin(angle), 2.0 * Math.cos(angle), 70);
            }
        }
    }
}

