/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.StdDungeonMonster;
import jgame.JGObject;
import jgame.JGPoint;

public class StdDungeonPlayer
extends JGObject {
    public String gfx_prefix = null;
    public boolean continuous_anim;
    public int block_mask;
    public int occupy_mask;
    public int key_up;
    public int key_down;
    public int key_left;
    public int key_right;
    public boolean stop_moving;
    JGPoint occupied = null;

    public StdDungeonPlayer(String name, double x, double y, int cid, String graphic, boolean is_directional, boolean continuous_anim, int block_mask, int occupy_mask, double speed, int key_up, int key_down, int key_left, int key_right) {
        super(name, false, x, y, cid, graphic);
        this.setTileBBox(0, 0, this.eng.tileWidth(), this.eng.tileHeight());
        this.setDir(0, 0);
        if (is_directional) {
            this.gfx_prefix = graphic;
        }
        this.continuous_anim = continuous_anim;
        this.key_up = key_up;
        this.key_down = key_down;
        this.key_left = key_left;
        this.key_right = key_right;
        this.block_mask = block_mask;
        this.occupy_mask = occupy_mask;
        this.setSpeed(speed, speed);
    }

    public void move() {
        if (this.occupied == null || this.xdir == 0 && this.ydir == 0 && (!this.isXAligned() || !this.isYAligned())) {
            if (this.occupied != null) {
                this.eng.andTileCid(this.occupied.x, this.occupied.y, ~this.occupy_mask);
            }
            this.snapToGrid(this.eng.tileWidth(), this.eng.tileHeight());
            this.occupied = this.getCenterTile();
            this.eng.orTileCid(this.occupied.x, this.occupied.y, this.occupy_mask);
        } else if (!this.isXAligned() || !this.isYAligned()) {
            if (!this.continuous_anim) {
                this.startAnim();
            }
        } else {
            int prevxdir = this.xdir;
            int prevydir = this.ydir;
            this.snapToGrid();
            JGPoint cen = this.getCenterTile();
            this.setDir(0, 0);
            if (!this.stop_moving) {
                if (this.eng.getKey(this.key_left)) {
                    this.xdir = -1;
                }
                if (this.eng.getKey(this.key_right)) {
                    this.xdir = 1;
                }
                if (this.eng.getKey(this.key_up)) {
                    this.ydir = -1;
                }
                if (this.eng.getKey(this.key_down)) {
                    this.ydir = 1;
                }
            }
            StdDungeonMonster.checkIfBlocked(this, this.block_mask, prevxdir, prevydir);
            if (this.occupied != null) {
                this.eng.andTileCid(this.occupied.x, this.occupied.y, ~this.occupy_mask);
            }
            this.occupied = new JGPoint(cen.x + this.xdir, cen.y + this.ydir);
            this.eng.orTileCid(this.occupied.x, this.occupied.y, this.occupy_mask);
            if (!this.continuous_anim) {
                if (this.xdir != 0 || this.ydir != 0) {
                    this.startAnim();
                } else {
                    this.stopAnim();
                }
            }
        }
    }

    public void destroy() {
        if (this.occupied != null) {
            this.eng.andTileCid(this.occupied.x, this.occupied.y, ~this.occupy_mask);
        }
    }
}

