/*
 * Decompiled with CFR 0.152.
 */
package examples.guardian;

import examples.StdScoring;
import java.util.Iterator;
import java.util.Vector;
import jgame.Highscore;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.platform.StdGame;

public class Guardian
extends StdGame {
    double panxofs = 0.0;
    double panx = 0.0;
    JGFont scoring_font = new JGFont("Arial", 0, 16.0);
    JGColor[] cyclecol = new JGColor[]{JGColor.yellow, JGColor.green, JGColor.cyan, JGColor.blue, JGColor.magenta, JGColor.red};
    JGColor[] flashcol = new JGColor[]{JGColor.red, JGColor.yellow, JGColor.white, JGColor.yellow, JGColor.red, JGColor.black, JGColor.black, JGColor.black};

    public static void main(String[] args) {
        new Guardian(Guardian.parseSizeArgs(args, 0));
    }

    public Guardian() {
        this.initEngineApplet();
    }

    public Guardian(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(32, 24, 16, 16, null, null, null);
    }

    public void initGame() {
        int i;
        this.defineMedia("guardian.tbl");
        for (i = 0; i < 100; ++i) {
            this.defineImage("hills" + i, "h" + i, 0, "hills_map", i, "-");
        }
        for (i = 0; i < 32; ++i) {
            this.defineImage("base" + i, "b" + i, 0, "hq_map", i, "-");
        }
        this.setPFSize(224, 24);
        this.setPFWrap(true, false, 0, 0);
        this.setFrameRate(45.0, 1.0);
        this.setBGImage("starbg");
        this.setHighscores(10, new Highscore(0, "nobody"), 15);
        this.startgame_ingame = true;
        this.leveldone_ingame = true;
        this.leveldone_ticks = 200;
    }

    public void initNewLife() {
        new Player(0.0, this.pfHeight() / 2, 5.0);
    }

    public void defineLevel() {
        int y;
        int x;
        this.removeObjects(null, 0);
        new Player(0.0, this.pfHeight() / 2, 5.0);
        for (x = 0; x < this.pfTilesX(); ++x) {
            for (y = 0; y < 5; ++y) {
                this.setTile(x, this.pfTilesY() - 5 + y, "h" + (20 * y + x % 20));
            }
        }
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 8; ++y) {
                this.setTile(8 + x, this.pfTilesY() - 8 + y, "b" + (4 * y + x % 4));
            }
        }
        for (x = 0; x < 9; ++x) {
            new Humanoid(this.random(0.0, this.pfWidth()));
        }
        new HomeBase(128.0, 16 * (this.pfTilesY() - 8));
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void doFrameInGame() {
        if (this.gametime >= 800.0 && this.countObjects(null, 4) == 0) {
            this.levelDone();
        }
        this.moveObjects();
        this.checkCollision(108, 1);
        this.checkCollision(36, 2);
        this.checkCollision(16, 5);
        if (this.checkTime(0, 800, 100 - this.level * 5)) {
            new UFO(this.random(0.0, this.pfWidth()), this.random(16.0, this.pfHeight() - 32));
        }
        if (this.checkTime(0, 800, 220 - this.level * 12)) {
            new Bomber(this.random(0.0, this.pfWidth()), this.random(16.0, this.pfHeight() - 32));
        }
        if (this.checkTime(0, 800, 200 - this.level * 10)) {
            new Splitter(this.random(0.0, this.pfWidth()), this.random(16.0, this.pfHeight() - 32));
        }
        if (this.checkTime(1200, 2000, 250 - this.level * 10)) {
            new Baiter(this.random(0.0, this.pfWidth()), this.random(16.0, this.pfHeight() - 32));
        }
        this.setViewOffset((int)(this.panx + this.panxofs), 0, true);
        this.setBGImgOffset(0, (int)((this.panx + this.panxofs) / 3.0), 0.0, true);
    }

    public void incrementLevel() {
        if (this.level < 9) {
            ++this.level;
        }
        ++this.stage;
    }

    public void startLevelDone() {
        this.score += 50 * this.countObjects("humanoid", 0);
    }

    public void paintFrameLevelDone() {
        super.paintFrameLevelDone();
        this.setFont(this.title_font);
        this.drawString("Humanoids on surface x 50", this.viewWidth() / 2, this.viewHeight() * 2 / 3 - 30, 0);
        this.drawCount(this.countObjects("humanoid", 0), "human_r2", this.viewWidth() / 2 - 100, this.viewHeight() * 2 / 3, 20);
    }

    public void shootPlayer(double x, double y, double bulspeed) {
        JGObject player = this.getObject("player");
        if (player != null) {
            double angle = Math.atan2(player.x - x, player.y - y);
            new JGObject("bullet", true, x + 2.0, y + 2.0, 64, "bullet", bulspeed * Math.sin(angle), bulspeed * Math.cos(angle), -3);
        }
    }

    class Globe
    extends JGObject {
        Globe(double x, double y, double xspeed, double yspeed) {
            super("globe", true, x, y, 4, "globe");
            this.setSpeed(xspeed, yspeed);
        }

        public void move() {
            JGObject player = Guardian.this.getObject("player");
            if (player != null) {
                if (this.x > player.x) {
                    this.xspeed -= 0.2;
                }
                if (this.x < player.x) {
                    this.xspeed += 0.2;
                }
                if (this.y > player.y) {
                    this.yspeed -= 0.2;
                }
                if (this.y < player.y) {
                    this.yspeed += 0.2;
                }
                this.xspeed *= 0.95;
                this.yspeed *= 0.95;
            }
        }
    }

    class Mutant
    extends JGObject {
        int bullettimer = 20;

        Mutant(double x, double y) {
            super("mutant", true, x, y, 4, "mutant");
        }

        public void move() {
            JGObject player;
            --this.bullettimer;
            if (this.bullettimer == 0) {
                Guardian.this.shootPlayer(this.x, this.y, 4.0);
                this.bullettimer = this.random(7, 22, 1);
            }
            if ((player = Guardian.this.getObject("player")) != null) {
                if (this.x > player.x) {
                    this.xspeed -= 0.2;
                }
                if (this.x < player.x) {
                    this.xspeed += 0.2;
                }
                if (this.y > player.y - 50.0) {
                    this.yspeed -= 0.2;
                }
                if (this.y < player.y - 50.0) {
                    this.yspeed += 0.2;
                }
                this.xspeed *= 0.98;
                this.yspeed *= 0.98;
            }
        }
    }

    class UFO
    extends Enemy {
        int mode = 0;
        int homeintimer = 200;
        Humanoid abduct = null;
        int bullettimer = 100;

        public UFO(double x, double y) {
            super("ufo", x, y, 4, "ufo");
        }

        public void materialise() {
            this.setSpeed((double)this.random(-1, 1, 2) * this.random(2.0, 3.0), (double)this.random(-1, 1, 2) * this.random(0.5, 1.5));
        }

        public void move() {
            super.move();
            if (!this.isMaterialised()) {
                return;
            }
            --this.bullettimer;
            if (this.bullettimer == 0) {
                Guardian.this.shootPlayer(this.x, this.y, 4.0);
                this.bullettimer = this.random(80, 150, 1);
            }
            if (this.mode == 0) {
                if (this.y > (double)(Guardian.this.pfHeight() - 16) && this.yspeed > 0.0) {
                    this.yspeed = -this.yspeed;
                }
                if (this.y < 0.0 && this.yspeed < 0.0) {
                    this.yspeed = -this.yspeed;
                }
                if (this.homeintimer == 0) {
                    Vector obj = Guardian.this.getObjects("humanoid", 0, true, new JGRectangle((int)this.x - 64, (int)this.y, 144, Guardian.this.pfHeight()));
                    Iterator obji = obj.iterator();
                    while (obji.hasNext()) {
                        Humanoid h = (Humanoid)obji.next();
                        if (h.isFollowing()) continue;
                        this.mode = 1;
                        this.abduct = h;
                        break;
                    }
                    this.homeintimer = this.random(100, 200, 1);
                } else {
                    --this.homeintimer;
                }
            } else if (this.mode == 1) {
                this.setSpeed(0.0, 0.0);
                if (this.x > this.abduct.x + 1.0) {
                    this.x -= 1.2;
                }
                if (this.x < this.abduct.x - 1.0) {
                    this.x += 1.2;
                }
                this.y += 0.5;
                if (this.abduct.isFollowing() || !this.abduct.isAlive() || this.y >= (double)Guardian.this.pfHeight()) {
                    this.mode = 0;
                    this.setSpeed((double)this.random(-1, 1, 2) * this.random(2.0, 3.0), (double)this.random(-1, 1, 2) * this.random(0.5, 1.5));
                }
            } else {
                this.setSpeed(0.0, 0.0);
                this.y -= 0.5;
                this.abduct.x = this.x + 2.0;
                this.abduct.y = this.y + 16.0;
                if (this.y <= 0.0) {
                    this.remove();
                    this.abduct.remove();
                    new Mutant(this.x, this.y);
                }
            }
        }

        public void hit(JGObject obj) {
            if (UFO.and(obj.colid, 16) && this.mode == 1) {
                this.mode = 2;
                this.abduct.setFollowing(this);
            }
        }

        public void paint() {
            super.paint();
            if (this.mode == 1) {
                Guardian.this.drawImage((int)this.x + 2, (double)((int)this.y + 16), "tractor");
            }
        }
    }

    class Baiter
    extends Enemy {
        int bullettimer = 20;

        public Baiter(double x, double y) {
            super("baiter", x, y, 4, "baiter");
        }

        public void move() {
            super.move();
            if (!this.isMaterialised()) {
                return;
            }
            JGObject player = Guardian.this.getObject("player");
            if (player != null) {
                if (this.x > player.x) {
                    this.xspeed -= 0.2;
                }
                if (this.x < player.x) {
                    this.xspeed += 0.2;
                }
                if (this.y > player.y) {
                    this.y -= 0.2;
                }
                if (this.y < player.y) {
                    this.y += 0.2;
                }
                this.xspeed *= 0.99;
                this.yspeed *= 0.99;
            }
            --this.bullettimer;
            if (this.bullettimer == 0) {
                Guardian.this.shootPlayer(this.x, this.y, 4.0);
                this.bullettimer = this.random(15, 35, 1);
            }
        }
    }

    class Splitter
    extends Enemy {
        public Splitter(double x, double y) {
            super("splitter", x, y, 4, "splitter");
        }

        public void materialise() {
            this.setSpeed(this.random(-1, 1, 2) * 1, 0.0);
        }

        public void move() {
            super.move();
            if (!this.isMaterialised()) {
                return;
            }
            if (this.y < -21.0) {
                this.y = Guardian.this.pfHeight();
            }
            if (this.y > (double)(Guardian.this.pfHeight() + 1)) {
                this.y = -20.0;
            }
        }
    }

    class Bomber
    extends Enemy {
        int bombtimer = 50;

        public Bomber(double x, double y) {
            super("bomber", x, y, 4, "bomber");
        }

        public void materialise() {
            this.setSpeed(this.random(-1, 1, 2) * 2, this.random(-1, 1, 2) * 2);
        }

        public void move() {
            super.move();
            if (!this.isMaterialised()) {
                return;
            }
            if (this.y < -21.0) {
                this.y = Guardian.this.pfHeight();
            }
            if (this.y > (double)(Guardian.this.pfHeight() + 1)) {
                this.y = -20.0;
            }
            if (this.bombtimer <= 0) {
                this.bombtimer = this.random(100, 200, 1);
                JGObject mine = new JGObject("mine", true, this.x, this.y, 32, "mine" + (this.random(0.0, 1.0) > 0.5 ? "" : "r"), 350);
                mine.setAnimSpeed((double)this.random(-1, 1, 2) * this.random(0.2, 0.5));
            } else {
                --this.bombtimer;
            }
        }
    }

    class Enemy
    extends JGObject {
        String graphic;
        int materialisetimer = 90;
        int colcycle = 0;

        public Enemy(String name, double x, double y, int type, String graphic) {
            super(name, true, x, y, type, null);
            this.graphic = graphic;
        }

        public void move() {
            if (this.materialisetimer > 0) {
                --this.materialisetimer;
                if (this.materialisetimer == 0) {
                    this.setGraphic(this.graphic);
                    this.x -= 8.0;
                    this.y -= 8.0;
                    this.materialise();
                }
            }
        }

        public void materialise() {
        }

        public boolean isMaterialised() {
            return this.materialisetimer <= 0;
        }

        public void paint() {
            if (this.materialisetimer > 0) {
                this.colcycle = (this.colcycle + 1) % (Guardian.this.cyclecol.length * 2);
                Guardian.this.setColor(Guardian.this.cyclecol[this.colcycle / 2]);
                for (double i = 0.0; i < 6.28; i += 1.05) {
                    Guardian.this.drawOval(this.x + (double)this.materialisetimer * Math.sin(i + (double)this.materialisetimer / 20.0), this.y + (double)this.materialisetimer * Math.cos(i + (double)this.materialisetimer / 20.0), 10 - this.materialisetimer / 10, 10 - this.materialisetimer / 10, true, true);
                }
            }
        }
    }

    class Humanoid
    extends JGObject {
        JGObject following = null;

        public Humanoid(double x) {
            super("humanoid", true, x, Guardian.this.pfHeight() - 23, 16, null);
            this.setSpeed(this.random(0.6, 0.8), 0.0);
            this.xdir = 0;
        }

        public void move() {
            if (this.following == null) {
                if (this.y < (double)(Guardian.this.pfHeight() - 23)) {
                    this.stopAnim();
                    this.xdir = 0;
                    this.y += 2.0;
                    if (this.y >= (double)(Guardian.this.pfHeight() - 23)) {
                        this.y = Guardian.this.pfHeight() - 23;
                        this.startAnim();
                    }
                } else if (this.xdir < 0) {
                    this.setGraphic("human_l");
                } else if (this.xdir > 0) {
                    this.setGraphic("human_r");
                } else {
                    this.xdir = this.random(-1, 1, 2);
                }
                this.setAnimSpeed(this.xspeed / 0.7 * 0.3);
            } else {
                this.stopAnim();
                this.xdir = 0;
                if (!this.following.isAlive()) {
                    this.following = null;
                }
            }
        }

        public boolean isFollowing() {
            return this.following != null;
        }

        public void setFollowing(JGObject obj) {
            this.following = obj;
        }
    }

    class HomeBase
    extends JGObject {
        int colcycle1 = 0;
        int colcycle2 = 0;
        int colcycle3 = 6;

        public HomeBase(double x, double y) {
            super("homebase", false, x, y, 8, null);
            this.setBBox(0, -16, 64, 16);
        }

        public void paint() {
            this.colcycle1 = (this.colcycle1 + 1) % (Guardian.this.flashcol.length * 2);
            this.colcycle2 = (this.colcycle2 + 1) % (Guardian.this.flashcol.length * 4);
            this.colcycle3 = (this.colcycle3 + 1) % (Guardian.this.flashcol.length * 4);
            Guardian.this.setColor(Guardian.this.flashcol[this.colcycle1 / 2]);
            Guardian.this.drawOval(this.x + 34.0, this.y + 3.0, 4.0, 4.0, true, true);
            Guardian.this.setColor(Guardian.this.flashcol[this.colcycle2 / 4]);
            Guardian.this.drawOval(this.x + 14.0, this.y + 8.0, 2.0, 2.0, true, true);
            Guardian.this.setColor(Guardian.this.flashcol[this.colcycle3 / 4]);
            Guardian.this.drawOval(this.x + 54.0, this.y + 8.0, 2.0, 2.0, true, true);
        }
    }

    class Explo
    extends JGObject {
        int colcycle;
        double phase1 = this.random(0.0, 3.14);
        double phase2 = this.random(0.0, 3.14);

        public Explo(double x, double y, int wait) {
            super("explo", true, x, y, 0, null, 30 + wait);
        }

        public void paint() {
            if (this.expiry >= 30.0) {
                return;
            }
            this.colcycle = (this.colcycle + 1) % (Guardian.this.cyclecol.length * 2);
            Guardian.this.setColor(Guardian.this.cyclecol[this.colcycle / 2]);
            int i = 0;
            while ((double)i < this.expiry / 2.0) {
                double expiry_fac = 0.3 * Math.sin(this.phase2 + (this.expiry - (double)i) / 4.0);
                Guardian.this.drawOval(this.x + ((double)i / 2.0 + 1.0) * (30.0 - this.expiry) * Math.sin(this.phase1 + (double)i + expiry_fac), this.y + ((double)i / 2.0 + 1.0) * (30.0 - this.expiry) * Math.cos(this.phase1 + (double)i + expiry_fac), 1.0 + this.expiry / 3.0, 1.0 + this.expiry / 3.0, true, true);
                ++i;
            }
        }
    }

    class Laser
    extends JGObject {
        double backx;
        int dir;
        double speedofs;
        int colcycle = 0;

        public Laser(double x, double y, int dir, double speedofs) {
            super("laser", true, x, y, 2, null, 18);
            this.backx = x;
            this.dir = dir;
            this.speedofs = speedofs;
        }

        public void move() {
            this.x += (double)(30 * this.dir) + this.speedofs;
            this.backx += (double)(10 * this.dir) + this.speedofs;
            if (this.backx < this.x) {
                this.setBBox((int)(-(this.x - this.backx)), 0, (int)(this.x - this.backx), 1);
            } else {
                this.setBBox(0, 0, (int)(this.backx - this.x), 1);
            }
        }

        public void hit(JGObject obj) {
            if (!obj.isAlive()) {
                return;
            }
            this.remove();
            if (Laser.and(obj.colid, 32)) {
                return;
            }
            obj.remove();
            Guardian.this.score += 5;
            if (obj instanceof Splitter) {
                Guardian.this.score += 5;
                for (double i = 0.0; i < 6.28; i += 0.525) {
                    new Globe(obj.x, obj.y, 6.0 * Math.sin(i), 6.0 * Math.cos(i));
                }
            }
            if (obj instanceof Baiter) {
                Guardian.this.score += 20;
            }
            new Explo(obj.x + 8.0, obj.y + 8.0, 0);
            new Explo(obj.x + 8.0, obj.y + 8.0, 1);
            new Explo(obj.x + 8.0, obj.y + 8.0, 2);
            new Explo(obj.x + 8.0, obj.y + 8.0, 3);
        }

        public void paint() {
            Guardian.this.setStroke(2.0);
            this.colcycle = (this.colcycle + 1) % Guardian.this.cyclecol.length;
            Guardian.this.setColor(Guardian.this.cyclecol[this.colcycle]);
            Guardian.this.drawLine(this.x, this.y, this.backx, this.y);
        }
    }

    class Player
    extends JGObject {
        int invulnerability = 70;
        int dir = 1;
        int bullettime = 0;
        Humanoid pickedup = null;
        int thrustdir = 0;

        public Player(double x, double y, double speed) {
            super("player", false, x, y, 1, "shipr");
        }

        public void move() {
            if (this.invulnerability > 0) {
                --this.invulnerability;
            }
            if (Guardian.this.getKey(Guardian.this.key_up) && this.y > 0.0) {
                if (this.yspeed > -2.5) {
                    this.yspeed = -2.5;
                } else if (Guardian.this.getKey(Guardian.this.key_fire)) {
                    if (this.yspeed > -8.0) {
                        this.yspeed -= 0.15;
                    }
                } else if (this.yspeed > -8.0) {
                    this.yspeed -= 0.5;
                }
            } else if (Guardian.this.getKey(Guardian.this.key_down) && this.y < (double)(Guardian.this.pfHeight() - 24)) {
                if (this.yspeed < 2.5) {
                    this.yspeed = 2.5;
                } else if (Guardian.this.getKey(Guardian.this.key_fire)) {
                    if (this.yspeed < 8.0) {
                        this.yspeed += 0.15;
                    }
                } else if (this.yspeed < 8.0) {
                    this.yspeed += 0.5;
                }
            } else {
                this.yspeed = 0.0;
            }
            if (this.y < 0.0) {
                this.y = 0.0;
                this.yspeed = 0.0;
            }
            if (this.y > (double)(Guardian.this.pfHeight() - 24)) {
                this.y = Guardian.this.pfHeight() - 24;
                this.yspeed = 0.0;
            }
            this.thrustdir = 0;
            if (Guardian.this.getKey(Guardian.this.key_left)) {
                if (this.xspeed > 0.0) {
                    this.xspeed -= 2.0;
                }
                if (this.xspeed > -30.0) {
                    this.xspeed -= 0.9;
                }
                this.dir = -1;
                this.thrustdir = -1;
                this.setGraphic("shipl");
            } else if (Guardian.this.getKey(Guardian.this.key_right)) {
                if (this.xspeed < 0.0) {
                    this.xspeed += 2.0;
                }
                if (this.xspeed < 30.0) {
                    this.xspeed += 0.9;
                }
                this.dir = 1;
                this.thrustdir = 1;
                this.setGraphic("shipr");
            } else {
                if (this.xspeed > 0.0) {
                    this.xspeed -= 1.0;
                }
                if (this.xspeed < 0.0) {
                    this.xspeed += 1.0;
                }
                if (this.xspeed > -1.0 && this.xspeed < 1.0) {
                    this.xspeed = 0.0;
                }
            }
            if (this.dir > 0) {
                if (Guardian.this.panxofs < (double)(Guardian.this.viewWidth() / 4)) {
                    Guardian.this.panxofs += 15.0;
                    if (Guardian.this.panxofs > (double)(Guardian.this.viewWidth() / 4)) {
                        Guardian.this.panxofs = Guardian.this.viewWidth() / 4;
                    }
                }
            } else if (Guardian.this.panxofs > (double)(-Guardian.this.viewWidth() / 4)) {
                Guardian.this.panxofs -= 15.0;
                if (Guardian.this.panxofs < (double)(-Guardian.this.viewWidth() / 4)) {
                    Guardian.this.panxofs = -Guardian.this.viewWidth() / 4;
                }
            }
            Guardian.this.panx = this.x + this.xspeed + 16.0;
            if (this.bullettime > 0) {
                --this.bullettime;
            } else if (Guardian.this.getKey(Guardian.this.key_fire)) {
                this.bullettime = 2;
                new Laser(this.x + 16.0, this.y + 8.0, this.dir, this.xspeed);
            }
            if (this.pickedup != null) {
                this.pickedup.x = this.x + this.xspeed * (double)this.xdir + 8.0;
                this.pickedup.y = this.y + this.yspeed * (double)this.ydir + 16.0;
            }
        }

        public void hit(JGObject obj) {
            if (Player.and(obj.colid, 100) && this.invulnerability <= 0) {
                Guardian.this.lifeLost();
            } else if (Player.and(obj.colid, 16)) {
                Humanoid h = (Humanoid)obj;
                if (!h.isFollowing() && this.pickedup == null) {
                    h.setFollowing(this);
                    this.pickedup = h;
                }
            } else if (this.pickedup != null) {
                new StdScoring("pts", obj.x + 32.0, obj.y, 0.0, -1.0, 40, "100 pts", Guardian.this.scoring_font, new JGColor[]{JGColor.blue, JGColor.cyan}, 2);
                Guardian.this.score += 100;
                this.pickedup.remove();
                this.pickedup = null;
            }
        }

        public void paint() {
            Guardian.this.setColor(JGColor.white);
            if (this.invulnerability > 0 && this.invulnerability % 3 == 0) {
                Guardian.this.drawOval(this.x - 4.0, this.y - 4.0, 40.0, 24.0, true, false);
            }
            if (this.thrustdir == 1) {
                Guardian.this.setColor(JGColor.yellow);
                if (Guardian.this.gametime % 4.0 <= 1.0) {
                    Guardian.this.drawOval(this.x - 6.0, this.y + 10.0, 12.0, 6.0, true, true);
                } else {
                    Guardian.this.drawOval(this.x - 4.0, this.y + 10.0, 8.0, 6.0, true, true);
                }
            }
            if (this.thrustdir == -1) {
                Guardian.this.setColor(JGColor.yellow);
                if (Guardian.this.gametime % 4.0 <= 1.0) {
                    Guardian.this.drawOval(this.x + 32.0 + 6.0, this.y + 10.0, 12.0, 6.0, true, true);
                } else {
                    Guardian.this.drawOval(this.x + 32.0 + 4.0, this.y + 10.0, 8.0, 6.0, true, true);
                }
            }
        }
    }
}

