/*
 * Decompiled with CFR 0.152.
 */
package examples.pubman;

import examples.StdMazeMonster;
import examples.StdMazePlayer;
import examples.StdScoring;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class PubMan
extends StdGame {
    Player player = null;
    JGObject ghost_house = null;
    int nr_pills;
    double powerpilltime = 0.0;
    double powerpillmax;
    int powerpillcaught;
    JGFont scorefont = new JGFont("Helvetica", 0, 18.0);

    public static void main(String[] args) {
        new PubMan(PubMan.parseSizeArgs(args, 0));
    }

    public PubMan() {
        this.initEngineApplet();
    }

    public PubMan(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(19, 15, 16, 16, null, null, null);
        if (this.isMidlet()) {
            this.setScalingPreferences(0.75, 1.3333333333333333, 0, 5, 5, 5);
        }
    }

    public void initGame() {
        this.defineMedia("pub_man.tbl");
        this.setVideoSyncedUpdate(true);
        if (this.isMidlet()) {
            this.setFrameRate(15.0, 4.0);
            this.setGameSpeed(2.0);
        } else {
            this.setFrameRate(40.0, 4.0);
        }
        this.startgame_ticks = 80;
        this.leveldone_ticks = 80;
        this.lifelost_ticks = 80;
        this.gameover_ticks = 120;
        this.startgame_ingame = true;
        this.stage = 1;
        this.defineLevel();
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkBGCollision(2, 1);
        this.checkBGCollision(4, 1);
        this.checkCollision(9, 2);
        this.checkCollision(4, 1);
        if (this.powerpilltime > 0.0) {
            this.powerpilltime -= this.getGameSpeed();
        }
    }

    public void paintFrame() {
        this.setFont(this.scorefont);
        this.drawString("" + this.score, 16.0, 0.0, -1);
        for (int i = 1; i < this.lives; ++i) {
            this.drawImage(this.pfWidth() - 16 - 16 * i, 0.0, "player_d7");
        }
    }

    public void paintFrameTitle() {
        this.drawImage(90.0, 72.0, "splash_image");
        if (!this.isMidlet()) {
            this.drawImageString("PRESS " + this.getKeyDesc(this.key_startgame).toUpperCase(), this.pfWidth() / 2, 140.0, 0, "font_map", 32, 2);
        } else {
            this.drawImageString("STAR TO START", this.pfWidth() / 2, 130.0, 0, "font_map", 32, 2);
            this.drawImageString("POUND TO QUIT", this.pfWidth() / 2, 160.0, 0, "font_map", 32, 2);
        }
    }

    public void paintFrameLifeLost() {
        int ypos = this.posWalkForwards(-16, this.pfHeight(), this.seqtimer, 80, 75, 10, 30);
        this.drawImageString("CAUGHT!", this.pfWidth() / 2, ypos, 0, "font_map", 32, 2);
    }

    public void paintFrameGameOver() {
        this.drawImageString("GAME OVER!", this.pfWidth() / 2, 75.0, 0, "font_map", 32, 2);
    }

    public void paintFrameLevelDone() {
        int ypos = this.posWalkForwards(-16, this.pfHeight(), this.seqtimer, 80, 75, 10, 30);
        this.drawImageString("LEVEL CLEAR!", this.pfWidth() / 2, ypos, 0, "font_map", 32, 2);
    }

    public void paintFrameStartLevel() {
        int ypos = this.posWalkForwards(this.pfHeight() - 8, this.pfHeight() - 8, this.seqtimer, 80, 113, 55, 10);
        this.drawImageString("LEVEL " + (this.stage + 1), this.pfWidth() / 2, ypos, 0, "font_map", 32, 2);
    }

    public void paintFrameStartGame() {
        int ypos = this.posWalkForwards(this.pfHeight() + 24, this.pfHeight() + 24, this.seqtimer, 80, 145, 55, 10);
        this.drawImageString("READY!", this.pfWidth() / 2, ypos, 0, "font_map", 32, 2);
    }

    public void incrementLevel() {
        ++this.level;
        ++this.stage;
        if (this.level >= 9) {
            this.level = 6;
        }
    }

    public void startInGame() {
        this.powerpillmax = 250 - 22 * this.level;
        this.powerpilltime = 0.0;
        this.removeObjects("enemy", 0);
        this.player = new Player(144.0, 176.0, this.key_up, this.key_down, this.key_left, this.key_right);
        this.ghost_house = new JGObject("ghost_house", false, 9 * this.tileWidth(), 5 * this.tileHeight() - 2, 8, null);
        this.ghost_house.setBBox(0, 0, 16, 16);
        for (int i = 0; i < 4 + this.level / 3; ++i) {
            new Enemy(9.0, 5.0, 0, -1, 1.5 + (double)i * 0.1);
        }
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void defineLevel() {
        int i;
        int x;
        int y;
        this.removeObjects(null, 0);
        this.fillBG(".");
        for (y = 0; y < this.pfTilesY(); ++y) {
            for (x = 0; x <= this.pfTilesX() / 2; ++x) {
                if (!this.and(x, 1) && !this.and(y, 1)) {
                    this.setTile(x, y, "#" + this.stage % 5);
                    continue;
                }
                if (x != 0 && x != this.pfTilesX() - 1 && y != 0 && y != this.pfTilesY() - 1) continue;
                this.setTile(x, y, "#" + this.stage % 5);
            }
        }
        this.setTile(8, 3, "f");
        this.setTile(9, 3, "f");
        this.setTile(6, 1, "g");
        this.setTile(7, 3, "g");
        this.setTile(7, 4, "f");
        this.setTile(7, 5, "f");
        for (i = 6; i <= 9; ++i) {
            this.setTile(i, 11, "f");
        }
        this.setTile(9, 12, "f");
        for (i = 0; i < 5 - this.level % 3; ++i) {
            int ycen;
            int xcen;
            while (this.and(this.getTileCid((xcen = this.random(2, this.pfTilesX() / 2 - 2, 2)) - 1, ycen = this.random(2, this.pfTilesY() - 4, 4) + ((xcen & 2) != 0 ? 0 : 2)) | this.getTileCid(xcen + 1, ycen) | this.getTileCid(xcen, ycen - 1) | this.getTileCid(xcen, ycen + 1), 21)) {
            }
            if (this.random(0.0, 1.0) > 0.5 || xcen >= 4 && xcen <= 6 && ycen >= 4 && ycen <= 6) {
                this.setTile(xcen + 1, ycen, "d");
                this.setTile(xcen - 1, ycen, "d");
                this.setTile(xcen, ycen - 1, "v");
                this.setTile(xcen, ycen + 1, "^");
                continue;
            }
            this.setTile(xcen + 1, ycen, "<");
            this.setTile(xcen - 1, ycen, ">");
            this.setTile(xcen, ycen - 1, "d");
            this.setTile(xcen, ycen + 1, "d");
        }
        for (i = 0; i < 10; ++i) {
            int wy;
            int wx;
            while (this.and(this.getTileCid(wx = this.random(1, this.pfTilesX() / 2, 1), wy = this.random(1, this.pfTilesY() - 1, 2) + ((wx & 1) != 0 ? 1 : 0)), 101) || wx == 5 && wy == 6 || wx == 5 && wy == 8) {
            }
            this.setTile(wx, wy, "#" + this.stage % 5);
        }
        this.setTile(9, 4, "=");
        this.setTile(8, 5, "#" + this.stage % 5);
        this.setTile(8, 6, "#" + this.stage % 5);
        this.setTile(9, 6, "#" + this.stage % 5);
        for (y = 0; y < this.pfTilesY(); ++y) {
            for (x = 0; x < this.pfTilesX() / 2; ++x) {
                String tile = this.getTileStr(x, y);
                if (tile.equals(">")) {
                    tile = "<";
                } else if (tile.equals("<")) {
                    tile = ">";
                }
                this.setTile(this.pfTilesX() - 1 - x, y, tile);
            }
        }
        this.floodFillPills(9, 11);
        block9: for (int py = 1; py < this.pfTilesY(); py += this.pfTilesY() - 3) {
            for (int px = 1; px < this.pfTilesX() / 2 - 1; ++px) {
                if (!this.and(this.getTileCid(px, py), 2)) continue;
                new JGObject("powerpill", true, px * this.tileWidth(), py * this.tileHeight(), 4, "powerpill");
                new JGObject("powerpill", true, (this.pfTilesX() - 1 - px) * this.tileWidth(), py * this.tileHeight(), 4, "powerpill");
                continue block9;
            }
        }
        this.nr_pills = this.countTiles(2);
    }

    void floodFillPills(int x, int y) {
        if (this.and(this.getTileCid(x, y), 11)) {
            return;
        }
        if (!this.and(this.getTileCid(x, y), 36)) {
            this.setTile(x, y, "o");
        }
        if (x > 0) {
            this.floodFillPills(x - 1, y);
        }
        if (y > 0) {
            this.floodFillPills(x, y - 1);
        }
        if (x < this.pfTilesX() - 1) {
            this.floodFillPills(x + 1, y);
        }
        if (y < this.pfTilesY() - 1) {
            this.floodFillPills(x, y + 1);
        }
    }

    public class Enemy
    extends StdMazeMonster {
        boolean is_eaten = false;
        boolean is_restored = false;

        public Enemy(double x, double y, int xdir, int ydir, double speed) {
            super("enemy", true, 16.0 * x, 16.0 * y, 2, "enemy_", true, 5, xdir, ydir, speed, null, false, 0.4);
        }

        public void move() {
            if (this.is_eaten) {
                this.avoid = false;
                this.home_in = PubMan.this.ghost_house;
                this.gfx_prefix = "enemy_bk_";
                this.block_mask = 1;
                this.random_proportion = 0.25;
            } else {
                this.random_proportion = 0.4;
                this.block_mask = 5;
                if (PubMan.this.powerpilltime >= PubMan.this.powerpillmax) {
                    this.xdir = -this.xdir;
                    this.ydir = -this.ydir;
                }
                if (PubMan.this.powerpilltime > 0.0 && !this.is_restored) {
                    this.home_in = PubMan.this.player;
                    this.avoid = true;
                    this.gfx_prefix = PubMan.this.powerpilltime < 80.0 && ((int)PubMan.this.powerpilltime & 8) != 0 ? "enemy_w_" : "enemy_b_";
                } else if (PubMan.this.powerpilltime <= 0.0 || PubMan.this.powerpilltime >= PubMan.this.powerpillmax) {
                    this.is_restored = false;
                    this.home_in = PubMan.this.player;
                    this.avoid = false;
                    this.gfx_prefix = "enemy_";
                } else {
                    this.home_in = PubMan.this.player;
                    this.avoid = false;
                    this.gfx_prefix = "enemy_";
                }
            }
            super.move();
        }

        public void hit(JGObject obj) {
            if (!(obj instanceof Player)) {
                if (this.is_eaten) {
                    this.is_eaten = false;
                    this.is_restored = true;
                }
            } else {
                if (PubMan.this.powerpilltime > 0.0 && !this.is_eaten && !this.is_restored) {
                    this.is_eaten = true;
                    this.xdir = -this.xdir;
                    this.ydir = -this.ydir;
                    PubMan.this.score += 100 * (1 << PubMan.this.powerpillcaught);
                    new StdScoring("Scoring", this.x + 8.0, this.y + 4.0, 0.0, 0.0, 80, "" + 100 * (1 << PubMan.this.powerpillcaught), new JGFont("Helvetica", 0, 10.0), new JGColor[]{JGColor.white, JGColor.green}, 16);
                    ++PubMan.this.powerpillcaught;
                }
                if ((PubMan.this.powerpilltime <= 0.0 && !this.is_eaten || this.is_restored) && !((Player)obj).is_dead) {
                    ((Player)obj).is_dead = true;
                    PubMan.this.lifeLost();
                }
            }
        }
    }

    public class Player
    extends StdMazePlayer {
        public boolean is_dead = false;

        public Player(double x, double y, int k_u, int k_d, int k_l, int k_r) {
            super("player", x, y, 1, "player_", true, false, 9, 3.0, k_u, k_d, k_l, k_r);
        }

        public void move() {
            super.move();
        }

        public void hit(JGObject obj) {
            obj.remove();
            PubMan.this.score += 50;
            PubMan.this.powerpilltime = PubMan.this.powerpillmax + 1.0;
            PubMan.this.powerpillcaught = 0;
        }

        public void hit_bg(int tilecid, int tx, int ty, int txsize, int tysize) {
            JGPoint cen;
            for (int dy = 0; dy < tysize; ++dy) {
                for (int dx = 0; dx < txsize; ++dx) {
                    if (!Player.and(PubMan.this.getTileCid(tx + dx, ty + dy), 2)) continue;
                    PubMan.this.setTile(tx + dx, ty + dy, ".");
                    --PubMan.this.nr_pills;
                    PubMan.this.score += 5;
                }
            }
            if (PubMan.this.nr_pills <= 0) {
                PubMan.this.levelDone();
            }
            if (Player.and(PubMan.this.getTileCid(cen = this.getCenterTile(), 0, 0), 4)) {
                String door = PubMan.this.getTileStr(cen, 0, 0);
                if (door.equals("^")) {
                    PubMan.this.setTile(cen.x, cen.y, ".");
                    PubMan.this.setTile(cen.x, cen.y - 2, ".");
                    PubMan.this.setTile(cen.x - 1, cen.y - 1, ">");
                    PubMan.this.setTile(cen.x + 1, cen.y - 1, "<");
                } else if (door.equals("v")) {
                    PubMan.this.setTile(cen.x, cen.y, ".");
                    PubMan.this.setTile(cen.x, cen.y + 2, ".");
                    PubMan.this.setTile(cen.x - 1, cen.y + 1, ">");
                    PubMan.this.setTile(cen.x + 1, cen.y + 1, "<");
                } else if (door.equals("<")) {
                    PubMan.this.setTile(cen.x, cen.y, ".");
                    PubMan.this.setTile(cen.x - 2, cen.y, ".");
                    PubMan.this.setTile(cen.x - 1, cen.y - 1, "v");
                    PubMan.this.setTile(cen.x - 1, cen.y + 1, "^");
                } else if (door.equals(">")) {
                    PubMan.this.setTile(cen.x, cen.y, ".");
                    PubMan.this.setTile(cen.x + 2, cen.y, ".");
                    PubMan.this.setTile(cen.x + 1, cen.y - 1, "v");
                    PubMan.this.setTile(cen.x + 1, cen.y + 1, "^");
                }
            }
        }
    }
}

