/*
 * Decompiled with CFR 0.152.
 */
package examples;

import jgame.JGObject;
import jgame.JGPoint;

public class StdMazePlayer
extends JGObject {
    public String gfx_prefix = null;
    public String cur_gfx_suffix = "";
    public boolean continuous_anim;
    public int block_mask;
    public double speed;
    public int key_up;
    public int key_down;
    public int key_left;
    public int key_right;
    public boolean stop_moving;
    int moving = 0;

    public StdMazePlayer(String name, double x, double y, int cid, String graphic, boolean is_directional, boolean continuous_anim, int block_mask, double speed, int key_up, int key_down, int key_left, int key_right) {
        super(name, false, x, y, cid, graphic);
        this.snapToGrid(this.eng.tileWidth(), this.eng.tileHeight());
        this.setTileBBox(0, 0, this.eng.tileWidth(), this.eng.tileHeight());
        this.setDir(0, 1);
        if (is_directional) {
            this.gfx_prefix = graphic;
        }
        this.continuous_anim = continuous_anim;
        this.key_up = key_up;
        this.key_down = key_down;
        this.key_left = key_left;
        this.key_right = key_right;
        this.block_mask = block_mask;
        this.speed = speed;
    }

    public void move() {
        boolean go_left = false;
        boolean go_right = false;
        boolean go_up = false;
        boolean go_down = false;
        if (!this.stop_moving) {
            go_left = this.eng.getKey(this.key_left);
            go_right = this.eng.getKey(this.key_right);
            go_up = this.eng.getKey(this.key_up);
            go_down = this.eng.getKey(this.key_down);
        }
        JGPoint cen = this.getCenterTile();
        double rawspeed = this.speed * this.eng.getGameSpeed();
        if (!this.isXAligned(rawspeed / 2.0) || !this.isYAligned(rawspeed / 2.0)) {
            this.moving = 1;
            if (!this.continuous_anim) {
                this.startAnim();
            }
            if (this.isXAligned(rawspeed / 2.0)) {
                if (go_left && !go_up && !go_down && this.eng.getYAlignOfs(this.y) * (double)this.ydir > 0.0 && !StdMazePlayer.and(this.eng.getTileCid(cen, -1, 0), this.block_mask)) {
                    this.ydir = -this.ydir;
                }
                if (go_right && !go_up && !go_down && this.eng.getYAlignOfs(this.y) * (double)this.ydir > 0.0 && !StdMazePlayer.and(this.eng.getTileCid(cen, 1, 0), this.block_mask)) {
                    this.ydir = -this.ydir;
                }
            }
            if (this.isYAligned(rawspeed / 2.0)) {
                if (go_up && !go_left && !go_right && this.eng.getXAlignOfs(this.x) * (double)this.xdir > 0.0 && !StdMazePlayer.and(this.eng.getTileCid(cen, 0, -1), this.block_mask)) {
                    this.xdir = -this.xdir;
                }
                if (go_down && !go_left && !go_right && this.eng.getXAlignOfs(this.x) * (double)this.xdir > 0.0 && !StdMazePlayer.and(this.eng.getTileCid(cen, 0, 1), this.block_mask)) {
                    this.xdir = -this.xdir;
                }
            }
        } else {
            if ((go_left || go_right) && (go_up || go_down)) {
                if (this.ydir < 0) {
                    go_up = false;
                }
                if (this.ydir > 0) {
                    go_down = false;
                }
                if (this.xdir < 0) {
                    go_left = false;
                }
                if (this.xdir > 0) {
                    go_right = false;
                }
            }
            this.snapToGrid(rawspeed / 2.0, rawspeed / 2.0);
            this.moving = 0;
            if (!this.continuous_anim) {
                this.stopAnim();
            }
            if (go_up) {
                if (!StdMazePlayer.and(this.eng.getTileCid(cen, 0, -1), this.block_mask)) {
                    this.setDir(0, -1);
                    if (this.gfx_prefix != null) {
                        this.cur_gfx_suffix = "u";
                        this.setGraphic(this.gfx_prefix + this.cur_gfx_suffix);
                    }
                }
                this.moving = 1;
            }
            if (go_down) {
                if (!StdMazePlayer.and(this.eng.getTileCid(cen, 0, 1), this.block_mask)) {
                    this.setDir(0, 1);
                    if (this.gfx_prefix != null) {
                        this.cur_gfx_suffix = "d";
                        this.setGraphic(this.gfx_prefix + this.cur_gfx_suffix);
                    }
                }
                this.moving = 1;
            }
            if (go_left) {
                if (!StdMazePlayer.and(this.eng.getTileCid(cen, -1, 0), this.block_mask)) {
                    this.setDir(-1, 0);
                    if (this.gfx_prefix != null) {
                        this.cur_gfx_suffix = "l";
                        this.setGraphic(this.gfx_prefix + this.cur_gfx_suffix);
                    }
                }
                this.moving = 1;
            }
            if (go_right) {
                if (!StdMazePlayer.and(this.eng.getTileCid(cen, 1, 0), this.block_mask)) {
                    this.setDir(1, 0);
                    if (this.gfx_prefix != null) {
                        this.cur_gfx_suffix = "r";
                        this.setGraphic(this.gfx_prefix + this.cur_gfx_suffix);
                    }
                }
                this.moving = 1;
            }
            if (StdMazePlayer.and(this.eng.getTileCid(cen, this.xdir, this.ydir), this.block_mask)) {
                this.moving = 0;
            }
        }
        this.setSpeed(this.moving == 1 ? this.speed : 0.0);
    }
}

