/*
 * Decompiled with CFR 0.152.
 */
package examples.gamegen;

import examples.StdScoring;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.platform.AppConfig;
import jgame.platform.StdGame;

public class SimpleGeneratedGame
extends StdGame {
    static final int PLAYERTYPE = 32;
    static final int BULLETTYPE = 16;
    AppConfig gamecfg;
    JGFont scoring_font = new JGFont("Arial", 0, 16.0);
    public String gp_gamename = "MyGame";
    Player player = null;
    public String gp_basebg = "empty";
    public double gp_basebgmazeysize = 1.0;
    public double gp_basebgmazexsize = 5.0;
    public int gp_basebgtype = 0;
    public String gp_basebgtile = "w";
    public String gp_basebgfill = "k";
    public boolean gp_randombg1 = false;
    public double gp_randombg1density = 0.0;
    public int gp_randombg1type = 0;
    public String gp_randombg1tile = "w";
    public boolean gp_randombg2 = false;
    public double gp_randombg2density = 0.0;
    public int gp_randombg2type = 0;
    public String gp_randombg2tile = "w";
    public boolean gp_randombg3 = false;
    public double gp_randombg3density = 0.0;
    public int gp_randombg3type = 0;
    public String gp_randombg3tile = "w";
    public String gp_playersprite = "white16";
    public double gp_playerx = 312.0;
    public double gp_playery = 232.0;
    public String gp_playerxmove = "linear";
    public double gp_playerxspeed = 8.0;
    public double gp_playerxaccel = 1.0;
    public String gp_playerymove = "linear";
    public double gp_playeryspeed = 8.0;
    public double gp_playeryaccel = 1.0;
    public int gp_playerbumpbgtype = 0;
    public int gp_playerdiebgtype = 0;
    public int gp_playerdieobjtype = 0;
    public int gp_playergetobjtype = 0;
    public double gp_playergetscore = 10.0;
    public String gp_playershoot = "off";
    public String gp_playershootdir = "left";
    public String gp_playershootaxis = "horizontal";
    public double gp_playerbulletspeed = 10.0;
    public double gp_playermaxbullets = 1.0;
    public int gp_playerbulletdiebgtype = 0;
    public boolean gp_endleveltimeout = false;
    public double gp_endleveltimeoutlen = 50.0;
    public boolean gp_endlevelobjcount = false;
    public int gp_endlevelobjtype = 0;
    public double gp_endlevelscore = 100.0;
    AgentMotion[] xmots = new AgentMotion[5];
    AgentMotion[] ymots = new AgentMotion[5];
    public boolean gp_agent1 = false;
    public int gp_agent1type = 0;
    public String gp_agent1sprite = "white16";
    public String gp_agent1createloc = "random";
    public double gp_agent1createinit = 1.0;
    public double gp_agent1createinterval = 0.0;
    public double gp_agent1createbegin = 0.0;
    public double gp_agent1createend = 999999.0;
    public double gp_agent1xspeed = 5.0;
    public String gp_agent1movexinit = "center";
    public boolean gp_agent1movexrandom = false;
    public double gp_agent1movexrandomchg = 1.0;
    public boolean gp_agent1movextoplayer = false;
    public double gp_agent1movextoplayermin = 0.0;
    public double gp_agent1movextoplayermax = 200.0;
    public boolean gp_agent1movexfrplayer = false;
    public double gp_agent1movexfrplayermin = 0.0;
    public double gp_agent1movexfrplayermax = 200.0;
    public double gp_agent1yspeed = 5.0;
    public String gp_agent1moveyinit = "center";
    public boolean gp_agent1moveyrandom = false;
    public double gp_agent1moveyrandomchg = 1.0;
    public boolean gp_agent1moveytoplayer = false;
    public double gp_agent1moveytoplayermin = 0.0;
    public double gp_agent1moveytoplayermax = 200.0;
    public boolean gp_agent1moveyfrplayer = false;
    public double gp_agent1moveyfrplayermin = 0.0;
    public double gp_agent1moveyfrplayermax = 200.0;
    public boolean gp_agent1shoot = false;
    public double gp_agent1shootfreq = 5.0;
    public String gp_agent1shootdir = "player";
    public double gp_agent1shootspeed = 10.0;
    public int gp_agent1bullettype = 0;
    public String gp_agent1bouncesides = "none";
    public int gp_agent1dieobjtype = 0;
    public int gp_agent1blockbgtype = 0;
    public int gp_agent1diebgtype = 0;
    public String gp_agent1dieaction = "not";
    public double gp_agent1diescore = 5.0;
    public boolean gp_agent2 = false;
    public int gp_agent2type = 0;
    public String gp_agent2sprite = "white16";
    public String gp_agent2createloc = "random";
    public double gp_agent2createinit = 1.0;
    public double gp_agent2createinterval = 0.0;
    public double gp_agent2createbegin = 0.0;
    public double gp_agent2createend = 999999.0;
    public double gp_agent2xspeed = 5.0;
    public String gp_agent2movexinit = "center";
    public boolean gp_agent2movexrandom = false;
    public double gp_agent2movexrandomchg = 1.0;
    public boolean gp_agent2movextoplayer = false;
    public double gp_agent2movextoplayermin = 0.0;
    public double gp_agent2movextoplayermax = 200.0;
    public boolean gp_agent2movexfrplayer = false;
    public double gp_agent2movexfrplayermin = 0.0;
    public double gp_agent2movexfrplayermax = 200.0;
    public double gp_agent2yspeed = 5.0;
    public String gp_agent2moveyinit = "center";
    public boolean gp_agent2moveyrandom = false;
    public double gp_agent2moveyrandomchg = 1.0;
    public boolean gp_agent2moveytoplayer = false;
    public double gp_agent2moveytoplayermin = 0.0;
    public double gp_agent2moveytoplayermax = 200.0;
    public boolean gp_agent2moveyfrplayer = false;
    public double gp_agent2moveyfrplayermin = 0.0;
    public double gp_agent2moveyfrplayermax = 200.0;
    public boolean gp_agent2shoot = false;
    public double gp_agent2shootfreq = 5.0;
    public String gp_agent2shootdir = "player";
    public double gp_agent2shootspeed = 10.0;
    public int gp_agent2bullettype = 0;
    public String gp_agent2bouncesides = "none";
    public int gp_agent2dieobjtype = 0;
    public int gp_agent2blockbgtype = 0;
    public int gp_agent2diebgtype = 0;
    public String gp_agent2dieaction = "not";
    public double gp_agent2diescore = 5.0;
    public boolean gp_agent3 = false;
    public int gp_agent3type = 0;
    public String gp_agent3sprite = "white16";
    public String gp_agent3createloc = "random";
    public double gp_agent3createinit = 1.0;
    public double gp_agent3createinterval = 0.0;
    public double gp_agent3createbegin = 0.0;
    public double gp_agent3createend = 999999.0;
    public double gp_agent3xspeed = 5.0;
    public String gp_agent3movexinit = "center";
    public boolean gp_agent3movexrandom = false;
    public double gp_agent3movexrandomchg = 1.0;
    public boolean gp_agent3movextoplayer = false;
    public double gp_agent3movextoplayermin = 0.0;
    public double gp_agent3movextoplayermax = 200.0;
    public boolean gp_agent3movexfrplayer = false;
    public double gp_agent3movexfrplayermin = 0.0;
    public double gp_agent3movexfrplayermax = 200.0;
    public double gp_agent3yspeed = 5.0;
    public String gp_agent3moveyinit = "center";
    public boolean gp_agent3moveyrandom = false;
    public double gp_agent3moveyrandomchg = 1.0;
    public boolean gp_agent3moveytoplayer = false;
    public double gp_agent3moveytoplayermin = 0.0;
    public double gp_agent3moveytoplayermax = 200.0;
    public boolean gp_agent3moveyfrplayer = false;
    public double gp_agent3moveyfrplayermin = 0.0;
    public double gp_agent3moveyfrplayermax = 200.0;
    public boolean gp_agent3shoot = false;
    public double gp_agent3shootfreq = 5.0;
    public String gp_agent3shootdir = "player";
    public double gp_agent3shootspeed = 10.0;
    public int gp_agent3bullettype = 0;
    public String gp_agent3bouncesides = "none";
    public int gp_agent3dieobjtype = 0;
    public int gp_agent3blockbgtype = 1;
    public int gp_agent3diebgtype = 1;
    public String gp_agent3dieaction = "not";
    public double gp_agent3diescore = 5.0;
    public boolean gp_agent4 = false;
    public int gp_agent4type = 0;
    public String gp_agent4sprite = "white16";
    public String gp_agent4createloc = "random";
    public double gp_agent4createinit = 1.0;
    public double gp_agent4createinterval = 0.0;
    public double gp_agent4createbegin = 0.0;
    public double gp_agent4createend = 999999.0;
    public double gp_agent4xspeed = 5.0;
    public String gp_agent4movexinit = "center";
    public boolean gp_agent4movexrandom = false;
    public double gp_agent4movexrandomchg = 1.0;
    public boolean gp_agent4movextoplayer = false;
    public double gp_agent4movextoplayermin = 0.0;
    public double gp_agent4movextoplayermax = 200.0;
    public boolean gp_agent4movexfrplayer = false;
    public double gp_agent4movexfrplayermin = 0.0;
    public double gp_agent4movexfrplayermax = 200.0;
    public double gp_agent4yspeed = 5.0;
    public String gp_agent4moveyinit = "center";
    public boolean gp_agent4moveyrandom = false;
    public double gp_agent4moveyrandomchg = 1.0;
    public boolean gp_agent4moveytoplayer = false;
    public double gp_agent4moveytoplayermin = 0.0;
    public double gp_agent4moveytoplayermax = 200.0;
    public boolean gp_agent4moveyfrplayer = false;
    public double gp_agent4moveyfrplayermin = 0.0;
    public double gp_agent4moveyfrplayermax = 200.0;
    public boolean gp_agent4shoot = false;
    public double gp_agent4shootfreq = 5.0;
    public String gp_agent4shootdir = "player";
    public double gp_agent4shootspeed = 10.0;
    public int gp_agent4bullettype = 0;
    public String gp_agent4bouncesides = "none";
    public int gp_agent4dieobjtype = 0;
    public int gp_agent4blockbgtype = 0;
    public int gp_agent4diebgtype = 0;
    public String gp_agent4dieaction = "not";
    public double gp_agent4diescore = 5.0;
    public boolean gp_agent5 = false;
    public int gp_agent5type = 0;
    public String gp_agent5sprite = "white16";
    public String gp_agent5createloc = "random";
    public double gp_agent5createinit = 1.0;
    public double gp_agent5createinterval = 0.0;
    public double gp_agent5createbegin = 0.0;
    public double gp_agent5createend = 999999.0;
    public double gp_agent5xspeed = 5.0;
    public String gp_agent5movexinit = "center";
    public boolean gp_agent5movexrandom = false;
    public double gp_agent5movexrandomchg = 1.0;
    public boolean gp_agent5movextoplayer = false;
    public double gp_agent5movextoplayermin = 0.0;
    public double gp_agent5movextoplayermax = 200.0;
    public boolean gp_agent5movexfrplayer = false;
    public double gp_agent5movexfrplayermin = 0.0;
    public double gp_agent5movexfrplayermax = 200.0;
    public double gp_agent5yspeed = 5.0;
    public String gp_agent5moveyinit = "center";
    public boolean gp_agent5moveyrandom = false;
    public double gp_agent5moveyrandomchg = 1.0;
    public boolean gp_agent5moveytoplayer = false;
    public double gp_agent5moveytoplayermin = 0.0;
    public double gp_agent5moveytoplayermax = 200.0;
    public boolean gp_agent5moveyfrplayer = false;
    public double gp_agent5moveyfrplayermin = 0.0;
    public double gp_agent5moveyfrplayermax = 200.0;
    public boolean gp_agent5shoot = false;
    public double gp_agent5shootfreq = 5.0;
    public String gp_agent5shootdir = "player";
    public double gp_agent5shootspeed = 10.0;
    public int gp_agent5bullettype = 0;
    public String gp_agent5bouncesides = "none";
    public int gp_agent5dieobjtype = 0;
    public int gp_agent5blockbgtype = 0;
    public int gp_agent5diebgtype = 0;
    public String gp_agent5dieaction = "not";
    public double gp_agent5diescore = 5.0;

    public static void main(String[] args) {
        new SimpleGeneratedGame(SimpleGeneratedGame.parseSizeArgs(args, 0));
    }

    public SimpleGeneratedGame() {
        this.initEngineApplet();
    }

    public SimpleGeneratedGame(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(40, 30, 16, 16, null, null, null);
    }

    public void initGame() {
        String cfgname = null;
        if (this.isApplet()) {
            cfgname = this.getParameter("configfile");
        } else {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
            chooser.setDialogTitle("Choose a config file");
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                cfgname = chooser.getSelectedFile().getAbsolutePath();
            } else {
                System.exit(0);
            }
        }
        this.gamecfg = new AppConfig("Game parameters", this, cfgname);
        this.gamecfg.loadFromFile();
        this.gamecfg.defineFields("gp_", "", "", "");
        this.gamecfg.saveToObject();
        this.initMotionPars();
        this.gamecfg.setListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleGeneratedGame.this.start();
                SimpleGeneratedGame.this.requestGameFocus();
                SimpleGeneratedGame.this.initMotionPars();
            }
        });
        this.defineMedia("simplegeneratedgame.tbl");
        this.setFrameRate(35.0, 1.0);
    }

    public void initNewLife() {
        this.player = new Player();
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void incrementLevel() {
        ++this.level;
        ++this.stage;
    }

    public void doFrameTitle() {
        if (this.getKey(71)) {
            this.clearKey(71);
            this.gamecfg.openGui();
            this.stop();
        }
    }

    public void paintFrameTitle() {
        this.drawString(this.gp_gamename, this.pfWidth() / 2, this.pfHeight() / 3, 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", this.pfWidth() / 2, 6 * this.pfHeight() / 10, 0, this.title_font, this.title_color);
        this.drawString("Press " + this.getKeyDesc(this.key_gamesettings) + " for settings", this.pfWidth() / 2, 7 * this.pfHeight() / 10, 0, this.title_font, this.title_color);
    }

    public void defineLevel() {
        int i;
        this.fillBG(this.gp_basebgfill);
        if (!this.gp_basebg.equals("empty")) {
            if (this.gp_basebg.equals("border")) {
                this.drawBGBorder(this.gp_basebgtile, this.gp_basebgtype);
            } else if (this.gp_basebg.equals("wallhoriz")) {
                this.drawBGBorder(this.gp_basebgtile, this.gp_basebgtype);
                for (int x = 6; x < this.pfTilesX() - 6; ++x) {
                    this.setTile(x, this.pfTilesY() / 2, this.gp_basebgtile);
                    this.setTileCid(x, this.pfTilesY() / 2, this.gp_basebgtype);
                }
            } else if (this.gp_basebg.equals("wallvert")) {
                this.drawBGBorder(this.gp_basebgtile, this.gp_basebgtype);
                for (int y = 6; y < this.pfTilesY() - 6; ++y) {
                    this.setTile(this.pfTilesX() / 3, y, this.gp_basebgtile);
                    this.setTileCid(this.pfTilesX() / 3, y, this.gp_basebgtype);
                    this.setTile(2 * this.pfTilesX() / 3, y, this.gp_basebgtile);
                    this.setTileCid(2 * this.pfTilesX() / 3, y, this.gp_basebgtype);
                }
            } else if (this.gp_basebg.equals("maze")) {
                double x;
                this.drawBGBorder(this.gp_basebgtile, this.gp_basebgtype);
                double xstep = (double)this.pfTilesX() / this.gp_basebgmazexsize;
                double ystep = (double)this.pfTilesY() / this.gp_basebgmazeysize;
                for (x = 0.0; x < (double)this.pfTilesX() - 1.5; x += xstep) {
                    for (double y = 0.0; y < (double)this.pfTilesY() - 1.5; y += ystep) {
                        this.drawBGCross(x, y, this.gp_basebgtile, this.gp_basebgtype);
                    }
                }
                for (x = 0.0; x < (double)this.pfTilesX() + xstep; x += xstep) {
                    this.drawBGCross(x, this.pfTilesY() - 1, this.gp_basebgtile, this.gp_basebgtype);
                }
                for (double y = 0.0; y < (double)this.pfTilesY() + ystep; y += ystep) {
                    this.drawBGCross(this.pfTilesX() - 1, y, this.gp_basebgtile, this.gp_basebgtype);
                }
                this.drawBGCross(this.pfTilesX() - 1, this.pfTilesY() - 1, this.gp_basebgtile, this.gp_basebgtype);
            }
        }
        if (this.gp_randombg1) {
            this.drawRandomBG(this.gp_randombg1density, this.gp_randombg1type, this.gp_randombg1tile);
        }
        if (this.gp_randombg2) {
            this.drawRandomBG(this.gp_randombg2density, this.gp_randombg2type, this.gp_randombg2tile);
        }
        if (this.gp_randombg3) {
            this.drawRandomBG(this.gp_randombg3density, this.gp_randombg3type, this.gp_randombg3tile);
        }
        this.removeObjects(null, 0);
        this.player = new Player();
        JGRectangle clr_t = this.getTiles(new JGRectangle((int)this.player.x - 16, (int)this.player.y - 16, 48, 48));
        for (int x = 0; x < clr_t.width; ++x) {
            for (int y = 0; y < clr_t.height; ++y) {
                this.setTile(clr_t.x + x, clr_t.y + y, this.gp_basebgfill);
            }
        }
        if (this.gp_agent1) {
            i = 0;
            while ((double)i < this.gp_agent1createinit) {
                this.newAgent(1);
                ++i;
            }
        }
        if (this.gp_agent2) {
            i = 0;
            while ((double)i < this.gp_agent2createinit) {
                this.newAgent(2);
                ++i;
            }
        }
        if (this.gp_agent3) {
            i = 0;
            while ((double)i < this.gp_agent3createinit) {
                this.newAgent(3);
                ++i;
            }
        }
        if (this.gp_agent4) {
            i = 0;
            while ((double)i < this.gp_agent4createinit) {
                this.newAgent(4);
                ++i;
            }
        }
        if (this.gp_agent5) {
            i = 0;
            while ((double)i < this.gp_agent5createinit) {
                this.newAgent(5);
                ++i;
            }
        }
    }

    void drawRandomBG(double density, int type, String tile) {
        int nrtiles = (int)((double)(this.pfTilesX() * this.pfTilesY()) * density / 100.0);
        for (int i = 0; i < nrtiles; ++i) {
            int ypos;
            int xpos;
            int nrtries = 20;
            do {
                xpos = this.random(0, this.pfTilesX(), 1);
                ypos = this.random(0, this.pfTilesY(), 1);
                if (--nrtries > 0) continue;
                return;
            } while (this.getTileCid(xpos, ypos) != 0 || this.getTileCid(xpos - 1, ypos - 1) != 0 || this.getTileCid(xpos + 1, ypos - 1) != 0 || this.getTileCid(xpos - 1, ypos + 1) != 0 || this.getTileCid(xpos + 1, ypos + 1) != 0);
            this.setTile(xpos, ypos, tile);
            this.setTileCid(xpos, ypos, type);
        }
    }

    void drawBGBorder(String tile, int type) {
        for (int x = 0; x < this.pfTilesX(); ++x) {
            this.setTile(x, 0, tile);
            this.setTileCid(x, 0, type);
            this.setTile(x, this.pfTilesY() - 1, tile);
            this.setTileCid(x, this.pfTilesY() - 1, type);
        }
        for (int y = 0; y < this.pfTilesY(); ++y) {
            this.setTile(0, y, tile);
            this.setTileCid(0, y, type);
            this.setTile(this.pfTilesX() - 1, y, tile);
            this.setTileCid(this.pfTilesX() - 1, y, type);
        }
    }

    public void drawBGCross(double xd, double yd, String tile, int type) {
        int x = (int)xd;
        int y = (int)yd;
        this.setTile(x, y, tile);
        this.setTileCid(x, y, type);
        this.setTile(x - 1, y, tile);
        this.setTileCid(x - 1, y, type);
        this.setTile(x + 1, y, tile);
        this.setTileCid(x + 1, y, type);
        this.setTile(x, y - 1, tile);
        this.setTileCid(x, y - 1, type);
        this.setTile(x, y + 1, tile);
        this.setTileCid(x, y + 1, type);
    }

    boolean checkForTiles(double xpos, double ypos) {
        return this.checkBGCollision(new JGRectangle((int)xpos, (int)ypos, 16, 16)) != 0;
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(15, 48);
        this.checkBGCollision(15, 48);
        this.checkCollision(16, 15);
        this.checkBGCollision(15, 15);
        if (this.gp_agent1 && this.gp_agent1createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent1createbegin), (int)(35.0 * this.gp_agent1createend), (int)(35.0 * this.gp_agent1createinterval))) {
            this.newAgent(1);
        }
        if (this.gp_agent2 && this.gp_agent2createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent2createbegin), (int)(35.0 * this.gp_agent2createend), (int)(35.0 * this.gp_agent2createinterval))) {
            this.newAgent(2);
        }
        if (this.gp_agent3 && this.gp_agent3createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent3createbegin), (int)(35.0 * this.gp_agent3createend), (int)(35.0 * this.gp_agent3createinterval))) {
            this.newAgent(3);
        }
        if (this.gp_agent4 && this.gp_agent4createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent4createbegin), (int)(35.0 * this.gp_agent4createend), (int)(35.0 * this.gp_agent4createinterval))) {
            this.newAgent(4);
        }
        if (this.gp_agent5 && this.gp_agent5createinterval > 0.0 && this.checkTime((int)(35.0 * this.gp_agent5createbegin), (int)(35.0 * this.gp_agent5createend), (int)(35.0 * this.gp_agent5createinterval))) {
            this.newAgent(5);
        }
        if (this.gp_endleveltimeout && this.gametime >= 35.0 * this.gp_endleveltimeoutlen || this.gp_endlevelobjcount && this.countObjects(null, this.gp_endlevelobjtype) == 0) {
            this.score += (int)this.gp_endlevelscore;
            this.levelDone();
        }
    }

    public Agent newAgent(int anr) {
        switch (anr) {
            case 1: {
                Agent agt = new Agent(this.gp_agent1type, this.gp_agent1sprite, this.gp_agent1bouncesides, this.gp_agent1createloc, this.gp_agent1dieobjtype, this.gp_agent1blockbgtype, this.gp_agent1diebgtype, this.gp_agent1dieaction, this.gp_agent1shoot, this.gp_agent1shootfreq, this.gp_agent1shootdir, this.gp_agent1shootspeed, this.gp_agent1bullettype, this.gp_agent1diescore, this.xmots[0], this.ymots[0]);
                return agt;
            }
            case 2: {
                Agent agt = new Agent(this.gp_agent2type, this.gp_agent2sprite, this.gp_agent2bouncesides, this.gp_agent2createloc, this.gp_agent2dieobjtype, this.gp_agent2blockbgtype, this.gp_agent2diebgtype, this.gp_agent2dieaction, this.gp_agent2shoot, this.gp_agent2shootfreq, this.gp_agent2shootdir, this.gp_agent2shootspeed, this.gp_agent2bullettype, this.gp_agent2diescore, this.xmots[1], this.ymots[1]);
                return agt;
            }
            case 3: {
                Agent agt = new Agent(this.gp_agent3type, this.gp_agent3sprite, this.gp_agent3bouncesides, this.gp_agent3createloc, this.gp_agent3dieobjtype, this.gp_agent3blockbgtype, this.gp_agent3diebgtype, this.gp_agent3dieaction, this.gp_agent3shoot, this.gp_agent3shootfreq, this.gp_agent3shootdir, this.gp_agent3shootspeed, this.gp_agent3bullettype, this.gp_agent3diescore, this.xmots[2], this.ymots[2]);
                return agt;
            }
            case 4: {
                Agent agt = new Agent(this.gp_agent4type, this.gp_agent4sprite, this.gp_agent4bouncesides, this.gp_agent4createloc, this.gp_agent4dieobjtype, this.gp_agent4blockbgtype, this.gp_agent4diebgtype, this.gp_agent4dieaction, this.gp_agent4shoot, this.gp_agent4shootfreq, this.gp_agent4shootdir, this.gp_agent4shootspeed, this.gp_agent4bullettype, this.gp_agent4diescore, this.xmots[3], this.ymots[3]);
                return agt;
            }
            case 5: {
                Agent agt = new Agent(this.gp_agent5type, this.gp_agent5sprite, this.gp_agent5bouncesides, this.gp_agent5createloc, this.gp_agent5dieobjtype, this.gp_agent5blockbgtype, this.gp_agent5diebgtype, this.gp_agent5dieaction, this.gp_agent5shoot, this.gp_agent5shootfreq, this.gp_agent5shootdir, this.gp_agent5shootspeed, this.gp_agent5bullettype, this.gp_agent5diescore, this.xmots[4], this.ymots[4]);
                return agt;
            }
        }
        return null;
    }

    void initMotionPars() {
        this.xmots[0] = new AgentMotion(this.gp_agent1xspeed, this.gp_agent1movexinit, this.gp_agent1movexrandom, this.gp_agent1movexrandomchg, this.gp_agent1movextoplayer, this.gp_agent1movextoplayermin, this.gp_agent1movextoplayermax, this.gp_agent1movexfrplayer, this.gp_agent1movexfrplayermin, this.gp_agent1movexfrplayermax);
        this.ymots[0] = new AgentMotion(this.gp_agent1yspeed, this.gp_agent1moveyinit, this.gp_agent1moveyrandom, this.gp_agent1moveyrandomchg, this.gp_agent1moveytoplayer, this.gp_agent1moveytoplayermin, this.gp_agent1moveytoplayermax, this.gp_agent1moveyfrplayer, this.gp_agent1moveyfrplayermin, this.gp_agent1moveyfrplayermax);
        this.xmots[1] = new AgentMotion(this.gp_agent2xspeed, this.gp_agent2movexinit, this.gp_agent2movexrandom, this.gp_agent2movexrandomchg, this.gp_agent2movextoplayer, this.gp_agent2movextoplayermin, this.gp_agent2movextoplayermax, this.gp_agent2movexfrplayer, this.gp_agent2movexfrplayermin, this.gp_agent2movexfrplayermax);
        this.ymots[1] = new AgentMotion(this.gp_agent2yspeed, this.gp_agent2moveyinit, this.gp_agent2moveyrandom, this.gp_agent2moveyrandomchg, this.gp_agent2moveytoplayer, this.gp_agent2moveytoplayermin, this.gp_agent2moveytoplayermax, this.gp_agent2moveyfrplayer, this.gp_agent2moveyfrplayermin, this.gp_agent2moveyfrplayermax);
        this.xmots[2] = new AgentMotion(this.gp_agent3xspeed, this.gp_agent3movexinit, this.gp_agent3movexrandom, this.gp_agent3movexrandomchg, this.gp_agent3movextoplayer, this.gp_agent3movextoplayermin, this.gp_agent3movextoplayermax, this.gp_agent3movexfrplayer, this.gp_agent3movexfrplayermin, this.gp_agent3movexfrplayermax);
        this.ymots[2] = new AgentMotion(this.gp_agent3yspeed, this.gp_agent3moveyinit, this.gp_agent3moveyrandom, this.gp_agent3moveyrandomchg, this.gp_agent3moveytoplayer, this.gp_agent3moveytoplayermin, this.gp_agent3moveytoplayermax, this.gp_agent3moveyfrplayer, this.gp_agent3moveyfrplayermin, this.gp_agent3moveyfrplayermax);
        this.xmots[3] = new AgentMotion(this.gp_agent4xspeed, this.gp_agent4movexinit, this.gp_agent4movexrandom, this.gp_agent4movexrandomchg, this.gp_agent4movextoplayer, this.gp_agent4movextoplayermin, this.gp_agent4movextoplayermax, this.gp_agent4movexfrplayer, this.gp_agent4movexfrplayermin, this.gp_agent4movexfrplayermax);
        this.ymots[3] = new AgentMotion(this.gp_agent4yspeed, this.gp_agent4moveyinit, this.gp_agent4moveyrandom, this.gp_agent4moveyrandomchg, this.gp_agent4moveytoplayer, this.gp_agent4moveytoplayermin, this.gp_agent4moveytoplayermax, this.gp_agent4moveyfrplayer, this.gp_agent4moveyfrplayermin, this.gp_agent4moveyfrplayermax);
        this.xmots[4] = new AgentMotion(this.gp_agent5xspeed, this.gp_agent5movexinit, this.gp_agent5movexrandom, this.gp_agent5movexrandomchg, this.gp_agent5movextoplayer, this.gp_agent5movextoplayermin, this.gp_agent5movextoplayermax, this.gp_agent5movexfrplayer, this.gp_agent5movexfrplayermin, this.gp_agent5movexfrplayermax);
        this.ymots[4] = new AgentMotion(this.gp_agent5yspeed, this.gp_agent5moveyinit, this.gp_agent5moveyrandom, this.gp_agent5moveyrandomchg, this.gp_agent5moveytoplayer, this.gp_agent5moveytoplayermin, this.gp_agent5moveytoplayermax, this.gp_agent5moveyfrplayer, this.gp_agent5moveyfrplayermin, this.gp_agent5moveyfrplayermax);
    }

    class AgentMotion {
        public double speed = 5.0;
        public String init = "center";
        public boolean random = false;
        public double randomchg = 1.0;
        public boolean toplayer = false;
        public double toplayermin = 0.0;
        public double toplayermax = 100.0;
        public boolean frplayer = false;
        public double frplayermin = 0.0;
        public double frplayermax = 100.0;

        public AgentMotion(double speed, String init, boolean random, double randomchg, boolean toplayer, double toplayermin, double toplayermax, boolean frplayer, double frplayermin, double frplayermax) {
            this.speed = speed;
            this.init = init;
            this.random = random;
            this.randomchg = randomchg;
            this.toplayer = toplayer;
            this.toplayermin = toplayermin;
            this.toplayermax = toplayermax;
            this.frplayer = frplayer;
            this.frplayermin = frplayermin;
            this.frplayermax = frplayermax;
        }
    }

    public class AgentBullet
    extends JGObject {
        int diebgtype;

        public AgentBullet(double x, double y, int type, String basesprite, int diebgtype, double xspeed, double yspeed) {
            super("agentbullet", true, x + 4.0, y + 4.0, type, basesprite + "bul", xspeed, yspeed, -2);
            this.diebgtype = diebgtype;
        }

        public void hit_bg(int tilecid) {
            if (AgentBullet.and(tilecid, this.diebgtype)) {
                this.remove();
            }
        }
    }

    class Agent
    extends JGObject {
        int objtimer = 0;
        int type;
        String sprite;
        String bouncesides;
        int dieobjtype;
        int blockbgtype;
        int diebgtype;
        String dieaction;
        boolean shoot;
        double shootfreq;
        String shootdir;
        double shootspeed;
        int bullettype;
        double diescore;
        AgentMotion xmot;
        AgentMotion ymot;

        public Agent(int type, String sprite, String bouncesides, String createloc, int dieobjtype, int blockbgtype, int diebgtype, String dieaction, boolean shoot, double shootfreq, String shootdir, double shootspeed, int bullettype, double diescore, AgentMotion xmot, AgentMotion ymot) {
            super("agent", true, 100.0, 100.0, type, sprite);
            this.type = type;
            this.sprite = sprite;
            this.bouncesides = bouncesides;
            this.dieobjtype = dieobjtype;
            this.blockbgtype = blockbgtype;
            this.diebgtype = diebgtype;
            this.dieaction = dieaction;
            this.shoot = shoot;
            this.shootfreq = shootfreq;
            this.shootdir = shootdir;
            this.shootspeed = shootspeed;
            this.bullettype = bullettype;
            this.diescore = diescore;
            int dirs = 0;
            int tries = 12;
            do {
                int dir;
                if (createloc.equals("random")) {
                    this.setPos(this.random(0, SimpleGeneratedGame.this.pfWidth(), 1), this.random(0, SimpleGeneratedGame.this.pfHeight(), 1));
                } else if (createloc.equals("corner")) {
                    dirs |= 0xF;
                } else if (createloc.equals("top")) {
                    dirs |= 1;
                } else if (createloc.equals("bottom")) {
                    dirs |= 2;
                } else if (createloc.equals("topbottom")) {
                    dirs |= 3;
                } else if (createloc.equals("left")) {
                    dirs |= 4;
                } else if (createloc.equals("right")) {
                    dirs |= 8;
                } else if (createloc.equals("leftright")) {
                    dirs |= 0xC;
                }
                if (dirs == 0) continue;
                while ((dirs & (dir = 1 << this.random(0, 3, 1))) == 0) {
                }
                if (dir == 1) {
                    this.y = -16.0;
                }
                if (dir == 2) {
                    this.y = SimpleGeneratedGame.this.pfHeight();
                }
                if (dir == 1 || dir == 2) {
                    this.x = this.random(0.0, SimpleGeneratedGame.this.pfWidth() - 16);
                }
                if (dir == 4) {
                    this.x = -16.0;
                }
                if (dir == 8) {
                    this.x = SimpleGeneratedGame.this.pfWidth();
                }
                if (dir != 4 && dir != 8) continue;
                this.y = this.random(0.0, SimpleGeneratedGame.this.pfHeight() - 16);
            } while (tries-- > 0 && (SimpleGeneratedGame.this.checkForTiles(this.x, this.y) || SimpleGeneratedGame.this.player != null && (this.x > SimpleGeneratedGame.this.player.x - 16.0 && this.x < SimpleGeneratedGame.this.player.x + 32.0 || this.y > SimpleGeneratedGame.this.player.y - 16.0 && this.y < SimpleGeneratedGame.this.player.y + 32.0 || this.x > SimpleGeneratedGame.this.player.x - 48.0 && this.x < SimpleGeneratedGame.this.player.x + 64.0 && this.y > SimpleGeneratedGame.this.player.y - 48.0 && this.y < SimpleGeneratedGame.this.player.y + 64.0)));
            this.xmot = xmot;
            this.ymot = ymot;
            if (xmot.init.equals("center") || xmot.init.equals("player") && SimpleGeneratedGame.this.player == null) {
                this.xspeed = (double)(this.x > (double)(SimpleGeneratedGame.this.pfWidth() / 2) ? -1 : 1) * xmot.speed;
            } else if (xmot.init.equals("player")) {
                this.xspeed = (double)(this.x > SimpleGeneratedGame.this.player.x ? -1 : 1) * xmot.speed;
            } else if (xmot.init.equals("random")) {
                this.xspeed = xmot.speed * (double)this.random(-1, 1, 2);
            } else if (xmot.init.equals("not")) {
                // empty if block
            }
            if (ymot.init.equals("center") || ymot.init.equals("player") && SimpleGeneratedGame.this.player == null) {
                this.yspeed = (double)(this.y > (double)(SimpleGeneratedGame.this.pfHeight() / 2) ? -1 : 1) * ymot.speed;
            } else if (ymot.init.equals("player")) {
                this.yspeed = (double)(this.y > SimpleGeneratedGame.this.player.y ? -1 : 1) * ymot.speed;
            } else if (ymot.init.equals("random")) {
                this.yspeed = ymot.speed * (double)this.random(-1, 1, 2);
            } else if (ymot.init.equals("not")) {
                // empty if block
            }
        }

        public void move() {
            ++this.objtimer;
            if (this.xmot.random && this.objtimer % (int)(35.0 * this.xmot.randomchg) == 0) {
                this.xspeed = this.xmot.speed * (double)this.random(-1, 1, 2);
            }
            if (this.ymot.random && this.objtimer % (int)(35.0 * this.ymot.randomchg) == 0) {
                this.yspeed = this.ymot.speed * (double)this.random(-1, 1, 2);
            }
            if (SimpleGeneratedGame.this.player != null) {
                double playerdist = Math.sqrt((SimpleGeneratedGame.this.player.x - this.x) * (SimpleGeneratedGame.this.player.x - this.x) + (SimpleGeneratedGame.this.player.y - this.y) * (SimpleGeneratedGame.this.player.y - this.y)) * 100.0 / (double)SimpleGeneratedGame.this.pfWidth();
                if (this.xmot.toplayer && playerdist > this.xmot.toplayermin && playerdist < this.xmot.toplayermax) {
                    this.xspeed = 0.0;
                    this.x += this.xmot.speed * (double)(SimpleGeneratedGame.this.player.x > this.x ? 1 : -1);
                } else if (this.xmot.frplayer && playerdist > this.xmot.frplayermin && playerdist < this.xmot.frplayermax) {
                    this.xspeed = 0.0;
                    this.x += this.xmot.speed * (double)(SimpleGeneratedGame.this.player.x < this.x ? 1 : -1);
                }
                if (this.ymot.toplayer && playerdist > this.ymot.toplayermin && playerdist < this.ymot.toplayermax) {
                    this.yspeed = 0.0;
                    this.y += this.ymot.speed * (double)(SimpleGeneratedGame.this.player.y > this.y ? 1 : -1);
                } else if (this.ymot.frplayer && playerdist > this.ymot.frplayermin && playerdist < this.ymot.frplayermax) {
                    this.yspeed = 0.0;
                    this.y += this.ymot.speed * (double)(SimpleGeneratedGame.this.player.y < this.y ? 1 : -1);
                }
            }
            int bounces = 0;
            if (this.bouncesides.equals("any")) {
                bounces |= 0xF;
            } else if (this.bouncesides.equals("top")) {
                bounces |= 1;
            } else if (this.bouncesides.equals("bottom")) {
                bounces |= 2;
            } else if (this.bouncesides.equals("topbottom")) {
                bounces |= 3;
            } else if (this.bouncesides.equals("left")) {
                bounces |= 4;
            } else if (this.bouncesides.equals("right")) {
                bounces |= 8;
            } else if (this.bouncesides.equals("leftright")) {
                bounces |= 0xC;
            }
            if ((bounces & 1) != 0 && this.y < 0.0) {
                this.y = 0.0;
                if (this.yspeed < 0.0) {
                    this.yspeed = -this.yspeed;
                }
            }
            if ((bounces & 2) != 0 && this.y > (double)(SimpleGeneratedGame.this.pfHeight() - 16)) {
                this.y = SimpleGeneratedGame.this.pfHeight() - 16;
                if (this.yspeed > 0.0) {
                    this.yspeed = -this.yspeed;
                }
            }
            if ((bounces & 4) != 0 && this.x < 0.0) {
                this.x = 0.0;
                if (this.xspeed < 0.0) {
                    this.xspeed = -this.xspeed;
                }
            }
            if ((bounces & 8) != 0 && this.x > (double)(SimpleGeneratedGame.this.pfWidth() - 16)) {
                this.x = SimpleGeneratedGame.this.pfWidth() - 16;
                if (this.xspeed > 0.0) {
                    this.xspeed = -this.xspeed;
                }
            }
            if (this.shoot && this.shootfreq > 0.0 && this.objtimer % (int)(this.shootfreq * 35.0) == 0) {
                if (this.shootdir.equals("left")) {
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, -this.shootspeed, 0.0);
                } else if (this.shootdir.equals("right")) {
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, this.shootspeed, 0.0);
                } else if (this.shootdir.equals("up")) {
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, 0.0, -this.shootspeed);
                } else if (this.shootdir.equals("down")) {
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, 0.0, this.shootspeed);
                } else if (this.shootdir.equals("player") && SimpleGeneratedGame.this.player != null) {
                    double angle = Math.atan2(SimpleGeneratedGame.this.player.x - this.x, SimpleGeneratedGame.this.player.y - this.y);
                    new AgentBullet(this.x, this.y, this.bullettype, this.sprite, this.diebgtype | this.blockbgtype, this.shootspeed * Math.sin(angle), this.shootspeed * Math.cos(angle));
                }
            }
        }

        public void hit(JGObject obj) {
            if (Agent.and(obj.colid, this.dieobjtype)) {
                this.die();
                if ((obj.colid & 0x10) != 0) {
                    obj.remove();
                }
            }
        }

        public void hit_bg(int tilecid) {
            if (Agent.and(tilecid, this.diebgtype)) {
                this.die();
            }
            if (Agent.and(tilecid, this.blockbgtype)) {
                this.x = this.getLastX();
                this.y = this.getLastY();
                this.xspeed = -this.xspeed;
                this.yspeed = -this.yspeed;
            }
        }

        public void die() {
            SimpleGeneratedGame.this.score += (int)this.diescore;
            this.remove();
            if (!this.dieaction.equals("die")) {
                if (this.dieaction.equals("create1")) {
                    Agent agt = SimpleGeneratedGame.this.newAgent(1);
                    agt.setPos(this.x, this.y);
                } else if (this.dieaction.equals("create2")) {
                    Agent agt = SimpleGeneratedGame.this.newAgent(2);
                    agt.setPos(this.x, this.y);
                } else if (this.dieaction.equals("create3")) {
                    Agent agt = SimpleGeneratedGame.this.newAgent(3);
                    agt.setPos(this.x, this.y);
                } else if (this.dieaction.equals("create4")) {
                    Agent agt = SimpleGeneratedGame.this.newAgent(4);
                    agt.setPos(this.x, this.y);
                } else if (this.dieaction.equals("create5")) {
                    Agent agt = SimpleGeneratedGame.this.newAgent(5);
                    agt.setPos(this.x, this.y);
                }
            }
        }
    }

    public class PlayerBullet
    extends JGObject {
        public PlayerBullet(double x, double y, double xspeed, double yspeed) {
            super("playerbullet", true, x + 4.0, y + 4.0, 16, null, xspeed, yspeed, -2);
            this.setImage(SimpleGeneratedGame.this.gp_playersprite + "bul");
        }

        public void hit_bg(int tilecid) {
            if (PlayerBullet.and(tilecid, SimpleGeneratedGame.this.gp_playerbulletdiebgtype)) {
                this.remove();
            }
        }
    }

    public class Player
    extends JGObject {
        int invulnerability = 105;
        double bulxdir = 0.0;
        double bulydir = 0.0;

        public Player() {
            super("player", false, 0.0, 0.0, 32, null);
            this.setPos(SimpleGeneratedGame.this.gp_playerx, SimpleGeneratedGame.this.gp_playery);
            this.setImage(SimpleGeneratedGame.this.gp_playersprite);
        }

        public void move() {
            if (this.invulnerability > 0) {
                --this.invulnerability;
                if ((this.invulnerability & 3) >= 2) {
                    this.setImage(null);
                } else {
                    this.setImage(SimpleGeneratedGame.this.gp_playersprite);
                }
            }
            if (SimpleGeneratedGame.this.gp_playerxmove.equals("linear")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_left)) {
                    this.x -= SimpleGeneratedGame.this.gp_playerxspeed;
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_right)) {
                    this.x += SimpleGeneratedGame.this.gp_playerxspeed;
                }
            } else if (SimpleGeneratedGame.this.gp_playerxmove.equals("accel")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_left)) {
                    this.xspeed -= SimpleGeneratedGame.this.gp_playerxaccel;
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_right)) {
                    this.xspeed += SimpleGeneratedGame.this.gp_playerxaccel;
                }
            }
            if (SimpleGeneratedGame.this.gp_playerymove.equals("linear")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_up)) {
                    this.y -= SimpleGeneratedGame.this.gp_playeryspeed;
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_down)) {
                    this.y += SimpleGeneratedGame.this.gp_playeryspeed;
                }
            } else if (SimpleGeneratedGame.this.gp_playerymove.equals("accel")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_up)) {
                    this.yspeed -= SimpleGeneratedGame.this.gp_playeryaccel;
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_down)) {
                    this.yspeed += SimpleGeneratedGame.this.gp_playeryaccel;
                }
            }
            if (this.x < 0.0) {
                this.x = 0.0;
            }
            if (this.x > (double)(SimpleGeneratedGame.this.pfWidth() - 16)) {
                this.x = SimpleGeneratedGame.this.pfWidth() - 16;
            }
            if (this.y < 0.0) {
                this.y = 0.0;
            }
            if (this.y > (double)(SimpleGeneratedGame.this.pfHeight() - 16)) {
                this.y = SimpleGeneratedGame.this.pfHeight() - 16;
            }
            double newbulxdir = this.x + this.xspeed - this.getLastX();
            double newbulydir = this.y + this.yspeed - this.getLastY();
            if (newbulxdir != 0.0 || newbulydir != 0.0) {
                this.bulxdir = newbulxdir;
                this.bulydir = newbulydir;
            }
            if ((double)SimpleGeneratedGame.this.countObjects(null, 16) > SimpleGeneratedGame.this.gp_playermaxbullets - 0.01) {
                return;
            }
            if (SimpleGeneratedGame.this.gp_playershoot.equals("1dir")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fire)) {
                    if (SimpleGeneratedGame.this.gp_playershootdir.equals("left")) {
                        new PlayerBullet(this.x, this.y, -SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                    }
                    if (SimpleGeneratedGame.this.gp_playershootdir.equals("right")) {
                        new PlayerBullet(this.x, this.y, SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                    }
                    if (SimpleGeneratedGame.this.gp_playershootdir.equals("up")) {
                        new PlayerBullet(this.x, this.y, 0.0, -SimpleGeneratedGame.this.gp_playerbulletspeed);
                    }
                    if (SimpleGeneratedGame.this.gp_playershootdir.equals("down")) {
                        new PlayerBullet(this.x, this.y, 0.0, SimpleGeneratedGame.this.gp_playerbulletspeed);
                    }
                }
            } else if (SimpleGeneratedGame.this.gp_playershoot.equals("2dir")) {
                if (SimpleGeneratedGame.this.gp_playershootaxis.equals("horizontal")) {
                    if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireleft)) {
                        new PlayerBullet(this.x, this.y, -SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                    }
                    if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireright)) {
                        new PlayerBullet(this.x, this.y, SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                    }
                }
                if (SimpleGeneratedGame.this.gp_playershootaxis.equals("vertical")) {
                    if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireup)) {
                        new PlayerBullet(this.x, this.y, 0.0, -SimpleGeneratedGame.this.gp_playerbulletspeed);
                    }
                    if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_firedown)) {
                        new PlayerBullet(this.x, this.y, 0.0, SimpleGeneratedGame.this.gp_playerbulletspeed);
                    }
                }
            } else if (SimpleGeneratedGame.this.gp_playershoot.equals("4dir")) {
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireleft)) {
                    new PlayerBullet(this.x, this.y, -SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireright)) {
                    new PlayerBullet(this.x, this.y, SimpleGeneratedGame.this.gp_playerbulletspeed, 0.0);
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fireup)) {
                    new PlayerBullet(this.x, this.y, 0.0, -SimpleGeneratedGame.this.gp_playerbulletspeed);
                }
                if (SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_firedown)) {
                    new PlayerBullet(this.x, this.y, 0.0, SimpleGeneratedGame.this.gp_playerbulletspeed);
                }
            } else if (SimpleGeneratedGame.this.gp_playershoot.equals("alldir") && SimpleGeneratedGame.this.getKey(SimpleGeneratedGame.this.key_fire) && (this.bulxdir != 0.0 || this.bulydir != 0.0)) {
                new PlayerBullet(this.x, this.y, this.bulxdir * SimpleGeneratedGame.this.gp_playerbulletspeed, this.bulydir * SimpleGeneratedGame.this.gp_playerbulletspeed);
            }
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_fire);
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_fireup);
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_firedown);
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_fireleft);
            SimpleGeneratedGame.this.clearKey(SimpleGeneratedGame.this.key_fireright);
        }

        public void hit(JGObject obj) {
            if (Player.and(obj.colid, SimpleGeneratedGame.this.gp_playerdieobjtype) && this.invulnerability == 0) {
                SimpleGeneratedGame.this.lifeLost();
            }
            if (Player.and(obj.colid, SimpleGeneratedGame.this.gp_playergetobjtype)) {
                obj.remove();
                SimpleGeneratedGame.this.score = (int)((double)SimpleGeneratedGame.this.score + SimpleGeneratedGame.this.gp_playergetscore);
                new StdScoring("pts", obj.x, obj.y, 0.0, -1.0, 40, (int)SimpleGeneratedGame.this.gp_playergetscore + " pts", SimpleGeneratedGame.this.scoring_font, new JGColor[]{JGColor.red, JGColor.yellow}, 2);
            }
        }

        public void hit_bg(int tilecid) {
            if (Player.and(tilecid, SimpleGeneratedGame.this.gp_playerbumpbgtype)) {
                this.x = this.getLastX();
                this.y = this.getLastY();
                this.snapToGrid(8.0, 8.0);
            }
            if (Player.and(tilecid, SimpleGeneratedGame.this.gp_playerdiebgtype) && this.invulnerability == 0) {
                SimpleGeneratedGame.this.lifeLost();
            }
        }
    }
}

