/*
 * Decompiled with CFR 0.152.
 */
package examples.matrixminer;

import examples.StdMazeMonster;
import examples.StdMazePlayer;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class MatrixMiner
extends StdGame {
    JGColor intro_color = new JGColor(60, 100, 255);
    String bonus_msg;
    Player player = null;
    JGFont scorefont = new JGFont("Helvetica", 0, 18.0);

    public static void main(String[] args) {
        new MatrixMiner(MatrixMiner.parseSizeArgs(args, 0));
    }

    public MatrixMiner() {
        this.initEngineApplet();
    }

    public MatrixMiner(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(19, 15, 16, 16, this.intro_color, null, null);
        this.setScalingPreferences(0.75, 1.3333333333333333, 0, 5, 5, 5);
    }

    public void initGame() {
        this.defineMedia("matrix_miner.tbl");
        this.setVideoSyncedUpdate(true);
        if (this.isMidlet()) {
            this.setFrameRate(12.0, 1.0);
            this.setGameSpeed(2.0);
        } else {
            this.setFrameRate(40.0, 4.0);
        }
        this.lifelost_ingame = true;
        this.startgame_ticks = 0;
        this.gameover_ticks = 0;
        this.leveldone_ticks = 120;
        this.defineLevel();
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(1, 8);
        this.checkCollision(18, 1);
        this.checkCollision(2, 32);
        this.checkCollision(4, 2);
        this.checkBGCollision(1, 20);
        if (this.checkTime(this.gametime < (double)(30 + 4 * this.level) ? 5 : 55 - this.level * 3)) {
            String enemy_gfx = "enemy" + (1 + this.stage % 3) + "_";
            switch ((int)this.random(0.0, 4.0)) {
                case 0: {
                    new Enemy(enemy_gfx, (double)this.random(1, 19, 2), -0.8, 0, 1);
                    break;
                }
                case 1: {
                    new Enemy(enemy_gfx, (double)this.random(1, 19, 2), 14.8, 0, -1);
                    break;
                }
                case 2: {
                    new Enemy(enemy_gfx, -0.8, (double)this.random(1, 15, 2), 1, 0);
                    break;
                }
                case 3: {
                    new Enemy(enemy_gfx, 18.8, (double)this.random(1, 15, 2), -1, 0);
                }
            }
        }
        if (this.countObjects("@goodie", 8) == 0) {
            int bonus = this.countObjects("@goodie", 0);
            if (bonus < 20) {
                this.bonus_msg = "25 X " + bonus + "..." + 25 * bonus + " PTS";
                this.score += 25 * bonus;
            } else {
                this.bonus_msg = "PERFECT! 1000 PTS";
                this.score += 1000;
            }
            this.removeObjects(null, 0);
            this.playAudio("leveldone");
            this.levelDone();
        }
    }

    public void incrementLevel() {
        if (this.level < 9) {
            ++this.level;
        }
        ++this.stage;
    }

    public void paintFrame() {
        this.setColor(JGColor.white);
        this.setFont(this.scorefont);
        this.drawString("" + this.score, 16.0, 0.0, -1);
        for (int i = 1; i < this.lives; ++i) {
            this.drawImage(this.pfWidth() - 16 - 16 * i, 0.0, "player_r0");
        }
    }

    public void paintFrameTitle() {
        this.drawImage(70.0, 35.0, "splash_image");
        if (!this.isMidlet()) {
            this.drawImageString("PRESS " + this.getKeyDesc(this.key_startgame).toUpperCase(), this.pfWidth() / 2, 140.0, 0, "font_map", 32, 2);
        } else {
            this.drawImageString("STAR TO START", this.pfWidth() / 2, 130.0, 0, "font_map", 32, 2);
            this.drawImageString("POUND TO QUIT", this.pfWidth() / 2, 160.0, 0, "font_map", 32, 2);
        }
    }

    public void paintFrameLifeLost() {
        this.drawImageString("GOT YOU !", 75.0, 75.0, -1, "font_map", 32, 2);
    }

    public void paintFrameLevelDone() {
        int ypos1 = this.posWalkForwards(-16, this.pfHeight(), this.seqtimer, 120, 75, 10, 100);
        this.drawImageString("LEVEL " + (this.stage + 1) + " CLEAR!", this.pfWidth() / 2, ypos1, 0, "font_map", 32, 2);
        int ypos2 = this.posWalkForwards(-16, this.pfHeight(), this.seqtimer, 120, 140, 15, 95);
        this.drawImageString(this.bonus_msg, this.pfWidth() / 2, ypos2, 0, "font_map", 32, 2);
    }

    public void startInGame() {
        this.removeObjects("Enemy", 0);
        this.removeObjects("bullet", 0);
        this.player = new Player(144.0, 80.0, this.key_up, this.key_down, this.key_left, this.key_right);
    }

    public void startTitle() {
        this.removeObjects(null, 0);
    }

    public void defineLevel() {
        int i;
        this.removeObjects(null, 0);
        this.fillBG(".");
        for (int y = 0; y < this.pfTilesY(); ++y) {
            for (int x = 0; x < this.pfTilesX(); ++x) {
                if (!this.and(x, 1) && !this.and(y, 1)) {
                    this.setTile(x, y, "#" + this.stage % 7);
                    continue;
                }
                if (x != 0 && x != this.pfTilesX() - 1 && y != 0 && y != this.pfTilesY() - 1) continue;
                this.setTile(x, y, "*");
            }
        }
        for (i = 0; i < 10 + 10 * (this.stage % 2); ++i) {
            int wy;
            int wx;
            while (this.and(this.getTileCid(wx = this.random(1, this.pfTilesX() - 1, 1), wy = this.random(1, this.pfTilesY() - 1, 2) + ((wx & 1) != 0 ? 1 : 0)), 3) || this.and(this.getTileCid(wx - 2, wy), 3) || this.and(this.getTileCid(wx, wy - 2), 3) || this.and(this.getTileCid(wx + 2, wy), 3) || this.and(this.getTileCid(wx, wy + 2), 3)) {
            }
            this.setTile(wx, wy, "#" + this.stage % 7);
        }
        for (i = 0; i < 20; ++i) {
            new Goodie(16 * this.random(4, 15, 2), 16 * this.random(4, 11, 2));
        }
    }

    public class Enemy
    extends StdMazeMonster {
        int bullettimer = 200 - (int)this.random(0.0, 100.0);

        public Enemy(String graphic, double x, double y, int xdir, int ydir) {
            super("Enemy", true, 16.0 * x, 16.0 * y, 2, graphic, true, 1, xdir, ydir, 0.0, null, false, 0.0);
            this.home_in = MatrixMiner.this.player;
            this.setSpeed(0.35 + 0.05 * (double)MatrixMiner.this.level);
        }

        public void move() {
            super.move();
            if ((this.xdir != 0 || this.ydir != 0) && this.bullettimer <= 0) {
                new Bullet(this.x, this.y, this.xdir, this.ydir, 16);
                MatrixMiner.this.playAudio("enemyshoot");
                this.bullettimer = 440 - 20 * MatrixMiner.this.level;
            }
            if (this.bullettimer > 0) {
                --this.bullettimer;
            }
            if (!this.isOnPF(0, 0)) {
                this.remove();
            }
        }

        public void hit(JGObject o) {
            MatrixMiner.this.playAudio("explo");
            for (int i = 0; i < (MatrixMiner.this.isMidlet() ? 5 : 8); ++i) {
                new JGObject("explo", true, this.x, this.y, 0, "explo", this.random(-2.0, 2.0), this.random(-2.0, 2.0), (int)this.random(8.0, 32.0));
            }
            o.remove();
            this.remove();
            MatrixMiner.this.score += 5;
        }
    }

    public class Bullet
    extends JGObject {
        public Bullet(double x, double y, int xdir, int ydir, int cid) {
            super("bullet", true, x, y, cid, "bullet", 0.0, 0.0, -2);
            double speed = Bullet.and(cid, 16) ? 4.0 / (3.0 - 0.15 * (double)MatrixMiner.this.level) : 4.0;
            this.setSpeedAbs((double)xdir * speed, (double)ydir * speed);
        }

        public void hit_bg(int cid) {
            this.remove();
        }
    }

    public class Player
    extends StdMazePlayer {
        Goodie following = null;
        boolean fireleft = false;
        boolean fireright = false;
        boolean fireup = false;
        boolean firedown = false;

        public Player(double x, double y, int k_up, int k_down, int k_left, int k_right) {
            super("player", x, y, 1, "player_", true, false, 3, 3.0, k_up, k_down, k_left, k_right);
        }

        public void move() {
            super.move();
            if (MatrixMiner.this.countObjects("bullet", 4) < 3) {
                if (MatrixMiner.this.getKey(MatrixMiner.this.key_fireleft)) {
                    this.fireleft = true;
                    MatrixMiner.this.clearKey(MatrixMiner.this.key_fireleft);
                }
                if (MatrixMiner.this.getKey(MatrixMiner.this.key_fireright)) {
                    this.fireright = true;
                    MatrixMiner.this.clearKey(MatrixMiner.this.key_fireright);
                }
                if (MatrixMiner.this.getKey(MatrixMiner.this.key_fireup)) {
                    this.fireup = true;
                    MatrixMiner.this.clearKey(MatrixMiner.this.key_fireup);
                }
                if (MatrixMiner.this.getKey(MatrixMiner.this.key_firedown)) {
                    this.firedown = true;
                    MatrixMiner.this.clearKey(MatrixMiner.this.key_firedown);
                }
                if (this.fireleft && this.isYAligned(this.speed)) {
                    new Bullet(this.x, this.y, -1, 0, 4);
                    MatrixMiner.this.playAudio("shoot");
                    this.fireleft = false;
                }
                if (this.fireright && this.isYAligned(this.speed)) {
                    new Bullet(this.x, this.y, 1, 0, 4);
                    MatrixMiner.this.playAudio("shoot");
                    this.fireright = false;
                }
                if (this.fireup && this.isXAligned(this.speed)) {
                    new Bullet(this.x, this.y, 0, -1, 4);
                    MatrixMiner.this.playAudio("shoot");
                    this.fireup = false;
                }
                if (this.firedown && this.isXAligned(this.speed)) {
                    new Bullet(this.x, this.y, 0, 1, 4);
                    MatrixMiner.this.playAudio("shoot");
                    this.firedown = false;
                }
            }
        }

        public void hit(JGObject obj) {
            MatrixMiner.this.playAudio("playerdead");
            for (int i = 0; i < (MatrixMiner.this.isMidlet() ? 8 : 16); ++i) {
                new JGObject("explo", true, this.x, this.y, 0, "explo", this.random(-2.0, 2.0), this.random(-2.0, 2.0), (int)this.random(16.0, 64.0));
            }
            MatrixMiner.this.player.remove();
            MatrixMiner.this.lifeLost();
        }
    }

    public class Goodie
    extends JGObject {
        JGPoint[] prevpos = null;
        JGObject to_follow = null;
        boolean is_in_tile = true;

        public Goodie(double x, double y) {
            super("@goodie", true, x, y, 8, "goodie", 0, 0, 16, 16);
            this.setBBox(-4, -4, 24, 24);
        }

        public void hit(JGObject obj) {
            if (this.colid == 32) {
                MatrixMiner.this.playAudio("eatgoodie");
                this.remove();
            } else if (this.is_in_tile) {
                int xdir = 0;
                int ydir = 0;
                if (MatrixMiner.this.player.xdir != 0 && MatrixMiner.this.player.y > this.y + 8.0) {
                    ydir = -1;
                }
                if (MatrixMiner.this.player.xdir != 0 && MatrixMiner.this.player.y < this.y - 8.0) {
                    ydir = 1;
                }
                if (MatrixMiner.this.player.ydir != 0 && MatrixMiner.this.player.x > this.x + 8.0) {
                    xdir = -1;
                }
                if (MatrixMiner.this.player.ydir != 0 && MatrixMiner.this.player.x < this.x - 8.0) {
                    xdir = 1;
                }
                if (!Goodie.and(MatrixMiner.this.getTileCid(this.getCenterTile(), xdir, ydir), 1)) {
                    this.clearBBox();
                    this.x += (double)(xdir * 16);
                    this.y += (double)(ydir * 16);
                    this.is_in_tile = false;
                    MatrixMiner.this.score += 5;
                    MatrixMiner.this.playAudio("extract");
                }
            } else {
                int i;
                this.colid = 32;
                if (((Player)obj).following != null) {
                    ((Player)obj).following.to_follow = this;
                }
                ((Player)obj).following = this;
                this.to_follow = obj;
                this.prevpos = new JGPoint[(int)(6.0 / gamespeed)];
                for (i = 0; i < this.prevpos.length; ++i) {
                    this.prevpos[i] = new JGPoint();
                }
                for (i = 0; i < this.prevpos.length; ++i) {
                    this.shiftPos(obj.x, obj.y);
                }
                MatrixMiner.this.score += 10;
                MatrixMiner.this.playAudio("pickup");
            }
        }

        void shiftPos(double newx, double newy) {
            for (int i = 0; i < this.prevpos.length - 1; ++i) {
                this.prevpos[i].x = this.prevpos[i + 1].x;
                this.prevpos[i].y = this.prevpos[i + 1].y;
            }
            this.prevpos[this.prevpos.length - 1].x = (int)newx;
            this.prevpos[this.prevpos.length - 1].y = (int)newy;
            this.x = this.prevpos[0].x;
            this.y = this.prevpos[0].y;
        }

        public void move() {
            if (this.to_follow != null) {
                if (!this.to_follow.isAlive()) {
                    this.remove();
                }
                this.shiftPos(this.to_follow.x, this.to_follow.y);
            }
        }
    }
}

