/*
 * Decompiled with CFR 0.152.
 */
package examples.munchies;

import jgame.JGColor;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class Munchies
extends StdGame {
    public static void main(String[] args) {
        new Munchies(Munchies.parseSizeArgs(args, 0));
    }

    public Munchies() {
        this.initEngineApplet();
    }

    public Munchies(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initCanvas() {
        this.setCanvasSettings(20, 15, 16, 16, null, null, null);
    }

    public void initGame() {
        this.defineMedia("munchies.tbl");
        if (this.isMidlet()) {
            this.setFrameRate(12.0, 4.0);
            this.setGameSpeed(3.0);
        } else {
            this.setFrameRate(40.0, 4.0);
        }
        this.lives_img = "munchie_g_l3";
        this.startgame_ingame = true;
    }

    public void startTitle() {
        this.removeObjects(null, 0);
        this.setMouseCursor(0);
    }

    public void initNewGame(int level_selected) {
        super.initNewGame(level_selected);
        this.stopAudio("music");
        this.lives = 4;
    }

    public void startInGame() {
        this.setMouseCursor(null);
        this.removeObjects(null, 0);
        new Player();
        for (int i = 2; i < 4 + this.level % 3; ++i) {
            new Munchie(this.random(0.0, this.pfWidth() - 16), this.pfHeight() + 8 - i * this.tileHeight(), (2.5 - 0.3 * (double)(this.level % 3)) * (double)this.random(-1, 1, 2));
        }
        this.fillBG("");
    }

    public void startGameOver() {
        this.removeObjects(null, 0);
    }

    public void doFrameInGame() {
        this.moveObjects();
        this.checkCollision(1, 4);
        this.checkCollision(4, 2);
        if (this.checkTime(0, 1500, 63 - this.level * 3)) {
            int tilepos;
            while (this.and(this.getTileCid(tilepos = this.random(1, this.pfTilesX() - 2, 1), 0), 1)) {
            }
            this.orTileCid(tilepos, 0, 1);
            new Spider(tilepos);
        }
        if (this.gametime >= 1500.0 && this.countObjects("spider", 0) == 0) {
            this.levelDone();
        }
    }

    public void incrementLevel() {
        ++this.stage;
        ++this.level;
        if (this.level > 10) {
            this.level = 8;
        }
    }

    public void paintFrameLifeLost() {
        this.drawWavyString("Munchie Killed !", 160, 50, 0, 12, this.seqtimer, 5.0, 0.5, 0.1, this.title_font, JGColor.red);
    }

    public void paintFrameGameOver() {
        this.drawWavyString("Game Over !", 160, 50, 0, 12, this.seqtimer, 5.0, 0.5, 0.1, this.title_font, JGColor.red);
    }

    public void paintFrameStartLevel() {
        this.drawWavyString("Level " + (this.stage + 1) + "!", 160, 50, 0, 12, this.seqtimer, 5.0, 0.5, 0.1, this.title_font, JGColor.yellow);
    }

    public void paintFrameStartGame() {
    }

    public void paintFrameLevelDone() {
        this.drawWavyString("Level Done !", 160, 50, 0, 12, this.seqtimer, 5.0, 0.5, 0.1, this.title_font, JGColor.yellow);
    }

    public void paintFrameTitle() {
        this.drawWavyString("Feed the Munchies", 160, 50, 0, 12, this.seqtimer, 5.0, 0.5, 0.05, this.title_font, JGColor.yellow);
        this.drawWavyString("Press " + this.getKeyDesc(this.key_startgame) + " to start", 160, 120, 0, 8, this.seqtimer, 5.0, 0.5, 0.05, this.status_font, JGColor.red);
    }

    public void drawWavyString(String s, int x, int y, JGColor col) {
        this.setColor(col);
        for (int i = 0; i < s.length(); ++i) {
            this.drawString(s.substring(i, i + 1), 8 + x + i * 13, y + (int)(4.9 * Math.sin((double)i + this.timer / 4.0)), 0);
        }
    }

    public class Player
    extends JGObject {
        int oldmousex = 0;
        int oldmousey = 0;
        boolean scissors_c = false;

        public Player() {
            super("player", false, 0.0, 0.0, 1, null);
        }

        public void move() {
            int mx = Munchies.this.getMouseX();
            int my = Munchies.this.getMouseY();
            if (mx != this.oldmousex) {
                this.x = mx;
            }
            if (my != this.oldmousey) {
                this.y = my;
            }
            this.oldmousex = mx;
            this.oldmousey = my;
            if (Munchies.this.getKey(Munchies.this.key_left) || Munchies.this.getKey(Munchies.this.key_right)) {
                int inc = Munchies.this.getKey(Munchies.this.key_left) ? -1 : 1;
                Munchies.this.clearKey(Munchies.this.key_left);
                Munchies.this.clearKey(Munchies.this.key_right);
                JGPoint cen = this.getCenterTile();
                for (int tx = 1; tx < Munchies.this.pfTilesX(); ++tx) {
                    cen.x += inc;
                    if (cen.x < 0) {
                        cen.x = Munchies.this.pfTilesX() - 1;
                    }
                    if (cen.x >= Munchies.this.pfTilesX()) {
                        cen.x = 0;
                    }
                    if (!Player.and(Munchies.this.getTileCid(cen.x, 1), 2)) continue;
                    this.x = cen.x * Munchies.this.tileWidth() + 3;
                    this.y = 20.0;
                    break;
                }
            }
            if (Munchies.this.getMouseButton(1) || Munchies.this.getKey(Munchies.this.key_fire)) {
                this.setGraphic("scissors_c");
                if (!this.scissors_c) {
                    Munchies.this.playAudio("scissors");
                }
                this.scissors_c = true;
            } else {
                this.setGraphic("scissors_o");
                this.scissors_c = false;
            }
        }
    }

    public class Munchie
    extends JGObject {
        double timeleft = 600 + this.random(0, 200, 1);

        public Munchie(double x, double y, double speed) {
            super("munchie", true, x, y, 2, null);
            this.setSpeedAbs(speed, 0.0);
        }

        public void move() {
            if (this.xdir != 0) {
                double d;
                this.setGraphic(this.getGraphicName());
                this.timeleft -= Munchies.this.getGameSpeed();
                if (d <= 0.0) {
                    this.setGraphic("munchie_die");
                    Munchies.this.lifeLost();
                }
            }
            if (this.x < (double)(-Munchies.this.tileWidth()) && this.xdir < 0) {
                this.x = Munchies.this.pfWidth();
            }
            if (this.x > (double)Munchies.this.pfWidth() && this.xdir > 0) {
                this.x = -Munchies.this.tileWidth();
            }
            if (this.isXAligned() && Munchie.and(Munchies.this.getTileCid(this.getCenterTile(), 0, 0), 1)) {
                this.setGraphic(this.getGraphicName() + "_eat");
                this.xdir = 0;
                JGPoint cen = this.getCenterTile();
                for (int i = 1; i < Munchies.this.pfTilesY(); ++i) {
                    Munchies.this.andTileCid(cen.x, i, -2);
                }
            }
        }

        public void hit(JGObject obj) {
            if (this.xdir == 0) {
                Munchies.this.playAudio("munch");
                JGPoint spiderocc = Munchies.this.getTileIndex(obj.x, 0.0);
                Munchies.this.andTileCid(spiderocc.x, spiderocc.y, -2);
                obj.remove();
                this.xdir = this.random(-1, 1, 2);
                this.timeleft = 600.0;
                Munchies.this.score += 5;
            } else if (obj.yspeed == 0.0) {
                this.setGraphic("munchie_die");
                Munchies.this.lifeLost();
            }
        }

        private String getGraphicName() {
            String gfxname = "munchie_";
            gfxname = this.timeleft < 200.0 ? gfxname + "r_" : (this.timeleft < 400.0 ? gfxname + "y_" : gfxname + "g_");
            return gfxname + (this.xdir < 0 ? "l" : "r");
        }
    }

    public class Spider
    extends JGObject {
        boolean falling = false;
        double divider = this.random(8.0, 20.0);

        public Spider(int tilex) {
            super("spider", true, tilex * Munchies.this.tileWidth(), -16.0, 4, "spider");
        }

        public void move() {
            int i;
            JGPoint cen;
            if (!this.falling) {
                this.setSpeedAbs(0.0, 0.25 + 0.2 * Math.sin(Munchies.this.timer / this.divider));
                this.setBBox(4, (int)(-this.y), 8, (int)this.y + 16);
                if (this.y >= 4.0) {
                    cen = this.getCenterTile();
                    for (i = 1; i < Munchies.this.pfTilesY(); ++i) {
                        Munchies.this.orTileCid(cen.x, i, 2);
                    }
                }
            } else {
                this.clearBBox();
            }
            if (this.y >= (double)(Munchies.this.pfHeight() - 24)) {
                this.setSpeedAbs(0.0, 0.0);
                cen = this.getCenterTile();
                for (i = 1; i < Munchies.this.pfTilesY(); ++i) {
                    Munchies.this.andTileCid(cen.x, i, -4);
                }
            }
        }

        public void paint() {
            if (!this.falling) {
                Munchies.this.drawLine((int)this.x + 8, 0.0, (int)this.x + 8, (int)this.y, 1.0, new JGColor(150, 0, 120));
            }
        }

        public void hit(JGObject obj) {
            if (!this.falling && (Munchies.this.getMouseButton(1) || Munchies.this.getKey(Munchies.this.key_fire))) {
                this.falling = true;
                this.yspeed = 3.0;
                this.setAnimSpeed(0.3);
                JGPoint cen = this.getCenterTile();
                for (int i = 1; i < Munchies.this.pfTilesY(); ++i) {
                    Munchies.this.setTileCid(cen.x, i, 1);
                }
            }
        }
    }
}

