/*
 * Decompiled with CFR 0.152.
 */
package jgame.impl;

public class Animation {
    String[] frames;
    public double speed;
    public int increment = 1;
    public boolean pingpong = false;
    int framenr = 0;
    double phase = 0.0;
    boolean running = true;

    public Animation(String[] frames, double speed) {
        this.frames = frames;
        this.speed = speed;
    }

    public Animation(String[] frames, double speed, boolean pingpong) {
        this.frames = frames;
        this.speed = speed;
        this.pingpong = pingpong;
    }

    public Animation(String[] frames, double speed, boolean pingpong, int increment) {
        this.frames = frames;
        this.speed = speed;
        this.pingpong = pingpong;
        this.increment = increment;
    }

    public void stop() {
        this.running = false;
    }

    public void start() {
        this.running = true;
    }

    public void reset() {
        this.framenr = 0;
        this.phase = 0.0;
    }

    public Animation copy() {
        Animation cp = new Animation(this.frames, this.speed, this.pingpong);
        cp.framenr = this.framenr;
        cp.phase = this.phase;
        cp.running = this.running;
        return cp;
    }

    public String getCurrentFrame() {
        if (this.framenr < 0 || this.framenr >= this.frames.length) {
            return this.frames[0];
        }
        return this.frames[this.framenr];
    }

    public String animate(double speedmul) {
        String ret = this.getCurrentFrame();
        if (this.running) {
            this.phase += this.speed * speedmul;
            while (this.phase >= 1.0) {
                this.phase -= 1.0;
                this.framenr += this.increment;
                if (!this.pingpong) {
                    if (this.framenr >= this.frames.length) {
                        this.framenr -= this.frames.length;
                    }
                    if (this.framenr >= 0) continue;
                    this.framenr += this.frames.length;
                    continue;
                }
                if (this.framenr >= this.frames.length) {
                    this.framenr -= 2 * this.increment;
                    this.increment = -this.increment;
                }
                if (this.framenr >= 0) continue;
                this.framenr -= 2 * this.increment;
                this.increment = -this.increment;
            }
        }
        return ret;
    }
}

