/*
 * Decompiled with CFR 0.152.
 */
package examples.dingbats;

import examples.StdScoring;
import jgame.Highscore;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGImage;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class Dingbats
extends StdGame {
    double zoom = 1.0;
    double time_to_alarm;
    boolean chase_player = false;
    int clicks;
    int bg_space;
    double max_time_to_alarm;
    double dingbat_speed;
    int mousex;
    int mousey;
    int prevmousex = 0;
    int prevmousey = 0;
    double mousespeed = 0.0;
    JGColor[] timebarcol = new JGColor[]{JGColor.white, JGColor.orange, JGColor.red, JGColor.yellow};
    JGColor[] colcycle = new JGColor[]{JGColor.red, JGColor.yellow, JGColor.green, JGColor.cyan, JGColor.blue, JGColor.magenta};
    JGColor[] dingbatcol = new JGColor[]{new JGColor(1.0, 1.0, 1.0), new JGColor(1.0, 1.0, 0.4), new JGColor(1.0, 0.5, 0.4)};

    public static void main(String[] args) {
        new Dingbats(StdGame.parseSizeArgs(args, 0));
    }

    public Dingbats(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public Dingbats() {
        this.initEngineApplet();
    }

    public void initCanvas() {
        this.setCanvasSettings(16, 12, 64, 64, null, null, null);
    }

    public void initGame() {
        this.setFrameRate(50.0, 2.0);
        this.setBlendMode(1, 0);
        this.setVideoSyncedUpdate(true);
        this.defineMedia("dingbats.tbl");
        this.setMouseCursor(null);
        this.setHighscores(10, new Highscore(0, "nobody"), 25);
        this.setPFWrap(true, true, -60, -60);
        this.setPFSize(23, 19);
        this.highscore_font = new JGFont("Serif", 0, 32.0);
        this.highscore_title_font = new JGFont("Serif", 0, 32.0);
        this.status_font = new JGFont("Serif", 0, 32.0);
        this.title_font = new JGFont("Serif", 0, 32.0);
        this.leveldone_ingame = true;
        this.startgame_ingame = true;
        this.lifelost_ingame = true;
    }

    public void startTitle() {
        this.removeObjects(null, 0);
        this.fillBG(" ");
        this.setBGImage(1, "background3", true, true);
        this.setBGImage(0, "background2l0", true, true);
    }

    public void defineLevel() {
        int i;
        if (this.level >= 11) {
            this.level = 11;
        }
        this.bg_space = 2 - this.level / 4;
        this.max_time_to_alarm = (40 - this.level) * 50;
        this.dingbat_speed = 0.6 + 0.05 * (double)this.level;
        this.fillBG(" ");
        this.removeObjects(null, 0);
        for (i = 0; i < 13; ++i) {
            new Dingbat(1);
        }
        for (i = 0; i < 13; ++i) {
            new Dingbat(2);
        }
        for (i = 0; i < 13; ++i) {
            new Dingbat(3);
        }
        new Pointer();
        this.time_to_alarm = this.max_time_to_alarm;
        switch (this.stage % 4) {
            case 0: {
                int y;
                this.setBGImage(1, "background5", true, true);
                this.setBGImage(0, "background1l0", true, true);
                for (y = this.random(1, 3, 1); y < 19; y += 4) {
                    for (int x = this.random(0, 5, 1); x < 22; x += this.random(6 + this.bg_space, 10 + this.bg_space, 1)) {
                        this.setTile(x, y, "2" + this.random(0, 7, 1));
                    }
                }
                break;
            }
            case 1: {
                this.setBGImage(0, "background1l0", true, true);
                this.setBGImage(1, "background1", true, true);
                for (int x = 2; x < 21; x += 5) {
                    for (int y = this.random(0, 5, 1); y < 18; y += this.random(7 + this.bg_space, 13 + this.bg_space, 1)) {
                        for (int y2 = 0; y2 < this.random(2, 4, 1); ++y2) {
                            this.setTile(x, y + y2, "1" + this.random(0, 7, 1));
                        }
                    }
                }
                break;
            }
            case 2: {
                int y;
                this.setBGImage(1, "background4", true, true);
                this.setBGImage(0, "background2l0", true, true);
                for (y = this.random(1, 3, 1); y < 18; y += 3) {
                    for (int x = this.random(0, 5, 1); x < 23; x += this.random(6 + this.bg_space, 9 + this.bg_space, 1)) {
                        this.setTile(x, y, "4" + this.random(0, 7, 1));
                    }
                }
                break;
            }
            case 3: {
                int y;
                this.setBGImage(0, "background2l0", true, true);
                this.setBGImage(1, "background3", true, true);
                for (y = 1; y < 18; y += 4) {
                    for (int x = this.random(0, 5, 1); x < 20; x += this.random(9 + this.bg_space, 13 + this.bg_space, 1)) {
                        int start = this.random(0, 8, 4);
                        for (int x2 = 0; x2 < 4; ++x2) {
                            this.setTile(x + x2, y, "3" + (start + x2));
                        }
                    }
                }
                break;
            }
        }
        this.clicks = 7;
    }

    public void initNewLife() {
        new Pointer();
        this.clicks = 9;
    }

    public void paintFrameTitle() {
        this.drawImage(this.viewWidth() / 2 - 250, (double)(this.viewHeight() / 3), "logo" + (1 + (int)(this.seqtimer / 12.0) % 4), false);
        this.setFont(this.status_font);
        this.setColor(JGColor.white);
        this.drawString("Press " + this.getKeyDesc(this.key_startgame) + " to start", this.viewWidth() / 2, this.viewHeight() * 2 / 3, 0);
    }

    public void doFrameInGame() {
        this.time_to_alarm -= this.getGameSpeed();
        boolean bl = this.chase_player = this.time_to_alarm <= 0.0;
        if (!this.inGameState("LifeLost")) {
            this.setViewZoomRotate(1.0, 0.0);
            this.prevmousex = this.mousex;
            this.prevmousey = this.mousey;
            this.mousex = this.getMouseX();
            this.mousey = this.getMouseY();
        }
        this.setViewZoomRotate(this.zoom, 0.0);
        this.setViewOffset((int)(-0.15 * (double)this.viewWidth() + 48.0 + 1.3 * (double)this.mousex), (int)(-0.15 * (double)this.viewHeight() + 48.0 + 1.3 * (double)this.mousey), false);
        this.setBGImgOffset(0, (double)this.mousex / 1.5 + 30.0 * this.zoom, (double)this.mousey / 1.5 + 30.0 * this.zoom, false);
        this.setBGImgOffset(1, (double)this.mousex / 3.0 + 50.0 * this.zoom, (double)this.mousey / 3.0 + 50.0 * this.zoom, false);
        this.moveObjects(null, 0);
        this.checkCollision(4, 2);
        this.checkCollision(4, 1);
        this.checkCollision(1, 8);
        this.checkBGCollision(1, 1);
        this.mousespeed = 0.8 * this.mousespeed + 0.2 * Math.sqrt((this.prevmousex - this.mousex) * (this.prevmousex - this.mousex) + (this.prevmousey - this.mousey) * (this.prevmousey - this.mousey));
        double newzoom = 1.15 - this.mousespeed * 0.035;
        if (newzoom < 1.0) {
            newzoom = 1.0;
        }
        this.zoom += (newzoom - this.zoom) * 0.035;
        if (this.zoom < 1.0) {
            this.zoom = 1.0;
        }
        if (this.countObjects("neon", 0) == 0) {
            this.levelDone();
        }
        if (this.getKey(68)) {
            this.levelDone();
        }
    }

    public void paintFrameInGame() {
        boolean animate;
        this.setFont(this.status_font);
        this.drawString("Clicks " + this.clicks, this.viewWidth() / 2, 0.0, 0);
        this.setBlendMode(1, -1);
        boolean bl = animate = this.time_to_alarm <= 0.0;
        if (animate) {
            animate = (int)(-this.time_to_alarm) / 10 % 2 == 0;
        }
        this.drawImage(0.0, (double)(this.viewHeight() - 64), "alarmbell" + (animate ? "2" : ""), false);
        if (this.time_to_alarm > 0.0) {
            this.drawRect(64.0, (double)(this.viewHeight() - 40), (double)(this.viewWidth() - 64) * (this.time_to_alarm / this.max_time_to_alarm), 16.0, true, false, false, this.timebarcol);
        }
    }

    class Dingbat
    extends JGObject {
        int type;
        double rot;
        double rotinc;
        double scale;
        double alpha;
        String imgname;
        double approach_angle;
        double approach_dir;

        Dingbat(int type) {
            super("neon", true, Dingbats.this.random(0.0, Dingbats.this.pfWidth() - 50), Dingbats.this.random(0.0, Dingbats.this.pfHeight() - 50), 4, null);
            this.rot = 0.0;
            this.scale = 1.0;
            this.alpha = 0.7;
            this.imgname = "star";
            this.setSpeed(Dingbats.this.dingbat_speed * (double)this.random(-1, 1, 2) * this.random(1.5, 3.0), Dingbats.this.dingbat_speed * (double)this.random(-1, 1, 2) * this.random(1.5, 3.0));
            this.rotinc = (double)this.random(-1, 1, 2) * this.random(0.08, 0.18);
            this.type = type;
            this.setBBox(16, 16, 64, 64);
            this.approach_dir = this.random(-1, 1, 2);
            this.approach_angle = this.random(0.6, 0.9);
            this.imgname = this.imgname + type + "" + (1 + Dingbats.this.stage % 3);
        }

        public void move() {
            JGObject player;
            this.rot += this.rotinc * Dingbats.this.getGameSpeed();
            if (Dingbats.this.chase_player && (player = Dingbats.this.getObject("pointer")) != null) {
                double ang = Dingbats.this.atan2(this.x - player.x, this.y - player.y);
                double dist = Math.abs(this.x - player.x) + Math.abs(this.y - player.y);
                if (dist > 400.0) {
                    dist = 400.0;
                }
                this.xspeed += Dingbats.this.dingbat_speed * 0.5 * Math.sin(ang += this.approach_dir * Math.PI * (this.approach_angle + 0.4 * (400.0 - dist) / 400.0));
                this.yspeed += Dingbats.this.dingbat_speed * 0.5 * Math.cos(ang);
                this.xspeed *= 0.95;
                this.yspeed *= 0.95;
            }
        }

        public void paint() {
            if (this.type == 2) {
                Dingbats.this.setBlendMode(1, 0);
            } else {
                Dingbats.this.setBlendMode(1, 0);
            }
            Dingbats.this.drawImage(this.x, this.y, this.imgname, Dingbats.this.dingbatcol[this.type - 1], this.alpha, this.rot, this.scale, true);
        }
    }

    class Bonus
    extends JGObject {
        double rot;
        String imgname;

        Bonus(double x, double y) {
            super("bonus", true, x, y, 8, null, 500);
            this.rot = 0.0;
            this.imgname = "bonus";
            this.setSpeed(this.random(-1.0, 1.0), this.random(-1.0, 1.0));
            this.setBBox(16, 16, 64, 64);
            this.imgname = this.imgname + (1 + Dingbats.this.stage % 3);
        }

        public void move() {
            this.rot += 0.01;
        }

        public void hit(JGObject o) {
            this.remove();
            Dingbats.this.score += 15;
            ++Dingbats.this.clicks;
        }

        public void paint() {
            Dingbats.this.setBlendMode(1, 0);
            Dingbats.this.drawImage(this.x, this.y, this.imgname, new JGColor(1.0, 1.0, 1.0), this.expiry / 500.0, this.rot, 1.0, true);
        }
    }

    class Explo
    extends JGObject {
        double rot;
        double rotinc;
        String imgname;

        Explo(double x, double y) {
            super("explo", true, x, y, 0, null, 80);
            this.rot = 0.0;
            this.imgname = "explo";
            this.rotinc = 0.06;
            this.imgname = this.imgname + (1 + Dingbats.this.stage % 3);
        }

        public void move() {
            this.rot += this.rotinc;
        }

        public void paint() {
            Dingbats.this.setBlendMode(1, 0);
            Dingbats.this.drawImage(this.x, this.y, this.imgname, new JGColor(1.0, 1.0, 1.0), this.expiry / 80.0, this.rot, 1.0 + (80.0 - this.expiry) / 80.0 * 2.5, true);
        }
    }

    class Message
    extends JGObject {
        double rot;
        String sprite;

        Message(double x, double y, String sprite, double rot) {
            super("message", true, x, y, 0, null, 80);
            this.sprite = sprite;
            this.rot = rot;
        }

        public void move() {
            this.x += 3.0 * Math.sin(this.rot);
            this.y += 3.0 * Math.cos(this.rot);
        }

        public void paint() {
            Dingbats.this.setBlendMode(1, 0);
            Dingbats.this.drawImage(this.x, this.y, this.sprite, Dingbats.this.colcycle[(int)this.expiry / 4 % Dingbats.this.colcycle.length], 0.5 + 0.5 * (this.expiry / 80.0), 0.0, 0.5 + 0.5 * (80.0 - this.expiry) / 80.0, true);
        }
    }

    class Bullet
    extends JGObject {
        int[] nr_got;
        double rot;
        double rotinc;
        boolean pair;
        boolean twopair;
        boolean triplet;
        boolean quad;
        boolean quint;
        boolean set;
        boolean twoset;

        Bullet(double x, double y, double ang) {
            super("bullet", true, x, y, 2, null, 35);
            this.nr_got = new int[3];
            this.rot = 0.0;
            this.pair = false;
            this.twopair = false;
            this.triplet = false;
            this.quad = false;
            this.quint = false;
            this.set = false;
            this.twoset = false;
            this.setBBox(-24, -24, 144, 144);
            this.rot = ang - 1.5707963267948966;
        }

        public void move() {
        }

        public void hit(JGObject o) {
            int i;
            Dingbat od = (Dingbat)o;
            new Explo(od.x, od.y);
            int n = od.type - 1;
            this.nr_got[n] = this.nr_got[n] + 1;
            od.remove();
            String bonusname = null;
            int bonus = 5;
            int clickbonus = 0;
            double msgangle = 0.0;
            for (i = 0; i < 3; ++i) {
                if (!this.quint && this.nr_got[i] >= 5) {
                    this.quint = true;
                    bonusname = "quint";
                    msgangle = 90.0;
                    clickbonus += 3;
                    bonus += 75;
                }
                if (this.quad || this.nr_got[i] != 4) continue;
                this.quad = true;
                bonusname = "quad";
                msgangle = 90.0;
                clickbonus += 5;
                bonus += 50;
            }
            while (!this.set && this.nr_got[0] > 0 && this.nr_got[1] > 0 && this.nr_got[2] > 0) {
                this.set = true;
                bonusname = "set";
                msgangle = -90.0;
                clickbonus += 5;
                bonus += 50;
            }
            while (!this.twoset && this.nr_got[0] > 1 && this.nr_got[1] > 1 && this.nr_got[2] > 1) {
                this.twoset = true;
                bonusname = "two sets";
                msgangle = -45.0;
                clickbonus += 3;
                bonus += 75;
            }
            for (i = 0; i < 3; ++i) {
                if (!this.triplet && this.nr_got[i] == 3) {
                    this.triplet = true;
                    bonusname = "triplet";
                    msgangle = 45.0;
                    clickbonus += 3;
                    bonus += 30;
                }
                if (this.nr_got[i] < 2) continue;
                if (!this.pair) {
                    this.pair = true;
                    bonusname = "pair";
                    msgangle = 0.0;
                    ++clickbonus;
                    bonus += 10;
                }
                if (this.twopair) continue;
                for (int j = 0; j < 3; ++j) {
                    if (j == i || this.nr_got[j] < 2) continue;
                    this.twopair = true;
                    bonusname = "two pairs";
                    msgangle = -90.0;
                    clickbonus += 3;
                    bonus += 30;
                }
            }
            Dingbats.this.score += bonus;
            for (i = 0; i < clickbonus; ++i) {
                new Bonus(this.x, this.y);
            }
            if (bonusname != null) {
                JGImage img = Dingbats.this.getImage("bonus-" + bonusname);
                if (img == null) {
                    new StdScoring("score", this.x, this.y, 0.0, -1.0, 80, bonusname + "!", new JGFont("Serif", 0, 20.0), new JGColor[]{JGColor.red, JGColor.blue, JGColor.green}, 10);
                } else {
                    msgangle = msgangle / 180.0 * Math.PI;
                    JGObject player = Dingbats.this.getObject("pointer");
                    if (player != null) {
                        msgangle += Dingbats.this.atan2(player.x - this.x, player.y - this.y);
                    }
                    new Message(this.x, this.y, "bonus-" + bonusname, msgangle);
                }
            }
        }

        public void paint() {
            Dingbats.this.setBlendMode(1, 0);
            Dingbats.this.drawImage(this.x, this.y, "bullet", Dingbats.this.colcycle[(int)this.expiry / 2 % Dingbats.this.colcycle.length], 1.0, this.rot, 0.5 + (35.0 - this.expiry) / 35.0 * 1.2, true);
        }
    }

    class Pointer
    extends JGObject {
        double mousexdir;
        double mouseydir;
        int bullettimer;
        double invulnerability;
        double markerx;
        double markery;
        double prevmarkerx;
        double prevmarkery;
        double angle;
        double prevangle;

        Pointer() {
            super("pointer", false, Dingbats.this.mousex, Dingbats.this.mousey, 1, null);
            this.mousexdir = 0.0;
            this.mouseydir = 0.0;
            this.bullettimer = 0;
            this.invulnerability = 100.0;
            this.setBBox(32, 32, 32, 32);
        }

        public void hit(JGObject o) {
            if (this.invulnerability <= 0.0) {
                this.remove();
                Dingbats.this.lifeLost();
                new Explo(this.x, this.y - 25.0);
                new Explo(this.x - 30.0, this.y + 15.0);
                new Explo(this.x + 30.0, this.y + 15.0);
            }
        }

        public void hit_bg(int tilecid) {
            if (this.invulnerability <= 0.0) {
                this.remove();
                Dingbats.this.lifeLost();
                new Explo(this.x, this.y - 25.0);
                new Explo(this.x - 30.0, this.y + 15.0);
                new Explo(this.x + 30.0, this.y + 15.0);
            }
        }

        public void move() {
            if (this.invulnerability > 0.0) {
                this.invulnerability -= gamespeed;
            }
            this.x = 2 * Dingbats.this.mousex;
            this.y = 2 * Dingbats.this.mousey;
            if (Math.abs(Dingbats.this.prevmousex - Dingbats.this.mousex) + Math.abs(Dingbats.this.prevmousey - Dingbats.this.mousey) > 2) {
                this.mousexdir = 0.8 * this.mousexdir + 0.2 * (double)(Dingbats.this.prevmousex - Dingbats.this.mousex);
                this.mouseydir = 0.8 * this.mouseydir + 0.2 * (double)(Dingbats.this.prevmousey - Dingbats.this.mousey);
            } else {
                this.mousexdir += 0.1 * (double)(Dingbats.this.prevmousex - Dingbats.this.mousex);
                this.mouseydir += 0.1 * (double)(Dingbats.this.prevmousey - Dingbats.this.mousey);
            }
            this.markerx = this.x + 150.0 * Math.sin(this.angle);
            this.markery = this.y + 150.0 * Math.cos(this.angle);
            this.prevmarkerx = this.x + 150.0 * Math.sin(this.prevangle);
            this.prevmarkery = this.y + 150.0 * Math.cos(this.prevangle);
            this.angle = Math.PI + Math.atan2(this.mousexdir, this.mouseydir);
            if (this.angle - this.prevangle > Math.PI) {
                this.prevangle -= Math.PI * 2;
            }
            if (this.angle - this.prevangle < -Math.PI) {
                this.prevangle += Math.PI * 2;
            }
            this.prevangle = Math.abs(this.angle - this.prevangle) > 0.9424777960769379 ? this.angle : 0.7 * this.prevangle + 0.3 * this.angle;
            if ((Dingbats.this.getMouseButton(1) || Dingbats.this.getKey(90)) && this.bullettimer <= 0 && Dingbats.this.clicks > 0) {
                Dingbats.this.clearKey(90);
                Dingbats.this.clearMouseButton(1);
                new Bullet(this.markerx, this.markery, this.angle);
                --Dingbats.this.clicks;
            }
        }

        public void paint() {
            Dingbats.this.setBlendMode(1, 0);
            Dingbats.this.drawImage(Dingbats.this.mousex * 2, (double)(Dingbats.this.mousey * 2), "pointer", new JGColor(1.0, 1.0, 1.0), 0.5 - (this.invulnerability > 0.0 ? 0.25 + 0.25 * Math.sin(this.invulnerability) : 0.0), Math.atan2(this.mousexdir, this.mouseydir), 1.0 + 0.5 * (this.invulnerability / 100.0), true);
            Dingbats.this.drawImage(this.prevmarkerx, this.prevmarkery, "bullet", new JGColor(1.0, 1.0, 1.0), 1.0, Math.atan2(this.mousexdir, this.mouseydir) + 1.5707963267948966, 0.5, true);
        }
    }

    class Level {
        String bat1;
        String bat2;
        String bat3;
        int combo;
        String bg0;
        String bg1;
        int bg_style;
        double bg_density;

        Level(String bat1, String bat2, String bat3, String bg0, String bg1, int bg_style, double bg_density) {
            this.bat1 = bat1;
            this.bat2 = bat2;
            this.bat3 = bat3;
            this.bg0 = bg0;
            this.bg1 = bg1;
            this.bg_style = bg_style;
            this.bg_density = bg_density;
        }
    }
}

