/*
 * Decompiled with CFR 0.152.
 */
package jgame.platform;

import com.sun.opengl.util.Animator;
import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.j2d.TextureRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGImage;
import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.JGTimer;
import jgame.impl.Animation;
import jgame.impl.EngineLogic;
import jgame.impl.ImageMap;
import jgame.impl.JGEngineInterface;
import jgame.impl.JGameError;
import jgame.impl.SortedArray;
import jgame.platform.JREEngine;
import jgame.platform.JREImage;

public abstract class JGEngine
extends Applet
implements JGEngineInterface {
    JREImage imageutil = new JREImage();
    EngineLogic el = new EngineLogic(this.imageutil, false, false);
    JREEngine jre = new JREEngine(this.el, this);
    private Thread thread = null;
    Animator anim = null;
    GLU glu = new GLU();
    JGCanvas canvas = null;
    double viewzoom = 1.0;
    double viewrotate = 0.0;
    boolean running = true;
    boolean i_am_applet = false;
    public static final int KeyBackspace = 8;
    public static final int KeyTab = 9;
    boolean gl_driven_update = false;
    boolean enable_npot = false;
    TextureRenderer background = null;
    TextureRenderer buffer = null;
    Graphics2D bgg = null;
    Graphics2D bufg = null;
    Graphics buf_gfx = null;
    GL cur_gl = null;
    int debugflags = 8;
    static final int BBOX_DEBUG = 1;
    static final int GAMESTATE_DEBUG = 2;
    static final int FULLSTACKTRACE_DEBUG = 4;
    static final int MSGSINPF_DEBUG = 8;
    private static int dbgframelog_expiry = 80;
    private JGFont debugmessage_font = new JGFont("Arial", 0, 12.0);
    JGColor debug_auxcolor1 = JGColor.green;
    JGColor debug_auxcolor2 = JGColor.magenta;
    private Hashtable dbgframelogs = new Hashtable();
    private Hashtable dbgnewframelogs = new Hashtable();
    private Hashtable dbgframelogs_new = new Hashtable();
    private Hashtable dbgframelogs_obj = new Hashtable();
    private Hashtable dbgframelogs_dead = new Hashtable();
    private BufferedImage null_image = new BufferedImage(1, 1, 2);
    boolean modelview_matrix_pf_relative = false;
    double[] ovalx = null;
    double[] ovaly = null;
    double[] ovalx_sm = null;
    double[] ovaly_sm = null;
    double[] ovalx_lg = null;
    double[] ovaly_lg = null;
    JGColor[] ovals;
    JGColor[] ovals_sm;
    JGColor[] ovals_lg;
    JGColor[] ovalshade;
    Hashtable textren = new Hashtable();
    Font cur_gl_font = new Font("Arial", 0, 12);
    JGColor cur_gl_color = JGColor.white;
    double cur_gl_stroke = 1.0;
    int cur_gl_blend_src = 1;
    int cur_gl_blend_dst = -1;

    public JGImage getImage(String imgname) {
        return this.el.getImage(imgname);
    }

    public JGPoint getImageSize(String imgname) {
        return this.el.getImageSize(imgname);
    }

    public void defineImage(String name, String tilename, int collisionid, String imgfile, String img_op, int top, int left, int width, int height) {
        this.el.defineImage(this, name, tilename, collisionid, imgfile, img_op, top, left, width, height);
    }

    public void defineImage(String imgname, String tilename, int collisionid, String imgfile, String img_op) {
        this.el.defineImage(this, imgname, tilename, collisionid, imgfile, img_op);
    }

    public void defineImage(String imgname, String tilename, int collisionid, String imgmap, int mapidx, String img_op, int top, int left, int width, int height) {
        this.el.defineImage(imgname, tilename, collisionid, imgmap, mapidx, img_op, top, left, width, height);
    }

    public void defineImage(String imgname, String tilename, int collisionid, String imgmap, int mapidx, String img_op) {
        this.el.defineImage(imgname, tilename, collisionid, imgmap, mapidx, img_op);
    }

    public void defineImageRotated(String name, String tilename, int collisionid, String srcname, double angle) {
        this.el.defineImageRotated(this, name, tilename, collisionid, srcname, angle);
    }

    public void defineImageMap(String mapname, String imgfile, int xofs, int yofs, int tilex, int tiley, int skipx, int skipy) {
        this.el.defineImageMap(this, mapname, imgfile, xofs, yofs, tilex, tiley, skipx, skipy);
    }

    public JGRectangle getImageBBox(String imgname) {
        return this.el.getImageBBox(imgname);
    }

    public void defineMedia(String filename) {
        this.el.defineMedia(this, filename);
    }

    public void markAddObject(JGObject obj) {
        this.el.markAddObject(obj);
    }

    public boolean existsObject(String index) {
        return this.el.existsObject(index);
    }

    public JGObject getObject(String index) {
        return this.el.getObject(index);
    }

    public void moveObjects(String prefix, int cidmask) {
        this.el.moveObjects(this, prefix, cidmask);
    }

    public void moveObjects() {
        this.el.moveObjects(this);
    }

    public void checkCollision(int srccid, int dstcid) {
        this.el.checkCollision(this, srccid, dstcid);
    }

    public int checkCollision(int cidmask, JGObject obj) {
        return this.el.checkCollision(cidmask, obj);
    }

    public int checkBGCollision(JGRectangle r) {
        return this.el.checkBGCollision(r);
    }

    public void checkBGCollision(int tilecid, int objcid) {
        this.el.checkBGCollision(this, tilecid, objcid);
    }

    public Vector getObjects(String prefix, int cidmask, boolean suspended_obj, JGRectangle bbox) {
        return this.el.getObjects(prefix, cidmask, suspended_obj, bbox);
    }

    public void removeObject(JGObject obj) {
        this.el.removeObject(obj);
    }

    public void removeObjects(String prefix, int cidmask) {
        this.el.removeObjects(prefix, cidmask);
    }

    public void removeObjects(String prefix, int cidmask, boolean suspended_obj) {
        this.el.removeObjects(prefix, cidmask, suspended_obj);
    }

    public int countObjects(String prefix, int cidmask) {
        return this.el.countObjects(prefix, cidmask);
    }

    public int countObjects(String prefix, int cidmask, boolean suspended_obj) {
        return this.el.countObjects(prefix, cidmask, suspended_obj);
    }

    void drawObject(Graphics g, GL gl, JGObject o) {
        if (!o.is_suspended) {
            this.drawImage(gl, (int)o.x, (int)o.y, o.getImageName(), null, 1.0, 0.0, 1.0, true);
            try {
                o.paint();
            }
            catch (JGameError ex) {
                this.exitEngine(this.dbgExceptionToString(ex));
            }
            catch (Exception e) {
                this.dbgShowException(o.getName(), e);
            }
        }
        if ((this.debugflags & 1) != 0) {
            JGColor oldcol = this.cur_gl_color;
            double oldstroke = this.cur_gl_stroke;
            this.setStroke(1.0);
            this.setColor(this.el.fg_color);
            JGRectangle bbox = o.getBBox();
            if (bbox != null) {
                this.drawRect(bbox.x, bbox.y, bbox.width, bbox.height, false, false);
            }
            if ((bbox = o.getTileBBox()) != null) {
                this.drawRect(bbox.x, bbox.y, bbox.width, bbox.height, false, false);
                this.setColor(this.debug_auxcolor1);
                bbox = o.getTileBBox();
                bbox = this.getTiles(bbox);
                bbox.x *= this.el.tilex;
                bbox.y *= this.el.tiley;
                bbox.width *= this.el.tilex;
                bbox.height *= this.el.tiley;
                this.drawRect(bbox.x, bbox.y, bbox.width, bbox.height, false, false);
                this.setColor(this.debug_auxcolor2);
                bbox = o.getCenterTiles();
                bbox.x *= this.el.tilex;
                bbox.y *= this.el.tiley;
                bbox.width *= this.el.tilex;
                bbox.height *= this.el.tiley;
                this.drawRect(bbox.x + 2, bbox.y + 2, bbox.width - 4, bbox.height - 4, false, false);
            }
            this.setColor(oldcol);
            this.setStroke(oldstroke);
        }
    }

    public void setBGImage(String bgimg) {
        this.el.setBGImage(bgimg, 0, true, true);
    }

    public void setBGImage(int depth, String bgimg, boolean wrapx, boolean wrapy) {
        this.el.setBGImage(bgimg, depth, wrapx, wrapy);
    }

    public void setTileSettings(String out_of_bounds_tile, int out_of_bounds_cid, int preserve_cids) {
        this.el.setTileSettings(out_of_bounds_tile, out_of_bounds_cid, preserve_cids);
    }

    public void fillBG(String filltile) {
        this.el.fillBG(filltile);
    }

    public void setTileCid(int x, int y, int and_mask, int or_mask) {
        this.el.setTileCid(x, y, and_mask, or_mask);
    }

    public void setTile(int x, int y, String tilestr) {
        this.el.setTile(x, y, tilestr);
    }

    void setColor(Graphics g, JGColor col) {
        this.cur_gl_color = col;
        col.impl = new Color(col.r, col.g, col.b);
        g.setColor((Color)col.impl);
    }

    void setColor(GL gl, JGColor col) {
        this.cur_gl_color = col;
        gl.glColor4d((double)col.r / 255.0, (double)col.g / 255.0, (double)col.b / 255.0, (double)col.alpha / 255.0);
    }

    public void drawTile(int xi, int yi, int tileid) {
        Integer tileid_obj;
        JREImage img;
        if (this.background == null) {
            return;
        }
        int x = this.el.moduloFloor(xi + 1, this.el.viewnrtilesx + 3) * this.el.scaledtilex;
        int y = this.el.moduloFloor(yi + 1, this.el.viewnrtilesy + 3) * this.el.scaledtiley;
        if (this.bgg == null) {
            this.bgg = this.background.createGraphics();
            this.bgg.setComposite(AlphaComposite.getInstance(2));
        }
        if ((img = (JREImage)this.el.getTileImage(tileid_obj = new Integer(tileid))) == null || this.el.images_transp.containsKey(tileid_obj)) {
            this.bgg.setColor(new Color(this.el.bg_color.r, this.el.bg_color.g, this.el.bg_color.b, 0));
            this.bgg.fillRect(x, y, this.el.scaledtilex, this.el.scaledtiley);
        }
        if (img != null) {
            this.bgg.drawImage(img.img, x, y, this);
        }
        this.background.markDirty(x, y, this.el.scaledtilex, this.el.scaledtiley);
    }

    public int countTiles(int tilecidmask) {
        return this.el.countTiles(tilecidmask);
    }

    public int getTileCid(int xidx, int yidx) {
        return this.el.getTileCid(xidx, yidx);
    }

    public String getTileStr(int xidx, int yidx) {
        return this.el.getTileStr(xidx, yidx);
    }

    public int getTileCid(JGRectangle tiler) {
        return this.el.getTileCid(tiler);
    }

    public JGRectangle getTiles(JGRectangle r) {
        return this.el.getTiles(r);
    }

    public boolean getTiles(JGRectangle dest, JGRectangle r) {
        return this.el.getTiles(dest, r);
    }

    public void setTileCid(int x, int y, int value) {
        this.el.setTileCid(x, y, value);
    }

    public void orTileCid(int x, int y, int or_mask) {
        this.el.orTileCid(x, y, or_mask);
    }

    public void andTileCid(int x, int y, int and_mask) {
        this.el.andTileCid(x, y, and_mask);
    }

    public void setTile(JGPoint tileidx, String tilename) {
        this.el.setTile(tileidx, tilename);
    }

    public void setTiles(int xofs, int yofs, String[] tilemap) {
        this.el.setTiles(xofs, yofs, tilemap);
    }

    public void setTilesMulti(int xofs, int yofs, String[] tilemap) {
        this.el.setTilesMulti(xofs, yofs, tilemap);
    }

    public int getTileCidAtCoord(double x, double y) {
        return this.el.getTileCidAtCoord(x, y);
    }

    public int getTileCid(JGPoint center, int xofs, int yofs) {
        return this.el.getTileCid(center, xofs, yofs);
    }

    public String getTileStrAtCoord(double x, double y) {
        return this.el.getTileStrAtCoord(x, y);
    }

    public String getTileStr(JGPoint center, int xofs, int yofs) {
        return this.el.getTileStr(center, xofs, yofs);
    }

    public int tileStrToID(String tilestr) {
        return this.el.tileStrToID(tilestr);
    }

    public String tileIDToStr(int tileid) {
        return this.el.tileIDToStr(tileid);
    }

    public double moduloXPos(double x) {
        return this.el.moduloXPos(x);
    }

    public double moduloYPos(double y) {
        return this.el.moduloYPos(y);
    }

    public void setProgressBar(double pos) {
        this.canvas.setProgressBar(pos);
    }

    public void setProgressMessage(String msg) {
        this.canvas.setProgressMessage(msg);
    }

    public void setAuthorMessage(String msg) {
        this.canvas.setAuthorMessage(msg);
    }

    private void refreshDbgFrameLogs() {
        this.dbgframelogs_new = new Hashtable();
        Enumeration e = this.dbgnewframelogs.keys();
        while (e.hasMoreElements()) {
            String source = (String)e.nextElement();
            Object log = this.dbgnewframelogs.get(source);
            this.dbgframelogs.put(source, log);
            this.dbgframelogs_new.put(source, "yes");
        }
        this.dbgnewframelogs = new Hashtable();
    }

    void paintDbgFrameLogs() {
        Font oldfont = this.cur_gl_font;
        JGColor oldcol = this.cur_gl_color;
        this.cur_gl_font = new Font(this.debugmessage_font.name, this.debugmessage_font.style, (int)this.debugmessage_font.size);
        Enumeration e = this.dbgframelogs.keys();
        while (e.hasMoreElements()) {
            Enumeration f;
            String source = (String)e.nextElement();
            Vector log = (Vector)this.dbgframelogs.get(source);
            if (this.dbgframelogs_new.containsKey(source)) {
                this.setColor(this.el.fg_color);
            } else {
                this.setColor(this.debug_auxcolor1);
            }
            JGObject obj = this.el.getObject(source);
            if (obj == null) {
                obj = (JGObject)this.dbgframelogs_obj.get(source);
                this.setColor(this.debug_auxcolor2);
                if (obj != null) {
                    int deadtime = 0;
                    if (this.dbgframelogs_dead.containsKey(source)) {
                        deadtime = (Integer)this.dbgframelogs_dead.get(source);
                    }
                    if (deadtime < dbgframelog_expiry) {
                        this.dbgframelogs_dead.put(source, new Integer(deadtime + 1));
                    } else {
                        this.dbgframelogs_obj.remove(source);
                        this.dbgframelogs_dead.remove(source);
                    }
                }
            }
            double lineheight = (double)(this.debugmessage_font.getSize() + 1) / this.el.y_scale_fac;
            if (obj != null) {
                double running_y = obj.y - lineheight * (double)log.size();
                f = log.elements();
                while (f.hasMoreElements()) {
                    this.drawString((String)f.nextElement(), obj.x, running_y, -1, true);
                    running_y += lineheight;
                }
                continue;
            }
            if (!source.equals("MAIN")) {
                this.dbgframelogs.remove(source);
                continue;
            }
            if (this.dbgframelogs_new.containsKey(source)) {
                this.setColor(this.el.fg_color);
            } else {
                this.setColor(this.debug_auxcolor1);
            }
            double ypos = (double)this.el.viewHeight() - lineheight * (double)log.size();
            f = log.elements();
            while (f.hasMoreElements()) {
                this.drawString((String)f.nextElement(), 0.0, ypos, -1, false);
                ypos += lineheight;
            }
        }
        this.cur_gl_font = oldfont;
        this.cur_gl_color = oldcol;
    }

    public void dbgShowBoundingBox(boolean enabled) {
        this.debugflags = enabled ? (this.debugflags |= 1) : (this.debugflags &= 0xFFFFFFFE);
    }

    public void dbgShowGameState(boolean enabled) {
        this.debugflags = enabled ? (this.debugflags |= 2) : (this.debugflags &= 0xFFFFFFFD);
    }

    public void dbgShowFullStackTrace(boolean enabled) {
        this.debugflags = enabled ? (this.debugflags |= 4) : (this.debugflags &= 0xFFFFFFFB);
    }

    public void dbgShowMessagesInPf(boolean enabled) {
        this.debugflags = enabled ? (this.debugflags |= 8) : (this.debugflags &= 0xFFFFFFF7);
    }

    public void dbgSetMessageExpiry(int ticks) {
        dbgframelog_expiry = ticks;
    }

    public void dbgSetMessageFont(JGFont font) {
        this.debugmessage_font = font;
    }

    public void dbgSetDebugColor1(JGColor col) {
        this.debug_auxcolor1 = col;
    }

    public void dbgSetDebugColor2(JGColor col) {
        this.debug_auxcolor2 = col;
    }

    public void dbgPrint(String msg) {
        this.dbgPrint("MAIN", msg);
    }

    public void dbgPrint(String source, String msg) {
        if ((this.debugflags & 8) != 0) {
            Vector<String> log = (Vector<String>)this.dbgnewframelogs.get(source);
            if (log == null) {
                log = new Vector<String>(5, 15);
            }
            if (log.size() < 19) {
                log.add(msg);
            } else if (log.size() == 19) {
                log.add("<messages truncated>");
            }
            this.dbgnewframelogs.put(source, log);
            JGObject obj = this.el.getObject(source);
            if (obj != null) {
                this.dbgframelogs_obj.put(source, obj);
                this.dbgframelogs_dead.remove(source);
            }
        } else {
            System.out.println(source + ": " + msg);
        }
    }

    public void dbgShowException(String source, Throwable e) {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(st));
        if ((this.debugflags & 4) != 0) {
            this.dbgPrint(source, st.toString());
        } else {
            StringTokenizer toker = new StringTokenizer(st.toString(), "\n");
            if (toker.hasMoreTokens()) {
                this.dbgPrint(source, toker.nextToken());
            }
            if (toker.hasMoreTokens()) {
                this.dbgPrint(source, toker.nextToken());
            }
            if (toker.hasMoreTokens()) {
                this.dbgPrint(source, toker.nextToken());
            }
        }
    }

    public String dbgExceptionToString(Throwable e) {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(st));
        if ((this.debugflags & 4) != 0) {
            return st.toString();
        }
        StringTokenizer toker = new StringTokenizer(st.toString(), "\n");
        String ret = toker.nextToken() + "\n";
        ret = ret + toker.nextToken() + "\n";
        if (toker.hasMoreTokens()) {
            ret = ret + toker.nextToken();
        }
        return ret;
    }

    public void exitEngine(String msg) {
        if (msg != null) {
            System.err.println(msg);
            this.el.exit_message = msg;
        }
        System.err.println("Exiting JGEngine.");
        if (!this.i_am_applet) {
            System.exit(0);
        }
        this.destroy();
        this.canvas.repaint();
    }

    public JGEngine() {
        this.imageutil.setComponent(this);
    }

    public void initEngineComponent(int width, int height) {
        this.i_am_applet = false;
        this.jre.create_frame = false;
        this.el.winwidth = width;
        this.el.winheight = height;
        this.init();
    }

    public void initEngineApplet() {
        this.i_am_applet = true;
    }

    public void initEngine(int width, int height) {
        this.i_am_applet = false;
        this.jre.create_frame = true;
        if (width == 0) {
            Dimension scrsize = Toolkit.getDefaultToolkit().getScreenSize();
            this.el.winwidth = scrsize.width;
            this.el.winheight = scrsize.height;
            this.jre.win_decoration = false;
        } else {
            this.el.winwidth = width;
            this.el.winheight = height;
            this.jre.win_decoration = true;
        }
        this.init();
    }

    public void setCanvasSettings(int nrtilesx, int nrtilesy, int tilex, int tiley, JGColor fgcolor, JGColor bgcolor, JGFont msgfont) {
        this.el.nrtilesx = nrtilesx;
        this.el.nrtilesy = nrtilesy;
        this.el.viewnrtilesx = nrtilesx;
        this.el.viewnrtilesy = nrtilesy;
        this.el.tilex = tilex;
        this.el.tiley = tiley;
        this.setColorsFont(fgcolor, bgcolor, msgfont);
        this.el.view_initialised = true;
    }

    public void setScalingPreferences(double min_aspect_ratio, double max_aspect_ratio, int crop_top, int crop_left, int crop_bottom, int crop_right) {
        this.el.min_aspect = min_aspect_ratio;
        this.el.max_aspect = max_aspect_ratio;
        this.el.crop_top = crop_top;
        this.el.crop_left = crop_left;
        this.el.crop_bottom = crop_bottom;
        this.el.crop_right = crop_right;
    }

    public void setSmoothing(boolean smooth_magnify) {
        this.el.smooth_magnify = smooth_magnify;
    }

    public void requestGameFocus() {
        this.canvas.requestFocus();
    }

    public boolean isApplet() {
        return this.i_am_applet;
    }

    public boolean isMidlet() {
        return false;
    }

    public boolean isOpenGL() {
        return true;
    }

    public boolean isAndroid() {
        return false;
    }

    public int viewWidth() {
        return this.el.viewnrtilesx * this.el.tilex;
    }

    public int viewHeight() {
        return this.el.viewnrtilesy * this.el.tiley;
    }

    public int viewTilesX() {
        return this.el.viewnrtilesx;
    }

    public int viewTilesY() {
        return this.el.viewnrtilesy;
    }

    public int viewXOfs() {
        return this.el.pendingxofs;
    }

    public int viewYOfs() {
        return this.el.pendingyofs;
    }

    public int pfWidth() {
        return this.el.nrtilesx * this.el.tilex;
    }

    public int pfHeight() {
        return this.el.nrtilesy * this.el.tiley;
    }

    public int pfTilesX() {
        return this.el.nrtilesx;
    }

    public int pfTilesY() {
        return this.el.nrtilesy;
    }

    public boolean pfWrapX() {
        return this.el.pf_wrapx;
    }

    public boolean pfWrapY() {
        return this.el.pf_wrapy;
    }

    public int tileWidth() {
        return this.el.tilex;
    }

    public int tileHeight() {
        return this.el.tiley;
    }

    public int displayWidth() {
        return this.el.winwidth;
    }

    public int displayHeight() {
        return this.el.winheight;
    }

    public double getFrameRate() {
        return this.el.fps;
    }

    public double getGameSpeed() {
        return this.el.gamespeed;
    }

    public double getFrameSkip() {
        return this.el.maxframeskip;
    }

    public boolean getVideoSyncedUpdate() {
        return this.gl_driven_update;
    }

    public int getOffscreenMarginX() {
        return this.el.offscreen_margin_x;
    }

    public int getOffscreenMarginY() {
        return this.el.offscreen_margin_y;
    }

    public double getXScaleFactor() {
        return this.el.x_scale_fac;
    }

    public double getYScaleFactor() {
        return this.el.y_scale_fac;
    }

    public double getMinScaleFactor() {
        return this.el.min_scale_fac;
    }

    public void init() {
        this.jre.storeInit();
        if (this.el.winwidth == 0) {
            this.el.winwidth = this.getWidth();
            this.el.winheight = this.getHeight();
            if (this.el.winwidth <= 1 || this.el.winheight <= 1) {
                this.el.winwidth = Integer.parseInt(this.getParameter("canvaswidth"));
                this.el.winheight = Integer.parseInt(this.getParameter("canvasheight"));
            }
        }
        this.initCanvas();
        if (!this.el.view_initialised) {
            this.exitEngine("Canvas settings not initialised, use setCanvasSettings().");
        }
        if (!this.i_am_applet && this.jre.create_frame) {
            this.jre.createWindow(this, this.jre.win_decoration);
        }
        this.el.initPF();
        this.canvas = new JGCanvas(this.el.winwidth - (this.el.canvas_xofs > 0 ? this.el.canvas_xofs * 2 : 0), this.el.winheight - (this.el.canvas_yofs > 0 ? this.el.canvas_yofs * 2 : 0));
        this.canvas.addGLEventListener(this.canvas);
        this.jre.canvas = this.canvas;
        this.jre.clearKeymap();
        this.canvas.addMouseListener(this.jre);
        this.canvas.addMouseMotionListener(this.jre);
        this.canvas.addFocusListener(this.jre);
        this.canvas.setBackground(this.getAWTColor(this.el.bg_color));
        if (this.jre.my_win != null) {
            this.jre.my_win.setBackground(this.getAWTColor(this.el.bg_color));
        }
        this.el.msg_font = new JGFont("Helvetica", 0, (int)(16.0 / (640.0 / (double)(this.el.tilex * this.el.nrtilesx))));
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add((Component)((Object)this.canvas));
        if (!JGObject.setEngine(this)) {
            this.canvas.setInitPainter(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList d1, Object value, int d2, boolean initialise, boolean d4) {
                    GL gl = (GL)value;
                    JGEngine.this.setFont(JGEngine.this.el.msg_font);
                    JGEngine.this.setColor(gl, JGEngine.this.el.fg_color);
                    JGEngine.this.drawString(gl, "JGame is already running in this VM", (double)(JGEngine.this.el.viewWidth() / 2), (double)(JGEngine.this.el.viewHeight() / 3), 0, false);
                    return null;
                }
            });
            return;
        }
        this.el.is_inited = true;
        this.canvas.setInitPainter(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList d1, Object value, int d2, boolean initialise, boolean d4) {
                JGImage splash;
                GL gl;
                JGEngine.this.cur_gl = gl = (GL)value;
                JGEngine.this.setFont(JGEngine.this.el.msg_font);
                JGEngine.this.setColor(JGEngine.this.el.fg_color);
                JGImage jGImage = splash = JGEngine.this.el.existsImage("splash_image") ? JGEngine.this.el.getImage("splash_image") : null;
                if (splash != null) {
                    gl.glEnable(3042);
                    gl.glBlendFunc(770, 771);
                    gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    JGPoint splash_size = JGEngine.this.getImageSize("splash_image");
                    JGEngine.this.drawImage(gl, JGEngine.this.viewWidth() / 2 - splash_size.x / 2, Math.max(0, JGEngine.this.viewHeight() / 4 - splash_size.y / 2), "splash_image", null, 1.0, 0.0, 1.0, false);
                    gl.glDisable(3042);
                }
                JGEngine.this.drawString(JGEngine.this.canvas.progress_message, JGEngine.this.viewWidth() / 2, JGEngine.this.viewHeight() / 2, 0, false);
                JGEngine.this.setColor(JGEngine.this.el.bg_color);
                JGEngine.this.drawRect((int)((double)JGEngine.this.viewWidth() * (0.1 + 0.8 * JGEngine.this.canvas.progress_bar)), (int)((double)JGEngine.this.viewHeight() * 0.75), (int)((double)JGEngine.this.viewWidth() * 0.8 * (1.0 - JGEngine.this.canvas.progress_bar)), (int)((double)JGEngine.this.viewHeight() * 0.05), true, false, false);
                JGEngine.this.setColor(JGEngine.this.el.fg_color);
                JGEngine.this.drawRect((int)((double)JGEngine.this.viewWidth() * 0.1), (int)((double)JGEngine.this.viewHeight() * 0.75), (int)((double)JGEngine.this.viewWidth() * 0.8 * JGEngine.this.canvas.progress_bar), (int)((double)JGEngine.this.viewHeight() * 0.05), true, false, false);
                JGEngine.this.drawRect((int)((double)JGEngine.this.viewWidth() * 0.1), (int)((double)JGEngine.this.viewHeight() * 0.75), (int)((double)JGEngine.this.viewWidth() * 0.8), (int)((double)JGEngine.this.viewHeight() * 0.008), true, false, false);
                JGEngine.this.drawRect((int)((double)JGEngine.this.viewWidth() * 0.1), (int)((double)JGEngine.this.viewHeight() * 0.796), (int)((double)JGEngine.this.viewWidth() * 0.8), (int)((double)JGEngine.this.viewHeight() * 0.008), true, false, false);
                JGEngine.this.drawString(JGEngine.this.canvas.author_message, JGEngine.this.viewWidth() - 16, (double)JGEngine.this.viewHeight() - JGEngine.this.getFontHeight(JGEngine.this.el.msg_font) - 10.0, 1, false);
                return null;
            }
        });
        if (this.jre.my_win != null) {
            this.jre.my_win.setVisible(true);
            this.jre.my_win.validate();
            this.jre.setWindowSize(this.jre.win_decoration);
        }
        this.canvas.addKeyListener(this.jre);
        this.canvas.requestFocus();
        this.canvas.repaint();
        this.thread = new Thread(new JGEngineThread());
        this.thread.start();
    }

    public abstract void initCanvas();

    public abstract void initGame();

    public void start() {
        this.running = true;
        this.canvas.repaint();
    }

    public void stop() {
        this.running = false;
    }

    public void startApp() {
        if (!this.el.is_inited) {
            this.init();
        } else {
            this.start();
        }
    }

    public void pauseApp() {
        this.stop();
    }

    public void destroyApp(boolean unconditional) {
        this.destroy();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void wakeUpOnKey(int key) {
        this.jre.wakeUpOnKey(key);
    }

    public void destroy() {
        this.el.is_exited = true;
        if (this.anim != null) {
            this.anim.stop();
            this.anim = null;
        }
        if (this.thread != null) {
            if (!this.i_am_applet) {
                this.thread.interrupt();
            }
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.el.is_inited) {
            JGObject.setEngine(null);
        }
        this.disableAudio();
        System.out.println("JGame engine disposed.");
    }

    public void setViewOffset(int xofs, int yofs, boolean centered) {
        this.el.setViewOffset(xofs, yofs, centered);
    }

    public void setBGImgOffset(int depth, double xofs, double yofs, boolean centered) {
        this.el.setBGImgOffset(depth, xofs, yofs, centered);
    }

    public void setViewZoomRotate(double zoom, double rotate) {
        this.viewzoom = zoom;
        this.viewrotate = rotate;
    }

    public void setPFSize(int nrtilesx, int nrtilesy) {
        this.el.setPFSize(nrtilesx, nrtilesy);
    }

    public void setPFWrap(boolean wrapx, boolean wrapy, int shiftx, int shifty) {
        this.el.setPFWrap(wrapx, wrapy, shiftx, shifty);
    }

    public void setFrameRate(double fps, double maxframeskip) {
        this.el.setFrameRate(fps, maxframeskip);
    }

    public void setVideoSyncedUpdate(boolean value) {
        this.gl_driven_update = value;
        if (value) {
            if (this.canvas != null) {
                this.canvas.repaint();
            }
        } else {
            if (this.anim != null) {
                this.anim.stop();
                this.anim = null;
            }
            this.setGameSpeed(1.0);
        }
    }

    public void setGameSpeed(double gamespeed) {
        this.el.setGameSpeed(gamespeed);
    }

    public void setRenderSettings(int alpha_thresh, JGColor render_bg_col) {
        this.el.setRenderSettings(alpha_thresh, render_bg_col);
    }

    public void setOffscreenMargin(int xmargin, int ymargin) {
        this.el.setOffscreenMargin(xmargin, ymargin);
    }

    public void setBGColor(JGColor bgcolor) {
        Color bgcol = new Color(bgcolor.r, bgcolor.g, bgcolor.b);
        if (this.canvas != null) {
            this.canvas.setBackground(bgcol);
        }
        if (this.jre.my_win != null) {
            this.jre.my_win.setBackground(bgcol);
        }
        this.el.bg_color = bgcolor;
    }

    public void setFGColor(JGColor fgcolor) {
        this.el.fg_color = fgcolor;
    }

    public void setMsgFont(JGFont msgfont) {
        this.el.msg_font = msgfont;
    }

    public void setColorsFont(JGColor fgcolor, JGColor bgcolor, JGFont msgfont) {
        if (msgfont != null) {
            this.el.msg_font = msgfont;
        }
        if (fgcolor != null) {
            this.el.fg_color = fgcolor;
        }
        if (bgcolor != null) {
            this.setBGColor(bgcolor);
        }
    }

    public void setTextOutline(int thickness, JGColor colour) {
        this.el.outline_colour = colour;
        this.el.outline_thickness = thickness;
    }

    public void setMouseCursor(int cursor) {
        if (cursor == 0) {
            this.canvas.setCursor(new Cursor(0));
        } else if (cursor == 1) {
            this.canvas.setCursor(new Cursor(1));
        } else if (cursor == 2) {
            this.canvas.setCursor(new Cursor(12));
        } else if (cursor == 3) {
            this.canvas.setCursor(new Cursor(3));
        } else if (cursor == -1) {
            this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.null_image, new Point(0, 0), "hidden"));
        }
    }

    public void setMouseCursor(Object cursor) {
        if (cursor == null) {
            this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.null_image, new Point(0, 0), "hidden"));
        } else {
            this.canvas.setCursor((Cursor)cursor);
        }
    }

    public void removeAllTimers() {
        this.el.removeAllTimers();
    }

    public void registerTimer(JGTimer timer) {
        this.el.registerTimer(timer);
    }

    public void setGameState(String state) {
        this.el.setGameState(state);
    }

    public void addGameState(String state) {
        this.el.addGameState(state);
    }

    public void removeGameState(String state) {
        this.el.removeGameState(state);
    }

    public void clearGameState() {
        this.el.clearGameState();
    }

    public boolean inGameState(String state) {
        return this.el.inGameState(state);
    }

    public boolean inGameStateNextFrame(String state) {
        return this.el.inGameStateNextFrame(state);
    }

    private void doFrameAll() {
        this.jre.audioNewFrame();
        this.el.flushRemoveList();
        this.el.flushAddList();
        this.el.tickTimers();
        this.el.flushRemoveList();
        this.el.flushAddList();
        this.el.gamestate = this.el.gamestate_nextframe;
        this.el.gamestate_nextframe = new Vector(10, 20);
        this.el.gamestate_nextframe.addAll(this.el.gamestate);
        this.invokeGameStateMethods("start", this.el.gamestate_new);
        this.el.gamestate_new.clear();
        this.el.flushRemoveList();
        this.el.flushAddList();
        try {
            this.doFrame();
        }
        catch (JGameError ex) {
            this.exitEngine(this.dbgExceptionToString(ex));
        }
        catch (Exception ex) {
            this.dbgShowException("MAIN", ex);
        }
        this.invokeGameStateMethods("doFrame", this.el.gamestate);
        this.el.frameFinished();
    }

    private void invokeGameStateMethods(String prefix, Vector states) {
        Enumeration e = states.elements();
        while (e.hasMoreElements()) {
            String state = (String)e.nextElement();
            this.jre.tryMethod(this, prefix + state, new Object[0]);
        }
    }

    public void doFrame() {
    }

    void paintFrame(Graphics g) {
        this.buf_gfx = g;
        this.setColor(g, this.el.fg_color);
        this.setFont(this.el.msg_font);
        try {
            this.paintFrame();
        }
        catch (JGameError ex) {
            this.exitEngine(this.dbgExceptionToString(ex));
        }
        catch (Exception ex) {
            this.dbgShowException("MAIN", ex);
        }
        this.invokeGameStateMethods("paintFrame", this.el.gamestate);
        if ((this.debugflags & 2) != 0) {
            String state = "{";
            Enumeration e = this.el.gamestate.elements();
            while (e.hasMoreElements()) {
                state = state + (String)e.nextElement();
                if (!e.hasMoreElements()) continue;
                state = state + ",";
            }
            state = state + "}";
            this.setFont(this.el.msg_font);
            this.setColor(g, this.el.fg_color);
            this.drawString(state, this.el.viewWidth(), this.el.viewHeight() - (int)this.getFontHeight(this.el.msg_font), 1);
        }
        if ((this.debugflags & 8) != 0) {
            this.paintDbgFrameLogs();
        }
        this.buf_gfx = null;
    }

    public void paintFrame() {
    }

    public Graphics getBufferGraphics() {
        return this.buf_gfx;
    }

    public void setColor(JGColor col) {
        if (this.buf_gfx != null) {
            this.setColor(this.buf_gfx, col);
        }
        if (this.cur_gl != null) {
            this.setColor(this.cur_gl, col);
        }
        this.cur_gl_color = col;
    }

    public Color getAWTColor(JGColor col) {
        return new Color(col.r, col.g, col.b);
    }

    public void setFont(JGFont font) {
        this.setFont(this.buf_gfx, font);
    }

    public void setFont(Graphics g, JGFont jgfont) {
        Font font = new Font(jgfont.name, jgfont.style, (int)jgfont.size);
        this.cur_gl_font = font = font.deriveFont((float)(jgfont.size * this.el.min_scale_fac));
        if (this.canvas != null && g != null) {
            g.setFont(font);
        }
    }

    public void setStroke(double thickness) {
        this.cur_gl_stroke = thickness;
    }

    public void setBlendMode(int src_func, int dst_func) {
        int srcmode;
        this.cur_gl_blend_src = src_func;
        this.cur_gl_blend_dst = dst_func;
        if (this.cur_gl == null) {
            return;
        }
        int n = src_func == 0 ? 1 : (srcmode = src_func == 1 ? 770 : 771);
        int dstmode = dst_func == 0 ? 1 : (dst_func == 1 ? 770 : 771);
        this.cur_gl.glBlendFunc(srcmode, dstmode);
    }

    public double getFontHeight(JGFont jgfont) {
        Font font = jgfont == null ? this.cur_gl_font : new Font(jgfont.name, jgfont.style, (int)jgfont.size);
        TextRenderer ren = this.getTextRenderer(font);
        FontRenderContext fontrc = ren.getFontRenderContext();
        Rectangle2D fontbounds = font.getMaxCharBounds(fontrc);
        return fontbounds.getHeight();
    }

    static int smallestPowerOfTwo(int i) {
        int ret;
        for (ret = 1; ret < i; ret <<= 1) {
        }
        return ret;
    }

    Texture getTexture(JREImage img) {
        if (img.texture == null) {
            JGPoint size = img.getSize();
            BufferedImage bimg = JREImage.createRGBA8Image(img.getPixels(), size.x, size.y);
            img.texture = TextureIO.newTexture((BufferedImage)bimg, (boolean)false);
        }
        return (Texture)img.texture;
    }

    Texture getPOTStretchedTexture(JREImage img) {
        if (img.stretched_texture == null) {
            JGPoint size = img.getSize();
            int xpot = JGEngine.smallestPowerOfTwo(size.x);
            int ypot = JGEngine.smallestPowerOfTwo(size.y);
            int[] pixels = img.getPixels();
            IntBuffer inbuf = IntBuffer.wrap(pixels);
            inbuf.rewind();
            IntBuffer outbuf = IntBuffer.allocate(xpot * ypot);
            outbuf.rewind();
            GLU glu = new GLU();
            if (glu.gluScaleImage(6408, size.x, size.y, 5121, (Buffer)inbuf, xpot, ypot, 5121, (Buffer)outbuf) != 0) {
                throw new JGameError("Texture fails to stretch.");
            }
            BufferedImage bimg = JREImage.createRGBA8Image(outbuf.array(), xpot, ypot);
            img.stretched_texture = TextureIO.newTexture((BufferedImage)bimg, (boolean)false);
        }
        return (Texture)img.stretched_texture;
    }

    void setupModelviewMatrix(GL gl, boolean pf_relative) {
        if (pf_relative == this.modelview_matrix_pf_relative) {
            return;
        }
        this.modelview_matrix_pf_relative = pf_relative;
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        if (!pf_relative) {
            return;
        }
        int w = this.el.width;
        int h = this.el.height;
        gl.glTranslated((double)w / 2.0, (double)h / 2.0, 0.0);
        gl.glRotated(this.viewrotate / Math.PI * 180.0, 0.0, 0.0, 1.0);
        gl.glScaled(this.viewzoom, this.viewzoom, 1.0);
        gl.glTranslated((double)(-w) / 2.0, (double)(-h) / 2.0, 0.0);
    }

    public void drawLine(double x1, double y1, double x2, double y2, double thickness, JGColor color) {
        if (color != null) {
            this.setColor(color);
        }
        this.setStroke(thickness);
        this.drawLine(x1, y1, x2, y2, true);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.drawLine(x1, y1, x2, y2, true);
    }

    public void drawLine(double x1, double y1, double x2, double y2, boolean pf_relative) {
        if (this.cur_gl == null) {
            return;
        }
        this.setColor(this.cur_gl, this.cur_gl_color);
        this.cur_gl.glLineWidth((float)this.cur_gl_stroke);
        this.cur_gl.glBegin(1);
        this.cur_gl.glVertex3d((double)this.el.scaleXPos(x1, pf_relative), (double)(this.el.height - this.el.scaleYPos(y1, pf_relative)), 0.0);
        this.cur_gl.glVertex3d((double)this.el.scaleXPos(x2, pf_relative), (double)(this.el.height - this.el.scaleYPos(y2, pf_relative)), 0.0);
        this.cur_gl.glEnd();
    }

    public void drawPolygon(double[] x, double[] y, JGColor[] col, int len, boolean filled, boolean pf_relative) {
        if (this.cur_gl == null) {
            return;
        }
        this.setupModelviewMatrix(this.cur_gl, pf_relative);
        this.drawPolygonInner(x, y, col, len, filled, pf_relative);
    }

    void drawPolygonInner(double[] x, double[] y, JGColor[] col, int len, boolean filled, boolean pf_relative) {
        this.setColor(this.cur_gl, this.cur_gl_color);
        if (filled) {
            this.cur_gl.glBegin(9);
        } else {
            this.cur_gl.glLineWidth((float)this.cur_gl_stroke);
            this.cur_gl.glBegin(2);
        }
        JGColor prevcol = null;
        for (int i = 0; i < len; ++i) {
            if (col != null) {
                if (col[i] != prevcol) {
                    this.setColor(this.cur_gl, col[i]);
                }
                prevcol = col[i];
            }
            this.cur_gl.glVertex3d((double)this.el.scaleXPos(x[i], pf_relative), (double)(this.el.height - this.el.scaleYPos(y[i], pf_relative)), 0.0);
        }
        this.cur_gl.glEnd();
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered, double thickness, JGColor color) {
        if (color != null) {
            this.setColor(color);
        }
        this.setStroke(thickness);
        this.drawRect(x, y, width, height, filled, centered, true, null, null);
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered) {
        this.drawRect(x, y, width, height, filled, centered, true, null, null);
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered, boolean pf_relative) {
        this.drawRect(x, y, width, height, filled, centered, pf_relative, null, null);
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered, boolean pf_relative, JGColor[] shadecol) {
        this.drawRect(x, y, width, height, filled, centered, pf_relative, shadecol, null);
    }

    public void drawRect(double x, double y, double width, double height, boolean filled, boolean centered, boolean pf_relative, JGColor[] shadecol, String tileimage) {
        if (this.cur_gl == null) {
            return;
        }
        this.setupModelviewMatrix(this.cur_gl, pf_relative);
        if (centered) {
            x -= width / 2.0;
            y -= height / 2.0;
        }
        JGRectangle r = this.el.scalePos(x, y, width, height, pf_relative);
        if (tileimage == null) {
            this.setColor(this.cur_gl, this.cur_gl_color);
        } else {
            this.setColor(this.cur_gl, JGColor.white);
        }
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double relx2 = 0.0;
        double rely2 = 0.0;
        Texture tex = null;
        if (tileimage != null) {
            JREImage img = (JREImage)this.el.getImage(tileimage);
            tex = this.getTexture(img);
            JGPoint size = img.getSize();
            TextureCoords coord = tex.getSubImageTexCoords(0, 0, size.x, size.y);
            x1 = coord.left();
            y1 = coord.top();
            x2 = coord.right();
            y2 = coord.bottom();
            tex.bind();
            tex.enable();
            this.cur_gl.glTexParameteri(3553, 10240, this.el.smooth_magnify ? 9729 : 9728);
            double relxsize = width / (double)size.x;
            double relysize = height / (double)size.y;
            relx2 = x1 + (x2 - x1) * relxsize;
            rely2 = y1 + (y2 - y1) * relysize;
        }
        if (filled || tileimage != null) {
            this.cur_gl.glBegin(7);
        } else {
            this.cur_gl.glLineWidth((float)this.cur_gl_stroke);
            this.cur_gl.glBegin(2);
        }
        if (tileimage != null) {
            this.cur_gl.glTexCoord2d(x1, y1);
        }
        if (shadecol != null) {
            this.setColor(this.cur_gl, shadecol[0]);
        }
        this.cur_gl.glVertex3d((double)r.x, (double)(this.el.height - r.y), 0.0);
        if (tileimage != null) {
            this.cur_gl.glTexCoord2d(relx2, y1);
        }
        if (shadecol != null) {
            this.setColor(this.cur_gl, shadecol[1]);
        }
        this.cur_gl.glVertex3d((double)(r.x + r.width), (double)(this.el.height - r.y), 0.0);
        if (tileimage != null) {
            this.cur_gl.glTexCoord2d(relx2, rely2);
        }
        if (shadecol != null) {
            this.setColor(this.cur_gl, shadecol[2]);
        }
        this.cur_gl.glVertex3d((double)(r.x + r.width), (double)(this.el.height - r.y - r.height), 0.0);
        if (tileimage != null) {
            this.cur_gl.glTexCoord2d(x1, rely2);
        }
        if (shadecol != null) {
            this.setColor(this.cur_gl, shadecol[3]);
        }
        this.cur_gl.glVertex3d((double)r.x, (double)(this.el.height - r.y - r.height), 0.0);
        this.cur_gl.glEnd();
        if (tileimage != null) {
            tex.disable();
        }
    }

    public void drawOval(double x, double y, double width, double height, boolean filled, boolean centered, double thickness, JGColor color) {
        if (color != null) {
            this.setColor(color);
        }
        this.setStroke(thickness);
        this.drawOval(x, y, width, height, filled, centered, true);
    }

    public void drawOval(double x, double y, double width, double height, boolean filled, boolean centered) {
        this.drawOval(x, y, width, height, filled, centered, true);
    }

    public void drawOval(double x, double y, double width, double height, boolean filled, boolean centered, boolean pf_relative) {
        if (this.cur_gl == null) {
            return;
        }
        this.setupModelviewMatrix(this.cur_gl, pf_relative);
        x = this.el.scaleXPos(x, pf_relative);
        y = this.el.scaleYPos(y, pf_relative);
        if (width < 0.0) {
            width = -width;
        }
        if (height < 0.0) {
            height = -height;
        }
        int scaledwidth = this.el.scaleXPos(width, false);
        int scaledheight = this.el.scaleYPos(height, false);
        int maxscale = Math.max(scaledwidth, scaledheight);
        if (!centered) {
            x += (double)(scaledwidth / 2);
            y += (double)(scaledheight / 2);
        }
        if (this.ovalx == null) {
            this.genOvalPolygons(256.0);
        }
        this.cur_gl.glPushMatrix();
        this.cur_gl.glTranslated(x, (double)this.el.height - y, 0.0);
        this.cur_gl.glScaled(width / 512.0, height / 512.0, 1.0);
        this.cur_gl.glTranslated(0.0, (double)(-this.el.height), 0.0);
        if (maxscale > 100) {
            this.drawPolygonInner(this.ovalx_lg, this.ovaly_lg, null, this.ovalx_lg.length, filled, false);
        } else if (maxscale > 16) {
            this.drawPolygonInner(this.ovalx, this.ovaly, null, this.ovalx.length, filled, false);
        } else {
            this.drawPolygonInner(this.ovalx_sm, this.ovaly_sm, null, this.ovalx_sm.length, filled, false);
        }
        this.cur_gl.glPopMatrix();
    }

    void genOvalPolygons(double radius) {
        this.ovalshade = new JGColor[4];
        for (int i = 0; i < this.ovalshade.length; ++i) {
            this.ovalshade[i] = new JGColor(50 * i, 30 * i, 60 * i, 255);
        }
        this.ovalx = new double[20];
        this.ovaly = new double[20];
        this.ovals = new JGColor[20];
        this.genOvalPolygon(this.ovalx, this.ovaly, this.ovals, radius, 20);
        this.ovalx_sm = new double[8];
        this.ovaly_sm = new double[8];
        this.ovals_sm = new JGColor[8];
        this.genOvalPolygon(this.ovalx_sm, this.ovaly_sm, this.ovals_sm, radius, 8);
        this.ovalx_lg = new double[50];
        this.ovaly_lg = new double[50];
        this.ovals_lg = new JGColor[50];
        this.genOvalPolygon(this.ovalx_lg, this.ovaly_lg, this.ovals_lg, radius, 50);
    }

    void genOvalPolygon(double[] ovalx, double[] ovaly, JGColor[] ovals, double radius, int segments) {
        int i = 0;
        for (double r = 0.0; r < Math.PI * 2; r += 6.286326899833176 / (double)segments) {
            ovalx[i] = radius * Math.sin(r);
            ovaly[i] = radius * Math.cos(r);
            ovals[i] = this.ovalshade[(int)(r / Math.PI * 2.0)];
            ++i;
        }
    }

    public void drawImage(String imgname, double x, double y) {
        this.drawImage(x, y, imgname);
    }

    public void drawImage(String imgname, double x, double y, boolean pf_relative) {
        this.drawImage(x, y, imgname, pf_relative);
    }

    public void drawImage(String imgname, double x, double y, boolean pf_relative, JGColor blend_col, double alpha, double rot, double scale) {
        this.drawImage(x, y, imgname, blend_col, alpha, rot, scale, pf_relative);
    }

    public void drawImage(double x, double y, String imgname) {
        if (this.cur_gl == null) {
            return;
        }
        this.drawImage(this.cur_gl, x, y, imgname, null, 1.0, 0.0, 1.0, true);
    }

    public void drawImage(double x, double y, String imgname, boolean pf_relative) {
        if (this.cur_gl == null) {
            return;
        }
        this.drawImage(this.cur_gl, x, y, imgname, null, 1.0, 0.0, 1.0, pf_relative);
    }

    public void drawImage(double x, double y, String imgname, JGColor blend_col, double alpha, double rot, double scale, boolean pf_relative) {
        if (this.cur_gl == null) {
            return;
        }
        this.drawImage(this.cur_gl, x, y, imgname, blend_col, alpha, rot, scale, pf_relative);
    }

    void drawImage(GL gl, double x, double y, String imgname, JGColor blend_col, double alpha, double rot, double scale, boolean pf_relative) {
        this.setupModelviewMatrix(gl, pf_relative);
        if (imgname == null) {
            return;
        }
        x = this.el.scaleXPos(x, pf_relative);
        y = this.el.scaleYPos(y, pf_relative);
        JREImage img = (JREImage)this.el.getImage(imgname);
        if (img != null) {
            Texture tex = this.getTexture(img);
            JGPoint size = img.getSize();
            TextureCoords coord = tex.getSubImageTexCoords(0, 0, size.x, size.y);
            double x1 = coord.left();
            double y1 = coord.top();
            double x2 = coord.right();
            double y2 = coord.bottom();
            tex.bind();
            tex.enable();
            gl.glTexParameteri(3553, 10240, this.el.smooth_magnify ? 9729 : 9728);
            if (blend_col == null) {
                gl.glColor4d(alpha, alpha, alpha, alpha);
            } else {
                gl.glColor4d((double)blend_col.r / 255.0, (double)blend_col.g / 255.0, (double)blend_col.b / 255.0, alpha);
            }
            double txsize = (double)size.x * scale;
            double tysize = (double)size.y * scale;
            size = this.el.scalePos(size.x, size.y, false);
            double txsize_s = (double)size.x * scale;
            double tysize_s = (double)size.y * scale;
            y -= (tysize_s - (double)size.y) / 2.0;
            y = (double)this.el.height - y - tysize_s;
            gl.glPushMatrix();
            gl.glTranslated((x -= (txsize_s - (double)size.x) / 2.0) + txsize_s / 2.0, y + tysize_s / 2.0, 0.0);
            gl.glScaled(this.el.x_scale_fac, this.el.y_scale_fac, 1.0);
            gl.glRotated(rot / Math.PI * 180.0, 0.0, 0.0, 1.0);
            gl.glBegin(7);
            gl.glTexCoord2d(x1, y1);
            gl.glVertex3d(-txsize / 2.0, tysize / 2.0, 0.0);
            gl.glTexCoord2d(x2, y1);
            gl.glVertex3d(txsize / 2.0, tysize / 2.0, 0.0);
            gl.glTexCoord2d(x2, y2);
            gl.glVertex3d(txsize / 2.0, -tysize / 2.0, 0.0);
            gl.glTexCoord2d(x1, y2);
            gl.glVertex3d(-txsize / 2.0, -tysize / 2.0, 0.0);
            gl.glEnd();
            gl.glPopMatrix();
            tex.disable();
        }
    }

    public void drawString(String str, double x, double y, int align, JGFont font, JGColor color) {
        if (font != null) {
            this.setFont(font);
        }
        if (color != null) {
            this.setColor(color);
        }
        this.drawString(this.cur_gl, str, x, y, align, false);
    }

    public void drawString(String str, double x, double y, int align) {
        this.drawString(this.cur_gl, str, x, y, align, false);
    }

    public void drawString(String str, double x, double y, int align, boolean pf_relative) {
        this.drawString(this.cur_gl, str, x, y, align, pf_relative);
    }

    TextRenderer getTextRenderer(Font font) {
        TextRenderer ren = (TextRenderer)this.textren.get(font);
        if (ren == null) {
            ren = new TextRenderer(font, true, true);
            this.textren.put(font, ren);
        }
        return ren;
    }

    void drawString(GL gl, String str, double x, double y, int align, boolean pf_relative) {
        JGColor c;
        int ypos;
        int xpos;
        if (gl == null) {
            return;
        }
        this.setupModelviewMatrix(gl, pf_relative);
        if (str.equals("")) {
            return;
        }
        x = this.el.scaleXPos(x, pf_relative);
        y = this.el.scaleYPos(y, pf_relative);
        Font font = this.cur_gl_font;
        TextRenderer ren = this.getTextRenderer(font);
        FontRenderContext fontrc = ren.getFontRenderContext();
        TextLayout layout = new TextLayout(str, font, fontrc);
        Rectangle2D strbounds = layout.getBounds();
        if (align == -1) {
            xpos = (int)(x - strbounds.getMinX());
            ypos = (int)(y - strbounds.getMinY());
        } else if (align == 0) {
            xpos = (int)(x - strbounds.getCenterX());
            ypos = (int)(y - strbounds.getMinY());
        } else {
            xpos = (int)(x - strbounds.getMaxX());
            ypos = (int)(y - strbounds.getMinY());
        }
        ren.begin3DRendering();
        if (this.el.outline_thickness > 0) {
            int i;
            c = this.el.outline_colour;
            ren.setColor((float)c.r / 255.0f, (float)c.g / 255.0f, (float)c.b / 255.0f, (float)c.alpha / 255.0f);
            int real_thickness = Math.max(this.el.scaleXPos(this.el.outline_thickness, false), 1);
            for (i = -real_thickness; i <= real_thickness; ++i) {
                if (i == 0) continue;
                ren.draw3D(str, (float)(xpos + i), (float)(this.el.height - ypos), 0.0f, 1.0f);
            }
            for (i = -real_thickness; i <= real_thickness; ++i) {
                if (i == 0) continue;
                ren.draw3D(str, (float)xpos, (float)(this.el.height - (ypos + i)), 0.0f, 1.0f);
            }
        }
        c = this.cur_gl_color;
        ren.setColor((float)c.r / 255.0f, (float)c.g / 255.0f, (float)c.b / 255.0f, (float)c.alpha / 255.0f);
        try {
            ren.draw3D(str, (float)xpos, (float)(this.el.height - ypos), 0.0f, 1.0f);
        }
        catch (Exception e) {
            // empty catch block
        }
        ren.end3DRendering();
    }

    void drawString(Graphics g, String str, double x, double y, int align, boolean pf_relative) {
        int ypos;
        int xpos;
        if (g == null) {
            return;
        }
        if (str.equals("")) {
            return;
        }
        x = this.el.scaleXPos(x, pf_relative);
        y = this.el.scaleYPos(y, pf_relative);
        Font font = g.getFont();
        FontRenderContext fontrc = ((Graphics2D)g).getFontRenderContext();
        TextLayout layout = new TextLayout(str, font, fontrc);
        Rectangle2D strbounds = layout.getBounds();
        if (align == -1) {
            xpos = (int)(x - strbounds.getMinX());
            ypos = (int)(y - strbounds.getMinY());
        } else if (align == 0) {
            xpos = (int)(x - strbounds.getCenterX());
            ypos = (int)(y - strbounds.getMinY());
        } else {
            xpos = (int)(x - strbounds.getMaxX());
            ypos = (int)(y - strbounds.getMinY());
        }
        if (this.el.outline_thickness > 0) {
            int i;
            Color origcol = g.getColor();
            this.setColor(this.el.outline_colour);
            int real_thickness = Math.max(this.el.scaleXPos(this.el.outline_thickness, false), 1);
            for (i = -real_thickness; i <= real_thickness; ++i) {
                if (i == 0) continue;
                g.drawString(str, xpos + i, ypos);
            }
            for (i = -real_thickness; i <= real_thickness; ++i) {
                if (i == 0) continue;
                g.drawString(str, xpos, ypos + i);
            }
            g.setColor(origcol);
        }
        g.drawString(str, xpos, ypos);
    }

    public void drawImageString(String string, double x, double y, int align, String imgmap, int char_offset, int spacing) {
        this.el.drawImageString(this, string, x, y, align, imgmap, char_offset, spacing, false);
    }

    public void drawImageString(String string, double x, double y, int align, String imgmap, int char_offset, int spacing, boolean pf_relative) {
        this.el.drawImageString(this, string, x, y, align, imgmap, char_offset, spacing, pf_relative);
        ImageMap map = (ImageMap)this.el.imagemaps.get(imgmap);
        if (map == null) {
            throw new JGameError("Font image map '" + imgmap + "' not found.", true);
        }
        if (align == 0) {
            x -= (double)((map.tilex + spacing) * string.length() / 2);
        } else if (align == 1) {
            x -= (double)((map.tilex + spacing) * string.length());
        }
        for (int i = 0; i < string.length(); ++i) {
            int imgnr = -char_offset + string.charAt(i);
            String lettername = imgmap + "#" + string.charAt(i);
            if (!this.el.existsImage(lettername)) {
                this.el.defineImage(lettername, "FONT", 0, this.el.getSubImage(imgmap, imgnr), "-", 0, 0, 0, 0);
            }
            JGImage letter = this.getImage(lettername);
            this.drawImage(this.cur_gl, x, y, lettername, null, 1.0, 0.0, 1.0, pf_relative);
            x += (double)(map.tilex + spacing);
        }
    }

    public JGPoint getMousePos() {
        int viewx = this.el.tilex * this.el.viewnrtilesx;
        int viewy = this.el.tiley * this.el.viewnrtilesy;
        double mx = this.jre.mousepos.x - viewx / 2;
        double my = this.jre.mousepos.y - viewy / 2;
        return new JGPoint(viewx / 2 + (int)(1.0 / this.viewzoom * (mx * Math.cos(-this.viewrotate) + my * Math.sin(-this.viewrotate))), viewy / 2 + (int)(1.0 / this.viewzoom * (-mx * Math.sin(-this.viewrotate) + my * Math.cos(-this.viewrotate))));
    }

    public int getMouseX() {
        return this.getMousePos().x;
    }

    public int getMouseY() {
        return this.getMousePos().y;
    }

    public boolean getMouseButton(int nr) {
        return this.jre.mousebutton[nr];
    }

    public void clearMouseButton(int nr) {
        this.jre.mousebutton[nr] = false;
    }

    public void setMouseButton(int nr) {
        this.jre.mousebutton[nr] = true;
    }

    public boolean getMouseInside() {
        return this.jre.mouseinside;
    }

    public boolean getKey(int key) {
        return this.jre.keymap[key];
    }

    public void clearKey(int key) {
        this.jre.keymap[key] = false;
    }

    public void setKey(int key) {
        this.jre.keymap[key] = true;
    }

    public int getLastKey() {
        return this.jre.lastkey;
    }

    public char getLastKeyChar() {
        return this.jre.lastkeychar;
    }

    public void clearLastKey() {
        this.jre.clearLastKey();
    }

    public String getKeyDesc(int key) {
        return JREEngine.getKeyDescStatic(key);
    }

    public static String getKeyDescStatic(int key) {
        return JREEngine.getKeyDescStatic(key);
    }

    public int getKeyCode(String keydesc) {
        return JREEngine.getKeyCodeStatic(keydesc);
    }

    public static int getKeyCodeStatic(String keydesc) {
        return JREEngine.getKeyCodeStatic(keydesc);
    }

    public boolean hasAccelerometer() {
        return false;
    }

    public double getAccelX() {
        return 0.0;
    }

    public double getAccelY() {
        return 0.0;
    }

    public double getAccelZ() {
        return 1.0;
    }

    public double[] getAccelVec() {
        return new double[]{0.0, 0.0, 1.0};
    }

    public void defineAnimation(String id, String[] frames, double speed) {
        this.el.defineAnimation(id, frames, speed);
    }

    public void defineAnimation(String id, String[] frames, double speed, boolean pingpong) {
        this.el.defineAnimation(id, frames, speed, pingpong);
    }

    public Animation getAnimation(String id) {
        return this.el.getAnimation(id);
    }

    public String getConfigPath(String filename) {
        File jgamedir;
        if (this.isApplet()) {
            return null;
        }
        try {
            jgamedir = new File(System.getProperty("user.home"), ".jgame");
        }
        catch (Exception e) {
            return null;
        }
        if (!jgamedir.exists() && !jgamedir.mkdir()) {
            return null;
        }
        if (!jgamedir.isDirectory()) {
            return null;
        }
        File file = new File(jgamedir, filename);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        if (!file.canWrite()) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public int invokeUrl(String url, String target) {
        if (this.isApplet()) {
            try {
                this.getAppletContext().showDocument(new URL(url), target);
            }
            catch (MalformedURLException e) {
                return 0;
            }
            return -1;
        }
        return 0;
    }

    void paintExitMessage(GL gl) {
        try {
            this.setFont(this.debugmessage_font);
            int height = (int)(this.getFontHeight(null) / this.el.y_scale_fac);
            this.cur_gl = gl;
            this.drawRect(this.el.viewWidth() / 2, this.el.viewHeight() / 2, 9 * this.el.viewWidth() / 10, height * 5, true, true, false);
            this.setColor(this.debug_auxcolor2);
            this.drawRect(this.el.viewWidth() / 2, this.el.viewHeight() / 2 - 5 * height / 2, 9 * this.viewWidth() / 10, 5.0, true, true, false);
            this.drawRect(this.el.viewWidth() / 2, this.el.viewHeight() / 2 + 5 * height / 2, 9 * this.viewWidth() / 10, 5.0, true, true, false);
            this.setColor(this.el.fg_color);
            int ypos = this.el.viewHeight() / 2 - 3 * height / 2;
            StringTokenizer toker = new StringTokenizer(this.el.exit_message, "\n");
            while (toker.hasMoreTokens()) {
                this.drawString(toker.nextToken(), this.el.viewWidth() / 2, ypos, 0, false);
                ypos += height + 1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean and(int value, int mask) {
        return this.el.and(value, mask);
    }

    public double random(double min, double max) {
        return this.el.random(min, max);
    }

    public double random(double min, double max, double interval) {
        return this.el.random(min, max, interval);
    }

    public int random(int min, int max, int interval) {
        return this.el.random(min, max, interval);
    }

    public double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public JGPoint getTileIndex(double x, double y) {
        return this.el.getTileIndex(x, y);
    }

    public JGPoint getTileCoord(int tilex, int tiley) {
        return this.el.getTileCoord(tilex, tiley);
    }

    public JGPoint getTileCoord(JGPoint tileidx) {
        return this.el.getTileCoord(tileidx);
    }

    public double snapToGridX(double x, double gridsnapx) {
        return this.el.snapToGridX(x, gridsnapx);
    }

    public double snapToGridY(double y, double gridsnapy) {
        return this.el.snapToGridY(y, gridsnapy);
    }

    public void snapToGrid(JGPoint p, int gridsnapx, int gridsnapy) {
        this.el.snapToGrid(p, gridsnapx, gridsnapy);
    }

    public boolean isXAligned(double x, double margin) {
        return this.el.isXAligned(x, margin);
    }

    public boolean isYAligned(double y, double margin) {
        return this.el.isYAligned(y, margin);
    }

    public double getXAlignOfs(double x) {
        return this.el.getXAlignOfs(x);
    }

    public double getYAlignOfs(double y) {
        return this.el.getYAlignOfs(y);
    }

    public double getXDist(double x1, double x2) {
        return this.el.getXDist(x1, x2);
    }

    public double getYDist(double y1, double y2) {
        return this.el.getYDist(y1, y2);
    }

    public void enableAudio() {
        this.jre.enableAudio();
    }

    public void disableAudio() {
        this.jre.disableAudio();
    }

    public void defineAudioClip(String clipid, String filename) {
        this.el.defineAudioClip(this, clipid, filename);
    }

    public String lastPlayedAudio(String channel) {
        return this.jre.lastPlayedAudio(channel);
    }

    public void playAudio(String clipid) {
        this.jre.playAudio(this, clipid);
    }

    public void playAudio(String channel, String clipid, boolean loop) {
        this.jre.playAudio(this, channel, clipid, loop);
    }

    public void stopAudio(String channel) {
        this.jre.stopAudio(channel);
    }

    public void stopAudio() {
        this.jre.stopAudio();
    }

    public void storeWriteInt(String id, int value) {
        this.jre.storeWriteInt(id, value);
    }

    public void storeWriteDouble(String id, double value) {
        this.jre.storeWriteDouble(id, value);
    }

    public void storeWriteString(String id, String value) {
        this.jre.storeWriteString(id, value);
    }

    public void storeRemove(String id) {
        this.jre.storeRemove(id);
    }

    public boolean storeExists(String id) {
        return this.jre.storeExists(id);
    }

    public int storeReadInt(String id, int undef) {
        return this.jre.storeReadInt(id, undef);
    }

    public double storeReadDouble(String id, double undef) {
        return this.jre.storeReadDouble(id, undef);
    }

    public String storeReadString(String id, String undef) {
        return this.jre.storeReadString(id, undef);
    }

    public void optsAddTitle(String title) {
        this.jre.optsAddTitle(title);
    }

    public void optsAddNumber(String varname, String title, String desc, int decimals, double lower, double upper, double step, double initial) {
        this.jre.optsAddNumber(varname, title, desc, decimals, lower, upper, step, initial);
    }

    public void optsAddBoolean(String varname, String title, String desc, boolean initial) {
        this.jre.optsAddBoolean(varname, title, desc, initial);
    }

    public void optsAddEnum(String varname, String title, String desc, String[] values, int initial) {
        this.jre.optsAddEnum(varname, title, desc, values, initial);
    }

    public void optsAddKey(String varname, String title, String desc, int initial) {
        this.jre.optsAddKey(varname, title, desc, initial);
    }

    public void optsAddString(String varname, String title, String desc, int maxlen, boolean isPassword, String initial) {
        this.jre.optsAddString(varname, title, desc, maxlen, isPassword, initial);
    }

    public void optsClear() {
        this.jre.optsClear();
    }

    class JGEngineThread
    implements Runnable {
        private long target_time = 0L;
        private int frames_skipped = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    JGEngine.this.initGame();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new JGameError("Exception during initGame(): " + e);
                }
                JGEngine.this.canvas.setInitialised();
                this.target_time = System.currentTimeMillis() + (long)(1000.0 / JGEngine.this.el.fps);
                while (!JGEngine.this.el.is_exited) {
                    int n;
                    SortedArray sortedArray;
                    if (!JGEngine.this.gl_driven_update && (JGEngine.this.debugflags & 8) != 0) {
                        JGEngine.this.refreshDbgFrameLogs();
                    }
                    long cur_time = System.currentTimeMillis();
                    if (!JGEngine.this.running) {
                        if (JGEngine.this.anim != null) {
                            JGEngine.this.anim.stop();
                            JGEngine.this.anim = null;
                        }
                        Thread.sleep(500L);
                        this.target_time = cur_time + (long)(1000.0 / JGEngine.this.el.fps);
                        JGEngine.this.canvas.repaint();
                        continue;
                    }
                    if (JGEngine.this.gl_driven_update) {
                        if (JGEngine.this.anim == null) {
                            JGEngine.this.canvas.repaint();
                        }
                        Thread.sleep(500L);
                        this.target_time = cur_time + (long)(1000.0 / JGEngine.this.el.fps);
                        continue;
                    }
                    if (cur_time < this.target_time + (long)(500.0 / JGEngine.this.el.fps)) {
                        sortedArray = JGEngine.this.el.objects;
                        synchronized (sortedArray) {
                            JGEngine.this.doFrameAll();
                            JGEngine.this.el.updateViewOffset();
                        }
                        JGEngine.this.canvas.repaint();
                        this.frames_skipped = 0;
                        if (cur_time + 3L < this.target_time) {
                            Thread.sleep(this.target_time - cur_time);
                        } else {
                            Thread.yield();
                        }
                        this.target_time = (long)((double)this.target_time + 1000.0 / JGEngine.this.el.fps);
                        continue;
                    }
                    sortedArray = JGEngine.this.el.objects;
                    synchronized (sortedArray) {
                        JGEngine.this.doFrameAll();
                        JGEngine.this.el.updateViewOffset();
                    }
                    ++this.frames_skipped;
                    if ((double)n > JGEngine.this.el.maxframeskip) {
                        JGEngine.this.canvas.repaint();
                        this.frames_skipped = 0;
                        this.target_time = cur_time + (long)(1000.0 / JGEngine.this.el.fps);
                    } else {
                        this.target_time += (long)(1000.0 / JGEngine.this.el.fps);
                    }
                    Thread.yield();
                }
            }
            catch (InterruptedException e) {
                System.out.println("JGame thread exited.");
            }
            catch (Exception e) {
                JGEngine.this.dbgShowException("MAIN", e);
            }
            catch (JGameError e) {
                JGEngine.this.exitEngine("Error in main:\n" + JGEngine.this.dbgExceptionToString(e));
            }
        }
    }

    class JGCanvas
    extends GLCanvas
    implements GLEventListener {
        int w;
        int h;
        long prev_gl_time;
        double max_gl_refresh_rate;
        int canvwidth;
        int canvheight;
        boolean is_initialised;
        private ListCellRenderer initpainter;
        String progress_message;
        String author_message;
        double progress_bar;

        public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
            System.out.println("glcanvas displayChanged()");
        }

        public void init(GLAutoDrawable drawable) {
            System.out.println("glcanvas init()");
            GL gl = drawable.getGL();
            gl.setSwapInterval(1);
            gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl.glColor3f(1.0f, 1.0f, 1.0f);
            gl.glPointSize(1.0f);
            if (JGEngine.this.gl_driven_update && JGEngine.this.anim == null) {
                JGEngine.this.anim = new Animator(drawable);
                JGEngine.this.anim.start();
                this.prev_gl_time = System.currentTimeMillis();
            }
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            System.out.println("glcanvas reshape()");
            GL gl = drawable.getGL();
            GLU glu = new GLU();
            gl.glViewport(0, 0, width, height);
            this.w = width;
            this.h = height;
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            glu.gluOrtho2D(0.0, (double)width, 0.0, (double)height);
            gl.glMatrixMode(5888);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void display(GLAutoDrawable drawable) {
            GL gl = drawable.getGL();
            GLU glu = new GLU();
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            glu.gluOrtho2D(0.0, (double)this.w, 0.0, (double)this.h);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            JGEngine.this.modelview_matrix_pf_relative = false;
            gl.glClearColor((float)JGEngine.this.el.bg_color.r, (float)JGEngine.this.el.bg_color.g, (float)JGEngine.this.el.bg_color.b, 1.0f);
            gl.glClear(16384);
            gl.glShadeModel(7425);
            if (!this.is_initialised) {
                if (this.initpainter != null) {
                    this.initpainter.getListCellRendererComponent(null, gl, 0, false, false);
                }
                return;
            }
            if (JGEngine.this.el.is_exited) {
                JGEngine.this.paintExitMessage(gl);
                return;
            }
            SortedArray sortedArray = JGEngine.this.el.objects;
            synchronized (sortedArray) {
                boolean canwrapy;
                TextureCoords tc;
                if (JGEngine.this.gl_driven_update && JGEngine.this.running) {
                    if (JGEngine.this.anim == null) {
                        JGEngine.this.anim = new Animator(drawable);
                        JGEngine.this.anim.start();
                        this.prev_gl_time = System.currentTimeMillis();
                    }
                    double w = JGEngine.this.el.width;
                    double h = JGEngine.this.el.height;
                    long cur_gl_time = System.currentTimeMillis();
                    long target_time = this.prev_gl_time + (long)(1000.0 / JGEngine.this.el.fps);
                    long elapsed = cur_gl_time - this.prev_gl_time;
                    double elapsed_ideal = 1000.0 / JGEngine.this.el.fps;
                    double elapsed_min = 1000.0 / this.max_gl_refresh_rate;
                    double elapsed_max = 1000.0 / JGEngine.this.el.fps * (1.0 + JGEngine.this.el.maxframeskip);
                    double gamespeed = (double)elapsed / elapsed_ideal;
                    double gamespeed_min = elapsed_min / elapsed_ideal;
                    double gamespeed_max = elapsed_max / elapsed_ideal;
                    if (gamespeed < gamespeed_min) {
                        gamespeed = gamespeed_min;
                        long ms_too_fast = (long)(elapsed_min - (double)elapsed);
                        if (ms_too_fast > 2L) {
                            try {
                                Thread.sleep(ms_too_fast);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (gamespeed > gamespeed_max) {
                        gamespeed = gamespeed_max;
                    }
                    JGEngine.this.setGameSpeed(gamespeed);
                    this.prev_gl_time = cur_gl_time;
                    if ((JGEngine.this.debugflags & 8) != 0) {
                        JGEngine.this.refreshDbgFrameLogs();
                    }
                    JGEngine.this.doFrameAll();
                    JGEngine.this.el.updateViewOffset();
                }
                JGEngine.this.setupModelviewMatrix(gl, true);
                gl.glEnable(3042);
                gl.glBlendFunc(770, 771);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                double x = 0.0;
                double y = 0.0;
                double w = JGEngine.this.el.width;
                double h = JGEngine.this.el.height;
                for (int i = JGEngine.this.el.bg_images.size() - 1; i >= 0; --i) {
                    double ysize;
                    double yofs;
                    double xsize;
                    double xofs;
                    EngineLogic.BGImage bg_image = (EngineLogic.BGImage)JGEngine.this.el.bg_images.get(i);
                    if (bg_image == null) continue;
                    JREImage bg_image_i = (JREImage)JGEngine.this.el.getImage(bg_image.imgname);
                    Texture tex = JGEngine.this.getTexture(bg_image_i);
                    tc = tex.getImageTexCoords();
                    if ((double)Math.abs(tc.right() - tc.left()) != 1.0 || (double)Math.abs(tc.bottom() - tc.top()) != 1.0 || !JGEngine.this.enable_npot) {
                        tex = JGEngine.this.getPOTStretchedTexture(bg_image_i);
                        tc = tex.getImageTexCoords();
                    }
                    tex.bind();
                    tex.enable();
                    gl.glTexParameterf(3553, 10242, bg_image.wrapx ? 10497.0f : 10496.0f);
                    gl.glTexParameterf(3553, 10243, bg_image.wrapy ? 10497.0f : 10496.0f);
                    gl.glTexParameteri(3553, 10241, 9729);
                    gl.glTexParameteri(3553, 10240, JGEngine.this.el.smooth_magnify ? 9729 : 9728);
                    JGPoint imgsize = bg_image_i.getSize();
                    double x1 = 0.0;
                    double y1 = 0.0;
                    double xs = w;
                    double ys = h;
                    double uscale = 1.0 / (double)imgsize.x;
                    if (bg_image.wrapx) {
                        xofs = bg_image.xofs * uscale;
                        xsize = w * uscale / JGEngine.this.el.x_scale_fac;
                    } else {
                        x1 = -bg_image.xofs * JGEngine.this.el.x_scale_fac;
                        xs = (double)imgsize.x * JGEngine.this.el.x_scale_fac;
                        xofs = 0.0;
                        xsize = 1.0;
                    }
                    double vscale = 1.0 / (double)imgsize.y;
                    if (bg_image.wrapy) {
                        yofs = bg_image.yofs * vscale;
                        ysize = h * vscale / JGEngine.this.el.y_scale_fac;
                    } else {
                        y1 = h - ((double)imgsize.y - bg_image.yofs) * JGEngine.this.el.y_scale_fac;
                        ys = (double)imgsize.y * JGEngine.this.el.y_scale_fac;
                        yofs = 0.0;
                        ysize = 1.0;
                    }
                    gl.glBegin(7);
                    gl.glTexCoord2d(xofs, yofs);
                    gl.glVertex3d(x1, y1 + ys, 0.0);
                    gl.glTexCoord2d(xofs + xsize, yofs);
                    gl.glVertex3d(x1 + xs, y1 + ys, 0.0);
                    gl.glTexCoord2d(xofs + xsize, yofs + ysize);
                    gl.glVertex3d(x1 + xs, y1, 0.0);
                    gl.glTexCoord2d(xofs, yofs + ysize);
                    gl.glVertex3d(x1, y1, 0.0);
                    gl.glEnd();
                    tex.disable();
                }
                int bgsizex = JGEngine.this.el.tilex * (JGEngine.this.el.viewnrtilesx + 3);
                int bgsizey = JGEngine.this.el.tiley * (JGEngine.this.el.viewnrtilesy + 3);
                if (JGEngine.this.background == null) {
                    JGEngine.this.background = new TextureRenderer(bgsizex, bgsizey, true);
                    JGEngine.this.background.setSmoothing(true);
                    JGEngine.this.el.invalidateBGTiles();
                }
                JGEngine.this.el.repaintBG(JGEngine.this);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                Texture tex = JGEngine.this.background.getTexture();
                tc = tex.getSubImageTexCoords(0, 0, bgsizex, bgsizey);
                int x1 = JGEngine.this.el.tilex + JGEngine.this.el.xofs;
                int y1 = JGEngine.this.el.tiley + JGEngine.this.el.yofs;
                int x2 = (JGEngine.this.el.viewnrtilesx + 1) * JGEngine.this.el.tilex + JGEngine.this.el.xofs;
                int y2 = (JGEngine.this.el.viewnrtilesy + 1) * JGEngine.this.el.tiley + JGEngine.this.el.yofs;
                int screensx1 = (int)Math.floor((double)x1 / (double)bgsizex);
                int screensy1 = (int)Math.floor((double)y1 / (double)bgsizey);
                int screensx2 = (int)Math.floor((double)x2 / (double)bgsizex);
                int screensy2 = (int)Math.floor((double)y2 / (double)bgsizey);
                x1 -= screensx1 * bgsizex;
                y1 -= screensy1 * bgsizey;
                x2 -= screensx2 * bgsizex;
                y2 -= screensy2 * bgsizey;
                boolean wrapx = screensx2 > screensx1;
                boolean wrapy = screensy2 > screensy1;
                double uwidth = Math.abs(tc.right() - tc.left());
                double vwidth = Math.abs(tc.bottom() - tc.top());
                double uofs = Math.min(tc.right(), tc.left());
                double vofs = Math.min(tc.bottom(), tc.top());
                double xscale = (double)bgsizex / uwidth;
                double yscale = (double)bgsizey / vwidth;
                boolean canwrapx = uwidth == 1.0 && JGEngine.this.enable_npot;
                boolean bl = canwrapy = vwidth == 1.0 && JGEngine.this.enable_npot;
                if (!canwrapx) {
                    uofs += 0.5 / xscale;
                    uwidth -= 1.0 / xscale;
                }
                if (!canwrapy) {
                    vofs += 0.5 / yscale;
                    vwidth -= 1.0 / yscale;
                }
                boolean dotilex = wrapx && !canwrapx;
                boolean dotiley = wrapy && !canwrapy;
                double wmid = w;
                double hmid = h;
                double wend = w;
                double hend = h;
                double t1x1 = uofs + (double)x1 / xscale;
                double t1y1 = vofs + (double)y1 / yscale;
                double t1x2 = uofs + (double)x2 / xscale;
                double t1y2 = vofs + (double)y2 / yscale;
                double t2x1 = uofs;
                double t2y1 = vofs;
                double t2x2 = t1x2;
                double t2y2 = t1y2;
                if (wrapx) {
                    if (dotilex) {
                        wmid = (double)(bgsizex - x1) * JGEngine.this.el.x_scale_fac;
                        t1x2 = uofs + uwidth;
                    } else {
                        t1x2 += 1.0;
                    }
                }
                if (wrapy) {
                    if (dotiley) {
                        hmid = (double)(bgsizey - y1) * JGEngine.this.el.y_scale_fac;
                        t1y2 = vofs + vwidth;
                    } else {
                        t1y2 += 1.0;
                    }
                }
                tex.bind();
                tex.enable();
                gl.glTexParameterf(3553, 10242, canwrapx ? 10497.0f : 10496.0f);
                gl.glTexParameterf(3553, 10243, canwrapy ? 10497.0f : 10496.0f);
                gl.glTexParameteri(3553, 10241, 9729);
                gl.glTexParameteri(3553, 10240, JGEngine.this.el.smooth_magnify ? 9729 : 9728);
                gl.glBegin(7);
                gl.glTexCoord2d(t1x1, t1y1);
                gl.glVertex3d(x, y + h, 0.0);
                gl.glTexCoord2d(t1x2, t1y1);
                gl.glVertex3d(x + wmid, y + h, 0.0);
                gl.glTexCoord2d(t1x2, t1y2);
                gl.glVertex3d(x + wmid, y + h - hmid, 0.0);
                gl.glTexCoord2d(t1x1, t1y2);
                gl.glVertex3d(x, y + h - hmid, 0.0);
                if (dotilex) {
                    gl.glTexCoord2d(t2x1, t1y1);
                    gl.glVertex3d(x + wmid, y + h, 0.0);
                    gl.glTexCoord2d(t2x2, t1y1);
                    gl.glVertex3d(x + wend, y + h, 0.0);
                    gl.glTexCoord2d(t2x2, t1y2);
                    gl.glVertex3d(x + wend, y + h - hmid, 0.0);
                    gl.glTexCoord2d(t2x1, t1y2);
                    gl.glVertex3d(x + wmid, y + h - hmid, 0.0);
                }
                if (dotiley) {
                    gl.glTexCoord2d(t1x1, t2y1);
                    gl.glVertex3d(x, y + h - hmid, 0.0);
                    gl.glTexCoord2d(t1x2, t2y1);
                    gl.glVertex3d(x + wmid, y + h - hmid, 0.0);
                    gl.glTexCoord2d(t1x2, t2y2);
                    gl.glVertex3d(x + wmid, y, 0.0);
                    gl.glTexCoord2d(t1x1, t2y2);
                    gl.glVertex3d(x, y, 0.0);
                }
                if (dotilex && dotiley) {
                    gl.glTexCoord2d(t2x1, t2y1);
                    gl.glVertex3d(x + wmid, y + h - hmid, 0.0);
                    gl.glTexCoord2d(t2x2, t2y1);
                    gl.glVertex3d(x + wend, y + h - hmid, 0.0);
                    gl.glTexCoord2d(t2x2, t2y2);
                    gl.glVertex3d(x + wend, y, 0.0);
                    gl.glTexCoord2d(t2x1, t2y2);
                    gl.glVertex3d(x + wmid, y, 0.0);
                }
                gl.glEnd();
                tex.disable();
                gl.glDisable(3042);
                if (JGEngine.this.buffer == null) {
                    JGEngine.this.buffer = new TextureRenderer(JGEngine.this.el.tilex * JGEngine.this.el.nrtilesx, JGEngine.this.el.tiley * JGEngine.this.el.nrtilesy, true);
                    JGEngine.this.buffer.setSmoothing(true);
                    JGEngine.this.bufg = JGEngine.this.buffer.createGraphics();
                }
                JGEngine.this.bufg.setComposite(AlphaComposite.getInstance(1, 0.0f));
                JGEngine.this.bufg.setComposite(AlphaComposite.SrcOver);
                gl.glTexParameterf(3553, 10242, 10496.0f);
                gl.glTexParameterf(3553, 10243, 10496.0f);
                gl.glTexParameteri(3553, 10241, 9729);
                gl.glTexParameteri(3553, 10240, JGEngine.this.el.smooth_magnify ? 9729 : 9728);
                JGEngine.this.buf_gfx = JGEngine.this.bufg;
                JGEngine.this.cur_gl = gl;
                gl.glEnable(3042);
                JGEngine.this.setBlendMode(JGEngine.this.cur_gl_blend_src, JGEngine.this.cur_gl_blend_dst);
                JGEngine.this.drawString(gl, "   ", 0.0, 0.0, 0, false);
                for (int i = 0; i < JGEngine.this.el.objects.size; ++i) {
                    JGEngine.this.drawObject(JGEngine.this.bufg, gl, (JGObject)JGEngine.this.el.objects.values[i]);
                }
                JGEngine.this.buf_gfx = null;
                if (JGEngine.this.bufg != null) {
                    JGEngine.this.paintFrame(JGEngine.this.bufg);
                }
                gl.glDisable(3042);
                JGEngine.this.cur_gl = null;
                tex = JGEngine.this.buffer.getTexture();
                tex.bind();
                tex.enable();
                gl.glEnable(3042);
                gl.glBegin(7);
                gl.glEnd();
                gl.glDisable(3042);
                tex.disable();
            }
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public JGCanvas(int winwidth, int winheight) {
            super(new GLCapabilities());
            this.w = 250;
            this.h = 250;
            this.prev_gl_time = 0L;
            this.max_gl_refresh_rate = 95.0;
            this.is_initialised = false;
            this.initpainter = null;
            this.progress_message = "Please wait, loading files .....";
            this.author_message = "JGame 3.6";
            this.progress_bar = 0.0;
            this.setSize(winwidth, winheight);
            this.canvwidth = winwidth;
            this.canvheight = winheight;
        }

        void setInitialised() {
            this.is_initialised = true;
            this.initpainter = null;
        }

        void setInitPainter(ListCellRenderer painter) {
            this.initpainter = painter;
        }

        void setProgressBar(double pos) {
            this.progress_bar = pos;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        void setProgressMessage(String msg) {
            this.progress_message = msg;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }

        void setAuthorMessage(String msg) {
            this.author_message = msg;
            if (!this.is_initialised && this.initpainter != null) {
                this.repaint(100L);
            }
        }
    }
}

