/*
 * Decompiled with CFR 0.152.
 */
package examples.webwars;

import examples.webwars.Asteroid;
import examples.webwars.Bird;
import examples.webwars.Boss;
import examples.webwars.Critter;
import examples.webwars.Cross;
import examples.webwars.Email;
import examples.webwars.Homer;
import examples.webwars.Level;
import examples.webwars.Link;
import examples.webwars.Particle;
import examples.webwars.ParticleBig;
import examples.webwars.Pear;
import examples.webwars.Player;
import examples.webwars.Triangle;
import jgame.JGColor;
import jgame.JGFont;
import jgame.JGPoint;
import jgame.platform.StdGame;

public class WebWars
extends StdGame {
    public static double particledensity = 5.0;
    public int[] colors = new int[]{0xFF0000, 0xFFFF00, 65280, 65535, 255, 0xFF00FF};
    public JGColor[] jgcolors = new JGColor[]{JGColor.red, new JGColor(255, 140, 0), JGColor.yellow, new JGColor(140, 255, 0), JGColor.green, new JGColor(0, 255, 140), JGColor.cyan, new JGColor(0, 128, 255), JGColor.blue, new JGColor(128, 0, 255), JGColor.magenta, new JGColor(255, 0, 140)};
    public boolean first_time = false;
    public Level[] lev = new Level[]{new Level(125, 140, 0, 0, 0, 0, 0, 0, false), new Level(0, 240, 40, 0, 0, 0, 0, 0, false), new Level(0, 0, 0, 270, 32, 0, 0, 0, false), new Level(0, 190, 0, 0, 0, 29, 0, 0, false), new Level(0, 0, 60, 0, 52, 48, 0, 0, false), new Level(0, 0, 0, 0, 0, 0, 0, 0, true), new Level(160, 310, 0, 0, 0, 0, 280, 0, false), new Level(0, 265, 0, 330, 0, 55, 350, 0, false), new Level(0, 0, 0, 0, 0, 0, 0, 22, false), new Level(0, 260, 90, 0, 0, 0, 0, 57, false), new Level(365, 375, 185, 590, 150, 110, 630, 155, false), new Level(0, 0, 0, 0, 0, 0, 0, 0, true)};
    public int nextlife = 0;
    public int ammo = 0;
    public int difficulty = 1;
    public int startlevel = 0;
    public int maxpow = 0;
    private double ctrlpos = 110.0;
    private double instrpos = 210.0;
    private double credpos = 380.0;
    private double tomatoxpos = 110.0;
    private double sndxpos = 570.0;
    private double sndypos = 420.0;
    private boolean firsttime = true;

    public static void main(String[] args) {
        new WebWars(WebWars.parseSizeArgs(args, 0));
    }

    public WebWars() {
        this.initEngineApplet();
    }

    public WebWars(JGPoint size) {
        this.initEngine(size.x, size.y);
    }

    public void initGame() {
        this.defineMedia("media.tbl");
        this.setFrameRate(this.isAndroid() ? 45.0 : 55.0, 3.0);
        this.setMouseCursor(-1);
        this.startgame_ingame = true;
        this.leveldone_ingame = true;
        this.lifelost_ingame = true;
        this.gameover_ingame = true;
        this.startgame_ticks = 100;
        this.leveldone_ticks = 140;
        this.lifelost_ticks = 100;
        this.gameover_ticks = 140;
        this.audio_dialog_at_startup = false;
        this.dbgShowMessagesInPf(false);
        this.dbgShowFullStackTrace(true);
    }

    public void initCanvas() {
        this.setCanvasSettings(20, 15, 32, 32, null, null, null);
        this.setScalingPreferences(0.875, 1.1428571428571428, 0, 5, 5, 5);
    }

    public void startTitle() {
        this.setBGImage("bg0");
        this.removeObjects(null, 0);
        new Link(2 * this.pfWidth() / 5, this.credpos + 0.0, 75.0, 15.0, null, "Web design hot", "http://www.webdesignhot.com/free-vector-graphics/");
        new Link(2 * this.pfWidth() / 5, this.credpos + 16.0, 75.0, 15.0, null, "Webtreats", "http://www.flickr.com/photos/webtreatsetc/");
        new Link(2 * this.pfWidth() / 5, this.credpos + 32.0, 75.0, 15.0, null, "Animesh Jha", "http://animeshjha.com/zenphoto/wallpapersanddesigns/");
        new Link(2 * this.pfWidth() / 5, this.credpos + 48.0, 75.0, 15.0, null, "Dark Maiden", "http://darkmaiden-stock.deviantart.com/art/Simple-Star-Field-44386925");
        new Link(3 * this.pfWidth() / 5, this.credpos + 0.0, 75.0, 15.0, null, "Snap2objects", "http://www.snap2objects.com/207/06/10/30-free-vector-rss-buttons/");
        new Link(3 * this.pfWidth() / 5, this.credpos + 16.0, 75.0, 15.0, null, "Icojoy", "http://www.icojoy.com/articles/47/");
        new Link(3 * this.pfWidth() / 5, this.credpos + 32.0, 75.0, 15.0, null, "Datamouse", "http://datamouse.deviantart.com/art/Web-2-0-RSS-Icon-2-69821640");
        new Link(3 * this.pfWidth() / 5, this.credpos + 48.0, 75.0, 15.0, null, "Iconspedia", "http://www.iconspedia.com/icon/music-15852.html");
        new Link(4 * this.pfWidth() / 5, this.credpos + 0.0, 75.0, 15.0, null, "J.B.", null);
        new Link(4 * this.pfWidth() / 5, this.credpos + 16.0, 75.0, 15.0, null, "J. Fairbanks", null);
    }

    public void doFrameTitle() {
        this.moveObjects(null, 0);
        if (this.first_time && this.seqtimer < 300.0 && this.getMouseButton(1)) {
            this.first_time = false;
            this.clearMouseButton(1);
        }
        if (this.getMouseButton(1) && this.getMouseX() >= this.pfWidth() / 2 - 120 && this.getMouseX() <= this.pfWidth() / 2 + 120 && (double)this.getMouseY() >= this.ctrlpos - 20.0 && (double)this.getMouseY() <= this.ctrlpos + 40.0) {
            this.startGame();
        }
        if (this.getMouseButton(1) && (double)this.getMouseY() >= this.ctrlpos + 40.0 && (double)this.getMouseY() <= this.ctrlpos + 90.0) {
            if (this.getMouseX() >= this.pfWidth() / 2 - 160 && this.getMouseX() <= this.pfWidth() / 2 - 90 && this.difficulty > 1) {
                --this.difficulty;
            }
            if (this.getMouseX() >= this.pfWidth() / 2 + 90 && this.getMouseX() <= this.pfWidth() / 2 + 160 && this.difficulty < 36) {
                ++this.difficulty;
            }
            this.clearMouseButton(1);
        }
        if ((double)this.getMouseX() >= this.tomatoxpos - 50.0 && (double)this.getMouseX() <= this.tomatoxpos + 50.0 && (double)this.getMouseY() >= this.credpos - 75.0 && (double)this.getMouseY() <= this.credpos + 100.0 && this.getMouseButton(1)) {
            this.clearMouseButton(1);
            this.invokeUrl("http://tmtg.net/", "_blank");
        }
        if ((double)this.getMouseX() >= this.sndxpos && (double)this.getMouseX() <= this.sndxpos + 48.0 && (double)this.getMouseY() >= this.sndypos && (double)this.getMouseY() <= this.sndypos + 48.0 && this.getMouseButton(1)) {
            this.clearMouseButton(1);
            this.audioenabled = !this.audioenabled;
        }
    }

    public void paintFrame() {
        this.setFont(new JGFont("sans", 0, 20.0));
        this.setColor(JGColor.green);
        this.drawString("" + this.score, this.status_l_margin, 0.0, -1);
        this.drawCount(this.lives < 8 ? this.lives - 1 : 7, "pointersm", this.viewWidth() - this.status_r_margin, 0, -this.getImageSize((String)"pointersm").x - 2);
        this.drawRect(128.0, 4.0, (this.ammo < 4000 ? this.ammo : 3999) / 10, 16.0, true, false, false, null, "powerbar");
    }

    public void paintFrameTitle() {
        this.setFont(new JGFont("sans", 0, 32.0));
        double frac = this.timer % 15.0 / 15.0;
        int intp = (int)Math.floor(this.timer / 15.0);
        int col1 = this.colors[intp % this.colors.length];
        int col2 = this.colors[(intp + 1) % this.colors.length];
        col1 = (col1 & 0xF8F8F8) / 8;
        col2 = (col2 & 0xF8F8F8) / 8;
        int w1 = (int)((1.0 - frac) * 8.999999);
        int w2 = (int)(frac * 8.9999);
        if (this.first_time && this.seqtimer < 300.0) {
            int light1 = (int)(255.0 * (this.seqtimer < 50.0 ? this.seqtimer / 50.0 : 1.0));
            int light2 = (int)(255.0 * (this.seqtimer < 200.0 ? (this.seqtimer - 150.0) / 50.0 : 1.0));
            if (this.seqtimer > 275.0) {
                light2 = light1 = (int)(255.0 * ((300.0 - this.seqtimer) / 25.0));
            }
            this.setColor(new JGColor(light1, light1, light1));
            this.drawString("They never warned us what ", this.viewWidth() / 2 + 3, 90.0, 0);
            this.drawString("Web 2.0 would be like ...", this.viewWidth() / 2 + 3, 125.0, 0);
            if (this.seqtimer > 150.0) {
                this.setColor(new JGColor(light2, light2, light2));
                this.drawString("... until it was too late.", this.viewWidth() / 2 + 3, 175.0, 0);
            }
        } else {
            this.first_time = false;
            this.drawImage("gamelogo", (double)(this.pfWidth() / 2 - 160), 30.0);
            this.setColor(JGColor.white);
            int col = (int)((double)col1 * Math.floor(w1 / 2) + (double)col2 * Math.floor(w2 / 2));
            this.setColor(new JGColor(col >> 16 & 0x7F, col >> 8 & 0x7F, col & 0x7F));
            this.drawString(this.isAndroid() ? "Touch here to start!" : "Click here to start!", this.viewWidth() / 2 + 3, this.ctrlpos + 3.0, 0);
            col = col1 * w1 + col2 * w2;
            this.setColor(new JGColor(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF));
            this.drawString(this.isAndroid() ? "Touch here to start!" : "Click here to start!", this.viewWidth() / 2, this.ctrlpos, 0);
            this.setColor(JGColor.white);
            this.setFont(new JGFont("sans", 0, 22.0));
            this.drawString("Start at level: " + this.difficulty, this.viewWidth() / 2, this.ctrlpos + 48.0, 0);
            this.drawImage("leftarrow", (double)(this.viewWidth() / 2 - 125 - 32), this.ctrlpos + 45.0);
            this.drawImage("rightarrow", (double)(this.viewWidth() / 2 + 125 - 32), this.ctrlpos + 45.0);
            this.setFont(new JGFont("sans", 0, 18.0));
            this.drawString(this.difficulty > 12 ? (this.difficulty > 24 ? "(Hard)" : "(Medium)") : "(Easy)", this.viewWidth() / 2, this.ctrlpos + 66.0, 0);
            this.setFont(new JGFont("sans", 0, 30.0));
            this.drawString("Instructions", this.viewWidth() / 2, this.instrpos, 0);
            this.setFont(new JGFont("sans", 0, 20.0));
            if (!this.isAndroid()) {
                this.drawString("Mouse button aims.", this.viewWidth() / 2, this.instrpos + 40.0 + 0.0, 0);
            } else {
                this.drawString("Move with accelerometer. Touch to aim.", this.viewWidth() / 2, this.instrpos + 40.0 + 0.0, 0);
            }
            this.drawString("Pick up orange things to gain firepower.", this.viewWidth() / 2, this.instrpos + 40.0 + 25.0, 0);
            this.drawString("Press 'P' to pause.", this.viewWidth() / 2, this.instrpos + 40.0 + 50.0, 0);
            this.setFont(new JGFont("sans", 0, 20.0));
            this.drawString("by", this.tomatoxpos, this.credpos - 78.0, 0);
            this.drawImage("logo", this.tomatoxpos - 48.0, this.credpos - 56.0);
            this.setFont(new JGFont("sans", 0, 18.0));
            this.drawString("Available for Android!", this.tomatoxpos, this.credpos + 48.0, 0);
            this.drawString("Get it at tmtg.net", this.tomatoxpos, this.credpos + 72.0, 0);
            this.setFont(new JGFont("sans", 0, 15.0));
            this.drawString("Featuring creative commons content by", 400.0, this.credpos - 40.0, 0);
            this.drawString("graphics", this.pfWidth() / 2, this.credpos - 20.0, 0);
            this.drawString("sound", 4 * this.pfWidth() / 5, this.credpos - 20.0, 0);
            this.drawImage("speakericon", this.sndxpos, this.sndypos);
            if (!this.audioenabled) {
                this.drawImage("officon", this.sndxpos - 12.0, this.sndypos - 18.0);
            }
            if (!this.isAndroid()) {
                this.drawImage("pointer", (double)(this.getMouseX() - 24), this.getMouseY() - 24, true, null, 1.0, -3.9269908169872414, 0.5);
            }
        }
    }

    public void doFrameInGame() {
        int i;
        int xpos;
        double diff;
        if (this.getKey(78)) {
            this.levelDone();
        }
        this.gametime = Math.floor(this.gametime);
        this.moveObjects(null, 0);
        this.checkCollision(6, 1);
        this.checkCollision(8, 6);
        if (this.ammo < 0) {
            this.ammo = 0;
        }
        int pow = 0;
        if (this.ammo > 250) {
            pow = 1;
        }
        if (this.ammo > 1000) {
            pow = 2;
        }
        if (this.ammo > 2000) {
            pow = 3;
        }
        if (this.ammo > 3000) {
            pow = 4;
        }
        if (pow > this.maxpow) {
            this.maxpow = pow;
        }
        if (this.score >= this.nextlife) {
            ++this.lives;
            this.playAudio("extralife");
            this.nextlife += 25000;
            if (this.getObject("player") != null) {
                ((Player)this.getObject((String)"player")).newlifeanim = 100;
            }
        }
        int nr_objects = this.countObjects("E", 0);
        int levphase = (int)Math.floor(this.level / 6) % 2;
        double d = this.level >= 12 ? (this.level >= 24 ? 0.75 : 1.0) : (diff = 2.0);
        if (this.isAndroid()) {
            diff *= 1.25;
        }
        Level lvl = this.lev[this.level % 12];
        lvl = new Level((int)(diff * (double)lvl.asteroid_freq), (int)(diff * (double)lvl.homer_freq), (int)(diff * (double)lvl.bird_freq), (int)(diff * (double)lvl.triangle_freq), (int)(diff * (double)lvl.email_freq), (int)(diff * (double)lvl.pear_freq), (int)(diff * (double)lvl.cross_freq), (int)(diff * (double)lvl.critter_freq), lvl.boss_ena);
        if (this.getObject("boss") != null) {
            ++nr_objects;
        }
        if (this.gametime > 3600.0 || lvl.boss_ena && this.gametime > 100.0) {
            if (nr_objects == 0) {
                this.levelDone();
            }
            return;
        }
        if (nr_objects >= 22) {
            return;
        }
        if (lvl.asteroid_freq != 0 && this.gametime % (double)lvl.asteroid_freq == 0.0) {
            new Asteroid(this.random(0.0, this.pfWidth() - 32), this.pfHeight(), 64, levphase);
        }
        if (lvl.homer_freq != 0 && this.gametime % (double)lvl.homer_freq == 0.0) {
            xpos = (int)this.random(0.0, this.pfWidth() - 300);
            int ypos = -64 + this.random(0, 1, 1) * (this.pfHeight() + 64);
            for (i = 0; i < 5; ++i) {
                new Homer(xpos + i * 60, ypos, this.level < 6 ? 0.045 * (1.0 - 0.3 * Math.cos((double)i - 1.5)) : (levphase == 0 ? 0.07 * (1.0 - 0.3 * Math.cos((double)i - 1.5)) : 0.15 * (1.0 - 0.3 * Math.cos((double)i - 1.5))), levphase == 0 ? "rss_blue" : "rss_green");
            }
        }
        if (lvl.bird_freq != 0 && this.gametime % (double)lvl.bird_freq == 0.0) {
            new Bird(this.pfWidth(), this.random(0.0, this.pfHeight() - 64), 0.05);
        }
        if (lvl.triangle_freq != 0 && this.gametime % (double)lvl.triangle_freq == 0.0) {
            xpos = (int)this.random(64.0, this.pfWidth() - 96);
            if (levphase == 1 && this.random(0.0, 1.0) > 0.5) {
                for (i = 0; i < 4; ++i) {
                    new Triangle(xpos, -65 - 96 * i, 2.0, "warning" + (levphase + 1));
                }
            } else {
                for (i = 0; i < 4; ++i) {
                    new Triangle(xpos, this.pfHeight() + 96 * i, -2.0, "warning" + (levphase + 1));
                }
            }
        }
        if (lvl.email_freq != 0 && this.gametime % (double)lvl.email_freq == 0.0) {
            new Email(-48 + this.random(0, 1, 1) * (this.pfWidth() + 48), this.random(0.0, this.pfHeight() - 48));
        }
        if (lvl.pear_freq != 0 && this.gametime % (double)lvl.pear_freq == 0.0) {
            new Pear(-48 + this.random(0, 1, 1) * (this.pfWidth() + 48), this.random(0.0, this.pfHeight() - 48), 2.0, "pear");
        }
        if (lvl.cross_freq != 0 && this.gametime % (double)lvl.cross_freq == 0.0) {
            new Cross(this.random(0.0, this.pfWidth() - 64), -128 + this.random(0, 1, 1) * (this.pfHeight() + 128 + 128), null, 64, 0.0);
        }
        if (lvl.critter_freq != 0 && this.gametime % (double)lvl.critter_freq == 0.0) {
            new Critter(this.random(0.0, this.pfWidth() - 64), -64 + this.random(0, 1, 1) * (this.pfHeight() + 64), 3.0, "jay");
        }
        if (lvl.boss_ena && this.gametime == 10.0) {
            new Boss(-256 + this.random(0, 1, 1) * (this.pfWidth() + 256), this.random(64.0, this.pfHeight() - 112 - 64), levphase, diff);
        }
    }

    public void paintFrameStartGame() {
        int size = 5 + (int)this.seqtimer;
        if (size > 50) {
            size = 50;
        }
        this.setColor(this.jgcolors[(int)Math.floor(this.seqtimer / 1.0) % 12]);
        this.setFont(new JGFont("sans", 0, size));
        this.drawString("Get Ready!", this.viewWidth() / 2, 130.0 - (double)size / 2.0, 0);
    }

    public void paintFrameStartLevel() {
        int size;
        if (this.seqtimer < 20.0) {
            int alpha = (int)(255.0 * (20.0 - this.seqtimer) / 20.0);
            this.setColor(new JGColor(255, 255, 255, alpha));
            this.drawRect(0.0, 0.0, this.pfWidth(), this.pfHeight(), true, false);
        }
        if ((size = 5 + (int)(this.seqtimer * 1.3) - 40) > 50) {
            size = 50;
        }
        this.setColor(this.jgcolors[(int)Math.floor(this.seqtimer / 1.0) % 12]);
        if (this.seqtimer > 40.0) {
            this.setFont(new JGFont("sans", 0, size));
            this.drawString("Wave " + (this.stage + 1), this.viewWidth() / 2, 270.0 - (double)size / 2.0, 0);
        }
    }

    public void paintFrameLevelDone() {
        int phase = 0;
        this.setBlendMode(1, 0);
        int colnr = (int)(this.seqtimer / 4.0);
        double offset = this.seqtimer / 70.0;
        double scale = this.seqtimer / 70.0;
        double bright = this.seqtimer < 90.0 ? 0.0 : (this.seqtimer - 90.0) / 50.0;
        double circsize = this.seqtimer < 120.0 ? 1.0 : 1.0 + (this.seqtimer - 120.0) / 45.0;
        for (double i = 150.0 * this.seqtimer / 50.0; i >= 8.0 / (scale + 5.0); i /= 1.5) {
            if (i < 25.0) {
                scale *= 1.5;
                i *= 0.7;
            }
            JGColor col = this.jgcolors[colnr % 12];
            col = new JGColor((int)((double)col.r + 255.0 * bright), (int)((double)col.g + 255.0 * bright), (int)((double)col.b + 255.0 * bright));
            if (col.r < 0) {
                col.r = 0;
            }
            if (col.g < 0) {
                col.g = 0;
            }
            if (col.b < 0) {
                col.b = 0;
            }
            if (col.r > 255) {
                col.r = 255;
            }
            if (col.g > 255) {
                col.g = 255;
            }
            if (col.b > 255) {
                col.b = 255;
            }
            for (double a = 0.0; a < 2.0; a += 0.125625) {
                double ang = offset + ((double)phase * 0.125 * 0.333333 + a) * Math.PI;
                double x = (double)(this.pfWidth() / 2) + i * scale * Math.sin(ang);
                double y = (double)(this.pfHeight() / 2) + i * scale * Math.cos(ang);
                this.drawImage("particlewhitehard", x - 16.0, y - 16.0, true, col, 1.0, 0.0, 0.012 * i * scale * circsize);
            }
            phase = (phase + 1) % 2;
            ++colnr;
        }
        this.setBlendMode(1, -1);
        int size = 5 + (int)this.seqtimer;
        if (size > 50) {
            size = 50;
        }
        this.setColor(this.jgcolors[(int)Math.floor(this.seqtimer / 1.0) % 12]);
        this.setFont(new JGFont("sans", 0, size));
        this.drawString("Wave " + (this.stage + 1), this.viewWidth() / 2, 130.0 - (double)size / 2.0, 0);
        this.drawString("Cleared!", this.viewWidth() / 2, 270.0 - (double)size / 2.0, 0);
    }

    public void paintFrameLifeLost() {
    }

    public void paintFrameGameOver() {
        int size = 5 + (int)this.seqtimer;
        if (size > 50) {
            size = 50;
        }
        this.setColor(this.jgcolors[(int)Math.floor(this.seqtimer / 1.0) % 12]);
        this.setFont(new JGFont("sans", 0, size));
        this.drawString("Game Over!", this.viewWidth() / 2, 130.0 - (double)size / 2.0, 0);
    }

    public void paintFramePaused() {
        this.setColor(JGColor.white);
        this.setFont(new JGFont("sans", 0, 30.0));
        this.drawString("Paused", this.viewWidth() / 2, 13 * this.viewHeight() / 36, 0);
        this.drawString("Press P to continue", this.viewWidth() / 2, 20 * this.viewHeight() / 36, 0);
    }

    public void initNewGame(int level_selected) {
        this.setMouseCursor(-1);
        this.score = 0;
        this.lives = 4;
        this.nextlife = 25000;
        this.stage = this.level = this.difficulty - 1;
        this.startlevel = this.level;
        this.ammo = 0;
        this.maxpow = 0;
        this.clearMouseButton(1);
    }

    public void initNewLife() {
        this.ammo /= 2;
        this.removeObjects("E", 0);
        new Player();
    }

    public void defineLevel() {
        this.setBGImage("bg" + (1 + this.stage % 6));
    }

    public void incrementLevel() {
        ++this.level;
        ++this.stage;
    }

    public void startStartGame() {
        this.playAudio("ready");
    }

    public void startLevelDone() {
        this.playAudio("excellent");
    }

    public void paintFrameInGame() {
        if (this.firsttime && this.gametime > 200.0 && this.gametime < 500.0) {
            double alpha = 1.0;
            if (this.gametime < 250.0) {
                alpha = (this.gametime - 200.0) / 50.0;
            }
            if (this.gametime > 450.0) {
                alpha = (500.0 - this.gametime) / 50.0;
            }
            this.setColor(new JGColor((int)(alpha * 255.0), (int)(alpha * 255.0), (int)(alpha * 255.0)));
            this.setFont(new JGFont("sans", 0, 25.0));
            if (!this.isAndroid()) {
                this.drawString("Hold mouse button to aim!", this.viewWidth() / 2, 100.0, 0);
            } else {
                this.drawString("Move with accelerometer. Touch to aim.", this.viewWidth() / 2, 100.0, 0);
            }
        }
        if (this.gametime >= 500.0) {
            this.firsttime = false;
        }
    }

    public void genExplo(double x, double y, int size) {
        new ParticleBig(x, y);
        for (int i = 0; i < (int)((double)size * particledensity); ++i) {
            new Particle(x, y);
        }
    }
}

