/*
 * Decompiled with CFR 0.152.
 */
package examples.webwars;

import examples.webwars.Bullet;
import examples.webwars.Message;
import examples.webwars.WebWars;
import jgame.JGObject;
import jgame.platform.StdGame;

class Player
extends JGObject {
    private double rot = 3.9269908169872414;
    private int bulletdir = 1;
    private double crossx = 1.0;
    private double crossy = 1.0;
    public int newlifeanim = 0;
    private int tmr = 0;

    public Player() {
        super("player", false, pfwidth / 2, pfheight / 2, 1, null);
        this.setBBox(8, 8, 32, 32);
    }

    public void move() {
        int ammo;
        ++this.tmr;
        if (this.newlifeanim > 0) {
            --this.newlifeanim;
        }
        if (this.eng.hasAccelerometer()) {
            if (this.eng.getMouseInside() && this.eng.getMouseButton(1)) {
                this.rot = this.eng.atan2((double)this.eng.getMouseY() - this.y, (double)this.eng.getMouseX() - this.x);
            }
            this.x += 3.0 * this.eng.getAccelX();
            this.y += 3.0 * this.eng.getAccelY();
            if (this.x < 0.0) {
                this.x = 0.0;
            }
            if (this.y < 0.0) {
                this.y = 0.0;
            }
            if (this.x > (double)(pfwidth - 48)) {
                this.x = pfwidth - 48;
            }
            if (this.y > (double)(pfheight - 48)) {
                this.y = pfheight - 48;
            }
        } else if (this.eng.getMouseInside()) {
            if (this.eng.getMouseButton(1)) {
                double newcrossx = (double)this.eng.getMouseX() - this.x;
                double newcrossy = (double)this.eng.getMouseY() - this.y;
                double w = 0.05;
                if (newcrossx * newcrossx + newcrossy * newcrossy >= 4.0) {
                    double newrot = Math.PI + this.eng.atan2(newcrossy, newcrossx);
                    double ang = newrot - this.rot;
                    if (ang > Math.PI) {
                        ang -= Math.PI * 2;
                    }
                    if (ang < -Math.PI) {
                        ang += Math.PI * 2;
                    }
                    if (ang > 1.0471975511965976) {
                        w += 0.14 * (ang - 1.0471975511965976) / 2.0943951023931953;
                    }
                }
                this.crossx = (1.0 - w) * this.crossx + w * newcrossx;
                this.crossy = (1.0 - w) * this.crossy + w * newcrossy;
                this.rot = Math.PI + this.eng.atan2(this.crossy, this.crossx);
                this.crossx = -Math.cos(this.rot);
                this.crossy = -Math.sin(this.rot);
            }
            this.x = this.eng.getMouseX();
            this.y = this.eng.getMouseY();
            if (this.x < 0.0) {
                this.x = 0.0;
            }
            if (this.y < 0.0) {
                this.y = 0.0;
            }
            if (this.x > (double)(pfwidth - 48)) {
                this.x = pfwidth - 48;
            }
            if (this.y > (double)(pfheight - 48)) {
                this.y = pfheight - 48;
            }
        }
        if ((ammo = ((WebWars)this.eng).ammo) > 250 && ammo <= 1000) {
            if (this.tmr % 5 == 0) {
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot);
            }
            if (this.tmr % 6 == 0) {
                --ammo;
            }
        } else if (ammo > 1000 && ammo <= 2000) {
            if (this.tmr % 8 == 0) {
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot - 0.2);
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot);
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot + 0.2);
            }
            if (this.tmr % 3 == 0) {
                --ammo;
            }
        } else if (ammo > 2000 && ammo <= 3000) {
            if (this.tmr % 8 == 0) {
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot - 0.2);
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot);
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot + 0.2);
                ammo -= 3;
            } else if (this.tmr % 8 == 4) {
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot);
                --ammo;
            }
        } else if (ammo > 3000) {
            if (this.tmr % 8 == 0) {
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot - 0.4);
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot - 0.2);
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot);
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot + 0.2);
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot + 0.4);
                ammo -= 5;
            }
        } else if (this.tmr % 8 == 0) {
            new Bullet(this.x + 14.0, this.y + 14.0, 9.0, this.rot);
            --ammo;
        }
        ((WebWars)this.eng).ammo = ammo;
    }

    public void paint() {
        double scale = 0.5;
        double imgx = this.x;
        double imgy = this.y;
        this.eng.drawImage("pointer", imgx - 24.0, imgy - 24.0, true, null, 1.0, -this.rot, scale);
        if (this.newlifeanim > 0) {
            this.eng.drawImage("pointer", imgx - 24.0, imgy - 24.0, true, null, 1.0 - (double)this.newlifeanim / 100.0, -this.rot, 0.5 + 10.0 * ((double)this.newlifeanim / 100.0));
        }
    }

    public void hit(JGObject obj) {
        if (obj.colid == 2 && this.tmr > 150) {
            this.remove();
            ((StdGame)this.eng).lifeLost();
            ((WebWars)this.eng).genExplo(this.x + 24.0, this.y + 24.0, 10);
            for (double ang = 0.0; ang < Math.PI * 2; ang += 0.17) {
                new Bullet(this.x + 14.0, this.y + 14.0, 9.0, ang);
            }
            this.eng.playAudio("death");
        }
        if (obj.colid == 4) {
            ((WebWars)this.eng).ammo = ((WebWars)this.eng).ammo + (this.eng.isAndroid() ? 56 : 45);
            ((WebWars)this.eng).score += 40;
            obj.remove();
            this.eng.playAudio("bonus" + this.random(1, 3, 1));
            new Message(obj.x + 16.0 - 113.0, obj.y + 16.0 - 35.0, "pow");
        }
    }

    public void hit_bg(int tilecid) {
        ((StdGame)this.eng).lifeLost();
    }
}

