/*
 * Decompiled with CFR 0.152.
 */
package examples.webwars;

import examples.webwars.WebWars;
import jgame.JGColor;
import jgame.JGObject;

class ParticleBig
extends JGObject {
    private double size = 1.0;
    private double z_dir;
    private int delay;
    private double ang = 0.0;
    private double col;

    public ParticleBig(double x, double y) {
        this(x, y, 0);
    }

    public ParticleBig(double x, double y, int delay) {
        super("particle", true, x - 16.0, y - 16.0, 0, null);
        this.expiry = delay + this.random(60, 75, 1);
        this.z_dir = this.random(0.05, 0.09);
        this.delay = delay;
        this.col = ((WebWars)this.eng).gametime + this.random(-1.5, 1.5);
    }

    public void move() {
        this.col += 0.1;
        if (this.delay == 0) {
            double iang = this.random(0.0, Math.PI * 2);
            double ispd = this.random(-1.0, 0.0);
            this.setSpeed(ispd * Math.sin(iang), ispd * Math.cos(iang));
        } else if (this.delay < 0) {
            this.size += this.z_dir;
        }
        --this.delay;
    }

    public void paint() {
        if (this.delay > 0) {
            return;
        }
        this.eng.setBlendMode(1, 0);
        JGColor color = ((WebWars)this.eng).jgcolors[(int)(this.col % 12.0)];
        this.eng.drawImage("particlewhite", this.x, this.y, true, color, this.expiry > 40.0 ? 0.8 : 0.8 * (this.expiry / 40.0), -1.5707963267948966 + this.ang, 2.0 * this.size);
        this.eng.setBlendMode(1, -1);
    }
}

