/*
 * Decompiled with CFR 0.152.
 */
package examples.webwars;

import examples.webwars.Bonus;
import examples.webwars.WebWars;
import jgame.JGObject;

class Cross
extends JGObject {
    private int tmr = 0;
    private double rot = 0.0;
    private Cross parent;
    private int imgsize;
    private int has_children = 3;

    public Cross(double x, double y, Cross parent, int size, double rot) {
        super("Ecross", true, x, y, 2, null);
        this.parent = parent;
        this.imgsize = size;
        this.rot = rot;
        this.setBBox(32 - size / 2, 32 - size / 2, size, size);
        if (size > 32) {
            for (int i = 0; i < 8; ++i) {
                new Cross(x, y, this, size / 2, (double)i * Math.PI / 4.0);
            }
        }
        this.setSpeed((double)this.random(-1, 1, 2) * this.random(1.0, 1.5), (double)this.random(-1, 1, 2) * this.random(1.0, 1.5));
    }

    public void move() {
        if (this.parent != null) {
            this.parent.has_children = 3;
        }
        if (this.has_children > 0) {
            --this.has_children;
        }
        this.rot += 0.01;
        ++this.tmr;
        if (this.parent != null) {
            this.x = this.parent.x + 1.5 * (double)this.imgsize * Math.sin(this.rot);
            this.y = this.parent.y + 1.5 * (double)this.imgsize * Math.cos(this.rot);
        } else {
            if (this.x < 64.0 && this.xspeed < 0.0) {
                this.xspeed = -this.xspeed;
            }
            if (this.y < 64.0 && this.yspeed < 0.0) {
                this.yspeed = -this.yspeed;
            }
            if (this.x > (double)(pfwidth - 128) && this.xspeed > 0.0) {
                this.xspeed = -this.xspeed;
            }
            if (this.y > (double)(pfheight - 128) && this.yspeed > 0.0) {
                this.yspeed = -this.yspeed;
            }
        }
        JGObject player = this.eng.getObject("player");
    }

    public void hit(JGObject obj) {
        if (!this.isAlive()) {
            return;
        }
        if (obj.colid == 8) {
            obj.remove();
            if (this.has_children != 0) {
                return;
            }
            this.eng.playAudio("explo" + this.random(1, 3, 1));
            ((WebWars)this.eng).genExplo(this.x + 32.0, this.y + 32.0, 5);
            ((WebWars)this.eng).score += 15;
            this.remove();
            if (this.parent == null) {
                new Bonus(this.x, this.y);
            }
            if (this.random(0.0, 1.0) > 0.7) {
                new Bonus(this.x, this.y);
            }
        }
    }

    public void paint() {
        this.eng.drawImage("cross", this.x, this.y, true, null, 1.0, this.rot, (double)this.imgsize / 64.0);
    }
}

