/*
 * Decompiled with CFR 0.152.
 */
package examples.webwars;

import examples.webwars.Bonus;
import examples.webwars.WebWars;
import jgame.JGObject;

class BossButton
extends JGObject {
    private int tmr = 0;
    private int anim = 1;
    private int type = 1;
    private double accel = this.random(0.1, 0.15);
    private String img;
    private double rot = 0.0;

    public BossButton(double x, double y, double speedx, double speedy, int type) {
        super("Ebossbutton", true, x, y, 2, null);
        this.xspeed = speedx * this.random(4.0, 6.0);
        this.yspeed = speedy * this.random(4.0, 6.0);
        this.type = type;
        if (type == 0) {
            this.setBBox(0, 0, 44, 20);
            this.img = "bossbut";
        } else {
            this.setBBox(4, 4, 32, 32);
            this.img = "bossstar";
        }
    }

    public void move() {
        if (this.x > (double)pfwidth) {
            this.x = -64.0;
        }
        if (this.y > (double)pfheight) {
            this.y = -64.0;
        }
        if (this.x < -64.0) {
            this.x = pfwidth;
        }
        if (this.y < -64.0) {
            this.y = pfheight;
        }
        ++this.tmr;
        JGObject player = this.eng.getObject("player");
        if (player != null) {
            this.xspeed = this.x > player.x ? (this.xspeed -= this.accel) : (this.xspeed += this.accel);
            this.yspeed = this.y > player.y - 8.0 ? (this.yspeed -= this.accel) : (this.yspeed += this.accel);
        }
        this.xspeed -= 0.02 * this.xspeed;
        this.yspeed -= 0.02 * this.yspeed;
        this.anim = 1 + this.tmr / 5 % 3;
        if (this.type == 1) {
            this.rot += this.accel;
        }
    }

    public void hit(JGObject obj) {
        if (!this.isAlive()) {
            return;
        }
        if (obj.colid == 8) {
            obj.remove();
            this.eng.playAudio("explo" + this.random(1, 3, 1));
            ((WebWars)this.eng).genExplo(this.x + 18.0, this.y + 13.0, 5);
            ((WebWars)this.eng).score += 15;
            this.remove();
            if (this.random(0.0, 1.0) > 0.6) {
                new Bonus(this.x, this.y);
            }
        }
    }

    public void paint() {
        this.eng.drawImage(this.img + this.anim, this.x, this.y, true, null, 1.0, -this.rot, 1.0);
    }
}

