/*
 * Decompiled with CFR 0.152.
 */
package examples.webwars;

import examples.webwars.Bonus;
import examples.webwars.BossButton;
import examples.webwars.Particle;
import examples.webwars.WebWars;
import jgame.JGObject;

class Boss
extends JGObject {
    private int tmr = 0;
    private int hp = 250;
    private int is_hit = 0;
    private double rot = 0.0;
    private double diff = 0.0;
    private int type;

    public Boss(double x, double y, int type, double diff) {
        super("boss", false, x, y, 2, null);
        this.xspeed = x < (double)(pfwidth / 2) ? 0.8 : -0.8;
        this.diff = diff;
        this.type = type;
        if (type == 0) {
            this.setBBox(0, 0, 256, 112);
        } else {
            this.setBBox(24, 24, 144, 144);
        }
    }

    public void move() {
        if (this.x < -256.0) {
            this.x = pfwidth;
        }
        if (this.x > (double)pfwidth) {
            this.x = -256.0;
        }
        ++this.tmr;
        if (this.tmr == 7200) {
            this.diff /= 3.0;
        }
        if (this.tmr == 10800) {
            this.diff /= 3.0;
        }
        this.is_hit = 0;
        if (this.type == 0) {
            if (this.tmr % (int)Math.floor(130.0 * this.diff) < 50 && this.tmr % 10 == 0) {
                if (Math.floor(this.tmr / 200) % 4.0 == 0.0) {
                    new BossButton(this.x + 128.0 - 22.0, this.y + 112.0 - 22.0, 0.0, 1.0, 0);
                } else if (Math.floor(this.tmr / 200) % 4.0 == 1.0) {
                    new BossButton(this.x, this.y + 45.0, -1.0, 0.0, 0);
                } else if (Math.floor(this.tmr / 200) % 4.0 == 2.0) {
                    new BossButton(this.x + 256.0 - 44.0, this.y + 45.0, 1.0, 0.0, 0);
                } else {
                    new BossButton(this.x + 128.0 - 22.0, this.y, 0.0, -1.0, 0);
                }
            }
        } else if (this.tmr % (int)Math.floor(30.0 * this.diff) == 0) {
            new BossButton(this.x + 96.0 - 20.0, this.y + 96.0 - 20.0, Math.sin(this.rot), Math.cos(this.rot), 1);
        }
        if (this.type == 1) {
            this.rot += 0.03;
        }
    }

    public void hit(JGObject obj) {
        if (!this.isAlive()) {
            return;
        }
        if (obj.colid == 8) {
            obj.remove();
            --this.hp;
            this.is_hit = 1;
            if (this.hp <= 0) {
                int i;
                this.eng.playAudio("bossexplo");
                for (i = 0; i < (int)(35.0 * WebWars.particledensity); ++i) {
                    new Particle(this.x + this.random(0.0, 224.0), this.y + this.random(0.0, 80.0), (int)this.random(0.0, 50.0));
                }
                ((WebWars)this.eng).score += 20;
                this.remove();
                for (i = 0; i < 12; ++i) {
                    new Bonus(this.x + this.random(0.0, 224.0), this.y + this.random(0.0, 80.0));
                }
            }
        }
    }

    public void paint() {
        this.eng.drawImage("boss" + (this.type + 1), this.x, this.y, true, null, this.is_hit != 0 ? 0.7 : 1.0, -this.rot, 1.0);
    }
}

