/*
 * Decompiled with CFR 0.152.
 */
package examples.webwars;

import examples.webwars.BirdBullet;
import examples.webwars.Bonus;
import examples.webwars.WebWars;
import jgame.JGObject;

class Bird
extends JGObject {
    private int tmr = 0;
    private double accel = 0.0;
    private double rot = 0.0;
    private String img = "birdl";

    public Bird(double x, double y, double accel) {
        super("Ebird", true, x, y, 2, null);
        this.xspeed = (double)(this.random(-1, 1, 2) * 35) * accel;
        this.accel = accel;
        this.setBBox(16, 16, 32, 32);
    }

    public void move() {
        if (this.x > (double)pfwidth) {
            this.x = -64.0;
        }
        if (this.y > (double)pfheight) {
            this.y = -64.0;
        }
        if (this.x < -64.0) {
            this.x = pfwidth;
        }
        if (this.y < -64.0) {
            this.y = pfheight;
        }
        ++this.tmr;
        JGObject player = this.eng.getObject("player");
        if (player != null) {
            this.yspeed = this.y > player.y ? (this.yspeed -= this.accel) : (this.yspeed += this.accel);
            this.img = this.x > player.x ? "birdl" : "birdr";
            this.rot = 1.5707963267948966 - this.eng.atan2(player.x - this.x, player.y - this.y);
            if (this.tmr % 70 == 0) {
                this.eng.playAudio("zap");
                double bulrot = this.eng.atan2(player.x - this.x, player.y - this.y);
                new BirdBullet(this.x, this.y, 4.0 * Math.sin(bulrot), 4.0 * Math.cos(bulrot), this.rot, this.img);
            }
        }
        this.yspeed -= 0.02 * this.yspeed;
    }

    public void hit(JGObject obj) {
        if (!this.isAlive()) {
            return;
        }
        if (obj.colid == 8) {
            obj.remove();
            this.eng.playAudio("screech" + this.random(1, 2, 1));
            this.eng.playAudio("explo" + this.random(1, 3, 1));
            ((WebWars)this.eng).genExplo(this.x + 32.0, this.y + 32.0, 6);
            ((WebWars)this.eng).score += 20;
            this.remove();
            if (this.random(0.0, 1.0) > 0.4) {
                new Bonus(this.x, this.y);
            }
        }
    }

    public void paint() {
        this.eng.drawImage(this.img, this.x, this.y, true, null, 1.0, -this.rot, 1.0);
    }
}

